# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class AccessKeys(Model):
    """Namespace/EventHub Connection String.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar primary_connection_string: Primary connection string of the created
     namespace AuthorizationRule.
    :vartype primary_connection_string: str
    :ivar secondary_connection_string: Secondary connection string of the
     created namespace AuthorizationRule.
    :vartype secondary_connection_string: str
    :ivar alias_primary_connection_string: Primary connection string of the
     alias if GEO DR is enabled
    :vartype alias_primary_connection_string: str
    :ivar alias_secondary_connection_string: Secondary  connection string of
     the alias if GEO DR is enabled
    :vartype alias_secondary_connection_string: str
    :ivar primary_key: A base64-encoded 256-bit primary key for signing and
     validating the SAS token.
    :vartype primary_key: str
    :ivar secondary_key: A base64-encoded 256-bit primary key for signing and
     validating the SAS token.
    :vartype secondary_key: str
    :ivar key_name: A string that describes the AuthorizationRule.
    :vartype key_name: str
    """

    _validation = {
        'primary_connection_string': {'readonly': True},
        'secondary_connection_string': {'readonly': True},
        'alias_primary_connection_string': {'readonly': True},
        'alias_secondary_connection_string': {'readonly': True},
        'primary_key': {'readonly': True},
        'secondary_key': {'readonly': True},
        'key_name': {'readonly': True},
    }

    _attribute_map = {
        'primary_connection_string': {'key': 'primaryConnectionString', 'type': 'str'},
        'secondary_connection_string': {'key': 'secondaryConnectionString', 'type': 'str'},
        'alias_primary_connection_string': {'key': 'aliasPrimaryConnectionString', 'type': 'str'},
        'alias_secondary_connection_string': {'key': 'aliasSecondaryConnectionString', 'type': 'str'},
        'primary_key': {'key': 'primaryKey', 'type': 'str'},
        'secondary_key': {'key': 'secondaryKey', 'type': 'str'},
        'key_name': {'key': 'keyName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(AccessKeys, self).__init__(**kwargs)
        self.primary_connection_string = None
        self.secondary_connection_string = None
        self.alias_primary_connection_string = None
        self.alias_secondary_connection_string = None
        self.primary_key = None
        self.secondary_key = None
        self.key_name = None


class Resource(Model):
    """The resource definition.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None


class ArmDisasterRecovery(Resource):
    """Single item in List or Get Alias(Disaster Recovery configuration)
    operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar provisioning_state: Provisioning state of the Alias(Disaster
     Recovery configuration) - possible values 'Accepted' or 'Succeeded' or
     'Failed'. Possible values include: 'Accepted', 'Succeeded', 'Failed'
    :vartype provisioning_state: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.ProvisioningStateDR
    :param partner_namespace: ARM Id of the Primary/Secondary eventhub
     namespace name, which is part of GEO DR pairing
    :type partner_namespace: str
    :param alternate_name: Alternate name specified when alias and namespace
     names are same.
    :type alternate_name: str
    :ivar role: role of namespace in GEO DR - possible values 'Primary' or
     'PrimaryNotReplicating' or 'Secondary'. Possible values include:
     'Primary', 'PrimaryNotReplicating', 'Secondary'
    :vartype role: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.RoleDisasterRecovery
    :ivar pending_replication_operations_count: Number of entities pending to
     be replicated.
    :vartype pending_replication_operations_count: long
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'role': {'readonly': True},
        'pending_replication_operations_count': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'ProvisioningStateDR'},
        'partner_namespace': {'key': 'properties.partnerNamespace', 'type': 'str'},
        'alternate_name': {'key': 'properties.alternateName', 'type': 'str'},
        'role': {'key': 'properties.role', 'type': 'RoleDisasterRecovery'},
        'pending_replication_operations_count': {'key': 'properties.pendingReplicationOperationsCount', 'type': 'long'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, **kwargs):
        super(ArmDisasterRecovery, self).__init__(**kwargs)
        self.provisioning_state = None
        self.partner_namespace = kwargs.get('partner_namespace', None)
        self.alternate_name = kwargs.get('alternate_name', None)
        self.role = None
        self.pending_replication_operations_count = None
        self.system_data = None


class AuthorizationRule(Resource):
    """Single item in a List or Get AuthorizationRule operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param rights: Required. The rights associated with the rule.
    :type rights: list[str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.AccessRights]
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'rights': {'required': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'rights': {'key': 'properties.rights', 'type': '[str]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, **kwargs):
        super(AuthorizationRule, self).__init__(**kwargs)
        self.rights = kwargs.get('rights', None)
        self.system_data = None


class CaptureDescription(Model):
    """Properties to configure capture description for eventhub.

    :param enabled: A value that indicates whether capture description is
     enabled.
    :type enabled: bool
    :param encoding: Enumerates the possible values for the encoding format of
     capture description. Note: 'AvroDeflate' will be deprecated in New API
     Version. Possible values include: 'Avro', 'AvroDeflate'
    :type encoding: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.EncodingCaptureDescription
    :param interval_in_seconds: The time window allows you to set the
     frequency with which the capture to Azure Blobs will happen, value should
     between 60 to 900 seconds
    :type interval_in_seconds: int
    :param size_limit_in_bytes: The size window defines the amount of data
     built up in your Event Hub before an capture operation, value should be
     between 10485760 to 524288000 bytes
    :type size_limit_in_bytes: int
    :param destination: Properties of Destination where capture will be
     stored. (Storage Account, Blob Names)
    :type destination:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.Destination
    :param skip_empty_archives: A value that indicates whether to Skip Empty
     Archives
    :type skip_empty_archives: bool
    """

    _validation = {
        'interval_in_seconds': {'maximum': 900, 'minimum': 60},
        'size_limit_in_bytes': {'maximum': 524288000, 'minimum': 10485760},
    }

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'encoding': {'key': 'encoding', 'type': 'EncodingCaptureDescription'},
        'interval_in_seconds': {'key': 'intervalInSeconds', 'type': 'int'},
        'size_limit_in_bytes': {'key': 'sizeLimitInBytes', 'type': 'int'},
        'destination': {'key': 'destination', 'type': 'Destination'},
        'skip_empty_archives': {'key': 'skipEmptyArchives', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(CaptureDescription, self).__init__(**kwargs)
        self.enabled = kwargs.get('enabled', None)
        self.encoding = kwargs.get('encoding', None)
        self.interval_in_seconds = kwargs.get('interval_in_seconds', None)
        self.size_limit_in_bytes = kwargs.get('size_limit_in_bytes', None)
        self.destination = kwargs.get('destination', None)
        self.skip_empty_archives = kwargs.get('skip_empty_archives', None)


class CheckNameAvailabilityParameter(Model):
    """Parameter supplied to check Namespace name availability operation .

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name to check the namespace name availability
    :type name: str
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityParameter, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)


class CheckNameAvailabilityResult(Model):
    """The Result of the CheckNameAvailability operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar message: The detailed info regarding the reason associated with the
     Namespace.
    :vartype message: str
    :param name_available: Value indicating Namespace is availability, true if
     the Namespace is available; otherwise, false.
    :type name_available: bool
    :param reason: The reason for unavailability of a Namespace. Possible
     values include: 'None', 'InvalidName', 'SubscriptionIsDisabled',
     'NameInUse', 'NameInLockdown', 'TooManyNamespaceInCurrentSubscription'
    :type reason: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.UnavailableReason
    """

    _validation = {
        'message': {'readonly': True},
    }

    _attribute_map = {
        'message': {'key': 'message', 'type': 'str'},
        'name_available': {'key': 'nameAvailable', 'type': 'bool'},
        'reason': {'key': 'reason', 'type': 'UnavailableReason'},
    }

    def __init__(self, **kwargs):
        super(CheckNameAvailabilityResult, self).__init__(**kwargs)
        self.message = None
        self.name_available = kwargs.get('name_available', None)
        self.reason = kwargs.get('reason', None)


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class ConnectionState(Model):
    """ConnectionState information.

    :param status: Status of the connection. Possible values include:
     'Pending', 'Approved', 'Rejected', 'Disconnected'
    :type status: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.PrivateLinkConnectionStatus
    :param description: Description of the connection state.
    :type description: str
    """

    _attribute_map = {
        'status': {'key': 'status', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ConnectionState, self).__init__(**kwargs)
        self.status = kwargs.get('status', None)
        self.description = kwargs.get('description', None)


class ConsumerGroup(Resource):
    """Single item in List or Get Consumer group operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar created_at: Exact time the message was created.
    :vartype created_at: datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    :param user_metadata: User Metadata is a placeholder to store user-defined
     string data with maximum length 1024. e.g. it can be used to store
     descriptive data, such as list of teams and their contact information also
     user-defined configuration settings can be stored.
    :type user_metadata: str
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'user_metadata': {'key': 'properties.userMetadata', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, **kwargs):
        super(ConsumerGroup, self).__init__(**kwargs)
        self.created_at = None
        self.updated_at = None
        self.user_metadata = kwargs.get('user_metadata', None)
        self.system_data = None


class Destination(Model):
    """Capture storage details for capture description.

    :param name: Name for capture destination
    :type name: str
    :param storage_account_resource_id: Resource id of the storage account to
     be used to create the blobs
    :type storage_account_resource_id: str
    :param blob_container: Blob container Name
    :type blob_container: str
    :param archive_name_format: Blob naming convention for archive, e.g.
     {Namespace}/{EventHub}/{PartitionId}/{Year}/{Month}/{Day}/{Hour}/{Minute}/{Second}.
     Here all the parameters (Namespace,EventHub .. etc) are mandatory
     irrespective of order
    :type archive_name_format: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'storage_account_resource_id': {'key': 'properties.storageAccountResourceId', 'type': 'str'},
        'blob_container': {'key': 'properties.blobContainer', 'type': 'str'},
        'archive_name_format': {'key': 'properties.archiveNameFormat', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Destination, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.storage_account_resource_id = kwargs.get('storage_account_resource_id', None)
        self.blob_container = kwargs.get('blob_container', None)
        self.archive_name_format = kwargs.get('archive_name_format', None)


class TrackedResource(Resource):
    """Definition of resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(self, **kwargs):
        super(TrackedResource, self).__init__(**kwargs)
        self.location = kwargs.get('location', None)
        self.tags = kwargs.get('tags', None)


class EHNamespace(TrackedResource):
    """Single Namespace item in List or Get Operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Resource location.
    :type location: str
    :param tags: Resource tags.
    :type tags: dict[str, str]
    :param sku: Properties of sku resource
    :type sku: ~azure.mgmt.eventhub.v2021_01_01_preview.models.Sku
    :param identity: Properties of BYOK Identity description
    :type identity: ~azure.mgmt.eventhub.v2021_01_01_preview.models.Identity
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.SystemData
    :ivar provisioning_state: Provisioning state of the Namespace.
    :vartype provisioning_state: str
    :ivar created_at: The time the Namespace was created.
    :vartype created_at: datetime
    :ivar updated_at: The time the Namespace was updated.
    :vartype updated_at: datetime
    :ivar service_bus_endpoint: Endpoint you can use to perform Service Bus
     operations.
    :vartype service_bus_endpoint: str
    :param cluster_arm_id: Cluster ARM ID of the Namespace.
    :type cluster_arm_id: str
    :ivar metric_id: Identifier for Azure Insights metrics.
    :vartype metric_id: str
    :param is_auto_inflate_enabled: Value that indicates whether AutoInflate
     is enabled for eventhub namespace.
    :type is_auto_inflate_enabled: bool
    :param maximum_throughput_units: Upper limit of throughput units when
     AutoInflate is enabled, value should be within 0 to 20 throughput units. (
     '0' if AutoInflateEnabled = true)
    :type maximum_throughput_units: int
    :param kafka_enabled: Value that indicates whether Kafka is enabled for
     eventhub namespace.
    :type kafka_enabled: bool
    :param zone_redundant: Enabling this property creates a Standard Event
     Hubs Namespace in regions supported availability zones.
    :type zone_redundant: bool
    :param encryption: Properties of BYOK Encryption description
    :type encryption:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.Encryption
    :param private_endpoint_connections: List of private endpoint connections.
    :type private_endpoint_connections:
     list[~azure.mgmt.eventhub.v2021_01_01_preview.models.PrivateEndpointConnection]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'service_bus_endpoint': {'readonly': True},
        'metric_id': {'readonly': True},
        'maximum_throughput_units': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'identity': {'key': 'identity', 'type': 'Identity'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'service_bus_endpoint': {'key': 'properties.serviceBusEndpoint', 'type': 'str'},
        'cluster_arm_id': {'key': 'properties.clusterArmId', 'type': 'str'},
        'metric_id': {'key': 'properties.metricId', 'type': 'str'},
        'is_auto_inflate_enabled': {'key': 'properties.isAutoInflateEnabled', 'type': 'bool'},
        'maximum_throughput_units': {'key': 'properties.maximumThroughputUnits', 'type': 'int'},
        'kafka_enabled': {'key': 'properties.kafkaEnabled', 'type': 'bool'},
        'zone_redundant': {'key': 'properties.zoneRedundant', 'type': 'bool'},
        'encryption': {'key': 'properties.encryption', 'type': 'Encryption'},
        'private_endpoint_connections': {'key': 'properties.privateEndpointConnections', 'type': '[PrivateEndpointConnection]'},
    }

    def __init__(self, **kwargs):
        super(EHNamespace, self).__init__(**kwargs)
        self.sku = kwargs.get('sku', None)
        self.identity = kwargs.get('identity', None)
        self.system_data = None
        self.provisioning_state = None
        self.created_at = None
        self.updated_at = None
        self.service_bus_endpoint = None
        self.cluster_arm_id = kwargs.get('cluster_arm_id', None)
        self.metric_id = None
        self.is_auto_inflate_enabled = kwargs.get('is_auto_inflate_enabled', None)
        self.maximum_throughput_units = kwargs.get('maximum_throughput_units', None)
        self.kafka_enabled = kwargs.get('kafka_enabled', None)
        self.zone_redundant = kwargs.get('zone_redundant', None)
        self.encryption = kwargs.get('encryption', None)
        self.private_endpoint_connections = kwargs.get('private_endpoint_connections', None)


class Encryption(Model):
    """Properties to configure Encryption.

    :param key_vault_properties: Properties of KeyVault
    :type key_vault_properties:
     list[~azure.mgmt.eventhub.v2021_01_01_preview.models.KeyVaultProperties]
    :param key_source: Enumerates the possible value of keySource for
     Encryption. Possible values include: 'Microsoft.KeyVault'. Default value:
     "Microsoft.KeyVault" .
    :type key_source: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.KeySource
    :param require_infrastructure_encryption: Enable Infrastructure Encryption
     (Double Encryption)
    :type require_infrastructure_encryption: bool
    """

    _attribute_map = {
        'key_vault_properties': {'key': 'keyVaultProperties', 'type': '[KeyVaultProperties]'},
        'key_source': {'key': 'keySource', 'type': 'KeySource'},
        'require_infrastructure_encryption': {'key': 'requireInfrastructureEncryption', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(Encryption, self).__init__(**kwargs)
        self.key_vault_properties = kwargs.get('key_vault_properties', None)
        self.key_source = kwargs.get('key_source', "Microsoft.KeyVault")
        self.require_infrastructure_encryption = kwargs.get('require_infrastructure_encryption', None)


class ErrorResponse(Model):
    """Error response indicates Event Hub service is not able to process the
    incoming request. The reason is provided in the error message.

    :param code: Error code.
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class Eventhub(Resource):
    """Single item in List or Get Event Hub operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar partition_ids: Current number of shards on the Event Hub.
    :vartype partition_ids: list[str]
    :ivar created_at: Exact time the Event Hub was created.
    :vartype created_at: datetime
    :ivar updated_at: The exact time the message was updated.
    :vartype updated_at: datetime
    :param message_retention_in_days: Number of days to retain the events for
     this Event Hub, value should be 1 to 7 days
    :type message_retention_in_days: long
    :param partition_count: Number of partitions created for the Event Hub,
     allowed values are from 1 to 32 partitions.
    :type partition_count: long
    :param status: Enumerates the possible values for the status of the Event
     Hub. Possible values include: 'Active', 'Disabled', 'Restoring',
     'SendDisabled', 'ReceiveDisabled', 'Creating', 'Deleting', 'Renaming',
     'Unknown'
    :type status: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.EntityStatus
    :param capture_description: Properties of capture description
    :type capture_description:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.CaptureDescription
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'partition_ids': {'readonly': True},
        'created_at': {'readonly': True},
        'updated_at': {'readonly': True},
        'message_retention_in_days': {'minimum': 1},
        'partition_count': {'minimum': 1},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'partition_ids': {'key': 'properties.partitionIds', 'type': '[str]'},
        'created_at': {'key': 'properties.createdAt', 'type': 'iso-8601'},
        'updated_at': {'key': 'properties.updatedAt', 'type': 'iso-8601'},
        'message_retention_in_days': {'key': 'properties.messageRetentionInDays', 'type': 'long'},
        'partition_count': {'key': 'properties.partitionCount', 'type': 'long'},
        'status': {'key': 'properties.status', 'type': 'EntityStatus'},
        'capture_description': {'key': 'properties.captureDescription', 'type': 'CaptureDescription'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, **kwargs):
        super(Eventhub, self).__init__(**kwargs)
        self.partition_ids = None
        self.created_at = None
        self.updated_at = None
        self.message_retention_in_days = kwargs.get('message_retention_in_days', None)
        self.partition_count = kwargs.get('partition_count', None)
        self.status = kwargs.get('status', None)
        self.capture_description = kwargs.get('capture_description', None)
        self.system_data = None


class Identity(Model):
    """Properties to configure Identity for Bring your Own Keys.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: ObjectId from the KeyVault
    :vartype principal_id: str
    :ivar tenant_id: TenantId from the KeyVault
    :vartype tenant_id: str
    :param type: Type of managed service identity. Possible values include:
     'SystemAssigned', 'UserAssigned', 'SystemAssigned, UserAssigned', 'None'
    :type type: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.ManagedServiceIdentityType
    :param user_assigned_identities: Properties for User Assigned Identities
    :type user_assigned_identities: dict[str,
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.IdentityUserAssignedIdentitiesValue]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'ManagedServiceIdentityType'},
        'user_assigned_identities': {'key': 'userAssignedIdentities', 'type': '{IdentityUserAssignedIdentitiesValue}'},
    }

    def __init__(self, **kwargs):
        super(Identity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = kwargs.get('type', None)
        self.user_assigned_identities = kwargs.get('user_assigned_identities', None)


class IdentityUserAssignedIdentitiesValue(Model):
    """IdentityUserAssignedIdentitiesValue.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar principal_id: Principal Id of user assigned identity
    :vartype principal_id: str
    :ivar client_id: Client Id of user assigned identity
    :vartype client_id: str
    """

    _validation = {
        'principal_id': {'readonly': True},
        'client_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'client_id': {'key': 'clientId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(IdentityUserAssignedIdentitiesValue, self).__init__(**kwargs)
        self.principal_id = None
        self.client_id = None


class KeyVaultProperties(Model):
    """Properties to configure keyVault Properties.

    :param key_name: Name of the Key from KeyVault
    :type key_name: str
    :param key_vault_uri: Uri of KeyVault
    :type key_vault_uri: str
    :param key_version: Key Version
    :type key_version: str
    :param identity:
    :type identity:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.UserAssignedIdentityProperties
    """

    _attribute_map = {
        'key_name': {'key': 'keyName', 'type': 'str'},
        'key_vault_uri': {'key': 'keyVaultUri', 'type': 'str'},
        'key_version': {'key': 'keyVersion', 'type': 'str'},
        'identity': {'key': 'identity', 'type': 'UserAssignedIdentityProperties'},
    }

    def __init__(self, **kwargs):
        super(KeyVaultProperties, self).__init__(**kwargs)
        self.key_name = kwargs.get('key_name', None)
        self.key_vault_uri = kwargs.get('key_vault_uri', None)
        self.key_version = kwargs.get('key_version', None)
        self.identity = kwargs.get('identity', None)


class NetworkRuleSet(Resource):
    """Description of topic resource.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param trusted_service_access_enabled: Value that indicates whether
     Trusted Service Access is Enabled or not.
    :type trusted_service_access_enabled: bool
    :param default_action: Default Action for Network Rule Set. Possible
     values include: 'Allow', 'Deny'
    :type default_action: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.DefaultAction
    :param virtual_network_rules: List VirtualNetwork Rules
    :type virtual_network_rules:
     list[~azure.mgmt.eventhub.v2021_01_01_preview.models.NWRuleSetVirtualNetworkRules]
    :param ip_rules: List of IpRules
    :type ip_rules:
     list[~azure.mgmt.eventhub.v2021_01_01_preview.models.NWRuleSetIpRules]
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'trusted_service_access_enabled': {'key': 'properties.trustedServiceAccessEnabled', 'type': 'bool'},
        'default_action': {'key': 'properties.defaultAction', 'type': 'str'},
        'virtual_network_rules': {'key': 'properties.virtualNetworkRules', 'type': '[NWRuleSetVirtualNetworkRules]'},
        'ip_rules': {'key': 'properties.ipRules', 'type': '[NWRuleSetIpRules]'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, **kwargs):
        super(NetworkRuleSet, self).__init__(**kwargs)
        self.trusted_service_access_enabled = kwargs.get('trusted_service_access_enabled', None)
        self.default_action = kwargs.get('default_action', None)
        self.virtual_network_rules = kwargs.get('virtual_network_rules', None)
        self.ip_rules = kwargs.get('ip_rules', None)
        self.system_data = None


class NWRuleSetIpRules(Model):
    """The response from the List namespace operation.

    :param ip_mask: IP Mask
    :type ip_mask: str
    :param action: The IP Filter Action. Possible values include: 'Allow'
    :type action: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.NetworkRuleIPAction
    """

    _attribute_map = {
        'ip_mask': {'key': 'ipMask', 'type': 'str'},
        'action': {'key': 'action', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(NWRuleSetIpRules, self).__init__(**kwargs)
        self.ip_mask = kwargs.get('ip_mask', None)
        self.action = kwargs.get('action', None)


class NWRuleSetVirtualNetworkRules(Model):
    """The response from the List namespace operation.

    :param subnet: Subnet properties
    :type subnet: ~azure.mgmt.eventhub.v2021_01_01_preview.models.Subnet
    :param ignore_missing_vnet_service_endpoint: Value that indicates whether
     to ignore missing Vnet Service Endpoint
    :type ignore_missing_vnet_service_endpoint: bool
    """

    _attribute_map = {
        'subnet': {'key': 'subnet', 'type': 'Subnet'},
        'ignore_missing_vnet_service_endpoint': {'key': 'ignoreMissingVnetServiceEndpoint', 'type': 'bool'},
    }

    def __init__(self, **kwargs):
        super(NWRuleSetVirtualNetworkRules, self).__init__(**kwargs)
        self.subnet = kwargs.get('subnet', None)
        self.ignore_missing_vnet_service_endpoint = kwargs.get('ignore_missing_vnet_service_endpoint', None)


class Operation(Model):
    """A Event Hub REST API operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar name: Operation name: {provider}/{resource}/{operation}
    :vartype name: str
    :param display: The object that represents the operation.
    :type display:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.OperationDisplay
    """

    _validation = {
        'name': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = None
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar provider: Service provider: Microsoft.EventHub
    :vartype provider: str
    :ivar resource: Resource on which the operation is performed: Invoice,
     etc.
    :vartype resource: str
    :ivar operation: Operation type: Read, write, delete, etc.
    :vartype operation: str
    """

    _validation = {
        'provider': {'readonly': True},
        'resource': {'readonly': True},
        'operation': {'readonly': True},
    }

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = None
        self.resource = None
        self.operation = None


class PrivateEndpoint(Model):
    """PrivateEndpoint information.

    :param id: The ARM identifier for Private Endpoint.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpoint, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class PrivateEndpointConnection(Resource):
    """Properties of the PrivateEndpointConnection.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Resource ID.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param private_endpoint: The Private Endpoint resource for this
     Connection.
    :type private_endpoint:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.PrivateEndpoint
    :param private_link_service_connection_state: Details about the state of
     the connection.
    :type private_link_service_connection_state:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.ConnectionState
    :param provisioning_state: Provisioning state of the Private Endpoint
     Connection. Possible values include: 'Creating', 'Updating', 'Deleting',
     'Succeeded', 'Canceled', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.EndPointProvisioningState
    :ivar system_data: The system meta data relating to this resource.
    :vartype system_data:
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.SystemData
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'system_data': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'private_endpoint': {'key': 'properties.privateEndpoint', 'type': 'PrivateEndpoint'},
        'private_link_service_connection_state': {'key': 'properties.privateLinkServiceConnectionState', 'type': 'ConnectionState'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'system_data': {'key': 'systemData', 'type': 'SystemData'},
    }

    def __init__(self, **kwargs):
        super(PrivateEndpointConnection, self).__init__(**kwargs)
        self.private_endpoint = kwargs.get('private_endpoint', None)
        self.private_link_service_connection_state = kwargs.get('private_link_service_connection_state', None)
        self.provisioning_state = kwargs.get('provisioning_state', None)
        self.system_data = None


class PrivateLinkResource(Model):
    """Information of the private link resource.

    :param group_id: The private link resource group id.
    :type group_id: str
    :param required_members: The private link resource required member names.
    :type required_members: list[str]
    :param required_zone_names: The private link resource Private link DNS
     zone name.
    :type required_zone_names: list[str]
    :param id: Fully qualified identifier of the resource.
    :type id: str
    :param name: Name of the resource
    :type name: str
    :param type: Type of the resource
    :type type: str
    """

    _attribute_map = {
        'group_id': {'key': 'properties.groupId', 'type': 'str'},
        'required_members': {'key': 'properties.requiredMembers', 'type': '[str]'},
        'required_zone_names': {'key': 'properties.requiredZoneNames', 'type': '[str]'},
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResource, self).__init__(**kwargs)
        self.group_id = kwargs.get('group_id', None)
        self.required_members = kwargs.get('required_members', None)
        self.required_zone_names = kwargs.get('required_zone_names', None)
        self.id = kwargs.get('id', None)
        self.name = kwargs.get('name', None)
        self.type = kwargs.get('type', None)


class PrivateLinkResourcesListResult(Model):
    """Result of the List private link resources operation.

    :param value: A collection of private link resources
    :type value:
     list[~azure.mgmt.eventhub.v2021_01_01_preview.models.PrivateLinkResource]
    :param next_link: A link for the next page of private link resources.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PrivateLinkResource]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PrivateLinkResourcesListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class RegenerateAccessKeyParameters(Model):
    """Parameters supplied to the Regenerate Authorization Rule operation,
    specifies which key needs to be reset.

    All required parameters must be populated in order to send to Azure.

    :param key_type: Required. The access key to regenerate. Possible values
     include: 'PrimaryKey', 'SecondaryKey'
    :type key_type: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.KeyType
    :param key: Optional, if the key value provided, is set for KeyType or
     autogenerated Key value set for keyType
    :type key: str
    """

    _validation = {
        'key_type': {'required': True},
    }

    _attribute_map = {
        'key_type': {'key': 'keyType', 'type': 'KeyType'},
        'key': {'key': 'key', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RegenerateAccessKeyParameters, self).__init__(**kwargs)
        self.key_type = kwargs.get('key_type', None)
        self.key = kwargs.get('key', None)


class Sku(Model):
    """SKU parameters supplied to the create namespace operation.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. Name of this SKU. Possible values include: 'Basic',
     'Standard', 'Premium'
    :type name: str or ~azure.mgmt.eventhub.v2021_01_01_preview.models.SkuName
    :param tier: The billing tier of this particular SKU. Possible values
     include: 'Basic', 'Standard', 'Premium'
    :type tier: str or ~azure.mgmt.eventhub.v2021_01_01_preview.models.SkuTier
    :param capacity: The Event Hubs throughput units for Basic or Standard
     tiers, where value should be 0 to 20 throughput units. The Event Hubs
     premium units for Premium tier, where value should be 0 to 10 premium
     units.
    :type capacity: int
    """

    _validation = {
        'name': {'required': True},
        'capacity': {'maximum': 20, 'minimum': 0},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'int'},
    }

    def __init__(self, **kwargs):
        super(Sku, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.tier = kwargs.get('tier', None)
        self.capacity = kwargs.get('capacity', None)


class Subnet(Model):
    """Properties supplied for Subnet.

    :param id: Resource ID of Virtual Network Subnet
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Subnet, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)


class SystemData(Model):
    """Metadata pertaining to creation and last modification of the resource.

    :param created_by: The identity that created the resource.
    :type created_by: str
    :param created_by_type: The type of identity that created the resource.
     Possible values include: 'User', 'Application', 'ManagedIdentity', 'Key'
    :type created_by_type: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.CreatedByType
    :param created_at: The timestamp of resource creation (UTC).
    :type created_at: datetime
    :param last_modified_by: The identity that last modified the resource.
    :type last_modified_by: str
    :param last_modified_by_type: The type of identity that last modified the
     resource. Possible values include: 'User', 'Application',
     'ManagedIdentity', 'Key'
    :type last_modified_by_type: str or
     ~azure.mgmt.eventhub.v2021_01_01_preview.models.CreatedByType
    :param last_modified_at: The type of identity that last modified the
     resource.
    :type last_modified_at: datetime
    """

    _attribute_map = {
        'created_by': {'key': 'createdBy', 'type': 'str'},
        'created_by_type': {'key': 'createdByType', 'type': 'str'},
        'created_at': {'key': 'createdAt', 'type': 'iso-8601'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'str'},
        'last_modified_by_type': {'key': 'lastModifiedByType', 'type': 'str'},
        'last_modified_at': {'key': 'lastModifiedAt', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(SystemData, self).__init__(**kwargs)
        self.created_by = kwargs.get('created_by', None)
        self.created_by_type = kwargs.get('created_by_type', None)
        self.created_at = kwargs.get('created_at', None)
        self.last_modified_by = kwargs.get('last_modified_by', None)
        self.last_modified_by_type = kwargs.get('last_modified_by_type', None)
        self.last_modified_at = kwargs.get('last_modified_at', None)


class UserAssignedIdentityProperties(Model):
    """UserAssignedIdentityProperties.

    :param user_assigned_identity: ARM ID of user Identity selected for
     encryption
    :type user_assigned_identity: str
    """

    _attribute_map = {
        'user_assigned_identity': {'key': 'userAssignedIdentity', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(UserAssignedIdentityProperties, self).__init__(**kwargs)
        self.user_assigned_identity = kwargs.get('user_assigned_identity', None)
