/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.sp;

import java.util.ArrayList;
import java.util.List;
import org.snu.ids.ha.ma.Eojeol;
import org.snu.ids.ha.ma.Morpheme;
import org.snu.ids.ha.sp.ParseTreeEdge;
import org.snu.ids.ha.util.Util;

public class ParseTreeNode {
    int id = 0;
    private Eojeol eojeol;
    private ParseTreeNode parentNode;
    private List<ParseTreeEdge> childEdges;

    protected ParseTreeNode(Eojeol eojeol) {
        this.eojeol = eojeol;
    }

    public List<ParseTreeEdge> getChildEdges() {
        return this.childEdges;
    }

    public void addChildEdge(ParseTreeEdge arc) {
        if (this.childEdges == null) {
            this.childEdges = new ArrayList<ParseTreeEdge>();
        }
        this.childEdges.add(arc);
    }

    public int getId() {
        return this.id;
    }

    public Eojeol getEojeol() {
        return this.eojeol;
    }

    public ParseTreeNode getParentNode() {
        return this.parentNode;
    }

    public void setParentNode(ParseTreeNode parentNode) {
        this.parentNode = parentNode;
    }

    public boolean contains(ParseTreeNode node) {
        if (this.eojeol == node.eojeol) {
            return true;
        }
        for (ParseTreeEdge edge : this.childEdges) {
            ParseTreeNode child = edge.getChildNode();
            if (!child.contains(node)) continue;
            return true;
        }
        return false;
    }

    public void traverse(int depth, String relation, StringBuffer sb) {
        int i = 0;
        while (i < depth) {
            sb.append("\t");
            ++i;
        }
        if (relation != null) {
            sb.append("<=[" + relation + "]=| ");
        }
        sb.append(String.valueOf(this.id) + "\t" + this.eojeol + "\n");
        i = 0;
        int size = this.childEdges == null ? 0 : this.childEdges.size();
        while (i < size) {
            ParseTreeEdge edge = this.childEdges.get(i);
            edge.getChildNode().traverse(depth + 1, edge.getRelation(), sb);
            ++i;
        }
    }

    public int traverse(int id) {
        this.id = id;
        int ret = id;
        int i = 0;
        int size = this.childEdges == null ? 0 : this.childEdges.size();
        while (i < size) {
            ParseTreeEdge edge = this.childEdges.get(i);
            ret = edge.getChildNode().traverse(ret + 1);
            ++i;
        }
        return ret;
    }

    public void traverse(List<ParseTreeNode> nodeList, List<ParseTreeEdge> edgeList) {
        nodeList.add(this);
        int i = 0;
        int size = this.childEdges == null ? 0 : this.childEdges.size();
        while (i < size) {
            ParseTreeEdge edge = this.childEdges.get(i);
            edgeList.add(edge);
            edge.getChildNode().traverse(nodeList, edgeList);
            ++i;
        }
    }

    public String getExp() {
        return this.eojeol == null ? "ROOT" : this.eojeol.getExp();
    }

    public String getMorpXmlStr() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int size = this.eojeol == null ? 0 : this.eojeol.size();
        while (i < size) {
            Morpheme morp = (Morpheme)this.eojeol.get(i);
            if (i > 0) {
                sb.append("+");
            }
            sb.append(String.valueOf(Util.rplcXMLSpclChar(morp.getString())) + "/" + morp.getTag());
            ++i;
        }
        return sb.toString();
    }
}

