/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.dic;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.snu.ids.ha.constants.POSTag;
import org.snu.ids.ha.dic.PDDictionary;
import org.snu.ids.ha.dic.SpacingPDDictionary;
import org.snu.ids.ha.util.Timer;
import org.snu.ids.ha.util.Util;

public class UNPDDictionary {
    private static final float DEFAULT_PROB = -30.0f;
    private static final Hashtable<Character, Float> PROB_AT_NOUN_HASH = new Hashtable();

    static {
        UNPDDictionary.load("/dic/prob/lnpr_syllable_uni_noun.dic");
    }

    public static final void load(String fileName) {
        System.out.println("Loading " + fileName);
        Timer timer = new Timer();
        timer.start();
        String line = null;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(SpacingPDDictionary.class.getResourceAsStream(fileName), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    if (!Util.valid(line) || line.startsWith("//")) continue;
                    line = line.trim();
                    char ch = line.charAt(0);
                    float lnpr = Float.parseFloat(line.substring(1).trim());
                    PROB_AT_NOUN_HASH.put(Character.valueOf(ch), Float.valueOf(lnpr));
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(line);
                System.err.println("Unable to load probability dictionary!!");
                timer.stop();
                System.out.println(String.valueOf(PROB_AT_NOUN_HASH.size()) + " values are loaded. (Loading time( " + timer.getInterval() + " secs)");
            }
        }
        finally {
            timer.stop();
            System.out.println(String.valueOf(PROB_AT_NOUN_HASH.size()) + " values are loaded. (Loading time( " + timer.getInterval() + " secs)");
        }
    }

    private static final float getProbAtNoun(char ch) {
        Float lnpr = PROB_AT_NOUN_HASH.get(Character.valueOf(ch));
        if (lnpr != null) {
            return lnpr.floatValue();
        }
        return -30.0f;
    }

    public static float getProb(String str) {
        if (!Util.valid(str)) {
            return Float.MIN_VALUE;
        }
        float prob = 0.0f;
        int i = 0;
        int len = str.length();
        while (i < len) {
            char ch = str.charAt(i);
            prob += UNPDDictionary.getProbAtNoun(ch);
            ++i;
        }
        return prob;
    }

    public static void main(String[] args) {
        System.out.println(UNPDDictionary.getProb("\uc18d\ud55c"));
        System.out.println(PDDictionary.getLnprPosGExp("\uc18d\ud558", POSTag.VV));
    }
}

