/*
 * Decompiled with CFR 0.152.
 */
package org.snu.ids.ha.dic;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.Hashtable;
import org.snu.ids.ha.util.Timer;
import org.snu.ids.ha.util.Util;

public class SpacingPDDictionary {
    private static final float DEFAULT_PROB = (float)Math.log(0.5);
    private static final Hashtable<String, float[]> PROB_HASH = new Hashtable();

    static {
        SpacingPDDictionary.load("/dic/prob/lnpr_syllable_bi.dic");
    }

    public static final void load(String fileName) {
        System.out.println("Loading " + fileName);
        Timer timer = new Timer();
        timer.start();
        String line = null;
        BufferedReader br = null;
        try {
            try {
                br = new BufferedReader(new InputStreamReader(SpacingPDDictionary.class.getResourceAsStream(fileName), "UTF-8"));
                while ((line = br.readLine()) != null) {
                    if (!Util.valid(line) || line.startsWith("//")) continue;
                    line = line.trim();
                    String[] arr = line.split("\t");
                    float[] lnProb = new float[]{Float.parseFloat(arr[2]), Float.parseFloat(arr[3])};
                    PROB_HASH.put(SpacingPDDictionary.getKey(arr[0], arr[1]), lnProb);
                }
                br.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println(line);
                System.err.println("Unable to load probability dictionary!!");
                timer.stop();
                System.out.println(String.valueOf(PROB_HASH.size()) + " values are loaded. (Loading time( " + timer.getInterval() + " secs)");
            }
        }
        finally {
            timer.stop();
            System.out.println(String.valueOf(PROB_HASH.size()) + " values are loaded. (Loading time( " + timer.getInterval() + " secs)");
        }
    }

    public static final float getProb(char ch1, char ch2, boolean hasSpace) {
        float[] probs = PROB_HASH.get(SpacingPDDictionary.getKey(ch1, ch2));
        if (probs != null) {
            if (hasSpace) {
                return probs[0];
            }
            return probs[1];
        }
        return DEFAULT_PROB;
    }

    public static float getProb(String str) {
        if (!Util.valid(str)) {
            return Float.MIN_VALUE;
        }
        float prob = 0.0f;
        str = str.trim().replaceAll("[ \t]+", " ");
        int i = 0;
        int len = str.length() - 1;
        while (i < len) {
            boolean hasSpace = false;
            char ch1 = str.charAt(i);
            char ch2 = str.charAt(i + 1);
            if (ch2 == ' ') {
                ch2 = str.charAt(i + 1);
                ++i;
                hasSpace = true;
            }
            float fTemp = SpacingPDDictionary.getProb(ch1, ch2, hasSpace);
            prob += fTemp;
            ++i;
        }
        return prob;
    }

    private static String getKey(String syllable1, String syllable2) {
        return String.valueOf(syllable1) + syllable2;
    }

    private static String getKey(char syllable1, char syllable2) {
        return String.valueOf(syllable1) + syllable2;
    }

    public static void main(String[] args) {
        System.out.println(SpacingPDDictionary.getProb("\uc1fc\uc640"));
        System.out.println(SpacingPDDictionary.getProb("\uc1fc \uc640"));
    }
}

