
"""
    This code was generated by Codezu.     

    Changes to this file may cause incorrect behavior and will be lost if
    the code is regenerated.
"""


from mozurestsdk.mozuclient import default as default_client
from mozurestsdk.mozuurl import MozuUrl;
from mozurestsdk.urllocation import UrlLocation
from mozurestsdk.apicontext import ApiContext;

class ProductSearchResult(object):
	def __init__(self, apiContext: ApiContext = None, mozuClient = None):
		self.client = mozuClient or default_client();
		client.withApiContext(apiContext);
	
	def search(self,query = None, filter = None, facetTemplate = None, facetTemplateSubset = None, facet = None, facetFieldRangeQuery = None, facetHierPrefix = None, facetHierValue = None, facetHierDepth = None, facetStartIndex = None, facetPageSize = None, facetSettings = None, facetValueFilter = None, sortBy = None, pageSize = None, startIndex = None, searchSettings = None, responseFields = None):
		""" Searches the categories displayed on the web storefront for products or product options that the shopper types in a search query.
		
		Args:
			| query (string) - A query entered for searches and facet range.
			| filter (string) - A set of filter expressions representing the search parameters for a query: eq=equals, ne=not equals, gt=greater than, lt = less than or equals, gt = greater than or equals, lt = less than or equals, sw = starts with, or cont = contains. Optional.
			| facetTemplate (string) - The facet template to use on the storefront. A template displays all facets associated with the template on the web storefront product search. Currently, only category-level facet templates are available.
			| facetTemplateSubset (string) - Display a subset of the facets defined in the template specified in facetTemplate parameter.
			| facet (string) - Individually list the facet fields you want to display in a web storefront product search.
			| facetFieldRangeQuery (string) - Display a range facet not specified in a template in a web storefront product search by listing the facet field and the range to display.
			| facetHierPrefix (string) - If filtering using category facets in a hierarchy, the parent categories you want to skip in the storefront product search. This parameter is only available for category facets.
			| facetHierValue (string) - If filtering using category facets in a hierarchy, the category in the hierarchy to begin faceting on. This parameter is only available for category facets.
			| facetHierDepth (string) - If filtering using category facets in a hierarchy, the number of category hierarchy levels to return for the facet. This option is only available for category facets.
			| facetStartIndex (string) - When paging through multiple facets, the startIndex value for each facet.
			| facetPageSize (string) - The number of facet values to return for one or more facets.
			| facetSettings (string) - Settings reserved for future facet search functionality on a web storefront product search.
			| facetValueFilter (string) - The facet values to apply to the filter.
			| sortBy (string) - 
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| startIndex (int) - 
			| searchSettings (string) - 
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| ProductSearchResult 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/storefront/productsearch/search/?query={query}&filter={filter}&facetTemplate={facetTemplate}&facetTemplateSubset={facetTemplateSubset}&facet={facet}&facetFieldRangeQuery={facetFieldRangeQuery}&facetHierPrefix={facetHierPrefix}&facetHierValue={facetHierValue}&facetHierDepth={facetHierDepth}&facetStartIndex={facetStartIndex}&facetPageSize={facetPageSize}&facetSettings={facetSettings}&facetValueFilter={facetValueFilter}&sortBy={sortBy}&pageSize={pageSize}&startIndex={startIndex}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("facet", facet);
		url.formatUrl("facetFieldRangeQuery", facetFieldRangeQuery);
		url.formatUrl("facetHierDepth", facetHierDepth);
		url.formatUrl("facetHierPrefix", facetHierPrefix);
		url.formatUrl("facetHierValue", facetHierValue);
		url.formatUrl("facetPageSize", facetPageSize);
		url.formatUrl("facetSettings", facetSettings);
		url.formatUrl("facetStartIndex", facetStartIndex);
		url.formatUrl("facetTemplate", facetTemplate);
		url.formatUrl("facetTemplateSubset", facetTemplateSubset);
		url.formatUrl("facetValueFilter", facetValueFilter);
		url.formatUrl("filter", filter);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("query", query);
		url.formatUrl("responseFields", responseFields);
		url.formatUrl("searchSettings", searchSettings);
		url.formatUrl("sortBy", sortBy);
		url.formatUrl("startIndex", startIndex);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
		
	def suggest(self,query = None, groups = None, pageSize = None, responseFields = None):
		""" Suggests possible search terms as the shopper enters search text.
		
		Args:
			| query (string) - A query entered for searches and facet range.
			| groups (string) - 
			| pageSize (int) - The number of results to display on each page when creating paged results from a query. The maximum value is 200.
			| responseFields (string) - Use this field to include those fields which are not included by default.
		
		Returns:
			| SearchSuggestionResult 
		
		Raises:
			| ApiException
		
		"""

		url = MozuUrl("/api/commerce/catalog/storefront/productsearch/suggest?query={query}&groups={groups}&pageSize={pageSize}&responseFields={responseFields}", "GET", UrlLocation.TenantPod, False);
		url.formatUrl("groups", groups);
		url.formatUrl("pageSize", pageSize);
		url.formatUrl("query", query);
		url.formatUrl("responseFields", responseFields);
		self.client.withResourceUrl(url).execute();
		return self.client.result();

	
	
	