/* /////////////////////////////////////////////////////////////////////////
 * File:        stlsoft/algorithms.hpp
 *
 * Purpose:     Main header file for the STLSoft Algorithms library.
 *
 * Created:     23rd October 2004
 * Updated:     10th August 2009
 *
 * Home:        http://stlsoft.org/
 *
 * Copyright (c) 2004-2009, Matthew Wilson and Synesis Software
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice, this
 *   list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright notice,
 *   this list of conditions and the following disclaimer in the documentation
 *   and/or other materials provided with the distribution.
 * - Neither the name(s) of Matthew Wilson and Synesis Software nor the names of
 *   any contributors may be used to endorse or promote products derived from
 *   this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * ////////////////////////////////////////////////////////////////////// */


/** \file stlsoft/algorithms.hpp
 *
 * \brief [C++ only] Main header file for the STLSoft Algorithms library
 *   (\ref group__library__algorithms "Algorithms" Library).
 */

#ifndef STLSOFT_INCL_STLSOFT_HPP_ALGORITHMS
#define STLSOFT_INCL_STLSOFT_HPP_ALGORITHMS

#ifndef STLSOFT_DOCUMENTATION_SKIP_SECTION
# define STLSOFT_VER_STLSOFT_HPP_ALGORITHMS_MAJOR       2
# define STLSOFT_VER_STLSOFT_HPP_ALGORITHMS_MINOR       0
# define STLSOFT_VER_STLSOFT_HPP_ALGORITHMS_REVISION    2
# define STLSOFT_VER_STLSOFT_HPP_ALGORITHMS_EDIT        29
#endif /* !STLSOFT_DOCUMENTATION_SKIP_SECTION */

/* /////////////////////////////////////////////////////////////////////////
 * Compatibility
 */

/*
[Incompatibilies-start]
STLSOFT_COMPILER_IS_WATCOM:
[Incompatibilies-end]
 */

/* /////////////////////////////////////////////////////////////////////////
 * Includes
 */

#ifndef STLSOFT_INCL_STLSOFT_H_STLSOFT
# include <stlsoft/stlsoft.h>
#endif /* !STLSOFT_INCL_STLSOFT_H_STLSOFT */

#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_BOUNDED
# include <stlsoft/algorithms/bounded.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_BOUNDED */
#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_COLLECTION
# include <stlsoft/algorithms/collection.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_COLLECTION */
#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_DEBUG
# include <stlsoft/algorithms/debug.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_DEBUG */
#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_DEPRECATED
# include <stlsoft/algorithms/deprecated.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_DEPRECATED */
#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_POD
# include <stlsoft/algorithms/pod.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_POD */
#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_UNORDERED
# include <stlsoft/algorithms/unordered.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_HPP_UNORDERED */
#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_STD_HPP_ALT
# include <stlsoft/algorithms/std/alt.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_STD_HPP_ALT */
#ifndef STLSOFT_INCL_STLSOFT_ALGORITHMS_STD_HPP_EXT
# include <stlsoft/algorithms/std/ext.hpp>
#endif /* !STLSOFT_INCL_STLSOFT_ALGORITHMS_STD_HPP_EXT */

/* ////////////////////////////////////////////////////////////////////// */

#endif /* !STLSOFT_INCL_STLSOFT_HPP_ALGORITHMS */

/* ///////////////////////////// end of file //////////////////////////// */
