/* Copyright 2017 - 2021 R. Thomas
 * Copyright 2017 - 2021 Quarkslab
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef LIEF_PE_GDI32_DLL_LOOKUP_H_
#define LIEF_PE_GDI32_DLL_LOOKUP_H_

#include <map>

namespace LIEF {
namespace PE {

static const std::map<uint32_t, const char*> gdi32_dll_lookup {
    { 0x0001, "AbortDoc"                    },
    { 0x0002, "AbortPath"                   },
    { 0x0003, "AddFontMemResourceEx"        },
    { 0x0004, "AddFontResourceA"            },
    { 0x0005, "AddFontResourceExA"          },
    { 0x0006, "AddFontResourceExW"          },
    { 0x0007, "AddFontResourceTracking"     },
    { 0x0008, "AddFontResourceW"            },
    { 0x0009, "AngleArc"                    },
    { 0x000a, "AnimatePalette"              },
    { 0x000b, "AnyLinkedFonts"              },
    { 0x000c, "Arc"                         },
    { 0x000d, "ArcTo"                       },
    { 0x000e, "BRUSHOBJ_hGetColorTransform" },
    { 0x000f, "BRUSHOBJ_pvAllocRbrush"      },
    { 0x0010, "BRUSHOBJ_pvGetRbrush"        },
    { 0x0011, "BRUSHOBJ_ulGetBrushColor"    },
    { 0x0012, "BeginPath"                   },
    { 0x0013, "BitBlt"                      },
    { 0x0014, "CLIPOBJ_bEnum"               },
    { 0x0015, "CLIPOBJ_cEnumStart"          },
    { 0x0016, "CLIPOBJ_ppoGetPath"          },
    { 0x0017, "CancelDC"                    },
    { 0x0018, "CheckColorsInGamut"          },
    { 0x0019, "ChoosePixelFormat"           },
    { 0x001a, "Chord"                       },
    { 0x001b, "ClearBitmapAttributes"       },
    { 0x001c, "ClearBrushAttributes"        },
    { 0x001d, "CloseEnhMetaFile"            },
    { 0x001e, "CloseFigure"                 },
    { 0x001f, "CloseMetaFile"               },
    { 0x0020, "ColorCorrectPalette"         },
    { 0x0021, "ColorMatchToTarget"          },
    { 0x0022, "CombineRgn"                  },
    { 0x0023, "CombineTransform"            },
    { 0x0024, "CopyEnhMetaFileA"            },
    { 0x0025, "CopyEnhMetaFileW"            },
    { 0x0026, "CopyMetaFileA"               },
    { 0x0027, "CopyMetaFileW"               },
    { 0x0028, "CreateBitmap"                },
    { 0x0029, "CreateBitmapIndirect"        },
    { 0x002a, "CreateBrushIndirect"         },
    { 0x002b, "CreateColorSpaceA"           },
    { 0x002c, "CreateColorSpaceW"           },
    { 0x002d, "CreateCompatibleBitmap"      },
    { 0x002e, "CreateCompatibleDC"          },
    { 0x002f, "CreateDCA"                   },
    { 0x0030, "CreateDCW"                   },
    { 0x0031, "CreateDIBPatternBrush"       },
    { 0x0032, "CreateDIBPatternBrushPt"     },
    { 0x0033, "CreateDIBSection"            },
    { 0x0034, "CreateDIBitmap"              },
    { 0x0035, "CreateDiscardableBitmap"     },
    { 0x0036, "CreateEllipticRgn"           },
    { 0x0037, "CreateEllipticRgnIndirect"   },
    { 0x0038, "CreateEnhMetaFileA"          },
    { 0x0039, "CreateEnhMetaFileW"          },
    { 0x003a, "CreateFontA"                 },
    { 0x003b, "CreateFontIndirectA"         },
    { 0x003c, "CreateFontIndirectExA"       },
    { 0x003d, "CreateFontIndirectExW"       },
    { 0x003e, "CreateFontIndirectW"         },
    { 0x003f, "CreateFontW"                 },
    { 0x0040, "CreateHalftonePalette"       },
    { 0x0041, "CreateHatchBrush"            },
    { 0x0042, "CreateICA"                   },
    { 0x0043, "CreateICW"                   },
    { 0x0044, "CreateMetaFileA"             },
    { 0x0045, "CreateMetaFileW"             },
    { 0x0046, "CreatePalette"               },
    { 0x0047, "CreatePatternBrush"          },
    { 0x0048, "CreatePen"                   },
    { 0x0049, "CreatePenIndirect"           },
    { 0x004a, "CreatePolyPolygonRgn"        },
    { 0x004b, "CreatePolygonRgn"            },
    { 0x004c, "CreateRectRgn"               },
    { 0x004d, "CreateRectRgnIndirect"       },
    { 0x004e, "CreateRoundRectRgn"          },
    { 0x004f, "CreateScalableFontResourceA" },
    { 0x0050, "CreateScalableFontResourceW" },
    { 0x0051, "CreateSolidBrush"            },
    { 0x0052, "DPtoLP"                      },
    { 0x0053, "DdEntry0"                    },
    { 0x005e, "DdEntry1"                    },
    { 0x0054, "DdEntry10"                   },
    { 0x0055, "DdEntry11"                   },
    { 0x0056, "DdEntry12"                   },
    { 0x0057, "DdEntry13"                   },
    { 0x0058, "DdEntry14"                   },
    { 0x0059, "DdEntry15"                   },
    { 0x005a, "DdEntry16"                   },
    { 0x005b, "DdEntry17"                   },
    { 0x005c, "DdEntry18"                   },
    { 0x005d, "DdEntry19"                   },
    { 0x0069, "DdEntry2"                    },
    { 0x005f, "DdEntry20"                   },
    { 0x0060, "DdEntry21"                   },
    { 0x0061, "DdEntry22"                   },
    { 0x0062, "DdEntry23"                   },
    { 0x0063, "DdEntry24"                   },
    { 0x0064, "DdEntry25"                   },
    { 0x0065, "DdEntry26"                   },
    { 0x0066, "DdEntry27"                   },
    { 0x0067, "DdEntry28"                   },
    { 0x0068, "DdEntry29"                   },
    { 0x0074, "DdEntry3"                    },
    { 0x006a, "DdEntry30"                   },
    { 0x006b, "DdEntry31"                   },
    { 0x006c, "DdEntry32"                   },
    { 0x006d, "DdEntry33"                   },
    { 0x006e, "DdEntry34"                   },
    { 0x006f, "DdEntry35"                   },
    { 0x0070, "DdEntry36"                   },
    { 0x0071, "DdEntry37"                   },
    { 0x0072, "DdEntry38"                   },
    { 0x0073, "DdEntry39"                   },
    { 0x007f, "DdEntry4"                    },
    { 0x0075, "DdEntry40"                   },
    { 0x0076, "DdEntry41"                   },
    { 0x0077, "DdEntry42"                   },
    { 0x0078, "DdEntry43"                   },
    { 0x0079, "DdEntry44"                   },
    { 0x007a, "DdEntry45"                   },
    { 0x007b, "DdEntry46"                   },
    { 0x007c, "DdEntry47"                   },
    { 0x007d, "DdEntry48"                   },
    { 0x007e, "DdEntry49"                   },
    { 0x0087, "DdEntry5"                    },
    { 0x0080, "DdEntry50"                   },
    { 0x0081, "DdEntry51"                   },
    { 0x0082, "DdEntry52"                   },
    { 0x0083, "DdEntry53"                   },
    { 0x0084, "DdEntry54"                   },
    { 0x0085, "DdEntry55"                   },
    { 0x0086, "DdEntry56"                   },
    { 0x0088, "DdEntry6"                    },
    { 0x0089, "DdEntry7"                    },
    { 0x008a, "DdEntry8"                    },
    { 0x008b, "DdEntry9"                    },
    { 0x008c, "DeleteColorSpace"            },
    { 0x008d, "DeleteDC"                    },
    { 0x008e, "DeleteEnhMetaFile"           },
    { 0x008f, "DeleteMetaFile"              },
    { 0x0090, "DeleteObject"                },
    { 0x0091, "DescribePixelFormat"         },
    { 0x0092, "DeviceCapabilitiesExA"       },
    { 0x0093, "DeviceCapabilitiesExW"       },
    { 0x0094, "DrawEscape"                  },
    { 0x0095, "Ellipse"                     },
    { 0x0096, "EnableEUDC"                  },
    { 0x0097, "EndDoc"                      },
    { 0x0098, "EndFormPage"                 },
    { 0x0099, "EndPage"                     },
    { 0x009a, "EndPath"                     },
    { 0x009b, "EngAcquireSemaphore"         },
    { 0x009c, "EngAlphaBlend"               },
    { 0x009d, "EngAssociateSurface"         },
    { 0x009e, "EngBitBlt"                   },
    { 0x009f, "EngCheckAbort"               },
    { 0x00a0, "EngComputeGlyphSet"          },
    { 0x00a1, "EngCopyBits"                 },
    { 0x00a2, "EngCreateBitmap"             },
    { 0x00a3, "EngCreateClip"               },
    { 0x00a4, "EngCreateDeviceBitmap"       },
    { 0x00a5, "EngCreateDeviceSurface"      },
    { 0x00a6, "EngCreatePalette"            },
    { 0x00a7, "EngCreateSemaphore"          },
    { 0x00a8, "EngDeleteClip"               },
    { 0x00a9, "EngDeletePalette"            },
    { 0x00aa, "EngDeletePath"               },
    { 0x00ab, "EngDeleteSemaphore"          },
    { 0x00ac, "EngDeleteSurface"            },
    { 0x00ad, "EngEraseSurface"             },
    { 0x00ae, "EngFillPath"                 },
    { 0x00af, "EngFindResource"             },
    { 0x00b0, "EngFreeModule"               },
    { 0x00b1, "EngGetCurrentCodePage"       },
    { 0x00b2, "EngGetDriverName"            },
    { 0x00b3, "EngGetPrinterDataFileName"   },
    { 0x00b4, "EngGradientFill"             },
    { 0x00b5, "EngLineTo"                   },
    { 0x00b6, "EngLoadModule"               },
    { 0x00b7, "EngLockSurface"              },
    { 0x00b8, "EngMarkBandingSurface"       },
    { 0x00b9, "EngMultiByteToUnicodeN"      },
    { 0x00ba, "EngMultiByteToWideChar"      },
    { 0x00bb, "EngPaint"                    },
    { 0x00bc, "EngPlgBlt"                   },
    { 0x00bd, "EngQueryEMFInfo"             },
    { 0x00be, "EngQueryLocalTime"           },
    { 0x00bf, "EngReleaseSemaphore"         },
    { 0x00c0, "EngStretchBlt"               },
    { 0x00c1, "EngStretchBltROP"            },
    { 0x00c2, "EngStrokeAndFillPath"        },
    { 0x00c3, "EngStrokePath"               },
    { 0x00c4, "EngTextOut"                  },
    { 0x00c5, "EngTransparentBlt"           },
    { 0x00c6, "EngUnicodeToMultiByteN"      },
    { 0x00c7, "EngUnlockSurface"            },
    { 0x00c8, "EngWideCharToMultiByte"      },
    { 0x00c9, "EnumEnhMetaFile"             },
    { 0x00ca, "EnumFontFamiliesA"           },
    { 0x00cb, "EnumFontFamiliesExA"         },
    { 0x00cc, "EnumFontFamiliesExW"         },
    { 0x00cd, "EnumFontFamiliesW"           },
    { 0x00ce, "EnumFontsA"                  },
    { 0x00cf, "EnumFontsW"                  },
    { 0x00d0, "EnumICMProfilesA"            },
    { 0x00d1, "EnumICMProfilesW"            },
    { 0x00d2, "EnumMetaFile"                },
    { 0x00d3, "EnumObjects"                 },
    { 0x00d4, "EqualRgn"                    },
    { 0x00d5, "Escape"                      },
    { 0x00d6, "EudcLoadLinkW"               },
    { 0x00d7, "EudcUnloadLinkW"             },
    { 0x00d8, "ExcludeClipRect"             },
    { 0x00d9, "ExtCreatePen"                },
    { 0x00da, "ExtCreateRegion"             },
    { 0x00db, "ExtEscape"                   },
    { 0x00dc, "ExtFloodFill"                },
    { 0x00dd, "ExtSelectClipRgn"            },
    { 0x00de, "ExtTextOutA"                 },
    { 0x00df, "ExtTextOutW"                 },
    { 0x00e0, "FONTOBJ_cGetAllGlyphHandles" },
    { 0x00e1, "FONTOBJ_cGetGlyphs"          },
    { 0x00e2, "FONTOBJ_pQueryGlyphAttrs"    },
    { 0x00e3, "FONTOBJ_pfdg"                },
    { 0x00e4, "FONTOBJ_pifi"                },
    { 0x00e5, "FONTOBJ_pvTrueTypeFontFile"  },
    { 0x00e6, "FONTOBJ_pxoGetXform"         },
    { 0x00e7, "FONTOBJ_vGetInfo"            },
    { 0x00e8, "FillPath"                    },
    { 0x00e9, "FillRgn"                     },
    { 0x00ea, "FixBrushOrgEx"               },
    { 0x00eb, "FlattenPath"                 },
    { 0x00ec, "FloodFill"                   },
    { 0x00ed, "FontIsLinked"                },
    { 0x00ee, "FrameRgn"                    },
    { 0x00ef, "GdiAddFontResourceW"         },
    { 0x00f0, "GdiAddGlsBounds"             },
    { 0x00f1, "GdiAddGlsRecord"             },
    { 0x00f2, "GdiAlphaBlend"               },
    { 0x00f3, "GdiArtificialDecrementDriver" },
    { 0x00f4, "GdiCleanCacheDC"             },
    { 0x00f5, "GdiComment"                  },
    { 0x00f6, "GdiConsoleTextOut"           },
    { 0x00f7, "GdiConvertAndCheckDC"        },
    { 0x00f8, "GdiConvertBitmap"            },
    { 0x00f9, "GdiConvertBitmapV5"          },
    { 0x00fa, "GdiConvertBrush"             },
    { 0x00fb, "GdiConvertDC"                },
    { 0x00fc, "GdiConvertEnhMetaFile"       },
    { 0x00fd, "GdiConvertFont"              },
    { 0x00fe, "GdiConvertMetaFilePict"      },
    { 0x00ff, "GdiConvertPalette"           },
    { 0x0100, "GdiConvertRegion"            },
    { 0x0101, "GdiConvertToDevmodeW"        },
    { 0x0102, "GdiCreateLocalEnhMetaFile"   },
    { 0x0103, "GdiCreateLocalMetaFilePict"  },
    { 0x0104, "GdiDeleteLocalDC"            },
    { 0x0105, "GdiDeleteSpoolFileHandle"    },
    { 0x0106, "GdiDescribePixelFormat"      },
    { 0x0107, "GdiDllInitialize"            },
    { 0x0108, "GdiDrawStream"               },
    { 0x0109, "GdiEndDocEMF"                },
    { 0x010a, "GdiEndPageEMF"               },
    { 0x0112, "GdiEntry1"                   },
    { 0x010b, "GdiEntry10"                  },
    { 0x010c, "GdiEntry11"                  },
    { 0x010d, "GdiEntry12"                  },
    { 0x010e, "GdiEntry13"                  },
    { 0x010f, "GdiEntry14"                  },
    { 0x0110, "GdiEntry15"                  },
    { 0x0111, "GdiEntry16"                  },
    { 0x0113, "GdiEntry2"                   },
    { 0x0114, "GdiEntry3"                   },
    { 0x0115, "GdiEntry4"                   },
    { 0x0116, "GdiEntry5"                   },
    { 0x0117, "GdiEntry6"                   },
    { 0x0118, "GdiEntry7"                   },
    { 0x0119, "GdiEntry8"                   },
    { 0x011a, "GdiEntry9"                   },
    { 0x011b, "GdiFixUpHandle"              },
    { 0x011c, "GdiFlush"                    },
    { 0x011d, "GdiFullscreenControl"        },
    { 0x011e, "GdiGetBatchLimit"            },
    { 0x011f, "GdiGetCharDimensions"        },
    { 0x0120, "GdiGetCodePage"              },
    { 0x0121, "GdiGetDC"                    },
    { 0x0122, "GdiGetDevmodeForPage"        },
    { 0x0123, "GdiGetLocalBrush"            },
    { 0x0124, "GdiGetLocalDC"               },
    { 0x0125, "GdiGetLocalFont"             },
    { 0x0126, "GdiGetPageCount"             },
    { 0x0127, "GdiGetPageHandle"            },
    { 0x0128, "GdiGetSpoolFileHandle"       },
    { 0x0129, "GdiGetSpoolMessage"          },
    { 0x012a, "GdiGradientFill"             },
    { 0x012b, "GdiInitSpool"                },
    { 0x012c, "GdiInitializeLanguagePack"   },
    { 0x012d, "GdiIsMetaFileDC"             },
    { 0x012e, "GdiIsMetaPrintDC"            },
    { 0x012f, "GdiIsPlayMetafileDC"         },
    { 0x0130, "GdiPlayDCScript"             },
    { 0x0131, "GdiPlayEMF"                  },
    { 0x0132, "GdiPlayJournal"              },
    { 0x0133, "GdiPlayPageEMF"              },
    { 0x0134, "GdiPlayPrivatePageEMF"       },
    { 0x0135, "GdiPlayScript"               },
    { 0x0136, "GdiPrinterThunk"             },
    { 0x0137, "GdiProcessSetup"             },
    { 0x0138, "GdiQueryFonts"               },
    { 0x0139, "GdiQueryTable"               },
    { 0x013a, "GdiRealizationInfo"          },
    { 0x013b, "GdiReleaseDC"                },
    { 0x013c, "GdiReleaseLocalDC"           },
    { 0x013d, "GdiResetDCEMF"               },
    { 0x013e, "GdiSetAttrs"                 },
    { 0x013f, "GdiSetBatchLimit"            },
    { 0x0140, "GdiSetLastError"             },
    { 0x0141, "GdiSetPixelFormat"           },
    { 0x0142, "GdiSetServerAttr"            },
    { 0x0143, "GdiStartDocEMF"              },
    { 0x0144, "GdiStartPageEMF"             },
    { 0x0145, "GdiSwapBuffers"              },
    { 0x0146, "GdiTransparentBlt"           },
    { 0x0147, "GdiValidateHandle"           },
    { 0x0148, "GetArcDirection"             },
    { 0x0149, "GetAspectRatioFilterEx"      },
    { 0x014a, "GetBitmapAttributes"         },
    { 0x014b, "GetBitmapBits"               },
    { 0x014c, "GetBitmapDimensionEx"        },
    { 0x014d, "GetBkColor"                  },
    { 0x014e, "GetBkMode"                   },
    { 0x014f, "GetBoundsRect"               },
    { 0x0150, "GetBrushAttributes"          },
    { 0x0151, "GetBrushOrgEx"               },
    { 0x0152, "GetCharABCWidthsA"           },
    { 0x0153, "GetCharABCWidthsFloatA"      },
    { 0x0154, "GetCharABCWidthsFloatW"      },
    { 0x0155, "GetCharABCWidthsI"           },
    { 0x0156, "GetCharABCWidthsW"           },
    { 0x0157, "GetCharWidth32A"             },
    { 0x0158, "GetCharWidth32W"             },
    { 0x0159, "GetCharWidthA"               },
    { 0x015a, "GetCharWidthFloatA"          },
    { 0x015b, "GetCharWidthFloatW"          },
    { 0x015c, "GetCharWidthI"               },
    { 0x015d, "GetCharWidthInfo"            },
    { 0x015e, "GetCharWidthW"               },
    { 0x015f, "GetCharacterPlacementA"      },
    { 0x0160, "GetCharacterPlacementW"      },
    { 0x0161, "GetClipBox"                  },
    { 0x0162, "GetClipRgn"                  },
    { 0x0163, "GetColorAdjustment"          },
    { 0x0164, "GetColorSpace"               },
    { 0x0165, "GetCurrentObject"            },
    { 0x0166, "GetCurrentPositionEx"        },
    { 0x0167, "GetDCBrushColor"             },
    { 0x0168, "GetDCOrgEx"                  },
    { 0x0169, "GetDCPenColor"               },
    { 0x016a, "GetDIBColorTable"            },
    { 0x016b, "GetDIBits"                   },
    { 0x016c, "GetDeviceCaps"               },
    { 0x016d, "GetDeviceGammaRamp"          },
    { 0x016e, "GetETM"                      },
    { 0x016f, "GetEUDCTimeStamp"            },
    { 0x0170, "GetEUDCTimeStampExW"         },
    { 0x0171, "GetEnhMetaFileA"             },
    { 0x0172, "GetEnhMetaFileBits"          },
    { 0x0173, "GetEnhMetaFileDescriptionA"  },
    { 0x0174, "GetEnhMetaFileDescriptionW"  },
    { 0x0175, "GetEnhMetaFileHeader"        },
    { 0x0176, "GetEnhMetaFilePaletteEntries" },
    { 0x0177, "GetEnhMetaFilePixelFormat"   },
    { 0x0178, "GetEnhMetaFileW"             },
    { 0x0179, "GetFontAssocStatus"          },
    { 0x017a, "GetFontData"                 },
    { 0x017b, "GetFontLanguageInfo"         },
    { 0x017c, "GetFontResourceInfoW"        },
    { 0x017d, "GetFontUnicodeRanges"        },
    { 0x017e, "GetGlyphIndicesA"            },
    { 0x017f, "GetGlyphIndicesW"            },
    { 0x0180, "GetGlyphOutline"             },
    { 0x0181, "GetGlyphOutlineA"            },
    { 0x0182, "GetGlyphOutlineW"            },
    { 0x0183, "GetGlyphOutlineWow"          },
    { 0x0184, "GetGraphicsMode"             },
    { 0x0185, "GetHFONT"                    },
    { 0x0186, "GetICMProfileA"              },
    { 0x0187, "GetICMProfileW"              },
    { 0x0188, "GetKerningPairs"             },
    { 0x0189, "GetKerningPairsA"            },
    { 0x018a, "GetKerningPairsW"            },
    { 0x018b, "GetLayout"                   },
    { 0x018c, "GetLogColorSpaceA"           },
    { 0x018d, "GetLogColorSpaceW"           },
    { 0x018e, "GetMapMode"                  },
    { 0x018f, "GetMetaFileA"                },
    { 0x0190, "GetMetaFileBitsEx"           },
    { 0x0191, "GetMetaFileW"                },
    { 0x0192, "GetMetaRgn"                  },
    { 0x0193, "GetMiterLimit"               },
    { 0x0194, "GetNearestColor"             },
    { 0x0195, "GetNearestPaletteIndex"      },
    { 0x0196, "GetObjectA"                  },
    { 0x0197, "GetObjectType"               },
    { 0x0198, "GetObjectW"                  },
    { 0x0199, "GetOutlineTextMetricsA"      },
    { 0x019a, "GetOutlineTextMetricsW"      },
    { 0x019b, "GetPaletteEntries"           },
    { 0x019c, "GetPath"                     },
    { 0x019d, "GetPixel"                    },
    { 0x019e, "GetPixelFormat"              },
    { 0x019f, "GetPolyFillMode"             },
    { 0x01a0, "GetROP2"                     },
    { 0x01a1, "GetRandomRgn"                },
    { 0x01a2, "GetRasterizerCaps"           },
    { 0x01a3, "GetRegionData"               },
    { 0x01a4, "GetRelAbs"                   },
    { 0x01a5, "GetRgnBox"                   },
    { 0x01a6, "GetStockObject"              },
    { 0x01a7, "GetStretchBltMode"           },
    { 0x01a8, "GetStringBitmapA"            },
    { 0x01a9, "GetStringBitmapW"            },
    { 0x01aa, "GetSystemPaletteEntries"     },
    { 0x01ab, "GetSystemPaletteUse"         },
    { 0x01ac, "GetTextAlign"                },
    { 0x01ad, "GetTextCharacterExtra"       },
    { 0x01ae, "GetTextCharset"              },
    { 0x01af, "GetTextCharsetInfo"          },
    { 0x01b0, "GetTextColor"                },
    { 0x01b1, "GetTextExtentExPointA"       },
    { 0x01b2, "GetTextExtentExPointI"       },
    { 0x01b3, "GetTextExtentExPointW"       },
    { 0x01b4, "GetTextExtentExPointWPri"    },
    { 0x01b5, "GetTextExtentPoint32A"       },
    { 0x01b6, "GetTextExtentPoint32W"       },
    { 0x01b7, "GetTextExtentPointA"         },
    { 0x01b8, "GetTextExtentPointI"         },
    { 0x01b9, "GetTextExtentPointW"         },
    { 0x01ba, "GetTextFaceA"                },
    { 0x01bb, "GetTextFaceAliasW"           },
    { 0x01bc, "GetTextFaceW"                },
    { 0x01bd, "GetTextMetricsA"             },
    { 0x01be, "GetTextMetricsW"             },
    { 0x01bf, "GetTransform"                },
    { 0x01c0, "GetViewportExtEx"            },
    { 0x01c1, "GetViewportOrgEx"            },
    { 0x01c2, "GetWinMetaFileBits"          },
    { 0x01c3, "GetWindowExtEx"              },
    { 0x01c4, "GetWindowOrgEx"              },
    { 0x01c5, "GetWorldTransform"           },
    { 0x01c6, "HT_Get8BPPFormatPalette"     },
    { 0x01c7, "HT_Get8BPPMaskPalette"       },
    { 0x01c8, "IntersectClipRect"           },
    { 0x01c9, "InvertRgn"                   },
    { 0x01ca, "IsValidEnhMetaRecord"        },
    { 0x01cb, "IsValidEnhMetaRecordOffExt"  },
    { 0x01cc, "LPtoDP"                      },
    { 0x01cd, "LineDDA"                     },
    { 0x01ce, "LineTo"                      },
    { 0x01cf, "MaskBlt"                     },
    { 0x01d0, "MirrorRgn"                   },
    { 0x01d1, "ModifyWorldTransform"        },
    { 0x01d2, "MoveToEx"                    },
    { 0x01d3, "NamedEscape"                 },
    { 0x01d4, "OffsetClipRgn"               },
    { 0x01d5, "OffsetRgn"                   },
    { 0x01d6, "OffsetViewportOrgEx"         },
    { 0x01d7, "OffsetWindowOrgEx"           },
    { 0x01d8, "PATHOBJ_bEnum"               },
    { 0x01d9, "PATHOBJ_bEnumClipLines"      },
    { 0x01da, "PATHOBJ_vEnumStart"          },
    { 0x01db, "PATHOBJ_vEnumStartClipLines" },
    { 0x01dc, "PATHOBJ_vGetBounds"          },
    { 0x01dd, "PaintRgn"                    },
    { 0x01de, "PatBlt"                      },
    { 0x01df, "PathToRegion"                },
    { 0x01e0, "Pie"                         },
    { 0x01e1, "PlayEnhMetaFile"             },
    { 0x01e2, "PlayEnhMetaFileRecord"       },
    { 0x01e3, "PlayMetaFile"                },
    { 0x01e4, "PlayMetaFileRecord"          },
    { 0x01e5, "PlgBlt"                      },
    { 0x01e6, "PolyBezier"                  },
    { 0x01e7, "PolyBezierTo"                },
    { 0x01e8, "PolyDraw"                    },
    { 0x01e9, "PolyPatBlt"                  },
    { 0x01ea, "PolyPolygon"                 },
    { 0x01eb, "PolyPolyline"                },
    { 0x01ec, "PolyTextOutA"                },
    { 0x01ed, "PolyTextOutW"                },
    { 0x01ee, "Polygon"                     },
    { 0x01ef, "Polyline"                    },
    { 0x01f0, "PolylineTo"                  },
    { 0x01f1, "PtInRegion"                  },
    { 0x01f2, "PtVisible"                   },
    { 0x01f3, "QueryFontAssocStatus"        },
    { 0x01f4, "RealizePalette"              },
    { 0x01f5, "RectInRegion"                },
    { 0x01f6, "RectVisible"                 },
    { 0x01f7, "Rectangle"                   },
    { 0x01f8, "RemoveFontMemResourceEx"     },
    { 0x01f9, "RemoveFontResourceA"         },
    { 0x01fa, "RemoveFontResourceExA"       },
    { 0x01fb, "RemoveFontResourceExW"       },
    { 0x01fc, "RemoveFontResourceTracking"  },
    { 0x01fd, "RemoveFontResourceW"         },
    { 0x01fe, "ResetDCA"                    },
    { 0x01ff, "ResetDCW"                    },
    { 0x0200, "ResizePalette"               },
    { 0x0201, "RestoreDC"                   },
    { 0x0202, "RoundRect"                   },
    { 0x0203, "STROBJ_bEnum"                },
    { 0x0204, "STROBJ_bEnumPositionsOnly"   },
    { 0x0205, "STROBJ_bGetAdvanceWidths"    },
    { 0x0206, "STROBJ_dwGetCodePage"        },
    { 0x0207, "STROBJ_vEnumStart"           },
    { 0x0208, "SaveDC"                      },
    { 0x0209, "ScaleViewportExtEx"          },
    { 0x020a, "ScaleWindowExtEx"            },
    { 0x020b, "SelectBrushLocal"            },
    { 0x020c, "SelectClipPath"              },
    { 0x020d, "SelectClipRgn"               },
    { 0x020e, "SelectFontLocal"             },
    { 0x020f, "SelectObject"                },
    { 0x0210, "SelectPalette"               },
    { 0x0211, "SetAbortProc"                },
    { 0x0212, "SetArcDirection"             },
    { 0x0213, "SetBitmapAttributes"         },
    { 0x0214, "SetBitmapBits"               },
    { 0x0215, "SetBitmapDimensionEx"        },
    { 0x0216, "SetBkColor"                  },
    { 0x0217, "SetBkMode"                   },
    { 0x0218, "SetBoundsRect"               },
    { 0x0219, "SetBrushAttributes"          },
    { 0x021a, "SetBrushOrgEx"               },
    { 0x021b, "SetColorAdjustment"          },
    { 0x021c, "SetColorSpace"               },
    { 0x021d, "SetDCBrushColor"             },
    { 0x021e, "SetDCPenColor"               },
    { 0x021f, "SetDIBColorTable"            },
    { 0x0220, "SetDIBits"                   },
    { 0x0221, "SetDIBitsToDevice"           },
    { 0x0222, "SetDeviceGammaRamp"          },
    { 0x0223, "SetEnhMetaFileBits"          },
    { 0x0224, "SetFontEnumeration"          },
    { 0x0225, "SetGraphicsMode"             },
    { 0x0226, "SetICMMode"                  },
    { 0x0227, "SetICMProfileA"              },
    { 0x0228, "SetICMProfileW"              },
    { 0x0229, "SetLayout"                   },
    { 0x022a, "SetLayoutWidth"              },
    { 0x022b, "SetMagicColors"              },
    { 0x022c, "SetMapMode"                  },
    { 0x022d, "SetMapperFlags"              },
    { 0x022e, "SetMetaFileBitsEx"           },
    { 0x022f, "SetMetaRgn"                  },
    { 0x0230, "SetMiterLimit"               },
    { 0x0231, "SetPaletteEntries"           },
    { 0x0232, "SetPixel"                    },
    { 0x0233, "SetPixelFormat"              },
    { 0x0234, "SetPixelV"                   },
    { 0x0235, "SetPolyFillMode"             },
    { 0x0236, "SetROP2"                     },
    { 0x0237, "SetRectRgn"                  },
    { 0x0238, "SetRelAbs"                   },
    { 0x0239, "SetStretchBltMode"           },
    { 0x023a, "SetSystemPaletteUse"         },
    { 0x023b, "SetTextAlign"                },
    { 0x023c, "SetTextCharacterExtra"       },
    { 0x023d, "SetTextColor"                },
    { 0x023e, "SetTextJustification"        },
    { 0x023f, "SetViewportExtEx"            },
    { 0x0240, "SetViewportOrgEx"            },
    { 0x0241, "SetVirtualResolution"        },
    { 0x0242, "SetWinMetaFileBits"          },
    { 0x0243, "SetWindowExtEx"              },
    { 0x0244, "SetWindowOrgEx"              },
    { 0x0245, "SetWorldTransform"           },
    { 0x0246, "StartDocA"                   },
    { 0x0247, "StartDocW"                   },
    { 0x0248, "StartFormPage"               },
    { 0x0249, "StartPage"                   },
    { 0x024a, "StretchBlt"                  },
    { 0x024b, "StretchDIBits"               },
    { 0x024c, "StrokeAndFillPath"           },
    { 0x024d, "StrokePath"                  },
    { 0x024e, "SwapBuffers"                 },
    { 0x024f, "TextOutA"                    },
    { 0x0250, "TextOutW"                    },
    { 0x0251, "TranslateCharsetInfo"        },
    { 0x0252, "UnloadNetworkFonts"          },
    { 0x0253, "UnrealizeObject"             },
    { 0x0254, "UpdateColors"                },
    { 0x0255, "UpdateICMRegKeyA"            },
    { 0x0256, "UpdateICMRegKeyW"            },
    { 0x0257, "WidenPath"                   },
    { 0x0258, "XFORMOBJ_bApplyXform"        },
    { 0x0259, "XFORMOBJ_iGetXform"          },
    { 0x025a, "XLATEOBJ_cGetPalette"        },
    { 0x025b, "XLATEOBJ_hGetColorTransform" },
    { 0x025c, "XLATEOBJ_iXlate"             },
    { 0x025d, "XLATEOBJ_piVector"           },
    { 0x025e, "bInitSystemAndFontsDirectoriesW" },
    { 0x025f, "bMakePathNameW"              },
    { 0x0260, "cGetTTFFromFOT"              },
    { 0x0261, "gdiPlaySpoolStream"          },
};


}
}

#endif

