# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Optional, TYPE_CHECKING

from azure.core.rest import HttpRequest, HttpResponse
from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

from . import models
from ._configuration import NetAppManagementClientConfiguration
from .operations import AccountBackupsOperations, AccountsOperations, BackupPoliciesOperations, BackupsOperations, NetAppResourceOperations, NetAppResourceQuotaLimitsOperations, Operations, PoolsOperations, SnapshotPoliciesOperations, SnapshotsOperations, VaultsOperations, VolumeGroupsOperations, VolumesOperations

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from azure.core.credentials import TokenCredential

class NetAppManagementClient:
    """Microsoft NetApp Files Azure Resource Provider specification.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.netapp.operations.Operations
    :ivar net_app_resource: NetAppResourceOperations operations
    :vartype net_app_resource: azure.mgmt.netapp.operations.NetAppResourceOperations
    :ivar net_app_resource_quota_limits: NetAppResourceQuotaLimitsOperations operations
    :vartype net_app_resource_quota_limits:
     azure.mgmt.netapp.operations.NetAppResourceQuotaLimitsOperations
    :ivar accounts: AccountsOperations operations
    :vartype accounts: azure.mgmt.netapp.operations.AccountsOperations
    :ivar pools: PoolsOperations operations
    :vartype pools: azure.mgmt.netapp.operations.PoolsOperations
    :ivar volumes: VolumesOperations operations
    :vartype volumes: azure.mgmt.netapp.operations.VolumesOperations
    :ivar snapshots: SnapshotsOperations operations
    :vartype snapshots: azure.mgmt.netapp.operations.SnapshotsOperations
    :ivar snapshot_policies: SnapshotPoliciesOperations operations
    :vartype snapshot_policies: azure.mgmt.netapp.operations.SnapshotPoliciesOperations
    :ivar backups: BackupsOperations operations
    :vartype backups: azure.mgmt.netapp.operations.BackupsOperations
    :ivar account_backups: AccountBackupsOperations operations
    :vartype account_backups: azure.mgmt.netapp.operations.AccountBackupsOperations
    :ivar backup_policies: BackupPoliciesOperations operations
    :vartype backup_policies: azure.mgmt.netapp.operations.BackupPoliciesOperations
    :ivar vaults: VaultsOperations operations
    :vartype vaults: azure.mgmt.netapp.operations.VaultsOperations
    :ivar volume_groups: VolumeGroupsOperations operations
    :vartype volume_groups: azure.mgmt.netapp.operations.VolumeGroupsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: Subscription credentials which uniquely identify Microsoft Azure
     subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param base_url: Service URL. Default value is 'https://management.azure.com'.
    :type base_url: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "TokenCredential",
        subscription_id: str,
        base_url: str = "https://management.azure.com",
        **kwargs: Any
    ) -> None:
        self._config = NetAppManagementClientConfiguration(credential=credential, subscription_id=subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._deserialize = Deserializer(client_models)
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.net_app_resource = NetAppResourceOperations(self._client, self._config, self._serialize, self._deserialize)
        self.net_app_resource_quota_limits = NetAppResourceQuotaLimitsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.accounts = AccountsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.pools = PoolsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.volumes = VolumesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.snapshots = SnapshotsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.snapshot_policies = SnapshotPoliciesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.backups = BackupsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.account_backups = AccountBackupsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.backup_policies = BackupPoliciesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.vaults = VaultsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.volume_groups = VolumeGroupsOperations(self._client, self._config, self._serialize, self._deserialize)


    def _send_request(
        self,
        request,  # type: HttpRequest
        **kwargs: Any
    ) -> HttpResponse:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = client._send_request(request)
        <HttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/python/protocol/quickstart

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.HttpResponse
        """

        request_copy = deepcopy(request)
        request_copy.url = self._client.format_url(request_copy.url)
        return self._client.send_request(request_copy, **kwargs)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> NetAppManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
