# Copyright 2020 StrongDM Inc
# 
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
# 
#     http://www.apache.org/licenses/LICENSE-2.0
# 
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
# 
# Generated by the gRPC Python protocol compiler plugin. DO NOT EDIT!
"""Client and server classes corresponding to protobuf-defined services."""
import grpc

from . import accounts_groups_pb2 as accounts__groups__pb2


class AccountsGroupsStub(object):
    """An AccountGroup links an account and a group.
    """

    def __init__(self, channel):
        """Constructor.

        Args:
            channel: A grpc.Channel.
        """
        self.Create = channel.unary_unary(
                '/v1.AccountsGroups/Create',
                request_serializer=accounts__groups__pb2.AccountGroupCreateRequest.SerializeToString,
                response_deserializer=accounts__groups__pb2.AccountGroupCreateResponse.FromString,
                )
        self.Get = channel.unary_unary(
                '/v1.AccountsGroups/Get',
                request_serializer=accounts__groups__pb2.AccountGroupGetRequest.SerializeToString,
                response_deserializer=accounts__groups__pb2.AccountGroupGetResponse.FromString,
                )
        self.Delete = channel.unary_unary(
                '/v1.AccountsGroups/Delete',
                request_serializer=accounts__groups__pb2.AccountGroupDeleteRequest.SerializeToString,
                response_deserializer=accounts__groups__pb2.AccountGroupDeleteResponse.FromString,
                )
        self.List = channel.unary_unary(
                '/v1.AccountsGroups/List',
                request_serializer=accounts__groups__pb2.AccountGroupListRequest.SerializeToString,
                response_deserializer=accounts__groups__pb2.AccountGroupListResponse.FromString,
                )


class AccountsGroupsServicer(object):
    """An AccountGroup links an account and a group.
    """

    def Create(self, request, context):
        """Create create a new AccountGroup.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Get(self, request, context):
        """Get reads one AccountGroup by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def Delete(self, request, context):
        """Delete removes an AccountGroup by ID.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')

    def List(self, request, context):
        """List gets a list of AccountGroups matching a given set of criteria.
        """
        context.set_code(grpc.StatusCode.UNIMPLEMENTED)
        context.set_details('Method not implemented!')
        raise NotImplementedError('Method not implemented!')


def add_AccountsGroupsServicer_to_server(servicer, server):
    rpc_method_handlers = {
            'Create': grpc.unary_unary_rpc_method_handler(
                    servicer.Create,
                    request_deserializer=accounts__groups__pb2.AccountGroupCreateRequest.FromString,
                    response_serializer=accounts__groups__pb2.AccountGroupCreateResponse.SerializeToString,
            ),
            'Get': grpc.unary_unary_rpc_method_handler(
                    servicer.Get,
                    request_deserializer=accounts__groups__pb2.AccountGroupGetRequest.FromString,
                    response_serializer=accounts__groups__pb2.AccountGroupGetResponse.SerializeToString,
            ),
            'Delete': grpc.unary_unary_rpc_method_handler(
                    servicer.Delete,
                    request_deserializer=accounts__groups__pb2.AccountGroupDeleteRequest.FromString,
                    response_serializer=accounts__groups__pb2.AccountGroupDeleteResponse.SerializeToString,
            ),
            'List': grpc.unary_unary_rpc_method_handler(
                    servicer.List,
                    request_deserializer=accounts__groups__pb2.AccountGroupListRequest.FromString,
                    response_serializer=accounts__groups__pb2.AccountGroupListResponse.SerializeToString,
            ),
    }
    generic_handler = grpc.method_handlers_generic_handler(
            'v1.AccountsGroups', rpc_method_handlers)
    server.add_generic_rpc_handlers((generic_handler,))


 # This class is part of an EXPERIMENTAL API.
class AccountsGroups(object):
    """An AccountGroup links an account and a group.
    """

    @staticmethod
    def Create(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccountsGroups/Create',
            accounts__groups__pb2.AccountGroupCreateRequest.SerializeToString,
            accounts__groups__pb2.AccountGroupCreateResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Get(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccountsGroups/Get',
            accounts__groups__pb2.AccountGroupGetRequest.SerializeToString,
            accounts__groups__pb2.AccountGroupGetResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def Delete(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccountsGroups/Delete',
            accounts__groups__pb2.AccountGroupDeleteRequest.SerializeToString,
            accounts__groups__pb2.AccountGroupDeleteResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)

    @staticmethod
    def List(request,
            target,
            options=(),
            channel_credentials=None,
            call_credentials=None,
            insecure=False,
            compression=None,
            wait_for_ready=None,
            timeout=None,
            metadata=None):
        return grpc.experimental.unary_unary(request, target, '/v1.AccountsGroups/List',
            accounts__groups__pb2.AccountGroupListRequest.SerializeToString,
            accounts__groups__pb2.AccountGroupListResponse.FromString,
            options, channel_credentials,
            insecure, call_credentials, compression, wait_for_ready, timeout, metadata)
