/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.wasync.decoder;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.atmosphere.wasync.Event;
import org.atmosphere.wasync.ReplayDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TrackMessageSizeDecoder
implements ReplayDecoder {
    private final Logger logger = LoggerFactory.getLogger(TrackMessageSizeDecoder.class);
    private final String delimiter;
    private final StringBuffer messagesBuffer = new StringBuffer();
    private final AtomicBoolean skipFirstMessage = new AtomicBoolean();
    private final List<String> empty = Collections.emptyList();

    public TrackMessageSizeDecoder() {
        this.delimiter = "|";
    }

    public TrackMessageSizeDecoder(boolean protocolEnabled) {
        this.delimiter = "|";
        this.skipFirstMessage.set(protocolEnabled);
    }

    public TrackMessageSizeDecoder(String delimiter, boolean protocolEnabled) {
        this.delimiter = delimiter;
        this.skipFirstMessage.set(protocolEnabled);
    }

    @Override
    public List<String> decode(Event type, String message) {
        if (type.equals((Object)Event.MESSAGE)) {
            if (this.skipFirstMessage.getAndSet(false)) {
                return this.empty;
            }
            LinkedList<String> messages = new LinkedList<String>();
            message = this.messagesBuffer.append(message).toString().replace(this.delimiter, "__");
            this.messagesBuffer.setLength(0);
            if (message.indexOf("__") != -1) {
                String[] tokens = message.split("__");
                int length = Integer.valueOf(tokens[0]);
                for (int pos = 1; pos < tokens.length; ++pos) {
                    String m = tokens[pos];
                    if (m.length() >= length) {
                        messages.addLast(m.substring(0, length));
                        String t = m.substring(length);
                        if (t.length() <= 0) continue;
                        length = Integer.valueOf(t);
                        continue;
                    }
                    if (pos != 1) {
                        this.messagesBuffer.append(length).append(this.delimiter).append(m);
                        break;
                    }
                    this.messagesBuffer.append(message);
                    break;
                }
            }
            return messages;
        }
        return this.empty;
    }
}

