    1                    ,    -  W   9          -   ^  ?     P              (     %     $   $  %   I  )   o  )     ,     (     +     .   E  (   t  (     )     (     (     )   B  )   l  (     )     )     )     *   =  -   h  *     /     *     *     +   G  *   s  *     .     )     )   "  -   L  :   z                O   {$  Q  $     &  B   &    &    3  -   :5  0   h5     5  U   5     6      &6     G6     e6     6  !   6  !   6  $   6      	7  #   *7  &   N7      u7      7  !   7      7      7  !   8  !   =8      _8  !   8  !   8  !   8  "   8  %   	9  "   /9  '   R9  "   z9  "   9  #   9  "   9  "   :  &   *:  !   Q:  !   s:  %   :  %   :     :     :  z  ;  .   0?   "K" を SI 接頭辞の記号として使用することは出来ません。
kilo を表現したい場合、 "K" ではなく、小文字の "k" をお使い下さい。
なぜならば、"K" は、Kelvin 温度を表現するための単位記号だからです。 0 < abs(number(={})) < 1 を満たす数字を int に変換しようとしました。 EngineerNumber class は、SI接頭辞の変換・異なるSI接頭辞同士の
    計算を容易にします。使用可能なSI接頭辞は、最後に説明します。

    EngineerNumber instance(インスタンス) に対し、
    任意のSI接頭辞を KEY にすることで、
    任意のSI接頭辞に換算した値を知ることが出来ます。
    SI 接頭辞変換結果として返される文字列を EngineerNumber() に渡し、
    新たな EngineerNumber instance を生成出来ます。

    EngineerNumber.num 属性は、数値型 object です。
    EngineerNumber class に、__add__() 等の method を定義し、
    演算の対象を EngineerNumber.num とすることで、
    EngineerNumber instance は、数値型 object 互換になっています。
    数値型 object 互換にする方法は、
    PEP 3141, numbers class 等をご覧下さい。

    以下、使うための手順を簡単に紹介します。
    >>> from engineer_number import EngineerNumber

    KILO, MEGA, ...等々の SI 接頭辞名を使わない場合、
    以下の行は必要ありません。
    >>> from engineer_number.constants import *

    以下の、No.1, 2, 3 では、 10 * 1000 の値を得る方法と、
    SI 接頭辞変換の方法を説明します。

    No.1: 有効値の文字列と、SI 接頭辞を連結し、
    10 kilo の値を得る方法です。
    >>> r1 = EngineerNumber('10k')       # No.1
    >>> r1
    10.000k

    10 kilo を Mega で計算し、SI 接頭辞変換を行います。
    >>> r1['M']
    '0.010M'

    No.2: 有効値と、SI 接頭辞名で 10 kilo の値を得る方法です。
    >>> r2 = EngineerNumber(10, KILO)    # No.2
    >>> r2 = EngineerNumber('10', KILO)  # No.2
    >>> r2
    10.000k

    10 kilo に SI 接頭辞変換を行い、数値に変換します。
    10 の乗数が 0 の場合、
    空文字列を SI 接頭辞としていることに注意して下さい。
    >>> r2['']
    '10000.000'

    No.3: 有効値と 10 の乗数で 10 kilo の値を得る方法です。
    抵抗のカラーコードから抵抗値を求める事を想定しています。
    >>> r3 = EngineerNumber(10, 3)       # No.3
    >>> r3 = EngineerNumber('10', 3)     # No.3
    >>> r3
    10.000k

    10 kilo を kilo で計算する、なんちゃって SI 接頭辞変換を行います。
    自分でも必要ないとは思うんですけれど、流れ上、書きました。
    >>> r3['k']
    '10.000k'

    以下の、No.4, 5 では、コンデンサ上の表示から、
    コンデンサの容量値を求める方法を紹介します。
    "p" を有効数値の後に付けていることに注意して下さい。

    No.4: コンデンサの表示 "104" から容量値を求めます。
    >>> c4 = EngineerNumber('10p', 4)    # No.4
    >>> c4
    100.000n

    マイクロ・ナノ・ピコを計算する時など、
    よく頭がこんがらがりますよね。
    >>> c4['u']
    '0.100u'

    No.5: コンデンサの表示 "202" から容量値を求めます。
    >>> c5 = EngineerNumber('20p', 2)    # No.5
    >>> c5
    2.000n

    マイクロ・ナノ・ピコを計算する時など、
    よく頭がこんがらがりますよね。
    >>> c5['p']
    '2000.000p'

    ここだけの話：
    マイクロ・ナノ・ピコの変換が大変でややこしくて、
    よく間違えて困るので、この EngineerNumber を作成しました。
    抵抗のカラーコードにも使えると分かった時には、
    本当に便利だなー。と自分でも思いました

    使用例を、もう少し知りたい方は "README.txt" をご覧下さい。

    SI 接頭辞として用意しているのは、以下の通りです。
    ('Y', YOTTA),
    ('Z', ZETTA),
    ('E', EXA),
    ('P', PETA),
    ('T', TERA),
    ('G', GIGA),
    ('M', MEGA),
    ('k', KILO),
     ('', ONE),
    ('m', MILLI),
    ('u', MICRO),
    ('n', NANO),
    ('p', PICO),
    ('f', FEMTO),
    ('a', ATTO),
    ('z', ZEPTO),
    ('y', YOCTO),
     EngineerNumber.num の値から、_value, _exponent10 を正規化する。
        num, _value, _exponent10 の計算方法は、簡単に以下の通り。

        _exponent10 = log10(num) // 3
        _value = num // (10 ** _exponent10)
        num =(大体同じ、approximately equal to) _value * 10 ** _exponent10

        _exponent10 は SI 接頭辞と連動するため、
        3 の整数倍になっていることに注意。 SI 接頭辞により有効数字を変換。 SI 接頭辞に対応する、10 の乗数値を返します。 SI 接頭辞の記号は、次のいずれかでなければなりません。{} attr.__doc__ を gettext() にて翻訳する。

    attr() として attr を呼び出し可能であれば、
    attr に結び付く __doc__ 属性を msgid とし、
    以下を実行する。
    msgstr = gettext(msgid)
    実行後、attr に結びつく __doc__ 属性の値を、msgstr で上書きする。

    attr() として attr を呼び出し可能でない場合、何も実行しない。
     look for optimized Hz. math.__ceil__() の help を読んで。 math.floor() の help を読んで。 math.sqrt() の help を読んで。 math.trunc() の help を読んで。 object.__abs__() の help を読んで。 object.__add__() の help を読んで。 object.__divmod__() の help を読んで。 object.__eq__() の help を読んで。 object.__float__() の help を読んで。 object.__floordiv__() の help を読んで。 object.__ge__() の help を読んで。 object.__gt__() の help を読んで。 object.__int__() の help を読んで。 object.__le__() の help を読んで。 object.__lt__() の help を読んで。 object.__mod__() の help を読んで。 object.__mul__() の help を読んで。 object.__ne__() の help を読んで。 object.__neg__() の help を読んで。 object.__pos__() の help を読んで。 object.__pow__() の help を読んで。 object.__radd__() の help を読んで。 object.__rdivmod__() の help を読んで。 object.__repr__() の help を読んで。 object.__rfloordiv__() の help を読んで。 object.__rmod__() の help を読んで。 object.__rmul__() の help を読んで。 object.__round__() の help を読んで。 object.__rpow__() の help を読んで。 object.__rsub__() の help を読んで。 object.__rtruediv__() の help を読んで。 object.__str__() の help を読んで。 object.__sub__() の help を読んで。 object.__truediv__() の help を読んで。 self[si_prefix] として、SI 接頭辞変換を行う。 series must be "E12". 主に debug 用。
        本当は非公開にしたかったが、公開としてしまった為、
        今更、非公開に出来なくて困っている。
        出来ることなら、今からでも非公開にしたい。。。 有効数値と 10 の乗数値を指定します。
        value を、二つの方法により指定できます。
        一つ目は、有効数値を整数値、浮動小数値として指定する方法です。
        二つ目は、有効数値の文字列と SI 接頭辞を連結し、文字列として
        指定する方法です。

        exponent10 は、無指定であれば、0 として取り扱います。
        以下の計算式により、value, exponent10 の値から、
        EngineerNumber.num 属性の値を計算します。
        num = value * 10 ** exponent10

        つまり、exponent10 を指定しなければ、
        num 属性の値として、value の値を、そのまま代入することになります。
        num = value * 10 ** 0 = value * 1 = value
        num 属性の値の範囲は、 -24 <= num <= 24 であり、かつ、
        num 属性の値は、3 の整数倍となります。

        詳しい使い方は、EngineerNumber class の docstring をご覧下さい。
        例 1 〜 5 等が分かりやすいかと思います。
        更なる情報は、少しだけ、"README.txt" に書いています。
         有効数字の数値と 10 の乗数値を、tuple に詰めて返します。 Project-Id-Version: 1.0.4
POT-Creation-Date: 2013-02-17 08:02+JST
PO-Revision-Date: 2013-02-17 08:02+JST
Last-Translator: 梅どぶろく(umedoblock) umedoblock@gmail.com
Language-Team: Japanese umedoblock@gmail.com
MIME-Version: 1.0
Content-Type: text/plain; charset=UTF-8
Content-Transfer-Encoding: 8bit
Generated-By: pygettext.py 1.5
 cannot accept "K" as SI prefix symbol. please use "k" as prefix if you hope to describe kilo.Because "K" means Kelbin celcius.') trying to convert Integer that satisfied 0 < abs(number(={})) < 1. EngineerNumber class can easily calculate to change SI prefix and
    to calculate with another SI prefix. List up last part to be
    available SI prefix.

    You can find out arbitrary resulted value in new SI prefix
    to use KEY as arbitrary SI prefix.
    New EngineerNumber instance is created to convert SI prefix
    to new SI prefix which gives to EngineerNumber().
    string.

    EngineerNumber.num attribute is numeric object.
    EngineerNumber instance can use as numeric object to define
    num attribute in it class.
    How to give numeric object compatibility to arbitrary object ?
    Please see PEP3141 and numbers class.
    
    Below show what need way to use a EngineerNumber class instance.
    >>> from engineer_number import EngineerNumber

    No need to write a below sentence if don't use SI prefix name
    like a KILO, MEGA, ... etc.
    >>> from engineer_number.constants import *

    Explain a way in case1, case2, case3 that 
    how to get 10 * 1000 value and
    how to convert arbitrary SI prerix.

    case1: A way that combine significant digits string and SI prefix
    to get 10 kilo value.
    >>> r1 = EngineerNumber('10k')       # No.1
    >>> r1
    10.000k

    SI prefix converting after calculate 10 kilo as Mega.
    >>> r1['M']
    '0.010M'

    case2: A way that using significant digits and SI prefix to get
    10 kilo value.
    >>> r2 = EngineerNumber(10, KILO)    # No.2
    >>> r2 = EngineerNumber('10', KILO)  # No.2
    >>> r2
    10.000k

    Converting to number after 10 kilo is converted by SI prefix.
    Pay attention to use empty string as SI prefix if 10 multiple value
    is zero.
    >>> r2['']
    '10000.000'

    case3: A way that to get 10 kilo using significant digits and
    ten multiple value.
    Expected scenario to calculate an R-value from color code
    on resistance.
    >>> r3 = EngineerNumber(10, 3)       # No.3
    >>> r3 = EngineerNumber('10', 3)     # No.3
    >>> r3
    10.000k

    Do SI prefix converting to convert 10 kilo use kilo.
    No need it me too thinking, but atmosphere hope to write it.
    >>> r3['k']
    '10.000k'

    case4, case5 explain that how to calculate a capacitance
    on capacitor string.
    Pay attention to add "p" after significant digits.

    case4: To get a capacitance from a display on capacitor.
    >>> c4 = EngineerNumber('10p', 4)    # No.4
    >>> c4
    100.000n

    Often confusing when to calculate MICRO, NANO, PICO...
    >>> c4['u']
    '0.100u'

    case5: To get a capacitor capacitance from "202" on capacitance
    >>> c5 = EngineerNumber('20p', 2)    # No.5
    >>> c5
    2.000n

    Often confusing when to calculate MICRO, NANO, PICO...
    >>> c5['p']
    '2000.000p'

    coffee break:
    Please study 日本語 and read 私が日本語で書いた docstring
    if you hope to a secret story in development of this module.

    Please read "README.txt" if you hope to get more using way.

    SI prefixes are below lines.
    ('Y', YOTTA),
    ('Z', ZETTA),
    ('E', EXA),
    ('P', PETA),
    ('T', TERA),
    ('G', GIGA),
    ('M', MEGA),
    ('k', KILO),
     ('', ONE),
    ('m', MILLI),
    ('u', MICRO),
    ('n', NANO),
    ('p', PICO),
    ('f', FEMTO),
    ('a', ATTO),
    ('z', ZEPTO),
    ('y', YOCTO),
     normalize _value, _exponent10 from EngineerNumber.num.        Instantly show you below how to calculate num, _value, _exponent10.

        _exponent10 = log10(num) // 3
        _value = num // (10 ** _exponent10)
        num =(approximately equal to) _value * 10 ** _exponent10

        Pay attention to _exponent10.
        _exponent10 is three-fold to associated with SI prerix.
         convert significant digits through SI prefix. return ten multiplier value injective SI prefix. SI prefix symbol must be in {}. attr.__doc__ = gettext(attr.__doc__)
     convert and translate to use gettext().     look for optimized Hz. please see math.__ceil__() help. please see math.floor() help. please see math.sqrt() help. please see math.trunc() help. please see object.__abs__() help. please see object.__add__() help. please see object.__divmod__() help. please see object.__eq__() help. please see object.__float__() help. please see object.__floordiv__() help. please see object.__ge__() help. please see object.__gt__() help. please see object.__int__() help. please see object.__le__() help. please see object.__lt__() help. please see object.__mod__() help. please see object.__mul__() help. please see object.__ne__() help. please see object.__neg__() help. please see object.__pos__() help. please see object.__pow__() help. please see object.__radd__() help. please see object.__rdivmod__() help. please see object.__repr__() help. please see object.__rfloordiv__() help. please see object.__rmod__() help. please see object.__rmul__() help. please see object.__round__() help. please see object.__rpow__() help. please see object.__rsub__() help. please see object.__rtruediv__() help. please see object.__str__() help. please see object.__sub__() help. please see object.__truediv__() help. convert SI prefix as self[si_prefix]. series must be "E12". mainly-purpose is debug.        now, I have a bother thing that
        In fact hope to no public method, but public method.
        If apologize you to hide, I hide it from now...
         assign significant digits and ten multiplier.
        value is assigned by two ways.
        first way, significant digits as integer or float.
        second way, join significant digits string and SI prefix like a
        as string

        exponent10 default is ten.
        calculate EngineerNumber.num attribute value to use a below
        calculating formula.
        num = value * 10 ** exponent10

        In short, if don't assign exponent10,
        directly assign value as num attribute value.
        num = value * 10 ** 0 = value * 1 = value
        num attribute value range is -24 <= num <= 24 and
        num attribute value three-fold value.

        If you hope to get a more detail, please see EngineerNumber class
        docstring.
        I anticipated that case 1 -> case 5 is your friendly.
        It exists a little bit more information in "README.txt".
         significant digit and ten multiplier in tuple. 