# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2018, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


from .groups import GROUPS
from .segments import SEGMENTS

MESSAGES = {
    'ACK': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),)),
    'ADT_A01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A01_PROCEDURE', GROUPS['ADT_A01_PROCEDURE'], (0, -1), 'GRP'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A01_INSURANCE', GROUPS['ADT_A01_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),
                 ('PDA', SEGMENTS['PDA'], (0, 1), 'SEG'),)),
    'ADT_A02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('PDA', SEGMENTS['PDA'], (0, 1), 'SEG'),)),
    'ADT_A03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A03_PROCEDURE', GROUPS['ADT_A03_PROCEDURE'], (0, -1), 'GRP'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A03_INSURANCE', GROUPS['ADT_A03_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('PDA', SEGMENTS['PDA'], (0, 1), 'SEG'),)),
    'ADT_A05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A05_PROCEDURE', GROUPS['ADT_A05_PROCEDURE'], (0, -1), 'GRP'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A05_INSURANCE', GROUPS['ADT_A05_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A06_PROCEDURE', GROUPS['ADT_A06_PROCEDURE'], (0, -1), 'GRP'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A06_INSURANCE', GROUPS['ADT_A06_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('UB1', SEGMENTS['UB1'], (0, 1), 'SEG'),
                 ('UB2', SEGMENTS['UB2'], (0, 1), 'SEG'),)),
    'ADT_A09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A15': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A16': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('ADT_A16_PROCEDURE', GROUPS['ADT_A16_PROCEDURE'], (0, -1), 'GRP'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('ADT_A16_INSURANCE', GROUPS['ADT_A16_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),)),
    'ADT_A17': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A20': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('NPU', SEGMENTS['NPU'], (1, 1), 'SEG'),)),
    'ADT_A21': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),)),
    'ADT_A24': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),)),
    'ADT_A37': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),)),
    'ADT_A38': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('OBX', SEGMENTS['OBX'], (0, -1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),)),
    'ADT_A39': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('ADT_A39_PATIENT', GROUPS['ADT_A39_PATIENT'], (1, -1), 'GRP'),)),
    'ADT_A43': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('ADT_A43_PATIENT', GROUPS['ADT_A43_PATIENT'], (1, -1), 'GRP'),)),
    'ADT_A44': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('ADT_A44_PATIENT', GROUPS['ADT_A44_PATIENT'], (1, -1), 'GRP'),)),
    'ADT_A45': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ADT_A45_MERGE_INFO', GROUPS['ADT_A45_MERGE_INFO'], (1, -1), 'GRP'),)),
    'ADT_A50': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('MRG', SEGMENTS['MRG'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),)),
    'ADT_A52': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),)),
    'ADT_A54': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),)),
    'ADT_A60': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ADT_A60_VISIT', GROUPS['ADT_A60_VISIT'], (0, 1), 'GRP'),
                 ('ADT_A60_ADVERSE_REACTION_GROUP', GROUPS['ADT_A60_ADVERSE_REACTION_GROUP'], (0, -1), 'GRP'),)),
    'ADT_A61': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),)),
    'BAR_P01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('BAR_P01_VISIT', GROUPS['BAR_P01_VISIT'], (1, -1), 'GRP'),)),
    'BAR_P02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('BAR_P02_PATIENT', GROUPS['BAR_P02_PATIENT'], (1, -1), 'GRP'),)),
    'BAR_P05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('BAR_P05_VISIT', GROUPS['BAR_P05_VISIT'], (1, -1), 'GRP'),)),
    'BAR_P06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('BAR_P06_PATIENT', GROUPS['BAR_P06_PATIENT'], (1, -1), 'GRP'),)),
    'BAR_P10': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('GP1', SEGMENTS['GP1'], (1, 1), 'SEG'),
                 ('BAR_P10_PROCEDURE', GROUPS['BAR_P10_PROCEDURE'], (0, -1), 'GRP'),)),
    'BAR_P12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('BAR_P12_PROCEDURE', GROUPS['BAR_P12_PROCEDURE'], (0, -1), 'GRP'),
                 ('OBX', SEGMENTS['OBX'], (0, 1), 'SEG'),)),
    'BPS_O29': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('BPS_O29_PATIENT', GROUPS['BPS_O29_PATIENT'], (0, 1), 'GRP'),
                 ('BPS_O29_ORDER', GROUPS['BPS_O29_ORDER'], (1, -1), 'GRP'),)),
    'BRP_O30': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('BRP_O30_RESPONSE', GROUPS['BRP_O30_RESPONSE'], (0, 1), 'GRP'),)),
    'BRT_O32': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('BRT_O32_RESPONSE', GROUPS['BRT_O32_RESPONSE'], (0, 1), 'GRP'),)),
    'BTS_O31': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('BTS_O31_PATIENT', GROUPS['BTS_O31_PATIENT'], (0, 1), 'GRP'),
                 ('BTS_O31_ORDER', GROUPS['BTS_O31_ORDER'], (1, -1), 'GRP'),)),
    'CCF_I22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),)),
    'CCI_I22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('CCI_I22_INSURANCE', GROUPS['CCI_I22_INSURANCE'], (0, -1), 'GRP'),
                 ('CCI_I22_APPOINTMENT_HISTORY', GROUPS['CCI_I22_APPOINTMENT_HISTORY'], (0, -1), 'GRP'),
                 ('CCI_I22_CLINICAL_HISTORY', GROUPS['CCI_I22_CLINICAL_HISTORY'], (0, -1), 'GRP'),
                 ('CCI_I22_PATIENT_VISITS', GROUPS['CCI_I22_PATIENT_VISITS'], (1, -1), 'GRP'),
                 ('CCI_I22_MEDICATION_HISTORY', GROUPS['CCI_I22_MEDICATION_HISTORY'], (0, -1), 'GRP'),
                 ('CCI_I22_PROBLEM', GROUPS['CCI_I22_PROBLEM'], (0, -1), 'GRP'),
                 ('CCI_I22_GOAL', GROUPS['CCI_I22_GOAL'], (0, -1), 'GRP'),
                 ('CCI_I22_PATHWAY', GROUPS['CCI_I22_PATHWAY'], (0, -1), 'GRP'),
                 ('REL', SEGMENTS['REL'], (0, -1), 'SEG'),)),
    'CCM_I21': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('CCM_I21_INSURANCE', GROUPS['CCM_I21_INSURANCE'], (0, -1), 'GRP'),
                 ('CCM_I21_APPOINTMENT_HISTORY', GROUPS['CCM_I21_APPOINTMENT_HISTORY'], (0, -1), 'GRP'),
                 ('CCM_I21_CLINICAL_HISTORY', GROUPS['CCM_I21_CLINICAL_HISTORY'], (0, -1), 'GRP'),
                 ('CCM_I21_PATIENT_VISITS', GROUPS['CCM_I21_PATIENT_VISITS'], (1, -1), 'GRP'),
                 ('CCM_I21_MEDICATION_HISTORY', GROUPS['CCM_I21_MEDICATION_HISTORY'], (0, -1), 'GRP'),
                 ('CCM_I21_PROBLEM', GROUPS['CCM_I21_PROBLEM'], (0, -1), 'GRP'),
                 ('CCM_I21_GOAL', GROUPS['CCM_I21_GOAL'], (0, -1), 'GRP'),
                 ('CCM_I21_PATHWAY', GROUPS['CCM_I21_PATHWAY'], (0, -1), 'GRP'),
                 ('REL', SEGMENTS['REL'], (0, -1), 'SEG'),)),
    'CCQ_I19': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (1, 1), 'SEG'),
                 ('CCQ_I19_PROVIDER_CONTACT', GROUPS['CCQ_I19_PROVIDER_CONTACT'], (0, -1), 'GRP'),
                 ('REL', SEGMENTS['REL'], (0, -1), 'SEG'),)),
    'CCR_I16': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (1, -1), 'SEG'),
                 ('CCR_I16_PROVIDER_CONTACT', GROUPS['CCR_I16_PROVIDER_CONTACT'], (1, -1), 'GRP'),
                 ('CCR_I16_CLINICAL_ORDER', GROUPS['CCR_I16_CLINICAL_ORDER'], (0, -1), 'GRP'),
                 ('CCR_I16_PATIENT', GROUPS['CCR_I16_PATIENT'], (1, -1), 'GRP'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('CCR_I16_INSURANCE', GROUPS['CCR_I16_INSURANCE'], (0, -1), 'GRP'),
                 ('CCR_I16_APPOINTMENT_HISTORY', GROUPS['CCR_I16_APPOINTMENT_HISTORY'], (0, -1), 'GRP'),
                 ('CCR_I16_CLINICAL_HISTORY', GROUPS['CCR_I16_CLINICAL_HISTORY'], (0, -1), 'GRP'),
                 ('CCR_I16_PATIENT_VISITS', GROUPS['CCR_I16_PATIENT_VISITS'], (1, -1), 'GRP'),
                 ('CCR_I16_MEDICATION_HISTORY', GROUPS['CCR_I16_MEDICATION_HISTORY'], (0, -1), 'GRP'),
                 ('CCR_I16_PROBLEM', GROUPS['CCR_I16_PROBLEM'], (0, -1), 'GRP'),
                 ('CCR_I16_GOAL', GROUPS['CCR_I16_GOAL'], (0, -1), 'GRP'),
                 ('CCR_I16_PATHWAY', GROUPS['CCR_I16_PATHWAY'], (0, -1), 'GRP'),
                 ('REL', SEGMENTS['REL'], (0, -1), 'SEG'),)),
    'CCU_I20': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (1, 1), 'SEG'),
                 ('CCU_I20_PROVIDER_CONTACT', GROUPS['CCU_I20_PROVIDER_CONTACT'], (0, -1), 'GRP'),
                 ('CCU_I20_PATIENT', GROUPS['CCU_I20_PATIENT'], (0, -1), 'GRP'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('CCU_I20_INSURANCE', GROUPS['CCU_I20_INSURANCE'], (0, -1), 'GRP'),
                 ('CCU_I20_APPOINTMENT_HISTORY', GROUPS['CCU_I20_APPOINTMENT_HISTORY'], (0, -1), 'GRP'),
                 ('CCU_I20_CLINICAL_HISTORY', GROUPS['CCU_I20_CLINICAL_HISTORY'], (0, -1), 'GRP'),
                 ('CCU_I20_PATIENT_VISITS', GROUPS['CCU_I20_PATIENT_VISITS'], (1, -1), 'GRP'),
                 ('CCU_I20_MEDICATION_HISTORY', GROUPS['CCU_I20_MEDICATION_HISTORY'], (0, -1), 'GRP'),
                 ('CCU_I20_PROBLEM', GROUPS['CCU_I20_PROBLEM'], (0, -1), 'GRP'),
                 ('CCU_I20_GOAL', GROUPS['CCU_I20_GOAL'], (0, -1), 'GRP'),
                 ('CCU_I20_PATHWAY', GROUPS['CCU_I20_PATHWAY'], (0, -1), 'GRP'),
                 ('REL', SEGMENTS['REL'], (0, -1), 'SEG'),)),
    'CQU_I19': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (1, 1), 'SEG'),
                 ('CQU_I19_PROVIDER_CONTACT', GROUPS['CQU_I19_PROVIDER_CONTACT'], (0, -1), 'GRP'),
                 ('CQU_I19_PATIENT', GROUPS['CQU_I19_PATIENT'], (0, -1), 'GRP'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('CQU_I19_INSURANCE', GROUPS['CQU_I19_INSURANCE'], (0, -1), 'GRP'),
                 ('CQU_I19_APPOINTMENT_HISTORY', GROUPS['CQU_I19_APPOINTMENT_HISTORY'], (0, -1), 'GRP'),
                 ('CQU_I19_CLINICAL_HISTORY', GROUPS['CQU_I19_CLINICAL_HISTORY'], (0, -1), 'GRP'),
                 ('CQU_I19_PATIENT_VISITS', GROUPS['CQU_I19_PATIENT_VISITS'], (1, -1), 'GRP'),
                 ('CQU_I19_MEDICATION_HISTORY', GROUPS['CQU_I19_MEDICATION_HISTORY'], (0, -1), 'GRP'),
                 ('CQU_I19_PROBLEM', GROUPS['CQU_I19_PROBLEM'], (0, -1), 'GRP'),
                 ('CQU_I19_GOAL', GROUPS['CQU_I19_GOAL'], (0, -1), 'GRP'),
                 ('CQU_I19_PATHWAY', GROUPS['CQU_I19_PATHWAY'], (0, -1), 'GRP'),
                 ('REL', SEGMENTS['REL'], (0, -1), 'SEG'),)),
    'CRM_C01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('CRM_C01_PATIENT', GROUPS['CRM_C01_PATIENT'], (1, -1), 'GRP'),)),
    'CSU_C09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('CSU_C09_PATIENT', GROUPS['CSU_C09_PATIENT'], (1, -1), 'GRP'),)),
    'DBC_O41': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DBC_O41_DONOR', GROUPS['DBC_O41_DONOR'], (0, 1), 'GRP'),)),
    'DBC_O42': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DBC_O42_DONOR', GROUPS['DBC_O42_DONOR'], (0, 1), 'GRP'),)),
    'DEL_O46': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DEL_O46_DONOR', GROUPS['DEL_O46_DONOR'], (0, 1), 'GRP'),
                 ('DON', SEGMENTS['DON'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'DEO_O45': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DEO_O45_DONOR', GROUPS['DEO_O45_DONOR'], (0, 1), 'GRP'),
                 ('DEO_O45_DONATION_ORDER', GROUPS['DEO_O45_DONATION_ORDER'], (1, -1), 'GRP'),)),
    'DER_O44': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DER_O44_DONOR', GROUPS['DER_O44_DONOR'], (0, 1), 'GRP'),
                 ('DER_O44_DONOR_ORDER', GROUPS['DER_O44_DONOR_ORDER'], (1, -1), 'GRP'),)),
    'DFT_P03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DFT_P03_VISIT', GROUPS['DFT_P03_VISIT'], (0, 1), 'GRP'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('DFT_P03_COMMON_ORDER', GROUPS['DFT_P03_COMMON_ORDER'], (0, -1), 'GRP'),
                 ('DFT_P03_FINANCIAL', GROUPS['DFT_P03_FINANCIAL'], (1, -1), 'GRP'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('DFT_P03_INSURANCE', GROUPS['DFT_P03_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),)),
    'DFT_P11': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (0, 1), 'SEG'),
                 ('DFT_P11_VISIT', GROUPS['DFT_P11_VISIT'], (0, 1), 'GRP'),
                 ('DB1', SEGMENTS['DB1'], (0, -1), 'SEG'),
                 ('DFT_P11_COMMON_ORDER', GROUPS['DFT_P11_COMMON_ORDER'], (0, -1), 'GRP'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, 1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('DFT_P11_INSURANCE', GROUPS['DFT_P11_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DFT_P11_FINANCIAL', GROUPS['DFT_P11_FINANCIAL'], (1, -1), 'GRP'),)),
    'DPR_O48': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DPR_O48_DONOR', GROUPS['DPR_O48_DONOR'], (0, 1), 'GRP'),
                 ('DPR_O48_DONATION_ORDER', GROUPS['DPR_O48_DONATION_ORDER'], (1, -1), 'GRP'),
                 ('DPR_O48_DONATION', GROUPS['DPR_O48_DONATION'], (0, 1), 'GRP'),)),
    'DRC_O47': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DRC_O47_DONOR', GROUPS['DRC_O47_DONOR'], (0, 1), 'GRP'),
                 ('DRC_O47_DONATION_ORDER', GROUPS['DRC_O47_DONATION_ORDER'], (1, -1), 'GRP'),)),
    'DRG_O43': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('DRG_O43_DONOR', GROUPS['DRG_O43_DONOR'], (0, 1), 'GRP'),)),
    'EAC_U07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('EAC_U07_COMMAND', GROUPS['EAC_U07_COMMAND'], (1, -1), 'GRP'),)),
    'EAN_U09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('EAN_U09_NOTIFICATION', GROUPS['EAN_U09_NOTIFICATION'], (1, -1), 'GRP'),)),
    'EAR_U08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('EAR_U08_COMMAND_RESPONSE', GROUPS['EAR_U08_COMMAND_RESPONSE'], (1, -1), 'GRP'),)),
    'EHC_E01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('EHC_E01_INVOICE_INFORMATION_SUBMIT', GROUPS['EHC_E01_INVOICE_INFORMATION_SUBMIT'], (1, 1), 'GRP'),)),
    'EHC_E02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('EHC_E02_INVOICE_INFORMATION_CANCEL', GROUPS['EHC_E02_INVOICE_INFORMATION_CANCEL'], (1, 1), 'GRP'),)),
    'EHC_E04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('EHC_E04_REASSESSMENT_REQUEST_INFO', GROUPS['EHC_E04_REASSESSMENT_REQUEST_INFO'], (1, 1), 'GRP'),)),
    'EHC_E10': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('EHC_E10_INVOICE_PROCESSING_RESULTS_INFO', GROUPS['EHC_E10_INVOICE_PROCESSING_RESULTS_INFO'], (1, -1), 'GRP'),)),
    'EHC_E12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('RFI', SEGMENTS['RFI'], (1, 1), 'SEG'),
                 ('CTD', SEGMENTS['CTD'], (0, -1), 'SEG'),
                 ('IVC', SEGMENTS['IVC'], (1, 1), 'SEG'),
                 ('PSS', SEGMENTS['PSS'], (1, 1), 'SEG'),
                 ('PSG', SEGMENTS['PSG'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (0, 1), 'SEG'),
                 ('PSL', SEGMENTS['PSL'], (0, -1), 'SEG'),
                 ('EHC_E12_REQUEST', GROUPS['EHC_E12_REQUEST'], (1, -1), 'GRP'),)),
    'EHC_E13': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('RFI', SEGMENTS['RFI'], (1, 1), 'SEG'),
                 ('CTD', SEGMENTS['CTD'], (0, -1), 'SEG'),
                 ('IVC', SEGMENTS['IVC'], (1, 1), 'SEG'),
                 ('PSS', SEGMENTS['PSS'], (1, 1), 'SEG'),
                 ('PSG', SEGMENTS['PSG'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (0, 1), 'SEG'),
                 ('PSL', SEGMENTS['PSL'], (0, 1), 'SEG'),
                 ('EHC_E13_REQUEST', GROUPS['EHC_E13_REQUEST'], (1, -1), 'GRP'),)),
    'EHC_E15': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('EHC_E15_PAYMENT_REMITTANCE_HEADER_INFO', GROUPS['EHC_E15_PAYMENT_REMITTANCE_HEADER_INFO'], (1, 1), 'GRP'),
                 ('EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO', GROUPS['EHC_E15_PAYMENT_REMITTANCE_DETAIL_INFO'], (0, -1), 'GRP'),
                 ('EHC_E15_ADJUSTMENT_PAYEE', GROUPS['EHC_E15_ADJUSTMENT_PAYEE'], (0, -1), 'GRP'),)),
    'EHC_E20': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('EHC_E20_AUTHORIZATION_REQUEST', GROUPS['EHC_E20_AUTHORIZATION_REQUEST'], (1, 1), 'GRP'),)),
    'EHC_E21': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('EHC_E21_AUTHORIZATION_REQUEST', GROUPS['EHC_E21_AUTHORIZATION_REQUEST'], (1, 1), 'GRP'),)),
    'EHC_E24': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('EHC_E24_AUTHORIZATION_RESPONSE_INFO', GROUPS['EHC_E24_AUTHORIZATION_RESPONSE_INFO'], (1, 1), 'GRP'),)),
    'ESR_U02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),)),
    'ESU_U01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('ISD', SEGMENTS['ISD'], (0, -1), 'SEG'),)),
    'INR_U06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('INV', SEGMENTS['INV'], (1, -1), 'SEG'),)),
    'INU_U05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('INV', SEGMENTS['INV'], (1, -1), 'SEG'),)),
    'LSU_U12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('EQP', SEGMENTS['EQP'], (1, -1), 'SEG'),)),
    'MDM_T01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('MDM_T01_COMMON_ORDER', GROUPS['MDM_T01_COMMON_ORDER'], (0, -1), 'GRP'),
                 ('TXA', SEGMENTS['TXA'], (1, 1), 'SEG'),
                 ('CON', SEGMENTS['CON'], (0, -1), 'SEG'),)),
    'MDM_T02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('MDM_T02_COMMON_ORDER', GROUPS['MDM_T02_COMMON_ORDER'], (0, -1), 'GRP'),
                 ('TXA', SEGMENTS['TXA'], (1, 1), 'SEG'),
                 ('CON', SEGMENTS['CON'], (0, -1), 'SEG'),
                 ('MDM_T02_OBSERVATION', GROUPS['MDM_T02_OBSERVATION'], (1, -1), 'GRP'),)),
    'MFK_M01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFA', SEGMENTS['MFA'], (0, -1), 'SEG'),)),
    'MFN_M02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M02_MF_STAFF', GROUPS['MFN_M02_MF_STAFF'], (1, -1), 'GRP'),)),
    'MFN_M04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('MFN_M04_MF_CDM', GROUPS['MFN_M04_MF_CDM'], (1, -1), 'GRP'),)),
    'MFN_M05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M05_MF_LOCATION', GROUPS['MFN_M05_MF_LOCATION'], (1, -1), 'GRP'),)),
    'MFN_M06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M06_MF_CLIN_STUDY', GROUPS['MFN_M06_MF_CLIN_STUDY'], (1, -1), 'GRP'),)),
    'MFN_M07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M07_MF_CLIN_STUDY_SCHED', GROUPS['MFN_M07_MF_CLIN_STUDY_SCHED'], (1, -1), 'GRP'),)),
    'MFN_M08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M08_MF_TEST_NUMERIC', GROUPS['MFN_M08_MF_TEST_NUMERIC'], (1, -1), 'GRP'),)),
    'MFN_M09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M09_MF_TEST_CATEGORICAL', GROUPS['MFN_M09_MF_TEST_CATEGORICAL'], (1, -1), 'GRP'),)),
    'MFN_M10': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M10_MF_TEST_BATTERIES', GROUPS['MFN_M10_MF_TEST_BATTERIES'], (1, -1), 'GRP'),)),
    'MFN_M11': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M11_MF_TEST_CALCULATED', GROUPS['MFN_M11_MF_TEST_CALCULATED'], (1, -1), 'GRP'),)),
    'MFN_M12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M12_MF_OBS_ATTRIBUTES', GROUPS['MFN_M12_MF_OBS_ATTRIBUTES'], (1, -1), 'GRP'),)),
    'MFN_M13': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFE', SEGMENTS['MFE'], (1, -1), 'SEG'),)),
    'MFN_M15': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M15_MF_INV_ITEM', GROUPS['MFN_M15_MF_INV_ITEM'], (1, -1), 'GRP'),)),
    'MFN_M16': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M16_MATERIAL_ITEM_RECORD', GROUPS['MFN_M16_MATERIAL_ITEM_RECORD'], (1, -1), 'GRP'),)),
    'MFN_M17': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M17_MF_DRG', GROUPS['MFN_M17_MF_DRG'], (1, -1), 'GRP'),)),
    'MFN_M18': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_M18_MF_PAYER', GROUPS['MFN_M18_MF_PAYER'], (1, -1), 'GRP'),)),
    'MFN_Znn': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MFI', SEGMENTS['MFI'], (1, 1), 'SEG'),
                 ('MFN_ZNN_MF_SITE_DEFINED', GROUPS['MFN_ZNN_MF_SITE_DEFINED'], (1, -1), 'GRP'),)),
    'NMD_N02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NMD_N02_CLOCK_AND_STATS_WITH_NOTES', GROUPS['NMD_N02_CLOCK_AND_STATS_WITH_NOTES'], (1, -1), 'GRP'),)),
    'OMB_O27': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMB_O27_PATIENT', GROUPS['OMB_O27_PATIENT'], (0, 1), 'GRP'),
                 ('OMB_O27_ORDER', GROUPS['OMB_O27_ORDER'], (1, -1), 'GRP'),)),
    'OMD_O03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMD_O03_PATIENT', GROUPS['OMD_O03_PATIENT'], (0, 1), 'GRP'),
                 ('OMD_O03_ORDER_DIET', GROUPS['OMD_O03_ORDER_DIET'], (1, -1), 'GRP'),
                 ('OMD_O03_ORDER_TRAY', GROUPS['OMD_O03_ORDER_TRAY'], (0, -1), 'GRP'),)),
    'OMG_O19': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMG_O19_PATIENT', GROUPS['OMG_O19_PATIENT'], (0, 1), 'GRP'),
                 ('OMG_O19_ORDER', GROUPS['OMG_O19_ORDER'], (1, -1), 'GRP'),)),
    'OMI_O23': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMI_O23_PATIENT', GROUPS['OMI_O23_PATIENT'], (0, 1), 'GRP'),
                 ('OMI_O23_ORDER', GROUPS['OMI_O23_ORDER'], (1, -1), 'GRP'),)),
    'OML_O21': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OML_O21_PATIENT', GROUPS['OML_O21_PATIENT'], (0, 1), 'GRP'),
                 ('OML_O21_ORDER', GROUPS['OML_O21_ORDER'], (1, -1), 'GRP'),)),
    'OML_O33': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OML_O33_PATIENT', GROUPS['OML_O33_PATIENT'], (0, 1), 'GRP'),
                 ('OML_O33_SPECIMEN', GROUPS['OML_O33_SPECIMEN'], (1, -1), 'GRP'),)),
    'OML_O35': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OML_O35_PATIENT', GROUPS['OML_O35_PATIENT'], (0, 1), 'GRP'),
                 ('OML_O35_SPECIMEN', GROUPS['OML_O35_SPECIMEN'], (1, -1), 'GRP'),)),
    'OML_O39': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OML_O39_PATIENT', GROUPS['OML_O39_PATIENT'], (0, 1), 'GRP'),
                 ('OML_O39_ORDER', GROUPS['OML_O39_ORDER'], (1, -1), 'GRP'),)),
    'OMN_O07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMN_O07_PATIENT', GROUPS['OMN_O07_PATIENT'], (0, 1), 'GRP'),
                 ('OMN_O07_ORDER', GROUPS['OMN_O07_ORDER'], (1, -1), 'GRP'),)),
    'OMP_O09': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMP_O09_PATIENT', GROUPS['OMP_O09_PATIENT'], (0, 1), 'GRP'),
                 ('OMP_O09_ORDER', GROUPS['OMP_O09_ORDER'], (1, -1), 'GRP'),)),
    'OMQ_O42': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMQ_O42_PATIENT', GROUPS['OMQ_O42_PATIENT'], (0, 1), 'GRP'),
                 ('OMQ_O42_ORDER', GROUPS['OMQ_O42_ORDER'], (1, -1), 'GRP'),)),
    'OMS_O05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OMS_O05_PATIENT', GROUPS['OMS_O05_PATIENT'], (0, 1), 'GRP'),
                 ('OMS_O05_ORDER', GROUPS['OMS_O05_ORDER'], (1, -1), 'GRP'),)),
    'OPL_O37': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (1, -1), 'SEG'),
                 ('OPL_O37_GUARANTOR', GROUPS['OPL_O37_GUARANTOR'], (0, 1), 'GRP'),
                 ('OPL_O37_ORDER', GROUPS['OPL_O37_ORDER'], (1, -1), 'GRP'),)),
    'OPR_O38': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('OPR_O38_RESPONSE', GROUPS['OPR_O38_RESPONSE'], (0, 1), 'GRP'),)),
    'OPU_R25': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, 1), 'SEG'),
                 ('PV1', SEGMENTS['PV1'], (1, 1), 'SEG'),
                 ('PV2', SEGMENTS['PV2'], (0, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('OPU_R25_PATIENT_VISIT_OBSERVATION', GROUPS['OPU_R25_PATIENT_VISIT_OBSERVATION'], (0, -1), 'GRP'),
                 ('OPU_R25_ACCESSION_DETAIL', GROUPS['OPU_R25_ACCESSION_DETAIL'], (1, -1), 'GRP'),)),
    'ORA_R33': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('ORC', SEGMENTS['ORC'], (0, 1), 'SEG'),)),
    'ORA_R41': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),)),
    'ORB_O28': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORB_O28_RESPONSE', GROUPS['ORB_O28_RESPONSE'], (0, 1), 'GRP'),)),
    'ORD_O04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORD_O04_RESPONSE', GROUPS['ORD_O04_RESPONSE'], (0, 1), 'GRP'),)),
    'ORG_O20': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORG_O20_RESPONSE', GROUPS['ORG_O20_RESPONSE'], (0, 1), 'GRP'),)),
    'ORI_O24': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORI_O24_RESPONSE', GROUPS['ORI_O24_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O22_RESPONSE', GROUPS['ORL_O22_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O34': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O34_RESPONSE', GROUPS['ORL_O34_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O36': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O36_RESPONSE', GROUPS['ORL_O36_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O40': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O40_RESPONSE', GROUPS['ORL_O40_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O41': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O41_RESPONSE', GROUPS['ORL_O41_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O42': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O42_RESPONSE', GROUPS['ORL_O42_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O43': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O43_RESPONSE', GROUPS['ORL_O43_RESPONSE'], (0, 1), 'GRP'),)),
    'ORL_O44': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORL_O44_RESPONSE', GROUPS['ORL_O44_RESPONSE'], (0, 1), 'GRP'),)),
    'ORN_O08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORN_O08_RESPONSE', GROUPS['ORN_O08_RESPONSE'], (0, 1), 'GRP'),)),
    'ORP_O10': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORP_O10_RESPONSE', GROUPS['ORP_O10_RESPONSE'], (0, 1), 'GRP'),)),
    'ORS_O06': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORS_O06_RESPONSE', GROUPS['ORS_O06_RESPONSE'], (0, 1), 'GRP'),)),
    'ORU_R01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('ORU_R01_PATIENT_RESULT', GROUPS['ORU_R01_PATIENT_RESULT'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'ORU_R30': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('ORU_R30_PATIENT_OBSERVATION', GROUPS['ORU_R30_PATIENT_OBSERVATION'], (0, -1), 'GRP'),
                 ('ORU_R30_VISIT', GROUPS['ORU_R30_VISIT'], (0, 1), 'GRP'),
                 ('ORC', SEGMENTS['ORC'], (1, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('OBR', SEGMENTS['OBR'], (1, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ORU_R30_TIMING_QTY', GROUPS['ORU_R30_TIMING_QTY'], (0, -1), 'GRP'),
                 ('ORU_R30_OBSERVATION', GROUPS['ORU_R30_OBSERVATION'], (1, -1), 'GRP'),)),
    'ORX_O43': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('ORX_O43_RESPONSE', GROUPS['ORX_O43_RESPONSE'], (0, 1), 'GRP'),)),
    'OSM_R26': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('OSM_R26_SHIPMENT', GROUPS['OSM_R26_SHIPMENT'], (1, -1), 'GRP'),)),
    'OSU_O41': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (0, 1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('OSU_O41_ORDER_STATUS', GROUPS['OSU_O41_ORDER_STATUS'], (1, -1), 'GRP'),)),
    'OUL_R22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, 1), 'SEG'),
                 ('OUL_R22_PATIENT', GROUPS['OUL_R22_PATIENT'], (0, 1), 'GRP'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('OUL_R22_SPECIMEN', GROUPS['OUL_R22_SPECIMEN'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'OUL_R23': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, 1), 'SEG'),
                 ('OUL_R23_PATIENT', GROUPS['OUL_R23_PATIENT'], (0, 1), 'GRP'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('OUL_R23_SPECIMEN', GROUPS['OUL_R23_SPECIMEN'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'OUL_R24': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, 1), 'SEG'),
                 ('OUL_R24_PATIENT', GROUPS['OUL_R24_PATIENT'], (0, 1), 'GRP'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('OUL_R24_ORDER', GROUPS['OUL_R24_ORDER'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'PEX_P07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('PEX_P07_VISIT', GROUPS['PEX_P07_VISIT'], (0, 1), 'GRP'),
                 ('PEX_P07_EXPERIENCE', GROUPS['PEX_P07_EXPERIENCE'], (1, -1), 'GRP'),)),
    'PGL_PC6': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PGL_PC6_PATIENT_VISIT', GROUPS['PGL_PC6_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PGL_PC6_GOAL', GROUPS['PGL_PC6_GOAL'], (1, -1), 'GRP'),)),
    'PMU_B01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('STF', SEGMENTS['STF'], (1, 1), 'SEG'),
                 ('PRA', SEGMENTS['PRA'], (0, -1), 'SEG'),
                 ('ORG', SEGMENTS['ORG'], (0, -1), 'SEG'),
                 ('AFF', SEGMENTS['AFF'], (0, -1), 'SEG'),
                 ('LAN', SEGMENTS['LAN'], (0, -1), 'SEG'),
                 ('EDU', SEGMENTS['EDU'], (0, -1), 'SEG'),
                 ('CER', SEGMENTS['CER'], (0, -1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('PRT', SEGMENTS['PRT'], (0, -1), 'SEG'),
                 ('ROL', SEGMENTS['ROL'], (0, -1), 'SEG'),)),
    'PMU_B03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('STF', SEGMENTS['STF'], (1, 1), 'SEG'),)),
    'PMU_B04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('STF', SEGMENTS['STF'], (1, 1), 'SEG'),
                 ('PRA', SEGMENTS['PRA'], (0, -1), 'SEG'),
                 ('ORG', SEGMENTS['ORG'], (0, -1), 'SEG'),)),
    'PMU_B07': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('STF', SEGMENTS['STF'], (1, 1), 'SEG'),
                 ('PRA', SEGMENTS['PRA'], (0, 1), 'SEG'),
                 ('PMU_B07_CERTIFICATE', GROUPS['PMU_B07_CERTIFICATE'], (0, -1), 'GRP'),)),
    'PMU_B08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EVN', SEGMENTS['EVN'], (1, 1), 'SEG'),
                 ('STF', SEGMENTS['STF'], (1, 1), 'SEG'),
                 ('PRA', SEGMENTS['PRA'], (0, 1), 'SEG'),
                 ('CER', SEGMENTS['CER'], (0, -1), 'SEG'),)),
    'PPG_PCG': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PPG_PCG_PATIENT_VISIT', GROUPS['PPG_PCG_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PPG_PCG_PATHWAY', GROUPS['PPG_PCG_PATHWAY'], (1, -1), 'GRP'),)),
    'PPP_PCB': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PPP_PCB_PATIENT_VISIT', GROUPS['PPP_PCB_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PPP_PCB_PATHWAY', GROUPS['PPP_PCB_PATHWAY'], (1, -1), 'GRP'),)),
    'PPR_PC1': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PPR_PC1_PATIENT_VISIT', GROUPS['PPR_PC1_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('PPR_PC1_PROBLEM', GROUPS['PPR_PC1_PROBLEM'], (1, -1), 'GRP'),)),
    'QBP_E03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('QBP_E03_QUERY_INFORMATION', GROUPS['QBP_E03_QUERY_INFORMATION'], (1, 1), 'GRP'),)),
    'QBP_E22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('QBP_E22_QUERY', GROUPS['QBP_E22_QUERY'], (1, 1), 'GRP'),)),
    'QBP_O33': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),)),
    'QBP_O34': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),)),
    'QBP_Q11': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('QBP_Q11_QBP', GROUPS['QBP_Q11_QBP'], (0, 1), 'GRP'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QBP_Q13': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (0, 1), 'SEG'),
                 ('RDF', SEGMENTS['RDF'], (0, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('RDF', SEGMENTS['RDF'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QBP_Q15': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('ANYHL7SEGMENT', SEGMENTS['ANYHL7SEGMENT'], (0, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QBP_Q21': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QBP_Qnn': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RDF', SEGMENTS['RDF'], (0, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QBP_Z73': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),)),
    'QCN_J01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QID', SEGMENTS['QID'], (1, 1), 'SEG'),)),
    'QSB_Q16': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'QVR_Q17': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('QVR_Q17_QBP', GROUPS['QVR_Q17_QBP'], (0, 1), 'GRP'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RAS_O17': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RAS_O17_PATIENT', GROUPS['RAS_O17_PATIENT'], (0, 1), 'GRP'),
                 ('RAS_O17_ORDER', GROUPS['RAS_O17_ORDER'], (1, -1), 'GRP'),)),
    'RDE_O11': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RDE_O11_PATIENT', GROUPS['RDE_O11_PATIENT'], (0, 1), 'GRP'),
                 ('RDE_O11_ORDER', GROUPS['RDE_O11_ORDER'], (1, -1), 'GRP'),)),
    'RDR_RDR': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, 1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RDR_RDR_DEFINITION', GROUPS['RDR_RDR_DEFINITION'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RDS_O13': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RDS_O13_PATIENT', GROUPS['RDS_O13_PATIENT'], (0, 1), 'GRP'),
                 ('RDS_O13_ORDER', GROUPS['RDS_O13_ORDER'], (1, -1), 'GRP'),)),
    'RDY_K15': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (0, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RDY_Z80': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (0, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'REF_I12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('REF_I12_AUTHORIZATION_CONTACT2', GROUPS['REF_I12_AUTHORIZATION_CONTACT2'], (0, 1), 'GRP'),
                 ('REF_I12_PROVIDER_CONTACT', GROUPS['REF_I12_PROVIDER_CONTACT'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('REF_I12_INSURANCE', GROUPS['REF_I12_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('REF_I12_PROCEDURE', GROUPS['REF_I12_PROCEDURE'], (0, -1), 'GRP'),
                 ('REF_I12_OBSERVATION', GROUPS['REF_I12_OBSERVATION'], (0, -1), 'GRP'),
                 ('REF_I12_PATIENT_VISIT', GROUPS['REF_I12_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RGV_O15': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RGV_O15_PATIENT', GROUPS['RGV_O15_PATIENT'], (0, 1), 'GRP'),
                 ('RGV_O15_ORDER', GROUPS['RGV_O15_ORDER'], (1, -1), 'GRP'),)),
    'RPA_I08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('RPA_I08_AUTHORIZATION', GROUPS['RPA_I08_AUTHORIZATION'], (0, 1), 'GRP'),
                 ('RPA_I08_PROVIDER', GROUPS['RPA_I08_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('RPA_I08_INSURANCE', GROUPS['RPA_I08_INSURANCE'], (0, -1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('RPA_I08_PROCEDURE', GROUPS['RPA_I08_PROCEDURE'], (1, -1), 'GRP'),
                 ('RPA_I08_OBSERVATION', GROUPS['RPA_I08_OBSERVATION'], (0, -1), 'GRP'),
                 ('RPA_I08_VISIT', GROUPS['RPA_I08_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RPI_I01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RPI_I01_PROVIDER', GROUPS['RPI_I01_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('RPI_I01_GUARANTOR_INSURANCE', GROUPS['RPI_I01_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RPI_I04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RPI_I04_PROVIDER', GROUPS['RPI_I04_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('RPI_I04_GUARANTOR_INSURANCE', GROUPS['RPI_I04_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RPL_I02': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RPL_I02_PROVIDER', GROUPS['RPL_I02_PROVIDER'], (1, -1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (0, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RPR_I03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('RPR_I03_PROVIDER', GROUPS['RPR_I03_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (0, -1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQA_I08': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('RQA_I08_AUTHORIZATION', GROUPS['RQA_I08_AUTHORIZATION'], (0, 1), 'GRP'),
                 ('RQA_I08_PROVIDER', GROUPS['RQA_I08_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('RQA_I08_GUARANTOR_INSURANCE', GROUPS['RQA_I08_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('RQA_I08_PROCEDURE', GROUPS['RQA_I08_PROCEDURE'], (0, -1), 'GRP'),
                 ('RQA_I08_OBSERVATION', GROUPS['RQA_I08_OBSERVATION'], (0, -1), 'GRP'),
                 ('RQA_I08_VISIT', GROUPS['RQA_I08_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQI_I01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RQI_I01_PROVIDER', GROUPS['RQI_I01_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('RQI_I01_GUARANTOR_INSURANCE', GROUPS['RQI_I01_GUARANTOR_INSURANCE'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RQP_I04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('RQP_I04_PROVIDER', GROUPS['RQP_I04_PROVIDER'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RRA_O18': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRA_O18_RESPONSE', GROUPS['RRA_O18_RESPONSE'], (0, 1), 'GRP'),)),
    'RRD_O14': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRD_O14_RESPONSE', GROUPS['RRD_O14_RESPONSE'], (0, 1), 'GRP'),)),
    'RRE_O12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRE_O12_RESPONSE', GROUPS['RRE_O12_RESPONSE'], (0, 1), 'GRP'),)),
    'RRG_O16': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('RRG_O16_RESPONSE', GROUPS['RRG_O16_RESPONSE'], (0, 1), 'GRP'),)),
    'RRI_I12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (0, 1), 'SEG'),
                 ('RF1', SEGMENTS['RF1'], (0, 1), 'SEG'),
                 ('RRI_I12_AUTHORIZATION_CONTACT2', GROUPS['RRI_I12_AUTHORIZATION_CONTACT2'], (0, 1), 'GRP'),
                 ('RRI_I12_PROVIDER_CONTACT', GROUPS['RRI_I12_PROVIDER_CONTACT'], (1, -1), 'GRP'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('ACC', SEGMENTS['ACC'], (0, 1), 'SEG'),
                 ('DG1', SEGMENTS['DG1'], (0, -1), 'SEG'),
                 ('DRG', SEGMENTS['DRG'], (0, -1), 'SEG'),
                 ('AL1', SEGMENTS['AL1'], (0, -1), 'SEG'),
                 ('RRI_I12_PROCEDURE', GROUPS['RRI_I12_PROCEDURE'], (0, -1), 'GRP'),
                 ('RRI_I12_OBSERVATION', GROUPS['RRI_I12_OBSERVATION'], (0, -1), 'GRP'),
                 ('RRI_I12_PATIENT_VISIT', GROUPS['RRI_I12_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),)),
    'RSP_E03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('RSP_E03_QUERY_ACK_IPR', GROUPS['RSP_E03_QUERY_ACK_IPR'], (1, 1), 'GRP'),)),
    'RSP_E22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, -1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('RSP_E22_QUERY_ACK', GROUPS['RSP_E22_QUERY_ACK'], (1, 1), 'GRP'),)),
    'RSP_K11': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_K11_SEGMENT_PATTERN', GROUPS['RSP_K11_SEGMENT_PATTERN'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_K21': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_K21_QUERY_RESPONSE', GROUPS['RSP_K21_QUERY_RESPONSE'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_K22': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_K22_QUERY_RESPONSE', GROUPS['RSP_K22_QUERY_RESPONSE'], (0, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_K23': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_K23_QUERY_RESPONSE', GROUPS['RSP_K23_QUERY_RESPONSE'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_K25': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('RSP_K25_STAFF', GROUPS['RSP_K25_STAFF'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_K31': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('RSP_K31_RESPONSE', GROUPS['RSP_K31_RESPONSE'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_K32': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_K32_QUERY_RESPONSE', GROUPS['RSP_K32_QUERY_RESPONSE'], (0, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_O33': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_O33_DONOR', GROUPS['RSP_O33_DONOR'], (0, 1), 'GRP'),)),
    'RSP_O34': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_O34_DONOR', GROUPS['RSP_O34_DONOR'], (0, 1), 'GRP'),
                 ('RSP_O34_DONATION', GROUPS['RSP_O34_DONATION'], (0, 1), 'GRP'),)),
    'RSP_Z82': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('RSP_Z82_QUERY_RESPONSE', GROUPS['RSP_Z82_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_Z84': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_Z84_ROW_DEFINITION', GROUPS['RSP_Z84_ROW_DEFINITION'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_Z86': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RSP_Z86_QUERY_RESPONSE', GROUPS['RSP_Z86_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RSP_Z88': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('RSP_Z88_QUERY_RESPONSE', GROUPS['RSP_Z88_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (1, 1), 'SEG'),)),
    'RSP_Z90': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RCP', SEGMENTS['RCP'], (1, 1), 'SEG'),
                 ('RSP_Z90_QUERY_RESPONSE', GROUPS['RSP_Z90_QUERY_RESPONSE'], (1, -1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (1, 1), 'SEG'),)),
    'RSP_Znn': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('ANYHL7SEGMENT', SEGMENTS['ANYHL7SEGMENT'], (0, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RTB_K13': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RTB_K13_ROW_DEFINITION', GROUPS['RTB_K13_ROW_DEFINITION'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RTB_Knn': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('ANYHL7SEGMENT', SEGMENTS['ANYHL7SEGMENT'], (1, 1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'RTB_Z74': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('QAK', SEGMENTS['QAK'], (1, 1), 'SEG'),
                 ('QPD', SEGMENTS['QPD'], (1, 1), 'SEG'),
                 ('RTB_Z74_ROW_DEFINITION', GROUPS['RTB_Z74_ROW_DEFINITION'], (0, 1), 'GRP'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'SDR_S31': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('SDR_S31_ANTI_MICROBIAL_DEVICE_DATA', GROUPS['SDR_S31_ANTI_MICROBIAL_DEVICE_DATA'], (1, 1), 'GRP'),)),
    'SDR_S32': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('SDR_S32_ANTI_MICROBIAL_DEVICE_CYCLE_DATA', GROUPS['SDR_S32_ANTI_MICROBIAL_DEVICE_CYCLE_DATA'], (1, 1), 'GRP'),)),
    'SIU_S12': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SCH', SEGMENTS['SCH'], (1, 1), 'SEG'),
                 ('TQ1', SEGMENTS['TQ1'], (0, -1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('SIU_S12_PATIENT', GROUPS['SIU_S12_PATIENT'], (0, -1), 'GRP'),
                 ('SIU_S12_RESOURCES', GROUPS['SIU_S12_RESOURCES'], (1, -1), 'GRP'),)),
    'SLR_S28': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('SLT', SEGMENTS['SLT'], (1, -1), 'SEG'),)),
    'SRM_S01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('ARQ', SEGMENTS['ARQ'], (1, 1), 'SEG'),
                 ('APR', SEGMENTS['APR'], (0, 1), 'SEG'),
                 ('NTE', SEGMENTS['NTE'], (0, -1), 'SEG'),
                 ('SRM_S01_PATIENT', GROUPS['SRM_S01_PATIENT'], (0, -1), 'GRP'),
                 ('SRM_S01_RESOURCES', GROUPS['SRM_S01_RESOURCES'], (1, -1), 'GRP'),)),
    'SRR_S01': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('MSA', SEGMENTS['MSA'], (1, 1), 'SEG'),
                 ('ERR', SEGMENTS['ERR'], (0, -1), 'SEG'),
                 ('SRR_S01_SCHEDULE', GROUPS['SRR_S01_SCHEDULE'], (0, 1), 'GRP'),)),
    'SSR_U04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('SSR_U04_SPECIMEN_CONTAINER', GROUPS['SSR_U04_SPECIMEN_CONTAINER'], (1, -1), 'GRP'),)),
    'SSU_U03': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('SSU_U03_SPECIMEN_CONTAINER', GROUPS['SSU_U03_SPECIMEN_CONTAINER'], (1, -1), 'GRP'),)),
    'STC_S33': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('SCP', SEGMENTS['SCP'], (1, -1), 'SEG'),)),
    'TCU_U10': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('EQU', SEGMENTS['EQU'], (1, 1), 'SEG'),
                 ('TCU_U10_TEST_CONFIGURATION', GROUPS['TCU_U10_TEST_CONFIGURATION'], (1, -1), 'GRP'),)),
    'UDM_Q05': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('URD', SEGMENTS['URD'], (1, 1), 'SEG'),
                 ('URS', SEGMENTS['URS'], (0, 1), 'SEG'),
                 ('DSP', SEGMENTS['DSP'], (1, -1), 'SEG'),
                 ('DSC', SEGMENTS['DSC'], (0, 1), 'SEG'),)),
    'VXU_V04': ('sequence',
                (('MSH', SEGMENTS['MSH'], (1, 1), 'SEG'),
                 ('SFT', SEGMENTS['SFT'], (0, -1), 'SEG'),
                 ('UAC', SEGMENTS['UAC'], (0, 1), 'SEG'),
                 ('PID', SEGMENTS['PID'], (1, 1), 'SEG'),
                 ('PD1', SEGMENTS['PD1'], (0, 1), 'SEG'),
                 ('NK1', SEGMENTS['NK1'], (0, -1), 'SEG'),
                 ('ARV', SEGMENTS['ARV'], (0, -1), 'SEG'),
                 ('VXU_V04_PATIENT_VISIT', GROUPS['VXU_V04_PATIENT_VISIT'], (0, 1), 'GRP'),
                 ('GT1', SEGMENTS['GT1'], (0, -1), 'SEG'),
                 ('VXU_V04_INSURANCE', GROUPS['VXU_V04_INSURANCE'], (0, -1), 'GRP'),
                 ('VXU_V04_PERSON_OBSERVATION', GROUPS['VXU_V04_PERSON_OBSERVATION'], (0, -1), 'GRP'),
                 ('VXU_V04_ORDER', GROUPS['VXU_V04_ORDER'], (0, -1), 'GRP'),)),
}