# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2018, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


TABLES = {
    'HL70001': ('Administrative Sex',
                ('F',
                 'M',
                 'O',
                 'U',
                 'A',
                 'N')),
    'HL70002': ('Marital Status',
                ('A',
                 'D',
                 'M',
                 'S',
                 'W',
                 'C',
                 'G',
                 'P',
                 'R',
                 'E',
                 'N',
                 'I',
                 'B',
                 'U',
                 'O',
                 'T')),
    'HL70003': ('Event Type',
                ('A01',
                 'A02',
                 'A03',
                 'A04',
                 'A05',
                 'A06',
                 'A07',
                 'A08',
                 'A09',
                 'A10',
                 'A11',
                 'A12',
                 'A13',
                 'A14',
                 'A15',
                 'A16',
                 'A17',
                 'A18',
                 'A19',
                 'A20',
                 'A21',
                 'A22',
                 'A23',
                 'A24',
                 'A25',
                 'A26',
                 'A27',
                 'A28',
                 'A29',
                 'A30',
                 'A31',
                 'A32',
                 'A33',
                 'A34',
                 'A35',
                 'A36',
                 'A37',
                 'A38',
                 'A39',
                 'A40',
                 'A41',
                 'A42',
                 'A43',
                 'A44',
                 'A45',
                 'A46',
                 'A47',
                 'A48',
                 'A49',
                 'A50',
                 'A51',
                 'A52',
                 'A53',
                 'A54',
                 'A55',
                 'A60',
                 'A61',
                 'A62',
                 'B01',
                 'B02',
                 'B03',
                 'B04',
                 'B05',
                 'B06',
                 'B07',
                 'B08',
                 'C01',
                 'C02',
                 'C03',
                 'C04',
                 'C05',
                 'C06',
                 'C07',
                 'C08',
                 'C09',
                 'C10',
                 'C11',
                 'C12',
                 'E01',
                 'E02',
                 'E03',
                 'E04',
                 'E10',
                 'E12',
                 'E13',
                 'E15',
                 'E20',
                 'E21',
                 'E22',
                 'E24',
                 'E30',
                 'E31',
                 'I01',
                 'I02',
                 'I03',
                 'I04',
                 'I05',
                 'I06',
                 'I07',
                 'I08',
                 'I09',
                 'I10',
                 'I11',
                 'I12',
                 'I13',
                 'I14',
                 'I15',
                 'I16',
                 'I17',
                 'I18',
                 'I19',
                 'I20',
                 'I21',
                 'I22',
                 'J01',
                 'J02',
                 'K11',
                 'K13',
                 'K15',
                 'K21',
                 'K22',
                 'K23',
                 'K24',
                 'K25',
                 'K31',
                 'K32',
                 'M01',
                 'M02',
                 'M03',
                 'M04',
                 'M05',
                 'M06',
                 'M07',
                 'M08',
                 'M09',
                 'M10',
                 'M11',
                 'M12',
                 'M13',
                 'M14',
                 'M15',
                 'M16',
                 'M17',
                 'N01',
                 'N02',
                 'O01',
                 'O02',
                 'O03',
                 'O04',
                 'O05',
                 'O06',
                 'O07',
                 'O08',
                 'O09',
                 'O10',
                 'O11',
                 'O12',
                 'O13',
                 'O14',
                 'O15',
                 'O16',
                 'O17',
                 'O18',
                 'O19',
                 'O20',
                 'O21',
                 'O22',
                 'O23',
                 'O24',
                 'O25',
                 'O26',
                 'O27',
                 'O28',
                 'O29',
                 'O30',
                 'O31',
                 'O32',
                 'O33',
                 'O34',
                 'O35',
                 'O36',
                 'O37',
                 'O38',
                 'O39',
                 'O40',
                 'O41',
                 'O42',
                 'O43',
                 'P01',
                 'P02',
                 'P03',
                 'P04',
                 'P05',
                 'P06',
                 'P07',
                 'P08',
                 'P09',
                 'P10',
                 'P11',
                 'P12',
                 'PC1',
                 'PC2',
                 'PC3',
                 'PC4',
                 'PC5',
                 'PC6',
                 'PC7',
                 'PC8',
                 'PC9',
                 'PCA',
                 'PCB',
                 'PCC',
                 'PCD',
                 'PCE',
                 'PCF',
                 'PCG',
                 'PCH',
                 'PCJ',
                 'PCK',
                 'PCL',
                 'Q01',
                 'Q02',
                 'Q03',
                 'Q05',
                 'Q06',
                 'Q11',
                 'Q13',
                 'Q15',
                 'Q16',
                 'Q17',
                 'Q21',
                 'Q22',
                 'Q23',
                 'Q24',
                 'Q25',
                 'Q26',
                 'Q27',
                 'Q28',
                 'Q29',
                 'Q30',
                 'Q31',
                 'Q32',
                 'R01',
                 'R02',
                 'R04',
                 'ROR',
                 'R21',
                 'R22',
                 'R23',
                 'R24',
                 'R25',
                 'R26',
                 'R30',
                 'R31',
                 'R32',
                 'R33',
                 'R40',
                 'S01',
                 'S02',
                 'S03',
                 'S04',
                 'S05',
                 'S06',
                 'S07',
                 'S08',
                 'S09',
                 'S10',
                 'S11',
                 'S12',
                 'S13',
                 'S14',
                 'S15',
                 'S16',
                 'S17',
                 'S18',
                 'S19',
                 'S20',
                 'S21',
                 'S22',
                 'S23',
                 'S24',
                 'S25',
                 'S26',
                 'S27',
                 'S28',
                 'S29',
                 'S30',
                 'S31',
                 'S32',
                 'S33',
                 'S34',
                 'S35',
                 'S36',
                 'S37',
                 'T01',
                 'T02',
                 'T03',
                 'T04',
                 'T05',
                 'T06',
                 'T07',
                 'T08',
                 'T09',
                 'T10',
                 'T11',
                 'T12',
                 'U01',
                 'U02',
                 'U03',
                 'U04',
                 'U05',
                 'U06',
                 'U07',
                 'U08',
                 'U09',
                 'U10',
                 'U11',
                 'U12',
                 'U13',
                 'V01',
                 'V02',
                 'V03',
                 'V04',
                 'Varies',
                 'W01',
                 'W02')),
    'HL70004': ('Patient Class',
                ('E',
                 'I',
                 'O',
                 'P',
                 'R',
                 'B',
                 'C',
                 'N',
                 'U')),
    'HL70005': ('Race',
                ('1002-5',
                 '2028-9',
                 '2054-5',
                 '2076-8',
                 '2106-3',
                 '2131-1')),
    'HL70006': ('Religion',
                ('AGN',
                 'ATH',
                 'BAH',
                 'BRE',
                 'BUD',
                 'BMA',
                 'BTH',
                 'BTA',
                 'BOT',
                 'CFR',
                 'CHR',
                 'ABC',
                 'AMT',
                 'AME',
                 'ANG',
                 'AOG',
                 'BAP',
                 'CRR',
                 'CHS',
                 'CMA',
                 'COC',
                 'COG',
                 'COI',
                 'COM',
                 'COL',
                 'EOT',
                 'EVC',
                 'EPI',
                 'FWB',
                 'FRQ',
                 'FUL',
                 'GRE',
                 'JWN',
                 'MOM',
                 'LUT',
                 'LMS',
                 'MEN',
                 'MET',
                 'NAZ',
                 'ORT',
                 'PEN',
                 'COP',
                 'PRE',
                 'PRO',
                 'PRC',
                 'REC',
                 'REO',
                 'CAT',
                 'SAA',
                 'SEV',
                 'SOU',
                 'UCC',
                 'UMD',
                 'UNI',
                 'UNU',
                 'WES',
                 'WMC',
                 'COT',
                 'CNF',
                 'DOC',
                 'ERL',
                 'HIN',
                 'HSH',
                 'HVA',
                 'HOT',
                 'JAI',
                 'JEW',
                 'JCO',
                 'JOR',
                 'JRC',
                 'JRF',
                 'JRN',
                 'JOT',
                 'MOS',
                 'MSH',
                 'MSU',
                 'MOT',
                 'NAM',
                 'NRL',
                 'NOE',
                 'SHN',
                 'SIK',
                 'SPI',
                 'OTH',
                 'VAR')),
    'HL70007': ('Admission Type',
                ('A',
                 'E',
                 'L',
                 'R',
                 'N',
                 'U',
                 'C')),
    'HL70008': ('Acknowledgment Code',
                ('AA',
                 'AE',
                 'AR',
                 'CA',
                 'CE',
                 'CR')),
    'HL70009': ('Ambulatory Status',
                ('A0',
                 'A1',
                 'A2',
                 'A3',
                 'A4',
                 'A5',
                 'A6',
                 'A7',
                 'A8',
                 'A9',
                 'B1',
                 'B2',
                 'B3',
                 'B4',
                 'B5',
                 'B6')),
    'HL70010': ('Physician Id', ()),
    'HL70017': ('Transaction Type ',
                ('CG',
                 'CD',
                 'PY',
                 'AJ',
                 'CO')),
    'HL70018': ('Patient Type', ()),
    'HL70019': ('Anesthesia Code', ()),
    'HL70021': ('Bad Debt Agency Code',
                ()),
    'HL70022': ('Billing Status',
                ()),
    'HL70023': ('Admit Source',
                ()),
    'HL70024': ('Fee Schedule',
                ()),
    'HL70027': ('Priority',
                ('S',
                 'A',
                 'R',
                 'P',
                 'T')),
    'HL70032': ('Charge Price Indicator',
                ()),
    'HL70038': ('Order status',
                ('A',
                 'CA',
                 'CM',
                 'DC',
                 'ER',
                 'HD',
                 'IP',
                 'RP',
                 'SC')),
    'HL70042': ('Company Plan Code',
                ()),
    'HL70043': ('Condition Code',
                ()),
    'HL70044': ('Contract Code',
                ()),
    'HL70045': ('Courtesy Code',
                ()),
    'HL70046': ('Credit Rating',
                ()),
    'HL70049': ('Department Code',
                ()),
    'HL70050': ('Accident Code',
                ()),
    'HL70051': ('Diagnosis Code',
                ()),
    'HL70052': ('Diagnosis Type',
                ('A',
                 'W',
                 'F')),
    'HL70055': ('Diagnosis Related Group',
                ()),
    'HL70056': ('DRG Grouper Review Code',
                ()),
    'HL70059': ('Consent Code',
                ()),
    'HL70061': ('Check Digit Scheme',
                ('BCV',
                 'NPI',
                 'ISO',
                 'M10',
                 'M11')),
    'HL70062': ('Event Reason ',
                ('1',
                 '2',
                 '3',
                 'O',
                 'U')),
    'HL70063': ('Relationship',
                ('SEL',
                 'SPO',
                 'DOM',
                 'CHD',
                 'GCH',
                 'NCH',
                 'SCH',
                 'FCH',
                 'DEP',
                 'WRD',
                 'PAR',
                 'MTH',
                 'FTH',
                 'CGV',
                 'GRD',
                 'GRP',
                 'EXF',
                 'SIB',
                 'BRO',
                 'SIS',
                 'FND',
                 'OAD',
                 'EME',
                 'EMR',
                 'ASC',
                 'EMC',
                 'OWN',
                 'TRA',
                 'MGR',
                 'NON',
                 'UNK',
                 'OTH')),
    'HL70064': ('Financial Class',
                ()),
    'HL70065': ('Specimen Action Code',
                ('A',
                 'G',
                 'L',
                 'O',
                 'P',
                 'R',
                 'S')),
    'HL70066': ('Employment Status',
                ('1',
                 '2',
                 '4',
                 'C',
                 'L',
                 'T',
                 '3',
                 '5',
                 '6',
                 'O',
                 '9')),
    'HL70068': ('Guarantor Type',
                ()),
    'HL70069': ('Hospital Service',
                ('MED',
                 'SUR',
                 'URO',
                 'PUL',
                 'CAR')),
    'HL70070': ('Specimen Source Codes', ()),
    'HL70072': ('Insurance Plan ID', ()),
    'HL70073': ('Interest Rate Code', ()),
    'HL70074': ('Diagnostic Service Section ID',
                ('AU',
                 'BG',
                 'BLB',
                 'CUS',
                 'CTH',
                 'CT',
                 'CH',
                 'CP',
                 'EC',
                 'EN',
                 'HM',
                 'ICU',
                 'IMM',
                 'LAB',
                 'MB',
                 'MCB',
                 'MYC',
                 'NMS',
                 'NMR',
                 'NRS',
                 'OUS',
                 'OT',
                 'OTH',
                 'OSL',
                 'PHR',
                 'PT',
                 'PHY',
                 'PF',
                 'RAD',
                 'RX',
                 'RUS',
                 'RC',
                 'RT',
                 'SR',
                 'SP',
                 'TX',
                 'VUS',
                 'VR',
                 'XRC')),
    'HL70076': ('Message Type',
                ('ACK',
                 'ADR',
                 'ADT',
                 'BAR',
                 'CCF',
                 'CCI',
                 'CCM',
                 'CCQ',
                 'CCU',
                 'CQU',
                 'CRM',
                 'BPS',
                 'BRP',
                 'BRT',
                 'BTS',
                 'CSU',
                 'DBC',
                 'DBU',
                 'DEL',
                 'DEO',
                 'DER',
                 'DFT',
                 'DOC',
                 'DPR',
                 'DRC',
                 'DSR',
                 'EAC',
                 'EAN',
                 'EAR',
                 'EHC',
                 'ESR',
                 'ESU',
                 'INR',
                 'INU',
                 'LSR',
                 'LSU',
                 'MDM',
                 'MFD',
                 'MFK',
                 'MFN',
                 'MFQ',
                 'MFR',
                 'NMD',
                 'NMQ',
                 'NMR',
                 'OMB',
                 'OMD',
                 'OMG',
                 'OMI',
                 'OML',
                 'OMN',
                 'OMP',
                 'OMQ',
                 'OMS',
                 'OPL',
                 'OPR',
                 'OPU',
                 'ORA',
                 'ORB',
                 'ORD',
                 'ORF',
                 'ORG',
                 'ORI',
                 'ORL',
                 'ORM',
                 'ORN',
                 'ORP',
                 'ORR',
                 'ORS',
                 'ORU',
                 'ORX',
                 'OSM',
                 'OSQ',
                 'OSR',
                 'OSU',
                 'OUL',
                 'PEX',
                 'PGL',
                 'PIN',
                 'PMU',
                 'PPG',
                 'PPP',
                 'PPR',
                 'PPT',
                 'PPV',
                 'PRR',
                 'PTR',
                 'QBP',
                 'QCK',
                 'QCN',
                 'QRY',
                 'QSB',
                 'QSX',
                 'QVR',
                 'RAR',
                 'RAS',
                 'RCI',
                 'RCL',
                 'RDE',
                 'RDR',
                 'RDS',
                 'RDY',
                 'REF',
                 'RER',
                 'RGR',
                 'RGV',
                 'ROR',
                 'RPA',
                 'RPI',
                 'RPL',
                 'RPR',
                 'RQA',
                 'RQC',
                 'RQI',
                 'RQP',
                 'RRA',
                 'RRD',
                 'RRE',
                 'RRG',
                 'RRI',
                 'RSP',
                 'RTB',
                 'SCN',
                 'SDN',
                 'SDR',
                 'SIU',
                 'SLN',
                 'SLR',
                 'SMD',
                 'SQM',
                 'SQR',
                 'SRM',
                 'SRR',
                 'SSR',
                 'SSU',
                 'STC',
                 'STI',
                 'SUR',
                 'TBR',
                 'TCR',
                 'TCU',
                 'UDM',
                 'VXQ',
                 'VXR',
                 'VXU',
                 'VXX')),
    'HL70078': ('Interpretation Codes',
                ('L',
                 'H',
                 'LL',
                 'HH',
                 '<',
                 '>',
                 'N',
                 'A',
                 'AA',
                 'null',
                 'U',
                 'D',
                 'B',
                 'W',
                 'S',
                 'R',
                 'I',
                 'MS',
                 'VS',
                 'POS',
                 'NEG',
                 'IND',
                 'DET',
                 'ND',
                 'AC',
                 'TOX',
                 'QCF',
                 'RR',
                 'WR',
                 'NR',
                 'OBX',
                 'HM')),
    'HL70080': ('Nature of Abnormal Testing',
                ('A',
                 'N',
                 'R',
                 'S',
                 'SP',
                 'B',
                 'ST')),
    'HL70083': ('Outlier Type',
                ('D',
                 'C')),
    'HL70084': ('Performed by',
                ()),
    'HL70085': ('Observation Result Status Codes Interpretation',
                ('A',
                 'B',
                 'C',
                 'D',
                 'F',
                 'I',
                 'N',
                 'O',
                 'P',
                 'R',
                 'S',
                 'V',
                 'X',
                 'U',
                 'W')),
    'HL70086': ('Plan ID',
                ()),
    'HL70087': ('Pre-Admit Test Indicator',
                ()),
    'HL70088': ('Procedure Code',
                ('C4',
                 'C5',
                 'HCPCS',
                 'HPC',
                 'I10P',
                 'SCT')),
    'HL70091': ('Query Priority',
                ('D',
                 'I')),
    'HL70092': ('Re-Admission Indicator',
                ('R',)),
    'HL70093': ('Release Information',
                ('Y',
                 'N',
                 '...')),
    'HL70098': ('Type of Agreement',
                ('S',
                 'U',
                 'M')),
    'HL70099': ('VIP Indicator',
                ()),
    'HL70100': ('Invocation event',
                ('D',
                 'O',
                 'R',
                 'S',
                 'T')),
    'HL70103': ('Processing ID',
                ('D',
                 'P',
                 'T')),
    'HL70104': ('Version ID',
                ('2',
                 '2.0D',
                 '2.1',
                 '2.2',
                 '2.3',
                 '2.3.1',
                 '2.4',
                 '2.5',
                 '2.5.1',
                 '2.6',
                 '2.7',
                 '2.7.1',
                 '2.8')),
    'HL70105': ('Source of Comment',
                ('L',
                 'P',
                 'O')),
    'HL70110': ('Transfer to Bad Debt Code',
                ()),
    'HL70111': ('Delete Account Code',
                ()),
    'HL70112': ('Discharge Disposition',
                ()),
    'HL70113': ('Discharged to Location',
                ()),
    'HL70114': ('Diet Type',
                ()),
    'HL70115': ('Servicing Facilities',
                ()),
    'HL70116': ('Bed Status',
                ('C',
                 'H',
                 'O',
                 'U',
                 'K',
                 'I')),
    'HL70117': ('Account Status',
                ()),
    'HL70118': ('Major Diagnostic Category',
                ()),
    'HL70119': ('Order Control Codes',
                ('AF',
                 'CA',
                 'CH',
                 'CN',
                 'CP',
                 'CR',
                 'DC',
                 'DE',
                 'DF',
                 'DR',
                 'FU',
                 'HD',
                 'HR',
                 'LI',
                 'NA',
                 'NW',
                 'OC',
                 'OD',
                 'OE',
                 'OF',
                 'OH',
                 'OK',
                 'OP',
                 'OR',
                 'PA',
                 'PR',
                 'PY',
                 'RE',
                 'RF',
                 'RL',
                 'RO',
                 'RP',
                 'RQ',
                 'RR',
                 'RU',
                 'SC',
                 'SN',
                 'SR',
                 'SS',
                 'UA',
                 'UC',
                 'UD',
                 'UF',
                 'UH',
                 'UM',
                 'UN',
                 'UR',
                 'UX',
                 'XO',
                 'XR',
                 'XX',
                 'MC')),
    'HL70121': ('Response Flag',
                ('E',
                 'R',
                 'D',
                 'F',
                 'N')),
    'HL70122': ('Charge Type',
                ('CH',
                 'CO',
                 'CR',
                 'DP',
                 'GR',
                 'NC',
                 'PC',
                 'RS')),
    'HL70123': ('Result Status',
                ('O',
                 'I',
                 'S',
                 'A',
                 'P',
                 'C',
                 'R',
                 'F',
                 'X',
                 'Y',
                 'Z')),
    'HL70124': ('Transportation Mode',
                ('CART',
                 'PORT',
                 'WALK',
                 'WHLC')),
    'HL70125': ('Value Type',
                ('AD',
                 'CNE',
                 'CWE',
                 'CF',
                 'CK',
                 'CN',
                 'CP',
                 'CX',
                 'DR',
                 'DT',
                 'DTM',
                 'ED',
                 'FT',
                 'ID',
                 'IS',
                 'MA',
                 'MO',
                 'NA',
                 'NM',
                 'PN',
                 'RP',
                 'SN',
                 'ST',
                 'TM',
                 'TN',
                 'TX',
                 'XAD',
                 'XCN',
                 'XON',
                 'XPN',
                 'XTN')),
    'HL70126': ('Quantity Limited Request',
                ('CH',
                 'LI',
                 'PG',
                 'RD',
                 'ZO')),
    'HL70127': ('llergen Type',
                ('DA',
                 'FA',
                 'MA',
                 'MC',
                 'EA',
                 'AA',
                 'PA',
                 'LA')),
    'HL70128': ('Allergy Severity',
                ('SV',
                 'MO',
                 'MI',
                 'U')),
    'HL70129': ('Accommodation Code',
                ()),
    'HL70130': ('Visit user Code ',
                ('TE',
                 'HO',
                 'MO',
                 'PH')),
    'HL70131': ('Contact Role',
                ('E',
                 'C',
                 'F',
                 'I',
                 'N',
                 'S',
                 'O',
                 'U')),
    'HL70132': ('Transaction Code',
                ()),
    'HL70135': ('Assignment of Benefits',
                ('Y',
                 'N',
                 'M')),
    'HL70136': ('Yes/no Indicator',
                ('Y',
                 'N')),
    'HL70137': ('Mail Claim Party',
                ('E',
                 'G',
                 'I',
                 'O',
                 'P')),
    'HL70139': ('Employer Information Data',
                ()),
    'HL70140': ('Military Service ',
                ('USA',
                 'USN',
                 'USAF',
                 'USMC',
                 'USCG',
                 'USPHS',
                 'NOAA',
                 'NATO',
                 'AUSA',
                 'AUSN',
                 'AUSAF')),
    'HL70141': ('Military Rank/Grade',
                ('E1... E9',
                 'O1 ... O9',
                 'W1 ... W4')),
    'HL70142': ('Military Status ',
                ('ACT',
                 'RET',
                 'DEC')),
    'HL70143': ('Non-covered Insurance Code',
                ()),
    'HL70144': ('Eligibility Source',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7')),
    'HL70145': ('Room Type',
                ('PRI',
                 '2PRI',
                 'SPR',
                 '2SPR',
                 'ICU',
                 '2ICU')),
    'HL70146': ('Amount Type',
                ('DF',
                 'LM',
                 'PC',
                 'RT',
                 'UL')),
    'HL70147': ('Policy Type',
                ('ANC',
                 '2ANC',
                 'MMD',
                 '2MMD',
                 '3MMD')),
    'HL70148': ('Money or Percentage Indicator',
                ('AT',
                 'PC')),
    'HL70149': ('Day Type',
                ('AP',
                 'DE',
                 'PE')),
    'HL70150': ('Certification Patient Type',
                ('ER',
                 'IPE',
                 'OPE',
                 'UR')),
    'HL70151': ('Second Opinion Status',
                ()),
    'HL70152': ('Second Opinion Documentation Received',
                ()),
    'HL70153': ('Value Code',
                ()),
    'HL70155': ('Accept/Application Acknowledgment Conditions',
                ('AL',
                 'NE',
                 'ER',
                 'SU')),
    'HL70159': ('Diet Code Specification Type',
                ('D',
                 'S',
                 'P')),
    'HL70160': ('Tray Type',
                ('EARLY',
                 'LATE',
                 'GUEST',
                 'NO',
                 'MSG')),
    'HL70161': ('Allow Substitution',
                ('N',
                 'G',
                 'T')),
    'HL70162': ('Route of Administration',
                ('AP',
                 'B',
                 'DT',
                 'EP',
                 'ET',
                 'GTT',
                 'GU',
                 'IMR',
                 'IA',
                 'IB',
                 'IC',
                 'ICV',
                 'ID',
                 'IH',
                 'IHA',
                 'IM',
                 'IN',
                 'IO',
                 'IP',
                 'IS',
                 'IT',
                 'IU',
                 'IV',
                 'MTH',
                 'MM',
                 'NS',
                 'NG',
                 'NP',
                 'NT',
                 'OP',
                 'OT',
                 'OTH',
                 'PF',
                 'PO',
                 'PR',
                 'RM',
                 'SD',
                 'SC',
                 'SL',
                 'TP',
                 'TRA',
                 'TD',
                 'TL',
                 'UR',
                 'VG',
                 'VM',
                 'WND')),
    'HL70163': ('Body Site',
                ('BE',
                 'OU',
                 'BN',
                 'BU',
                 'CT',
                 'LA',
                 'LAC',
                 'LACF',
                 'LD',
                 'LE',
                 'LEJ',
                 'OS',
                 'LF',
                 'LG',
                 'LH',
                 'LIJ',
                 'LLAQ',
                 'LLFA',
                 'LMFA',
                 'LN',
                 'LPC',
                 'LSC',
                 'LT',
                 'LUA',
                 'LUAQ',
                 'LUFA',
                 'LVG',
                 'LVL',
                 'NB',
                 'PA',
                 'PERIN',
                 'RA',
                 'RAC',
                 'RACF',
                 'RD',
                 'RE',
                 'REJ',
                 'OD',
                 'RF',
                 'RG',
                 'RH',
                 'RIJ',
                 'RLAQ',
                 'RLFA',
                 'RMFA',
                 'RN',
                 'RPC',
                 'RSC',
                 'RT',
                 'RUA',
                 'RUAQ',
                 'RUFA',
                 'RVL',
                 'RVG')),
    'HL70164': ('Administration Device',
                ('AP',
                 'BT',
                 'HL',
                 'IPPB',
                 'IVP',
                 'IVS',
                 'MI',
                 'NEB',
                 'PCA')),
    'HL70165': ('Administration Method',
                ('CH',
                 'DI',
                 'DU',
                 'IF',
                 'IS',
                 'IR',
                 'IVPB',
                 'IVP',
                 'NB',
                 'PT',
                 'PF',
                 'SH',
                 'SO',
                 'WA',
                 'WI')),
    'HL70166': ('RX Component Type',
                ('B',
                 'A')),
    'HL70167': ('Substitution Status',
                ('N',
                 'G',
                 'T',
                 '0',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '7',
                 '8')),
    'HL70168': ('Processing Priority',
                ('S',
                 'A',
                 'R',
                 'P',
                 'T',
                 'C',
                 'B')),
    'HL70169': ('Reporting Priority',
                ('C',
                 'R')),
    'HL70170': ('Derived Specimen',
                ('P',
                 'C',
                 'N')),
    'HL70171': ('Citizenship',
                ()),
    'HL70172': ('Veterans Military Status',
                ()),
    'HL70173': ('Coordination of Benefits',
                ('CO',
                 'IN')),
    'HL70174': ('Nature of Service/Test/Observation',
                ('P',
                 'F',
                 'A',
                 'S',
                 'C')),
    'HL70175': ('Master File Identifier Code',
                ('CDM',
                 'CMA',
                 'CMB',
                 'LOC',
                 'OMA',
                 'OMB',
                 'OMC',
                 'OMD',
                 'PRA',
                 'STF',
                 'CLN',
                 'OME',
                 'INV')),
    'HL70177': ('Confidentiality Code',
                ('V',
                 'R',
                 'U',
                 'EMP',
                 'UWM',
                 'VIP',
                 'PSY',
                 'AID',
                 'HIV',
                 'ETH')),
    'HL70178': ('File Level Event Code',
                ('REP',
                 'UPD')),
    'HL70179': ('Response Level',
                ('NE',
                 'ER',
                 'AL',
                 'SU')),
    'HL70180': ('Record-level Event Code',
                ('MAD',
                 'MDL',
                 'MUP',
                 'MDC',
                 'MAC')),
    'HL70181': ('MFN Record-level Error Return',
                ('S',
                 'U')),
    'HL70182': ('Staff Type',
                ()),
    'HL70183': ('Active/Inactive',
                ('A',
                 'I')),
    'HL70184': ('Department',
                ()),
    'HL70185': ('Preferred Method of Contact',
                ('B',
                 'C',
                 'E',
                 'F',
                 'H',
                 'O')),
    'HL70186': ('Practitioner Category',
                ()),
    'HL70187': ('Provider Billing',
                ('I',
                 'P')),
    'HL70188': ('Operator ID',
                ()),
    'HL70189': ('Ethnic Group',
                ('H',
                 'N',
                 'U')),
    'HL70190': ('Address Type',
                ('BA',
                 'BI',
                 'N',
                 'BDL',
                 'F',
                 'C',
                 'B',
                 'H',
                 'L',
                 'M',
                 'O',
                 'P',
                 'RH',
                 'BR',
                 'S',
                 'SH',
                 'TM',
                 'V')),
    'HL70191': ('Type of Referenced Data',
                ('AP',
                 'AU',
                 'FT',
                 'IM',
                 'multipart',
                 'NS',
                 'SD',
                 'SI',
                 'TEXT',
                 'TX')),
    'HL70193': ('Amount Class',
                ('AT',
                 'LM',
                 'PC',
                 'UL')),
    'HL70200': ('Name Type',
                ('A',
                 'B',
                 'BAD',
                 'C',
                 'D',
                 'F',
                 'I',
                 'K',
                 'L',
                 'M',
                 'MSK',
                 'N',
                 'NAV',
                 'NB',
                 'NOUSE',
                 'P',
                 'R',
                 'REL',
                 'S',
                 'T',
                 'TEMP',
                 'U')),
    'HL70201': ('Telecommunication Use Code',
                ('PRN',
                 'ORN',
                 'WPN',
                 'VHN',
                 'ASN',
                 'EMR',
                 'NET',
                 'BPN',
                 'PRS')),
    'HL70202': ('Telecommunication Equipment Type',
                ('PH',
                 'FX',
                 'MD',
                 'CP',
                 'SAT',
                 'BP',
                 'Internet',
                 'X.400',
                 'TDD',
                 'TTY')),
    'HL70203': ('Identifier Type',
                ('ACSN',
                 'AM',
                 'AMA',
                 'AN',
                 'ANON',
                 'ANC',
                 'AND',
                 'ANT',
                 'APRN',
                 'ASID',
                 'BA',
                 'BC',
                 'BCT',
                 'BR',
                 'BRN',
                 'BSNR',
                 'CC',
                 'CONM',
                 'CZ',
                 'CY',
                 'DDS',
                 'DEA',
                 'DI',
                 'DFN',
                 'DL',
                 'DN',
                 'DO',
                 'DP',
                 'DPM',
                 'DR',
                 'DS',
                 'EI',
                 'EN',
                 'ESN',
                 'FI',
                 'GI',
                 'GL',
                 'GN',
                 'HC',
                 'JHN',
                 'IND',
                 'LACSN',
                 'LANR ',
                 'LI',
                 'LN',
                 'LR',
                 'MA',
                 'MB',
                 'MC',
                 'MCD',
                 'MCN',
                 'MCR',
                 'MCT',
                 'MD',
                 'MI',
                 'MR',
                 'MRT',
                 'MS',
                 'NBSNR',
                 'NCT',
                 'NE',
                 'NH',
                 'NI',
                 'NII',
                 'NIIP',
                 'NNxxx',
                 'NP',
                 'NPI',
                 'OD',
                 'PA',
                 'PC',
                 'PCN',
                 'PE',
                 'PEN',
                 'PI',
                 'PN',
                 'PNT',
                 'PPIN',
                 'PPN',
                 'PRC',
                 'PRN',
                 'PT',
                 'QA',
                 'RI',
                 'RPH',
                 'RN',
                 'RR',
                 'RRI',
                 'RRP',
                 'SID',
                 'SL',
                 'SN',
                 'SP',
                 'SR',
                 'SS',
                 'TAX',
                 'TN',
                 'TPR',
                 'U',
                 'UPIN',
                 'USID',
                 'VN',
                 'VP',
                 'VS',
                 'WC',
                 'WCN',
                 'WP',
                 'XX')),
    'HL70204': ('Organizational Name Type',
                ('A',
                 'L',
                 'D',
                 'SL')),
    'HL70205': ('Price Type',
                ('AP',
                 'DC',
                 'IC',
                 'PF',
                 'TF',
                 'TP',
                 'UP')),
    'HL70206': ('Segment Action Code',
                ('A',
                 'D',
                 'U',
                 'X')),
    'HL70207': ('Processing Mode',
                ('A',
                 'R',
                 'I',
                 'T',
                 'Not present')),
    'HL70208': ('Query Response Status',
                ('OK',
                 'NF',
                 'AE',
                 'AR')),
    'HL70209': ('Relational Operator',
                ('EQ',
                 'NE',
                 'LT',
                 'GT',
                 'LE',
                 'GE',
                 'CT',
                 'GN')),
    'HL70210': ('Relational Conjunction',
                ('AND',
                 'OR')),
    'HL70211': ('Alternate Character Sets',
                ('ASCII',
                 '8859/1',
                 '8859/2',
                 '8859/3',
                 '8859/4',
                 '8859/5',
                 '8859/6',
                 '8859/7',
                 '8859/8',
                 '8859/9',
                 '8859/15',
                 'ISO IR6',
                 'ISO IR14',
                 'ISO IR87',
                 'ISO IR159',
                 'GB 18030-2000',
                 'KS X 1001',
                 'CNS 11643-1992',
                 'BIG-5',
                 'UNICODE',
                 'UNICODE UTF-8')),
    'HL70212': ('Nationality',
                ()),
    'HL70213': ('Purge Status Code',
                ('P',
                 'D',
                 'I')),
    'HL70214': ('Special Program Code',
                ('CH',
                 'ES',
                 'FP',
                 'O',
                 'U')),
    'HL70215': ('Publicity Code',
                ('F',
                 'N',
                 'O',
                 'U')),
    'HL70216': ('Patient Status Code',
                ('AI',
                 'DI')),
    'HL70217': ('Visit Priority Code',
                ('1',
                 '2',
                 '3')),
    'HL70218': ('Patient Charge Adjustment',
                ()),
    'HL70219': ('Recurring Service Code',
                ()),
    'HL70220': ('Living Arrangements',
                ('A',
                 'F',
                 'I',
                 'R',
                 'U',
                 'S')),
    'HL70222': ('Contact Reason',
                ()),
    'HL70223': ('Living Dependency',
                ('S',
                 'M',
                 'C',
                 'O',
                 'U')),
    'HL70224': ('Transport Arranged',
                ('A',
                 'N',
                 'U')),
    'HL70225': ('Escort Required',
                ('R',
                 'N',
                 'U')),
    'HL70227': ('Manufacturers of Vaccines',
                ('AB',
                 'AD',
                 'ALP',
                 'AR',
                 'AVB',
                 'AVI',
                 'BA',
                 'BAH',
                 'BAY',
                 'BP',
                 'BPC',
                 'MIP',
                 'CNJ',
                 'CMP',
                 'CEN',
                 'CHI',
                 'CON',
                 'DVC',
                 'EVN',
                 'GEO',
                 'SKB',
                 'GRE',
                 'IAG',
                 'IUS',
                 'KGC',
                 'LED',
                 'MBL',
                 'MA',
                 'MED',
                 'MSD ',
                 'IM',
                 'MIL',
                 'NAB',
                 'NYB',
                 'NAV',
                 'NOV',
                 'NVX',
                 'OTC',
                 'ORT',
                 'PD',
                 'PWJ',
                 'PRX',
                 'PMC',
                 'JPN',
                 'SCL',
                 'SOL',
                 'SI',
                 'TAL',
                 'USA',
                 'VXG',
                 'WA',
                 'WAL',
                 'ZLB',
                 'OTH',
                 'UNK')),
    'HL70228': ('Diagnosis Classification',
                ('C',
                 'D',
                 'M',
                 'O',
                 'R',
                 'S',
                 'T',
                 'I')),
    'HL70229': ('DRG Payor',
                ()),
    'HL70230': ('Procedure Functional Type',
                ('A',
                 'P',
                 'I',
                 'D')),
    'HL70231': ('Student Status',
                ('F',
                 'P',
                 'N')),
    'HL70232': ('Insurance Company Contact Reason',
                ('1',
                 '2',
                 '3')),
    'HL70233': ('Non-Concur Code/Description',
                ()),
    'HL70234': ('Report Timing',
                ('CO',
                 'AD',
                 'RQ',
                 'DE',
                 'PD',
                 '3D',
                 '7D',
                 '10D',
                 '15D',
                 '30D')),
    'HL70235': ('Report Source',
                ('C',
                 'L',
                 'H',
                 'R',
                 'D',
                 'N',
                 'P',
                 'M',
                 'E',
                 'O')),
    'HL70236': ('Event Reported To',
                ('M',
                 'L',
                 'R',
                 'D')),
    'HL70237': ('Event Qualification',
                ('I',
                 'O',
                 'A',
                 'M',
                 'D',
                 'L',
                 'W',
                 'B')),
    'HL70238': ('Event Seriousness',
                ('Y',
                 'S',
                 'N')),
    'HL70239': ('Event Expected',
                ('Y',
                 'N',
                 'U')),
    'HL70240': ('Event Consequence',
                ('D',
                 'L',
                 'H',
                 'P',
                 'C',
                 'I',
                 'J',
                 'R',
                 'O')),
    'HL70241': ('Patient Outcome',
                ('D',
                 'R',
                 'N',
                 'W',
                 'S',
                 'F',
                 'U')),
    'HL70242': ('Primary Observer\'s Qualification',
                ('P',
                 'R',
                 'M',
                 'H',
                 'C',
                 'L',
                 'O')),
    'HL70243': ('Identity May Be Divulged',
                ('Y',
                 'N',
                 'NA')),
    'HL70244': ('Single Use Device',
                ()),
    'HL70245': ('Product Problem',
                ()),
    'HL70246': ('Product Available for Inspection',
                ()),
    'HL70247': ('Status of Evaluation',
                ('Y',
                 'P',
                 'K',
                 'X',
                 'A',
                 'D',
                 'C',
                 'I',
                 'U',
                 'Q',
                 'R',
                 'O')),
    'HL70248': ('Product Source',
                ('A',
                 'L',
                 'R',
                 'N')),
    'HL70249': ('Generic Product',
                ()),
    'HL70250': ('Relatedness Assessment',
                ('H',
                 'M',
                 'S',
                 'I',
                 'N')),
    'HL70251': ('Action Taken in Response to the Event',
                ('WP',
                 'WT',
                 'DR',
                 'DI',
                 'OT',
                 'N')),
    'HL70252': ('Causality Observations',
                ('AW',
                 'BE',
                 'LI',
                 'IN',
                 'EX',
                 'PL',
                 'TC',
                 'DR',
                 'SE',
                 'OE',
                 'OT')),
    'HL70253': ('Indirect Exposure Mechanism',
                ('B',
                 'P',
                 'F',
                 'X',
                 'O')),
    'HL70254': ('Kind of Quantity',
                ('CACT',
                 'CNC',
                 'CCRTO',
                 'CCNT',
                 'CFR',
                 'CRAT',
                 'CRTO',
                 'ENT',
                 'ENTSUB',
                 'ENTCAT',
                 'ENTNUM',
                 'ENTVOL',
                 'MASS',
                 'MCNC',
                 'MCRTO',
                 'MCNT',
                 'MFR',
                 'MINC',
                 'MRAT',
                 'MRTO',
                 'NUM',
                 'NCNC',
                 'NCNT',
                 'NFR',
                 'NRTO',
                 'SUB',
                 'SCNC',
                 'SCRTO',
                 'SCNT',
                 'SCNTR',
                 'SFR',
                 'SCNCIN',
                 'SRAT',
                 'SRTO',
                 'VOL',
                 'VCNT',
                 'VFR',
                 'VRAT',
                 'VRTO',
                 'ACNC',
                 'RLMCNC',
                 'RLSCNC',
                 'THRMCNC',
                 'THRSCNC',
                 'TIME',
                 'TMDF',
                 'TMSTP',
                 'TRTO',
                 'RCRLTM',
                 'RLTM',
                 'ABS',
                 'ACT',
                 'APER',
                 'ARB',
                 'AREA',
                 'ASPECT',
                 'CLAS',
                 'CNST',
                 'COEF',
                 'COLOR',
                 'CONS',
                 'DEN',
                 'DEV',
                 'DIFF',
                 'ELAS',
                 'ELPOT',
                 'ELRAT',
                 'ELRES',
                 'ENGR',
                 'EQL',
                 'FORCE',
                 'FREQ',
                 'IMP',
                 'KINV',
                 'LEN',
                 'LINC',
                 'LIQ',
                 'MGFLUX',
                 'MORPH',
                 'MOTIL',
                 'OD',
                 'OSMOL',
                 'PRID',
                 'PRES',
                 'PWR',
                 'RANGE',
                 'RATIO',
                 'RDEN',
                 'REL',
                 'SATFR',
                 'SHAPE',
                 'SMELL',
                 'SUSC',
                 'TASTE',
                 'TEMP',
                 'TEMPDF',
                 'TEMPIN',
                 'TITR',
                 'TYPE',
                 'VEL',
                 'VELRT',
                 'VISC')),
    'HL70255': ('Duration Categories',
                ('PT',
                 '*',
                 '30M',
                 '1H',
                 '2H',
                 '2.5H',
                 '3H',
                 '4H',
                 '5H',
                 '6H',
                 '7H',
                 '8H',
                 '12H',
                 '24H',
                 '2D',
                 '3D',
                 '4D',
                 '5D',
                 '6D',
                 '1W',
                 '2W',
                 '3W',
                 '4W',
                 '1L',
                 '2L',
                 '3L')),
    'HL70256': ('Time Delay Post Challenge',
                ('BS',
                 'PEAK',
                 'TROUGH',
                 'RANDOM',
                 '1M',
                 '2M',
                 '3M',
                 '4M',
                 '5M',
                 '6M',
                 '7M',
                 '8M',
                 '9M',
                 '10M',
                 '15M',
                 '20M',
                 '25M',
                 '30M',
                 '1H',
                 '2H',
                 '2.5H',
                 '3H',
                 '4H',
                 '5H',
                 '6H',
                 '7H',
                 '8H',
                 '8H SHIFT',
                 '12H',
                 '24H',
                 '2D',
                 '3D',
                 '4D',
                 '5D',
                 '6D',
                 '7D',
                 '1W',
                 '10D',
                 '2W',
                 '3W',
                 '4W',
                 '1L',
                 '2L',
                 '3L')),
    'HL70257': ('Nature of Challenge',
                ('CFST',
                 'EXCZ',
                 'FFST')),
    'HL70258': ('Relationship Modifier',
                ('CONTROL',
                 'PATIENT',
                 'DONOR',
                 'BPU')),
    'HL70259': ('Modality',
                ('AS',
                 'BS',
                 'CD',
                 'CP',
                 'CR',
                 'CS',
                 'CT',
                 'DD',
                 'DG',
                 'DM',
                 'EC',
                 'ES',
                 'FA',
                 'FS',
                 'LP',
                 'LS',
                 'MA',
                 'MS',
                 'NM',
                 'OT',
                 'PT',
                 'RF',
                 'ST',
                 'TG',
                 'US',
                 'XA')),
    'HL70260': ('Patient Location Type',
                ('N',
                 'R',
                 'B',
                 'E',
                 'O',
                 'C',
                 'D',
                 'L')),
    'HL70261': ('Location Equipment',
                ('OXY',
                 'SUC',
                 'VIT',
                 'INF',
                 'IVP',
                 'EEG',
                 'EKG',
                 'VEN')),
    'HL70262': ('Privacy Level',
                ('F',
                 'P',
                 'J',
                 'Q',
                 'S',
                 'W')),
    'HL70263': ('Level of Care',
                ('A',
                 'E',
                 'F',
                 'N',
                 'C',
                 'R',
                 'S')),
    'HL70264': ('Location Department',
                ()),
    'HL70265': ('Specialty Type',
                ('AMB',
                 'PSY',
                 'PPS',
                 'REH',
                 'PRE',
                 'ISO',
                 'OBG',
                 'PIN',
                 'INT',
                 'SUR',
                 'PSI',
                 'EDI',
                 'CAR',
                 'NBI',
                 'CCR',
                 'PED',
                 'EMR',
                 'OBS',
                 'WIC',
                 'PHY',
                 'ALC',
                 'FPC',
                 'CHI',
                 'CAN',
                 'NAT',
                 'OTH')),
    'HL70267': ('Days of the Week',
                ('SAT',
                 'SUN',
                 'MON',
                 'TUE',
                 'WED',
                 'THU',
                 'FRI')),
    'HL70268': ('Override',
                ('X',
                 'A',
                 'R')),
    'HL70269': ('Charge On Indicator',
                ('O',
                 'R')),
    'HL70270': ('Document Type',
                ('AR',
                 'CD',
                 'CN',
                 'DI',
                 'DS',
                 'ED',
                 'HP',
                 'OP',
                 'PC',
                 'PH',
                 'PN',
                 'PR',
                 'SP',
                 'TS')),
    'HL70271': ('Document Completion Status',
                ('DI',
                 'DO',
                 'IP',
                 'IN',
                 'PA',
                 'AU',
                 'LA')),
    'HL70272': ('Document Confidentiality Status',
                ('V',
                 'R',
                 'U')),
    'HL70273': ('Document Availability Status',
                ('AV',
                 'CA',
                 'OB',
                 'UN')),
    'HL70275': ('Document Storage Status',
                ('AC',
                 'AA',
                 'AR',
                 'PU')),
    'HL70276': ('Appointment Reason Codes',
                ('ROUTINE',
                 'WALKIN',
                 'CHECKUP',
                 'FOLLOWUP',
                 'EMERGENCY')),
    'HL70277': ('Appointment Type Codes',
                ('Normal',
                 'Tentative',
                 'Complete')),
    'HL70278': ('Filler Status Code',
                ('Pending',
                 'Waitlist',
                 'Booked',
                 'Started',
                 'Complete',
                 'Cancelled',
                 'Dc',
                 'Deleted',
                 'Blocked',
                 'Overbook',
                 'Noshow')),
    'HL70279': ('Allow Substitutions Code',
                ('No',
                 'Confirm',
                 'Notify',
                 'Yes')),
    'HL70280': ('Referral Priority',
                ('S',
                 'A',
                 'R')),
    'HL70281': ('Referral Type',
                ('Lab',
                 'Rad',
                 'Med',
                 'Skn',
                 'Psy',
                 'Hom')),
    'HL70282': ('Referral Disposition',
                ('WR',
                 'RP',
                 'AM',
                 'SO')),
    'HL70283': ('Referral Status',
                ('A',
                 'P',
                 'R',
                 'E')),
    'HL70284': ('Referral Category',
                ('I',
                 'O',
                 'A',
                 'E')),
    'HL70285': ('Insurance Company ID Codes',
                ()),
    'HL70286': ('Provider Role',
                ('RP',
                 'PP',
                 'CP',
                 'RT')),
    'HL70287': ('Problem/Goal Action Code',
                ('AD',
                 'CO',
                 'DE',
                 'LI',
                 'UC',
                 'UN',
                 'UP')),
    'HL70288': ('Census Tract',
                ()),
    'HL70289': ('County/Parish',
                ()),
    'HL70291': ('Subtype of Referenced Data',
                ('...',
                 'x-hl7-cda-level-one')),
    'HL70292': ('Vaccines Administered (code = CVX)',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35',
                 '36',
                 '37',
                 '38',
                 '39',
                 '40',
                 '41',
                 '42',
                 '43',
                 '44',
                 '45',
                 '46',
                 '47',
                 '48',
                 '49',
                 '50',
                 '51',
                 '52',
                 '53',
                 '54',
                 '55',
                 '56',
                 '57',
                 '58',
                 '59',
                 '60',
                 '61',
                 '62',
                 '63',
                 '64',
                 '65',
                 '66',
                 '67',
                 '68',
                 '69',
                 '70',
                 '71',
                 '72',
                 '73',
                 '74',
                 '75',
                 '76',
                 '77',
                 '78',
                 '79',
                 '80',
                 '81',
                 '82',
                 '83',
                 '84',
                 '85',
                 '86',
                 '87',
                 '88',
                 '89',
                 '90',
                 '91',
                 '92',
                 '93',
                 '94',
                 '95',
                 '96',
                 '97',
                 '98',
                 '99',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '105',
                 '106',
                 '107',
                 '108',
                 '109',
                 '110',
                 '111',
                 '112',
                 '113',
                 '114',
                 '115',
                 '116',
                 '117',
                 '118',
                 '119',
                 '120',
                 '121',
                 '122',
                 '998',
                 '999')),
    'HL70293': ('Billing Category',
                ()),
    'HL70294': ('Time Selection Criteria Parameter Class Codes',
                ('Prefstart',
                 'Prefend',
                 'Mon',
                 'Tue',
                 'Wed',
                 'Thu',
                 'Fri',
                 'Sat',
                 'Sun')),
    'HL70295': ('Handicap',
                ()),
    'HL70296': ('Primary Language',
                ()),
    'HL70297': ('CN ID Source',
                ()),
    'HL70298': ('CP Range Type',
                ('P',
                 'F')),
    'HL70299': ('Encoding',
                ('A',
                 'Hex',
                 'Base64')),
    'HL70300': ('Namespace ID',
                ()),
    'HL70301': ('Universal ID Type',
                ('DNS',
                 'EUI64',
                 'CLIA',
                 'CLIP',
                 'GUID',
                 'HCD',
                 'HL7',
                 'ISO',
                 'L,M,N',
                 'Random',
                 'URI',
                 'UUID',
                 'x400',
                 'x500')),
    'HL70302': ('Point of Care',
                ()),
    'HL70303': ('Room',
                ()),
    'HL70304': ('Bed',
                ()),
    'HL70305': ('Person Location Type',
                ('C',
                 'D',
                 'H',
                 'N',
                 'O',
                 'P',
                 'S')),
    'HL70306': ('Location Status',
                ()),
    'HL70307': ('Building',
                ()),
    'HL70308': ('Floor',
                ()),
    'HL70309': ('Coverage Type',
                ('H',
                 'P',
                 'B',
                 'RX')),
    'HL70311': ('Job Status',
                ('P',
                 'T',
                 'O',
                 'U')),
    'HL70312': ('Policy Scope',
                ()),
    'HL70313': ('Policy Source',
                ()),
    'HL70315': ('Living Will Code',
                ('Y',
                 'F',
                 'N',
                 'I',
                 'U')),
    'HL70316': ('Organ Donor Code',
                ('Y',
                 'F',
                 'N',
                 'I',
                 'R',
                 'P',
                 'U')),
    'HL70317': ('Annotations',
                ('9900',
                 '9901',
                 '9902',
                 '9903',
                 '9904')),
    'HL70319': ('Department Cost Center',
                ()),
    'HL70320': ('Item Natural Account Code',
                ()),
    'HL70321': ('Dispense Method',
                ('TR',
                 'UD',
                 'F',
                 'AD')),
    'HL70322': ('Completion Status',
                ('CP',
                 'RE',
                 'NA',
                 'PA')),
    'HL70324': ('Location Characteristic ID',
                ('SMK',
                 'LIC',
                 'IMP',
                 'SHA',
                 'INF',
                 'PRL',
                 'LCR',
                 'OVR',
                 'STF',
                 'SET',
                 'GEN',
                 'TEA')),
    'HL70325': ('Location Relationship ID',
                ('RX',
                 'RX2',
                 'LAB',
                 'LB2',
                 'DTY',
                 'ALI',
                 'PAR')),
    'HL70326': ('Visit Indicator',
                ('A ',
                 'V')),
    'HL70327': ('Job Code',
                ()),
    'HL70328': ('Employee Classification',
                ()),
    'HL70329': ('Quantity Method',
                ('A',
                 'E')),
    'HL70330': ('Marketing Basis',
                ('510K',
                 '510E',
                 'PMA',
                 'PRE',
                 'TXN',
                 '522S')),
    'HL70331': ('Facility Type',
                ('U',
                 'M',
                 'D',
                 'A')),
    'HL70332': ('Source Type',
                ('I',
                 'A')),
    'HL70333': ('Driver\u2019s License Issuing Authority',
                ()),
    'HL70334': ('Disabled Person Code',
                ('PT',
                 'GT',
                 'IN',
                 'AP')),
    'HL70335': ('epeat Pattern',
                ('Q<integer>S',
                 'Q<integer>M',
                 'Q<integer>H',
                 'Q<integer>D',
                 'Q<integer>W',
                 'Q<integer>L',
                 'Q<integer>J<day#>',
                 'BID',
                 'TID',
                 'QID',
                 'xID',
                 'QAM',
                 'QSHIFT',
                 'QOD',
                 'QHS',
                 'QPM',
                 'C',
                 'U <spec>',
                 'PRN',
                 'PRNxxx',
                 'Once',
                 'Meal Related Timings',
                 'A',
                 'P',
                 'I',
                 'M',
                 'D',
                 'V')),
    'HL70336': ('Referral Reason',
                ('S',
                 'P',
                 'O',
                 'W')),
    'HL70337': ('Certification Status',
                ('C',
                 'E')),
    'HL70338': ('Practitioner ID Number Type',
                ('CY',
                 'DEA',
                 'GL',
                 'LI',
                 'L&I',
                 'MCD',
                 'MCR',
                 'QA',
                 'SL',
                 'TAX',
                 'TRL',
                 'UPIN')),
    'HL70339': ('Advanced Beneficiary Notice Code',
                ('1',
                 '2',
                 '3',
                 '4')),
    'HL70340': ('Procedure Code Modifier',
                ('CPTM',
                 'HPC')),
    'HL70341': ('Guarantor Credit Rating Code',
                ()),
    'HL70342': ('Military Recipient',
                ()),
    'HL70343': ('Military Handicapped Program Code',
                ()),
    'HL70344': ('Patient\u2019s Relationship to Insured',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19')),
    'HL70345': ('Appeal Reason',
                ()),
    'HL70346': ('Certification Agency',
                ()),
    'HL70347': ('State/Province',
                ('AB',
                 'MI')),
    'HL70350': ('Occurrence Code',
                ()),
    'HL70351': ('Occurrence Span',
                ()),
    'HL70353': ('CWE Statuses',
                ('U',
                 'UASK',
                 'NAV',
                 'NA',
                 'NASK')),
    'HL70354': ('Message Structure',
                ('ACK',
                 'ADR_A19',
                 'ADT_A01',
                 'ADT_A02',
                 'ADT_A03',
                 'ADT_A05',
                 'ADT_A06',
                 'ADT_A09',
                 'ADT_A12',
                 'ADT_A15',
                 'ADT_A16',
                 'ADT_A17',
                 'ADT_A18',
                 'ADT_A20',
                 'ADT_A21',
                 'ADT_A24',
                 'ADT_A30',
                 'ADT_A37',
                 'ADT_A38',
                 'ADT_A39',
                 'ADT_A43',
                 'ADT_A44',
                 'ADT_A45',
                 'ADT_A50',
                 'ADT_A52',
                 'ADT_A54',
                 'ADT_A60',
                 'ADT_A61',
                 'BAR_P01',
                 'BAR_P02',
                 'BAR_P05',
                 'BAR_P06',
                 'BAR_P10',
                 'BAR_P12',
                 'BPS_O29',
                 'BRP_O30',
                 'BRT_O32',
                 'BTS_O31',
                 'CCF_I22',
                 'CCI_I22',
                 'CCM_I21',
                 'CCQ_I19',
                 'CCR_I16',
                 'CCU_I20',
                 'CQU_I19',
                 'CRM_C01',
                 'CSU_C09',
                 'DFT_P03',
                 'DFT_P11',
                 'DOC_T12',
                 'EAC_U07',
                 'EAN_U09',
                 'EAR_U08',
                 'EHC_E01',
                 'EHC_E02',
                 'EHC_E04',
                 'EHC_E10',
                 'EHC_E12',
                 'EHC_E13',
                 'EHC_E15',
                 'EHC_E20',
                 'EHC_E21',
                 'EHC_E24',
                 'ESR_U02',
                 'ESU_U01',
                 'INR_U06',
                 'INU_U05',
                 'LSU_U12',
                 'MDM_T01',
                 'MDM_T02',
                 'MFK_M01',
                 'MFN_M01',
                 'MFN_M02',
                 'MFN_M03',
                 'MFN_M04',
                 'MFN_M05',
                 'MFN_M06',
                 'MFN_M07',
                 'MFN_M08',
                 'MFN_M09',
                 'MFN_M10',
                 'MFN_M11',
                 'MFN_M12',
                 'MFN_M13',
                 'MFN_M15',
                 'MFN_M16',
                 'MFN_M17',
                 'MFQ_M01',
                 'MFR_M01',
                 'MFR_M04',
                 'MFR_M05',
                 'MFR_M06',
                 'MFR_M07',
                 'NMD_N02',
                 'NMQ_N01',
                 'NMR_N01',
                 'OMB_O27',
                 'OMD_O03',
                 'OMG_O19',
                 'OMI_O23',
                 'OML_O21',
                 'OML_O33',
                 'OML_O35',
                 'OML_O39',
                 'OMN_O07',
                 'OMQ_O42',
                 'OMP_O09',
                 'OMS_O05',
                 'OPL_O37',
                 'OPR_O38',
                 'OPU_R25',
                 'ORA_R33',
                 'ORB_O28',
                 'ORD_O04',
                 'ORF_R04',
                 'ORG_O20',
                 'ORI_O24',
                 'ORL_O22',
                 'ORL_O34',
                 'ORL_O36',
                 'ORL_O40',
                 'ORM_O01',
                 'ORN_O08',
                 'ORP_O10',
                 'ORR_O02',
                 'ORS_O06',
                 'ORU_R01',
                 'ORU_R30',
                 'ORX_O43',
                 'OSM_R26',
                 'OSQ_Q06',
                 'OSR_Q06',
                 'OSU_O41',
                 'OUL_R21',
                 'OUL_R22',
                 'OUL_R23',
                 'OUL_R24',
                 'PEX_P07',
                 'PGL_PC6',
                 'PMU_B01',
                 'PMU_B03',
                 'PMU_B04',
                 'PMU_B07',
                 'PMU_B08',
                 'PPG_PCG',
                 'PPP_PCB',
                 'PPR_PC1',
                 'PPT_PCL',
                 'PPV_PCA',
                 'PRR_PC5',
                 'PTR_PCF',
                 'QBP_E03',
                 'QBP_E22',
                 'QBP_Q11',
                 'QBP_Q13',
                 'QBP_Q15',
                 'QBP_Q21',
                 'QCK_Q02',
                 'QCN_J01',
                 'QRY_A19',
                 'QRY_PC4',
                 'QRY_Q01',
                 'QRY_Q02',
                 'QRY_R02',
                 'QRY_T12',
                 'QSB_Q16',
                 'QVR_Q17',
                 'RAR_RAR',
                 'RAS_O17',
                 'RCI_I05',
                 'RCL_I06',
                 'RDE_O11',
                 'RDR_RDR',
                 'RDS_O13',
                 'RDY_K15',
                 'REF_I12',
                 'RER_RER',
                 'RGR_RGR',
                 'RGV_O15',
                 'ROR_ROR',
                 'RPA_I08',
                 'RPI_I01',
                 'RPI_I04',
                 'RPL_I02',
                 'RPR_I03',
                 'RQA_I08',
                 'RQC_I05',
                 'RQI_I01',
                 'RQP_I04',
                 'RRA_O18',
                 'RRD_O14',
                 'RRE_O12',
                 'RRG_O16',
                 'RRI_I12',
                 'RSP_E03',
                 'RSP_E22',
                 'RSP_K11',
                 'RSP_K21',
                 'RSP_K22',
                 'RSP_K23',
                 'RSP_K25',
                 'RSP_K31',
                 'RSP_K32',
                 'RSP_Q11',
                 'RTB_K13',
                 'SDR_S31',
                 'SDR_S32',
                 'SIU_S12',
                 'SLR_S28',
                 'SQM_S25',
                 'SQR_S25',
                 'SRM_S01',
                 'SRR_S01',
                 'SSR_U04',
                 'SSU_U03',
                 'STC_S33',
                 'SUR_P09',
                 'TCU_U10',
                 'UDM_Q05',
                 'VXQ_V01',
                 'VXR_V03',
                 'VXU_V04',
                 'VXX_V02',
                 'ORU_W01',
                 'QRF_W02')),
    'HL70355': ('Primary Key Value Type ',
                ('PL',
                 'CE',
                 'CWE')),
    'HL70356': ('Alternate Character Set Handling Scheme',
                ('ISO 2022-1994',
                 '2.3',
                 '<null>')),
    'HL70357': ('Message Error Condition Codes',
                ('0',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '200',
                 '201',
                 '202',
                 '203',
                 '204',
                 '205',
                 '206',
                 '207')),
    'HL70358': ('Practitioner Group',
                ()),
    'HL70359': ('Diagnosis Priority',
                ('0',
                 '1',
                 '2',
                 '\u2026')),
    'HL70360': ('Degree/License/Certificate',
                ('PN',
                 'AAS',
                 'AA',
                 'ABA',
                 'AE',
                 'AS',
                 'BA',
                 'BBA',
                 'BE',
                 'BFA',
                 'BN',
                 'BS',
                 'BSL',
                 'BSN',
                 'BT',
                 'CER',
                 'CANP',
                 'CMA',
                 'CNP',
                 'CNM',
                 'CRN',
                 'CNS',
                 'CPNP',
                 'CTR',
                 'DIP',
                 'DBA',
                 'DED',
                 'PharmD',
                 'PHE',
                 'PHD',
                 'PHS',
                 'MD',
                 'DO',
                 'EMT',
                 'EMTP',
                 'FPNP',
                 'HS',
                 'JD',
                 'MA',
                 'MBA',
                 'MCE',
                 'MDI',
                 'MED',
                 'MEE',
                 'ME',
                 'MFA',
                 'MME',
                 'MS',
                 'MSL',
                 'MSN',
                 'MTH',
                 'MDA',
                 'MT',
                 'NG',
                 'NP',
                 'PA',
                 'RMA',
                 'RN',
                 'RPH',
                 'SEC',
                 'TS')),
    'HL70361': ('Application',
                ()),
    'HL70362': ('Facility',
                ()),
    'HL70363': ('Assigning Authority',
                ()),
    'HL70364': ('Comment Type',
                ('PI',
                 'AI',
                 'GI',
                 '1R',
                 '2R',
                 'GR',
                 'RE',
                 'DR')),
    'HL70365': ('Equipment State',
                ('PU',
                 'IN',
                 'ID',
                 'CO',
                 'OP',
                 'CL',
                 'PA',
                 'PD',
                 'ES',
                 'TS',
                 'SS',
                 'SD',
                 'DI',
                 'MA',
                 '...')),
    'HL70366': ('Local/Remote Control State',
                ('L',
                 'R',
                 '...')),
    'HL70367': ('Alert Level',
                ('N',
                 'W',
                 'S',
                 'C',
                 '...')),
    'HL70368': ('Remote Control Command',
                ('SA',
                 'LO',
                 'UN',
                 'LK',
                 'UC',
                 'TT',
                 'CN',
                 'IN',
                 'SU',
                 'CL',
                 'PA',
                 'RE',
                 'ES',
                 'LC',
                 'RC',
                 'AB',
                 'EN',
                 'DI',
                 'EX',
                 'AF',
                 'AT')),
    'HL70369': ('Specimen Role',
                ('B',
                 'C',
                 'E',
                 'F',
                 'G',
                 'L',
                 'O',
                 'P',
                 'Q',
                 'R',
                 'V')),
    'HL70370': ('Container Status',
                ('I',
                 'P',
                 'O',
                 'R',
                 'L',
                 'M',
                 'X',
                 'U')),
    'HL70371': ('Additive/Preservative',
                ('F10',
                 'C32',
                 'C38',
                 'HCL6',
                 'ACDA',
                 'ACDB',
                 'ACET',
                 'AMIES',
                 'HEPA',
                 'BACTM',
                 'BOR',
                 'BOUIN',
                 'BF10',
                 'WEST',
                 'BSKM',
                 'CARS',
                 'CARY',
                 'CHLTM',
                 'CTAD',
                 'ENT',
                 'ENT+',
                 'JKM',
                 'KARN',
                 'LIA',
                 'HEPL',
                 'M4',
                 'M4RT',
                 'M5',
                 'MICHTM',
                 'MMDTM',
                 'HNO3',
                 'NONE',
                 'PAGE',
                 'PHENOL',
                 'KOX',
                 'EDTK',
                 'EDTK15',
                 'EDTK75',
                 'PVA',
                 'RLM',
                 'SST',
                 'SILICA',
                 'NAF',
                 'FL100',
                 'FL10',
                 'NAPS',
                 'HEPN',
                 'EDTN',
                 'SPS',
                 'STUTM',
                 'THROM',
                 'FDP',
                 'THYMOL',
                 'THYO',
                 'TOLU',
                 'URETM',
                 'VIRTM')),
    'HL70372': ('Specimen Component',
                ('SUP',
                 'SED',
                 'BLD',
                 'BSEP',
                 'PRP',
                 'PPP',
                 'SER',
                 'PLAS')),
    'HL70373': ('Treatment',
                ('LDLP',
                 'RECA',
                 'DEFB',
                 'ACID',
                 'NEUT',
                 'ALK',
                 'FILT',
                 'UFIL')),
    'HL70374': ('System Induced Contaminants',
                ('CNTM',)),
    'HL70375': ('Artificial Blood',
                ('SFHB',
                 'FLUR')),
    'HL70376': ('Special Handling Code',
                ('C37',
                 'AMB',
                 'CAMB ',
                 'REF',
                 'CREF ',
                 'FRZ',
                 'CFRZ',
                 'DFRZ',
                 'UFRZ',
                 'NTR',
                 'PRTL',
                 'CATM ',
                 'DRY',
                 'PSO',
                 'PSA',
                 'UPR',
                 'MTLF')),
    'HL70377': ('Other Environmental Factors',
                ('ATM',
                 'A60')),
    'HL70378': ('Carrier Type',
                ()),
    'HL70379': ('Tray Type',
                ()),
    'HL70380': ('Separator Type',
                ()),
    'HL70381': ('Cap Type',
                ()),
    'HL70382': ('Drug Interference',
                ()),
    'HL70383': ('Substance Status',
                ('EW',
                 'EE',
                 'CW',
                 'CE',
                 'QW',
                 'QE',
                 'NW',
                 'NE',
                 'OW',
                 'OE',
                 'OK')),
    'HL70384': ('Substance Type',
                ('SR',
                 'MR',
                 'DI',
                 'PT',
                 'RC',
                 'CO',
                 'PW',
                 'LW',
                 'SW',
                 'SC',
                 'LI',
                 'OT')),
    'HL70385': ('Manufacturer Identifier',
                ()),
    'HL70386': ('Supplier Identifier',
                ()),
    'HL70387': ('Command Response',
                ('OK',
                 'TI',
                 'ER',
                 'ST',
                 'UN')),
    'HL70388': ('Processing Type',
                ('P',
                 'E')),
    'HL70389': ('Analyte Repeat Status',
                ('O',
                 'R',
                 'D',
                 'F')),
    'HL70391': ('Segment Group',
                ('ADMINISTRATION',
                 'ALLERGY',
                 'APP_STATS',
                 'APP_STATUS',
                 'ASSOCIATED_PERSON',
                 'ASSOCIATED_RX_ADMIN',
                 'ASSOCIATED_RX_ORDER',
                 'AUTHORIZATION',
                 'AUTHORIZATION_CONTACT',
                 'CERTIFICATE',
                 'CLOCK',
                 'CLOCK_AND_STATISTICS',
                 'CLOCK_AND_STATS_WITH_NOTES',
                 'CLOCK_AND_STATS_WITH_NOTES_ALT',
                 'COMMAND',
                 'COMMAND_RESPONSE',
                 'COMMON_ORDER',
                 'COMPONENT',
                 'COMPONENTS',
                 'CONTAINER',
                 'DEFINITION',
                 'DIET',
                 'DISPENSE',
                 'ENCODED_ORDER',
                 'ENCODING',
                 'EXPERIENCE',
                 'FINANCIAL',
                 'FINANCIAL_COMMON_ORDER',
                 'FINANCIAL_INSURANCE',
                 'FINANCIAL_OBSERVATION',
                 'FINANCIAL_ORDER',
                 'FINANCIAL_PROCEDURE',
                 'FINANCIAL_TIMING_QUANTITY',
                 'GENERAL_RESOURCE',
                 'GIVE',
                 'GOAL',
                 'GOAL_OBSERVATION',
                 'GOAL_PATHWAY',
                 'GOAL_ROLE',
                 'GUARANTOR_INSURANCE',
                 'INSURANCE',
                 'LOCATION_RESOURCE',
                 'MERGE_INFO',
                 'MF',
                 'MF_CDM',
                 'MF_CLIN_STUDY',
                 'MF_CLIN_STUDY_SCHED',
                 'MF_INV_ITEM',
                 'MF_LOC_DEPT',
                 'MF_LOCATION',
                 'MF_OBS_ATTRIBUTES',
                 'MF_PHASE_SCHED_DETAIL',
                 'MF_QUERY',
                 'MF_SITE_DEFINED',
                 'MF_STAFF',
                 'MF_TEST',
                 'MF_TEST_BATT_DETAIL',
                 'MF_TEST_BATTERIES',
                 'MF_TEST_CALC_DETAIL',
                 'MF_TEST_CALCULATED',
                 'MF_TEST_CAT_DETAIL',
                 'MF_TEST_CATEGORICAL',
                 'MF_TEST_NUMERIC',
                 'NK1_TIMING_QTY',
                 'NOTIFICATION',
                 'OBSERVATION',
                 'OBSERVATION_PRIOR',
                 'OBSERVATION_REQUEST',
                 'OMSERVATION',
                 'ORDER',
                 'ORDER_CHOICE',
                 'ORDER_DETAIL',
                 'ORDER_DETAIL_SUPPLEMENT',
                 'ORDER_DIET',
                 'ORDER_ENCODED',
                 'ORDER_OBSERVATION',
                 'ORDER_PRIOR',
                 'ORDER_TRAY',
                 'PATHWAY',
                 'PATHWAY_ROLE',
                 'PATIENT',
                 'PATIENT_PRIOR',
                 'PATIENT_RESULT',
                 'PATIENT_VISIT',
                 'PATIENT_VISIT_PRIOR',
                 'PERSONNEL_RESOURCE',
                 'PEX_CAUSE',
                 'PEX_OBSERVATION',
                 'PRIOR_RESULT',
                 'PROBLEM',
                 'PROBLEM_OBSERVATION',
                 'PROBLEM_PATHWAY',
                 'PROBLEM_ROLE',
                 'PROCEDURE',
                 'PRODUCT',
                 'PRODUCT_STATUS',
                 'PROVIDER',
                 'PROVIDER_CONTACT',
                 'QBP',
                 'QRY_WITH_DETAIL',
                 'QUERY_RESPONSE',
                 'QUERY_RESULT_CLUSTER',
                 'REQUEST',
                 'RESOURCE',
                 'RESOURCES',
                 'RESPONSE',
                 'RESULT',
                 'RESULTS',
                 'RESULTS_NOTES',
                 'ROW_DEFINITION',
                 'RX_ADMINISTRATION',
                 'RX_ORDER',
                 'SCHEDULE',
                 'SERVICE',
                 'SPECIMEN',
                 'SPECIMEN_CONTAINER',
                 'STAFF',
                 'STUDY',
                 'STUDY_OBSERVATION',
                 'STUDY_PHASE',
                 'STUDY_SCHEDULE',
                 'TEST_CONFIGURATION',
                 'TIMING',
                 'TIMING_DIET',
                 'TIMING_ENCODED',
                 'TIMING_GIVE',
                 'TIMING_PRIOR',
                 'TIMING_QTY',
                 'TIMING_QUANTITY',
                 'TIMING_TRAY',
                 'TREATMENT',
                 'VISIT')),
    'HL70392': ('Match Reason',
                ('DB',
                 'NA',
                 'NP',
                 'SS')),
    'HL70393': ('Match Algorithms',
                ('LINKSOFT_2.01',
                 'MATCHWARE_1.2')),
    'HL70394': ('Response Modality',
                ('R',
                 'T',
                 'B')),
    'HL70395': ('Modify Indicator',
                ('N',
                 'M')),
    'HL70396': ('Coding System',
                ('L',
                 '99zzz',
                 'ACR',
                 'ALPHAID2006',
                 'ALPHAID2007',
                 'ALPHAID2008',
                 'ALPHAID2009',
                 'ALPHAID2010',
                 'ALPHAID2011',
                 'ART',
                 'ANS+',
                 'AS4',
                 'AS4E',
                 'ATC',
                 'C4',
                 'CAPECC',
                 'CAS',
                 'CCC',
                 'CD2',
                 'CDCA',
                 'CDCEDACUITY',
                 'CDCM',
                 'CDCOBS',
                 'CDCPHINVS',
                 'CDCREC',
                 'CDS',
                 'CE (obsolete)',
                 'CLP',
                 'CPTM',
                 'CST',
                 'CVX',
                 'DCM',
                 'E',
                 'E5',
                 'E6',
                 'E7',
                 'ENZC',
                 'EPASRS',
                 'FDAUNII',
                 'FDDC',
                 'FDDX',
                 'FDK',
                 'FIPS5_2',
                 'FIPS6_4',
                 'GDRG2004',
                 'GDRG2005',
                 'GDRG2006',
                 'GDRG2007',
                 'GDRG2008',
                 'GDRG2009',
                 'GMDC2004',
                 'GMDC2005',
                 'GMDC2006',
                 'GMDC2007',
                 'GMDC2008',
                 'GMDC2009',
                 'HB',
                 'HCPCS',
                 'HCPT',
                 'HHC',
                 'HI',
                 'HL7nnnn',
                 'HOT',
                 'HPC',
                 'I10',
                 'I10G2004',
                 'I10G2005',
                 'I10G2006',
                 'I10P',
                 'I9',
                 'I9C',
                 'I9CDX',
                 'I9CP',
                 'IBT',
                 'IBTnnnn',
                 'IC2',
                 'ICD10GM2007',
                 'ICD10GM2008',
                 'ICD10GM2009',
                 'ICD10GM2010',
                 'ICD10GM2011',
                 'ICD10AM',
                 'ICD10CA',
                 'ICDO',
                 'ICDO2',
                 'ICDO3',
                 'ICS',
                 'ICSD',
                 'ISOnnnn (deprecated)',
                 'ISO',
                 'ISO3166_1',
                 'ISO3166_2',
                 'ISO4217',
                 'ISO639',
                 'ITIS',
                 'IUPP',
                 'IUPC',
                 'JC8',
                 'JC10',
                 'JJ1017',
                 'LB',
                 'LN',
                 'MCD',
                 'MCR',
                 'MDC',
                 'MDDX',
                 'MEDC',
                 'MEDR',
                 'MEDX',
                 'MGPI',
                 'MVX',
                 'NAICS',
                 'NCPDPnnnnsss',
                 'NDA',
                 'NDC',
                 'NDFRT',
                 'NIC',
                 'NIP001',
                 'NIP002',
                 'NIP004',
                 'NIP007',
                 'NIP008',
                 'NIP009',
                 'NIP010',
                 'NND',
                 'NPI',
                 'NUBC',
                 'NULLFL',
                 'OHA',
                 'O301',
                 'O3012004',
                 'O3012005',
                 'O3012006',
                 'OPS2007',
                 'OPS2008',
                 'OPS2009',
                 'OPS2010',
                 'OPS2011',
                 'PHINQUESTION',
                 'PLR',
                 'PLT',
                 'POS',
                 'RC',
                 'RXNORM',
                 'SCT',
                 'SCT2',
                 'SDM',
                 'SIC',
                 'SNM',
                 'SNM3',
                 'SNT',
                 'SOC',
                 'UB04FL14',
                 'UB04FL15',
                 'UB04FL17',
                 'UB04FL31',
                 'UB04FL35',
                 'UB04FL39',
                 'UC',
                 'UCUM',
                 'UMD',
                 'UML',
                 'UPC',
                 'UPIN',
                 'USPS',
                 'W1',
                 'W2',
                 'W4',
                 'WC',
                 'X12Dennnn')),
    'HL70397': ('Sequencing',
                ('A',
                 'AN',
                 'D',
                 'DN',
                 'N')),
    'HL70398': ('Continuation Style Code',
                ('F',
                 'I')),
    'HL70401': ('Government Reimbursement Program',
                ('MM',
                 'C')),
    'HL70402': ('School Type',
                ('D',
                 'G',
                 'M',
                 'U')),
    'HL70403': ('Language Ability',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70404': ('Language Proficiency',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6')),
    'HL70405': ('Organization Unit',
                ()),
    'HL70406': ('Organization Unit Type',
                ('H',
                 'O',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70409': ('Application Change Type',
                ('SU',
                 'SD',
                 'M')),
    'HL70411': ('Supplemental Service Information Values',
                ()),
    'HL70412': ('Category Identifier',
                ()),
    'HL70413': ('Consent Identifier',
                ()),
    'HL70414': ('Units of Time',
                ()),
    'HL70415': ('DRG Transfer Type',
                ('N',
                 'E')),
    'HL70416': ('rocedure DRG Type',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70417': ('Tissue Type Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '0',
                 'B',
                 'C',
                 'G')),
    'HL70418': ('Procedure Priority',
                ('0',
                 '1',
                 '2',
                 '\u2026')),
    'HL70421': ('Severity of Illness Code',
                ('MI',
                 'MO',
                 'SE')),
    'HL70422': ('Triage Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '99')),
    'HL70423': ('Case Category Code',
                ('D',)),
    'HL70424': ('Gestation Category Code',
                ('1',
                 '2',
                 '3')),
    'HL70425': ('Newborn Code',
                ('5',
                 '3',
                 '1',
                 '4',
                 '2')),
    'HL70426': ('Blood Product Code',
                ('CRYO',
                 'CRYOP',
                 'FFP',
                 'FFPTH',
                 'PC',
                 'PCA',
                 'PCNEO',
                 'PCW',
                 'PLT',
                 'PLTNEO',
                 'PLTP',
                 'PLTPH',
                 'PLTPHLR',
                 'RWB',
                 'WBA')),
    'HL70427': ('Risk Management Incident Code',
                ('B',
                 'C',
                 'D',
                 'E',
                 'F',
                 'H',
                 'I',
                 'J',
                 'K',
                 'P',
                 'R',
                 'S',
                 'T',
                 'O')),
    'HL70428': ('Incident Type Code',
                ('P',
                 'U',
                 'O')),
    'HL70429': ('Production Class Code',
                ('BR',
                 'DA',
                 'DR',
                 'DU',
                 'LY',
                 'MT',
                 'OT',
                 'PL',
                 'RA',
                 'SH',
                 'NA',
                 'U')),
    'HL70430': ('Mode of Arrival Code',
                ('A',
                 'C',
                 'F',
                 'H',
                 'P',
                 'O',
                 'U')),
    'HL70431': ('Recreational Drug use Code',
                ('A',
                 'K',
                 'M',
                 'T',
                 'C',
                 'O',
                 'U')),
    'HL70432': ('Admission level of Care Code',
                ('AC',
                 'CH',
                 'CO',
                 'CR',
                 'IM',
                 'MO')),
    'HL70433': ('Precaution Code',
                ('A',
                 'B',
                 'C',
                 'D',
                 'I',
                 'N',
                 'P',
                 'O',
                 'U')),
    'HL70434': ('Patient Condition Code',
                ('A',
                 'C',
                 'P',
                 'S',
                 'O',
                 'U')),
    'HL70435': ('Advance Directive Code',
                ('DNR',
                 'N')),
    'HL70436': ('Sensitivity to Causative Agent Code',
                ('AD',
                 'AL',
                 'CT',
                 'IN',
                 'SE')),
    'HL70437': ('Alert Device Code',
                ('B',
                 'N',
                 'W')),
    'HL70438': ('Allergy Clinical Status ',
                ('U',
                 'P',
                 'S',
                 'C',
                 'I',
                 'E',
                 'D')),
    'HL70440': ('Data types',
                ('AD',
                 'AUI',
                 'CCD',
                 'CCP',
                 'CD',
                 'CE',
                 'CF',
                 'CK',
                 'CM',
                 'CN',
                 'CNE',
                 'CNN',
                 'CP',
                 'CQ',
                 'CSU',
                 'CWE',
                 'CX',
                 'DDI',
                 'DIN',
                 'DLD',
                 'DLN',
                 'DLT',
                 'DR',
                 'DT',
                 'DTM',
                 'DTN',
                 'ED',
                 'EI',
                 'EIP',
                 'ELD',
                 'ERL',
                 'FC',
                 'FN',
                 'FT',
                 'GTS',
                 'HD',
                 'ICD',
                 'ID',
                 'IS',
                 'JCC',
                 'LA1',
                 'LA2',
                 'MA',
                 'MO',
                 'MOC',
                 'MOP',
                 'MSG',
                 'NA',
                 'NDL',
                 'NM',
                 'NR',
                 'OCD',
                 'OSD',
                 'OSP',
                 'PIP',
                 'PL',
                 'PLN',
                 'PN',
                 'PPN',
                 'PRL',
                 'PT',
                 'PTA',
                 'QIP',
                 'QSC',
                 'RCD',
                 'RFR',
                 'RI',
                 'RMC',
                 'RP',
                 'RPT',
                 'SAD',
                 'SCV',
                 'SI',
                 'SN',
                 'SNM',
                 'SPD',
                 'SPS',
                 'SRT',
                 'ST',
                 'TM',
                 'TN',
                 'TQ',
                 'TS',
                 'TX',
                 'UVC',
                 'VH',
                 'VID',
                 'VR',
                 'WVI',
                 'WVS',
                 'XAD',
                 'XCN',
                 'XON',
                 'XPN',
                 'XTN')),
    'HL70441': ('Immunization Registry Status ',
                ('A',
                 'I',
                 'L',
                 'M',
                 'P',
                 'O',
                 'U')),
    'HL70442': ('Location Service Code',
                ('D',
                 'T',
                 'P',
                 'E')),
    'HL70443': ('Provider Role',
                ('AD',
                 'AP',
                 'AT',
                 'CLP',
                 'CP',
                 'DP',
                 'EP',
                 'FHCP',
                 'IP',
                 'MDIR',
                 'OP',
                 'PH',
                 'PP',
                 'RO',
                 'RP',
                 'RT',
                 'TR',
                 'PI',
                 'AI',
                 'TN',
                 'VP',
                 'VPS',
                 'VTS')),
    'HL70444': ('Name Assembly Order',
                ('G',
                 'F')),
    'HL70445': ('Identity Reliability Code',
                ('US',
                 'UD',
                 'UA',
                 'AL')),
    'HL70446': ('Species Code',
                ()),
    'HL70447': ('Breed Code',
                ()),
    'HL70448': ('Name Context',
                ()),
    'HL70450': ('Event Type',
                ('LOG',
                 'SER')),
    'HL70451': ('Substance Identifier',
                ()),
    'HL70452': ('Health Care Provider Type Code',
                ('SUGGESTION',)),
    'HL70453': ('Health Care Provider Classification',
                ('SUGGESTION',)),
    'HL70454': ('Health Care Provider Area of Specialization',
                ('SUGGESTION',)),
    'HL70455': ('Type of Bill Code',
                ()),
    'HL70456': ('Revenue code',
                ()),
    'HL70457': ('Overall Claim Disposition Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70458': ('OCE Edit Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35',
                 '36',
                 '37',
                 '38',
                 '39',
                 '40',
                 '41',
                 '42')),
    'HL70459': ('Reimbursement Action Code',
                ('0',
                 '1',
                 '2',
                 '3')),
    'HL70460': ('Denial or Rejection Code',
                ('0',
                 '1',
                 '2')),
    'HL70461': ('License Number',
                ()),
    'HL70462': ('Location Cost Center',
                ()),
    'HL70463': ('Inventory Number',
                ()),
    'HL70464': ('Facility ID',
                ()),
    'HL70465': ('Name/Address Representation',
                ('I',
                 'A',
                 'P')),
    'HL70466': ('Ambulatory Payment Classification Code',
                ('31',
                 '163',
                 '181',
                 '...')),
    'HL70467': ('Modifier Edit Code',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 'U')),
    'HL70468': ('Payment Adjustment Code',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70469': ('Packaging Status Code',
                ('0',
                 '1',
                 '2')),
    'HL70470': ('Reimbursement Type Code',
                ('OPPS',
                 'Pckg',
                 'Lab',
                 'Thrpy',
                 'DME',
                 'EPO',
                 'Mamm',
                 'PartH',
                 'Crnl',
                 'NoPay')),
    'HL70471': ('Query Name',
                ()),
    'HL70472': ('TQ Conjunction ID',
                ('S',
                 'A',
                 'C')),
    'HL70473': ('Formulary Status',
                ('G',
                 'N',
                 'R',
                 'Y')),
    'HL70474': ('Organization Unit Type',
                ('D',
                 'F',
                 'U',
                 'S',
                 'V')),
    'HL70475': ('Charge Type Reason',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70476': ('Medically Necessary Duplicate Procedure Reason',
                ()),
    'HL70477': ('Controlled Substance Schedule',
                ('I',
                 'II',
                 'III',
                 'IV',
                 'V',
                 'VI')),
    'HL70478': ('Formulary Status',
                ('Y',
                 'N',
                 'R',
                 'G')),
    'HL70479': ('Pharmaceutical Substances',
                ()),
    'HL70480': ('Pharmacy Order Types',
                ('M',
                 'S',
                 'O')),
    'HL70482': ('Order Type',
                ('I',
                 'O')),
    'HL70483': ('Authorization Mode',
                ('EL',
                 'EM',
                 'FX',
                 'IP',
                 'MA',
                 'PA',
                 'PH',
                 'RE',
                 'VC',
                 'VO')),
    'HL70484': ('Dispense Type',
                ('B',
                 'C',
                 'N',
                 'P',
                 'Q',
                 'R',
                 'S',
                 'T',
                 'Z')),
    'HL70485': ('Extended Priority Codes',
                ('S',
                 'A',
                 'R',
                 'P',
                 'C',
                 'T',
                 'TS<integer>',
                 'TM<integer>',
                 'TH<integer>',
                 'TD<integer>',
                 'TW<integer>',
                 'TL<integer>',
                 'PRN')),
    'HL70487': ('Specimen Type',
                ('ABS',
                 'PELVA',
                 'PERIA',
                 'RECTA',
                 'SCROA',
                 'SUBMA',
                 'SUBMX',
                 'TSTES',
                 'AIRS',
                 'ALL ',
                 'AMP ',
                 'GASAN',
                 'ASP',
                 'ETA',
                 'GASA',
                 'NGASP',
                 'TASP',
                 'TTRA',
                 'AUTP',
                 'BX',
                 'GSPEC',
                 'SKBP',
                 'CONE',
                 'BITE',
                 'CBITE',
                 'DBITE',
                 'HBITE',
                 'IBITE',
                 'RBITE',
                 'BLEB',
                 'BLIST',
                 'BBL',
                 'BPU',
                 'HBLUD',
                 'CSVR',
                 'FBLOOD',
                 'MBLD',
                 'WB',
                 'BOIL',
                 'BON',
                 'BOWL',
                 'BRTH',
                 'BRSH ',
                 'EBRUSH',
                 'BRUS',
                 'GASBR',
                 'BUB',
                 'BULLA',
                 'BRN',
                 'CALC',
                 'CARBU',
                 'CAT',
                 'CSITE',
                 'CTP',
                 'ANGI',
                 'ARTC',
                 'CVPT',
                 'ETTP',
                 'FOLEY',
                 'HEMAQ',
                 'HEMO',
                 'IDC',
                 'INTRD',
                 'IVCAT',
                 'MAHUR',
                 'SCLV',
                 'SPRP',
                 'SWGZ',
                 'VASTIP',
                 'VENT',
                 'GROSH',
                 'HIC  ',
                 'PORTA',
                 'SPRPB',
                 'TLC',
                 'CLIPP',
                 'COL',
                 'CNJT',
                 'LENS1',
                 'LENS2',
                 'CYST',
                 'BCYST',
                 'ICYST',
                 'PILOC',
                 'RENALC',
                 'DIA',
                 'DISCHG',
                 'DIV',
                 'DRN',
                 'HEV',
                 'GTUBE',
                 'GASD',
                 'ILEO',
                 'JP',
                 'JEJU',
                 'NASDR',
                 'NGAST',
                 'PND',
                 'DRNGP',
                 'RECT',
                 'SUMP',
                 'DRNG',
                 'EARW',
                 'EFFUS',
                 'ELT',
                 'ATTE',
                 'AUTOA',
                 'AUTOC',
                 'EFF ',
                 'EEYE',
                 'EFOD',
                 'EISO',
                 'EOTH',
                 'ESOI',
                 'ESOS',
                 'SPS',
                 'STER',
                 'ENVIR',
                 ' WWA',
                 'DEION',
                 ' WWT',
                 'FAW',
                 'WWO',
                 'EWHI',
                 'EXUDTE',
                 'FLT',
                 'FIST',
                 'FLUID',
                 'FGA',
                 'CSMY',
                 'ACNFLD',
                 'FLU',
                 'CST',
                 'HYDC',
                 'IVFLD',
                 'JNTFLD',
                 'KIDFLD',
                 'LSAC',
                 'FLD',
                 'PCFL',
                 'RENC',
                 'FRS',
                 'SHUNF',
                 'SNV',
                 'GAST',
                 'FUR',
                 'GAS',
                 'EXG',
                 'IHG',
                 'GENV',
                 'GRAFT',
                 'GRAFTS',
                 'POPGS',
                 'POPLG',
                 'GRANU',
                 'IMP',
                 'INFIL',
                 'INS',
                 'IUD',
                 'IT',
                 'KELOI',
                 'LAVG',
                 'LAVGG',
                 'LAVGP',
                 'LAVPG',
                 'LESN',
                 'ORL',
                 'PENIL',
                 'LIQO',
                 'LIQ',
                 'MASS',
                 'SMM',
                 'MUCOS',
                 'MUCUS',
                 'NEDL',
                 'NODUL',
                 'CYN',
                 'ORH',
                 'PACEM',
                 'PLAN',
                 'PLAS',
                 'PLB',
                 'PPP',
                 'PRP',
                 'POL',
                 'PROST',
                 'PSC',
                 'PUS',
                 'PUST',
                 'PUSFR',
                 'QC3',
                 'RES',
                 'SAL',
                 'FSCLP',
                 'CSCR',
                 'SECRE',
                 'NSECR',
                 'SER',
                 'ASERU',
                 'CSERU',
                 'PLEVS',
                 'TSERU',
                 'SHUNT',
                 'EXS',
                 'SITE',
                 'CVPS',
                 'INCI',
                 'NGS',
                 'NEPH',
                 'PIS',
                 'PDSIT',
                 'PDTS',
                 'PINS',
                 'POPLV',
                 'SHU',
                 'TRAC',
                 'SKN',
                 'TZANC',
                 'GSOL',
                 'ILLEG',
                 'OTH',
                 'UDENT',
                 'USPEC',
                 'SPRM',
                 'SPT',
                 'SPTC',
                 'SPTT',
                 'DCS',
                 'SPUTIN',
                 'SPUT1',
                 'SPUTSP',
                 'STONE',
                 'STL',
                 'SUP',
                 'SUTUR',
                 'TISS',
                 'TISU',
                 'ACNE',
                 'HERNI',
                 'SCAR',
                 'TRANS',
                 'ETTUB',
                 'GT ',
                 'TUBES',
                 'IVTIP',
                 'TUMOR',
                 'DEC',
                 'UR',
                 'URT',
                 'URC',
                 'URINB',
                 'URINC',
                 'USCOP',
                 'URINM',
                 'URINN',
                 'URINP',
                 'RANDU',
                 'VITF',
                 'VOM',
                 'WRT',
                 'WASH',
                 'WASI',
                 'WAT',
                 'WEN',
                 'WICK',
                 'WORM',
                 'WND',
                 'WNDA',
                 'WNDD',
                 'WNDE',
                 'PUNCT')),
    'HL70488': ('Specimen Collection Method',
                ('FNA',
                 'PNA',
                 'BIO',
                 'BCAE',
                 'BCAN',
                 'BCPD',
                 'CAP',
                 'CATH',
                 'EPLA',
                 'ESWA',
                 'LNA',
                 'CVP',
                 'LNV',
                 'MARTL',
                 'ML11',
                 'PACE',
                 'PIN',
                 'KOFFP',
                 'MLP',
                 'NYP',
                 'TMP',
                 'ANP',
                 'BAP',
                 'PRIME',
                 'PUMP',
                 'QC5',
                 'SCLP',
                 'SCRAPS',
                 'SHA',
                 'SWA',
                 'SWD',
                 'WOOD',
                 'TMOT',
                 'TMAN',
                 'TMCH',
                 'TMM4',
                 'TMMY',
                 'TMPV',
                 'TMSC',
                 'TMUP',
                 'TMVI',
                 'VENIP')),
    'HL70489': ('Risk Codes',
                ('BIO',
                 'COR',
                 'ESC',
                 'AGG',
                 'IFL',
                 'EXP',
                 'INF',
                 'BHZ',
                 'INJ',
                 'POI',
                 'RAD')),
    'HL70490': ('Specimen Reject Reason',
                ('EX',
                 'QS',
                 'RB',
                 'RC',
                 'RD',
                 'RA',
                 'RE',
                 'RH',
                 'RI',
                 'RM',
                 'RN',
                 'RP',
                 'RR',
                 'RS')),
    'HL70491': ('Specimen Quality',
                ('E',
                 'G',
                 'F',
                 'P')),
    'HL70492': ('Specimen Appropriateness',
                ('P',
                 'A',
                 'I')),
    'HL70493': ('Specimen Condition',
                ('AUT',
                 'CLOT',
                 'CON',
                 'COOL',
                 'FROZ',
                 'HEM',
                 'LIVE',
                 'ROOM',
                 'SNR',
                 'CFU')),
    'HL70494': ('Specimen Child Role',
                ('A',
                 'C',
                 'M')),
    'HL70495': ('Body Site Modifier',
                ('ANT',
                 'BIL',
                 'DIS',
                 'EXT',
                 'LAT',
                 'L',
                 'LOW',
                 'MED',
                 'POS',
                 'PRO',
                 'LLQ',
                 'LUQ',
                 'RLQ',
                 'RUQ',
                 'R',
                 'UPP')),
    'HL70496': ('Consent Type',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9',
                 '10',
                 '11',
                 '12',
                 '13',
                 '14',
                 '15',
                 '16',
                 '17',
                 '18',
                 '19',
                 '20',
                 '21',
                 '22',
                 '23',
                 '24',
                 '25',
                 '26',
                 '27',
                 '28',
                 '29',
                 '30',
                 '31',
                 '32',
                 '33',
                 '34',
                 '35',
                 '36',
                 '37',
                 '38',
                 '39',
                 '40',
                 '41',
                 '42',
                 '43',
                 '44',
                 '45',
                 '46',
                 '47',
                 '48',
                 '49',
                 '50',
                 '51',
                 '52',
                 '53',
                 '54',
                 '55',
                 '56',
                 '57',
                 '58',
                 '59',
                 '60',
                 '61',
                 '62',
                 '63',
                 '64',
                 '65',
                 '66',
                 '67',
                 '68',
                 '69',
                 '70',
                 '71',
                 '72',
                 '73',
                 '74',
                 '75',
                 '76',
                 '77',
                 '78',
                 '79',
                 '80',
                 '81',
                 '82',
                 '83',
                 '84',
                 '85',
                 '86',
                 '87',
                 '88',
                 '89',
                 '90',
                 '91',
                 '92',
                 '93',
                 '94',
                 '95',
                 '96',
                 '97',
                 '98',
                 '99',
                 '100',
                 '101',
                 '102',
                 '103',
                 '104',
                 '105',
                 '106',
                 '107',
                 '108',
                 '109',
                 '110',
                 '111',
                 '112',
                 '113',
                 '114',
                 '115',
                 '116',
                 '117',
                 '118',
                 '119',
                 '120',
                 '121',
                 '122',
                 '123',
                 '124',
                 '125',
                 '126',
                 '127',
                 '128',
                 '129',
                 '130',
                 '131',
                 '132',
                 '133',
                 '134',
                 '135',
                 '136',
                 '1137')),
    'HL70497': ('Consent Mode',
                ('V',
                 'W',
                 'T')),
    'HL70498': ('Consent Status',
                ('A',
                 'L',
                 'R',
                 'P',
                 'X',
                 'B')),
    'HL70499': ('Consent Bypass Reason',
                ('E',
                 'PJ')),
    'HL70500': ('Consent Disclosure Level',
                ('F',
                 'P',
                 'N')),
    'HL70501': ('Consent Non-Disclosure Reason',
                ('E',
                 'RX',
                 'PR')),
    'HL70502': ('Non-Subject Consenter Reason',
                ('MIN',
                 'NC',
                 'LM')),
    'HL70503': ('Sequence/Results Flag',
                ('S',
                 'C',
                 'R')),
    'HL70504': ('Sequence Condition Code',
                ('EE',
                 'ES',
                 'SS',
                 'SE')),
    'HL70505': ('Cyclic Entry/Exit Indicator',
                ('*',
                 '#')),
    'HL70506': ('Service Request Relationship',
                ('N',
                 'C',
                 'T',
                 'E',
                 'S')),
    'HL70507': ('Observation Result Handling',
                ('F',
                 'N',
                 'A')),
    'HL70508': ('Blood Product Processing Requirements',
                ('LR',
                 'IR',
                 'CS',
                 'FR',
                 'AU',
                 'DI',
                 'HL',
                 'CM',
                 'HB',
                 'WA',
                 'IG')),
    'HL70509': ('Indication for Use',
                ()),
    'HL70510': ('Blood Product Dispense Status',
                ('RI',
                 'RD',
                 'RS',
                 'RE',
                 'DS',
                 'RA',
                 'RL',
                 'WA',
                 'PT',
                 'CR',
                 'RQ')),
    'HL70511': ('BP Observation Status Codes Interpretation',
                ('C',
                 'D',
                 'F',
                 'O',
                 'P',
                 'W')),
    'HL70512': ('Commercial Product',
                ()),
    'HL70513': ('Blood Product Transfusion/Disposition Status',
                ('RA',
                 'RL',
                 'WA',
                 'TX',
                 'TR')),
    'HL70514': ('Transfusion Adverse Reaction',
                ('ABOINC',
                 'ACUTHEHTR',
                 'ALLERGIC1',
                 'ALLERGIC2',
                 'ALLERGICR ',
                 'ANAPHYLAC',
                 'BACTCONTAM',
                 'DELAYEDHTR',
                 'DELAYEDSTR',
                 'GVHD',
                 'HYPOTENS',
                 'NONHTR1',
                 'NONHTR2',
                 'NONHTRREC',
                 'NONIMMUNE',
                 'NONSPEC',
                 'NORXN',
                 'PTP',
                 'VOLOVER')),
    'HL70515': ('Transfusion Interrupted Reason',
                ()),
    'HL70516': ('Error Severity',
                ('W',
                 'I',
                 'E',
                 'F')),
    'HL70517': ('Inform Person Code',
                ('PAT',
                 'NPAT',
                 'USR',
                 'HD')),
    'HL70518': ('Override Type',
                ('EXTN',
                 'INLV',
                 'EQV')),
    'HL70519': ('Override Reason',
                ()),
    'HL70520': ('Message Waiting Priority',
                ('H',
                 'M',
                 'L')),
    'HL70521': ('Override Code',
                ()),
    'HL70523': ('Computation Type',
                ('%',
                 'a')),
    'HL70525': ('Privilege',
                ()),
    'HL70526': ('Privilege Class',
                ()),
    'HL70527': ('Calendar Alignment',
                ('MY',
                 'WY',
                 'DM',
                 'DY',
                 'DW',
                 'HD',
                 'NH',
                 'SN')),
    'HL70528': ('Event Related Period',
                ('HS',
                 'AC',
                 'PC',
                 'IC',
                 'ACM',
                 'ACD',
                 'ACV',
                 'PCM',
                 'PCD',
                 'PCV',
                 'ICM',
                 'ICD',
                 'ICV')),
    'HL70530': ('Organization, Agency, Department',
                ('AE',
                 'DEA',
                 'DOD',
                 'MC',
                 'VA',
                 'VI')),
    'HL70531': ('Institution',
                ()),
    'HL70532': ('Expanded Yes/No Indicator',
                ('Y',
                 'N',
                 'NI',
                 'NA',
                 'UNK',
                 'NASK',
                 'ASKU',
                 'NAV',
                 'NP')),
    'HL70533': ('Application Error Code',
                ()),
    'HL70534': ('Notify Clergy Code ',
                ('Y',
                 'N',
                 'L',
                 'O',
                 'U')),
    'HL70535': ('Signature Code',
                ('C',
                 'S',
                 'M',
                 'P')),
    'HL70536': ('Certificate Status',
                ('P',
                 'R',
                 'V',
                 'E',
                 'I')),
    'HL70537': ('Institution',
                ()),
    'HL70538': ('Institution Relationship Type',
                ('EMP',
                 'VOL',
                 'CON',
                 'CST')),
    'HL70539': ('Cost Center Code',
                ()),
    'HL70540': ('Inactive Reason Code',
                ('L',
                 'T',
                 'R')),
    'HL70541': ('Specimen Type Modifier',
                ()),
    'HL70542': ('Specimen Source Type Modifier',
                ()),
    'HL70543': ('Specimen Collection Site',
                ()),
    'HL70544': ('Container Condition',
                ('XC37',
                 'XAMB ',
                 'XCAMB ',
                 'XREF ',
                 'XCREF ',
                 'XFRZ ',
                 'XCFRZ ',
                 'XDFRZ ',
                 'XUFRZ ',
                 'XNTR ',
                 'XPRTL ',
                 'XCATM ',
                 'XDRY',
                 'XPSO ',
                 'XPSA ',
                 'XUPR ',
                 'XMTLF ',
                 'SB',
                 'CC',
                 'CT',
                 'CL')),
    'HL70547': ('Jurisdictional Breadth',
                ('C',
                 'S',
                 'N')),
    'HL70548': ('Signatory\u2019s Relationship to Subject',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7')),
    'HL70549': ('NDC Codes',
                ()),
    'HL70550': ('Body Parts',
                ('ADB',
                 'ACET',
                 'ACHIL',
                 'ADE',
                 'ADR',
                 'AMN',
                 'AMS',
                 'ANAL',
                 'ANKL',
                 'ANTEC',
                 'ANTECF',
                 'ANTR',
                 'ANUS',
                 'AORTA',
                 'AR',
                 'AV',
                 'APDX',
                 'AREO',
                 'ARM',
                 'ARTE',
                 'ASCIT',
                 'ASCT',
                 'ATR',
                 'AURI',
                 'AXI',
                 'BACK',
                 'BARTD',
                 'BARTG',
                 'BRTGF',
                 'BPH',
                 'BID',
                 'BIFL',
                 'BLAD',
                 'BLOOD',
                 'BLDA',
                 'BLDC',
                 'BLDV',
                 'CBLD',
                 'BLD',
                 'BDY',
                 'BON',
                 'BMAR',
                 'BOWEL',
                 'BOWLA',
                 'BOWSM',
                 'BRA',
                 'BRAIN',
                 'BCYS',
                 'BRST',
                 'BRSTFL',
                 'BRO',
                 'BROCH',
                 'BRONC',
                 'BRV   ',
                 'BUCCA',
                 'BURSA',
                 'BURSF',
                 'BUTT',
                 'CALF',
                 'CANAL',
                 'CANLI',
                 'CNL',
                 'CANTH',
                 'CDM',
                 'CARO',
                 'CARP',
                 'CAVIT',
                 'CHE',
                 'CECUM',
                 'CSF',
                 'CVX',
                 'CERVUT',
                 'CHEEK',
                 'CHES',
                 'CHEST\u00a0',
                 'CHIN',
                 'CIRCU',
                 'CLAVI',
                 'CLITO',
                 'CLIT',
                 'COCCG',
                 'COCCY',
                 'COLON',
                 'COLOS',
                 'COS   ',
                 'CDUCT',
                 'CONJ',
                 'CORAL',
                 'COR',
                 'CORD',
                 'CORN',
                 'CRANE',
                 'CRANF',
                 'CRANO',
                 'CRANP',
                 'CRANS',
                 'CRANT',
                 'CUBIT',
                 'CUFF',
                 'CULD',
                 'CULDO',
                 'DELT',
                 'DENTA',
                 'DEN ',
                 'DIAF',
                 'DPH',
                 'DIGIT',
                 'DISC',
                 'DORS',
                 'DUFL',
                 'DUODE',
                 'DUR ',
                 'EAR',
                 'EARBI',
                 'EARBM',
                 'EARBS',
                 'EARLO',
                 'ELBOW',
                 'ELBOWJ',
                 'ENDC',
                 'EC',
                 'EOLPH',
                 'ENDM',
                 'ET',
                 'EUR',
                 'EOS',
                 'EPICA',
                 'EPICM',
                 'EPD ',
                 'EPIDU',
                 'EPIGL',
                 'ESOPG',
                 'ESO',
                 'ETHMO',
                 '\u00a0',
                 'EYE',
                 'BROW',
                 'EYELI',
                 'FACE',
                 'FBINC',
                 'FBLAC',
                 'FBMAX',
                 'FBNAS',
                 'FBPAL',
                 'FBVOM',
                 'FBZYG',
                 'FALLT',
                 'FEMOR',
                 'FMH',
                 'FEMUR',
                 'FET',
                 'FIBU',
                 'FING',
                 'FINGN',
                 'FOL',
                 'FOOT',
                 'FOREA',
                 'FOREH',
                 'FORES',
                 'FOURC',
                 'GB',
                 'GEN',
                 'GVU',
                 'GENC',
                 'GL',
                 'GENL',
                 'GLAND',
                 'GLANS',
                 'GLUTE',
                 'GLUT',
                 'GLUTM',
                 'GROIN',
                 'GUM',
                 'HAR',
                 'HAL',
                 'HAND',
                 'HEAD',
                 'HART',
                 'HV',
                 'HVB',
                 'HVT',
                 'HEEL',
                 'HEM',
                 'HIP',
                 'HIPJ',
                 'HUMER',
                 'HYMEN',
                 'ILC',
                 'ILE',
                 'ILEOS',
                 'ILEUM',
                 'ILIAC',
                 'ILCR',
                 'ILCON',
                 'INGUI',
                 'JUGI',
                 'INT',
                 'ICX  ',
                 'INASA',
                 'INTRU',
                 'INTRO',
                 'ISCHI',
                 'JAW',
                 'KIDN\u00a0',
                 'KNEE',
                 'KNEEF',
                 'KNEEJ',
                 'LABIA',
                 'LABMA',
                 'LABMI',
                 'LACRI',
                 'LAM',
                 'INSTL',
                 'LARYN',
                 'LEG',
                 'LENS',
                 'WBC',
                 'LING',
                 'LINGU',
                 'LIP',
                 'STOOLL',
                 'LIVER',
                 'LOBE',
                 'LOCH',
                 'ISH',
                 'LUMBA',
                 'LMN ',
                 'LUNG',
                 'LN',
                 'LNG',
                 'LYM',
                 'MAC',
                 'MALLE',
                 'MANDI',
                 'MAR',
                 'MAST',
                 'MAXIL',
                 'MAXS',
                 'MEATU',
                 'MEC',
                 'MEDST',
                 'MEDU',
                 'MOU',
                 'MPB',
                 'METAC',
                 'METAT',
                 'MILK',
                 'MITRL',
                 'MOLAR',
                 'MP',
                 'MONSU',
                 'MONSV',
                 'MOUTH',
                 'MRSA2',
                 'MYO',
                 'NAIL',
                 'NAILB',
                 'NAILF',
                 'NAILT',
                 'NARES',
                 'NASL',
                 'NSS ',
                 'NLACR',
                 'NP',
                 'NTRAC',
                 'NAVEL',
                 'NECK',
                 'NERVE',
                 'NIPPL',
                 'NOS',
                 'NOSE',
                 'NOSTR',
                 'OCCIP',
                 'OLECR',
                 'OMEN',
                 'ORBIT',
                 'ORO ',
                 'OSCOX',
                 'OVARY',
                 'PALAT',
                 'PLATH',
                 'PLATS',
                 'PALM',
                 'PANCR',
                 'PAFL',
                 'PAS   ',
                 'PARAT',
                 'PARIE',
                 'PARON',
                 'PAROT',
                 'PATEL',
                 'PELV',
                 'PENSH',
                 'PENIS',
                 'PANAL',
                 'PERI',
                 'PCARD',
                 'PCLIT',
                 'PERIH',
                 'PNEAL',
                 'PERIN',
                 'PNEPH',
                 'PNM',
                 'PORBI',
                 'PERRA',
                 'PERIS',
                 'PER',
                 'PERT',
                 'PERIT',
                 'PTONS',
                 'PERIU',
                 'PERIV',
                 'PHALA',
                 'PILO',
                 'PINNA',
                 'PLC',
                 'PLACF',
                 'PLACM',
                 'PLANT',
                 'PLEUR',
                 'PLEU',
                 'PLR',
                 'POPLI',
                 'PREAU',
                 'PRERE',
                 'PRST',
                 'PROS',
                 'PUBIC',
                 'PUL',
                 'RADI',
                 'RADIUS',
                 'RECTL',
                 'RECTU',
                 'RBC',
                 'RENL',
                 'RNP',
                 'RPERI',
                 'RIB',
                 'SACRA',
                 'SACRO',
                 'SACIL',
                 'SACRU',
                 'SALGL',
                 'SCALP',
                 'SCAPU',
                 'SCLER',
                 'SCROT',
                 'SEMN',
                 'SEM',
                 'SEPTU',
                 'SEROM',
                 'SHIN',
                 'SHOLJ',
                 'SHOL',
                 'SIGMO',
                 'SINUS',
                 'SKM',
                 'SKENE',
                 'SKULL',
                 'INSTS',
                 'SOLE',
                 'SPRM',
                 'SPHEN',
                 'SPCOR',
                 'SPLN',
                 'STER',
                 'STOM',
                 'USTOM',
                 'STOMA',
                 'STUMP',
                 'SCLV',
                 'SDP',
                 'SUB',
                 'SUBD',
                 'SGF',
                 'SUBM',
                 'SUBX',
                 'SUBME',
                 'SUBPH',
                 'SPX',
                 'SCLAV',
                 'SUPRA',
                 'SUPB',
                 'SWT',
                 'SWTG',
                 'SYNOL',
                 'SYN',
                 'SYNOV',
                 'TARS',
                 'TDUCT',
                 'TEAR',
                 'TEMPL',
                 'TEMPO',
                 'TML',
                 'TESTI',
                 'THIGH',
                 'THORA',
                 'THRB',
                 'THUMB',
                 'TNL',
                 'THM ',
                 'THYRD',
                 'TIBIA',
                 'TOE',
                 'TOEN',
                 'TONG',
                 'TONS',
                 'TOOTH',
                 'TSK',
                 'TRCHE',
                 'TBRON',
                 'TCN',
                 'ULNA',
                 'UMB',
                 'UMBL',
                 'URET',
                 'URTH',
                 'UTERI',
                 'SAC',
                 'UTER',
                 'VAGIN',
                 'VCUFF',
                 'VGV ',
                 'VAL ',
                 'VAS',
                 'VASTL',
                 'VAULT',
                 'VEIN',
                 'VENTG',
                 'VCSF',
                 'VERMI',
                 'VERTC',
                 'VERTL',
                 'VERTT',
                 'VESI',
                 'VESCL',
                 'VESFLD',
                 'VESTI',
                 'VITR',
                 'VOC',
                 'VULVA',
                 'WRIST')),
    'HL70552': ('Advanced Beneficiary Notice Override Reason',
                ()),
    'HL70553': ('Invoice Control Code',
                ('OR',
                 'CN',
                 'CG',
                 'CL',
                 'PD',
                 'RA',
                 'OA',
                 'SA',
                 'AI',
                 'PA',
                 'AA',
                 'EA',
                 'RC',
                 'CA',
                 'CP',
                 'CQ',
                 'RU')),
    'HL70554': ('Invoice Reason Codes',
                ('LATE',
                 'NORM',
                 'SUB')),
    'HL70555': ('Invoice Type',
                ('FS',
                 'SS',
                 'GP',
                 'BK',
                 'SL',
                 'IN',
                 'NP',
                 'FN',
                 'PA',
                 'SU')),
    'HL70556': ('Benefit Group',
                ('AMB',
                 'DENT')),
    'HL70557': ('Payee Type',
                ('ORG',
                 'PERS',
                 'PPER',
                 'EMPL')),
    'HL70558': ('Payee Relationship to Invoice',
                ('PT',
                 'FM',
                 'SB',
                 'GT')),
    'HL70559': ('Product/Service Line Item Status',
                ('P',
                 'D',
                 'R')),
    'HL70560': ('Quantity Units',
                ('FL',
                 'HS',
                 'DY',
                 'MN',
                 'YY')),
    'HL70561': ('Product/Services Clarification Codes',
                ('DTCTR',
                 'SEQ',
                 'DGAPP',
                 'CLCTR',
                 'ENC',
                 'OOP',
                 'GFTH')),
    'HL70562': ('Processing Consideration Codes',
                ('PAPER',
                 'EFORM',
                 'FAX',
                 'RTADJ',
                 'DFADJ',
                 'PYRDELAY')),
    'HL70564': ('Adjustment Category Code',
                ('EA',
                 'IN',
                 'PA',
                 'PR')),
    'HL70565': ('Provider Adjustment Reason Code',
                ('PST',
                 'GST',
                 'HST',
                 'DISP',
                 'MKUP')),
    'HL70566': ('Blood Unit Type',
                ('WBL',
                 'RBC',
                 'PLS',
                 'PLT',
                 'GRN',
                 'PSC',
                 'LYM')),
    'HL70567': ('Weight Units',
                ('(lb_av)',
                 '(oz_av)',
                 'kg',
                 'g')),
    'HL70568': ('Volume Units',
                ('l',
                 '(pt_us)',
                 'ml')),
    'HL70569': ('Adjustment Action',
                ('EOB',
                 'PAT',
                 'PRO')),
    'HL70570': ('Payment Method Code',
                ('CASH',
                 'CCCA',
                 'CCHK',
                 'CDAC',
                 'CHCK',
                 'DDPO',
                 'DEBC',
                 'SWFT',
                 'TRAC',
                 'VISN')),
    'HL70571': ('Invoice Processing Results Status',
                ('ACK',
                 'REJECT',
                 'PEND',
                 'ADJZER',
                 'ADJSUB',
                 'ADJ',
                 'PAID',
                 'PRED')),
    'HL70572': ('Provider Tax Status',
                ('RVAT',
                 'UVAT')),
    'HL70615': ('User Authentication Credential Type Code',
                ('KERB',
                 'SAML')),
    'HL70616': ('Address Expiration Reason',
                ('M',
                 'E',
                 'R',
                 'C')),
    'HL70617': ('Address Usage',
                ('M',
                 'V',
                 'C')),
    'HL70618': ('Protection Code',
                ('LI',
                 'UL',
                 'UP')),
    'HL70625': ('Item Status Codes',
                ('1',
                 '2',
                 '3')),
    'HL70634': ('Item Importance Codes',
                ()),
    'HL70642': ('Reorder Theory Codes',
                ('D',
                 'M',
                 'O')),
    'HL70651': ('Labor Calculation Type',
                ('TME',
                 'CST')),
    'HL70653': ('Date Format',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6')),
    'HL70657': ('Device Type',
                ('1',
                 '2',
                 '3')),
    'HL70659': ('Lot Control',
                ('1',
                 '2',
                 '3',
                 '4',
                 '5')),
    'HL70667': ('Device Data State',
                ('0',
                 '1')),
    'HL70669': ('Load Status',
                ('LLD',
                 'LCP',
                 'LCC',
                 'LCN')),
    'HL70682': ('Device Status',
                ('0',
                 '1')),
    'HL70702': ('Cycle Type',
                ('FLS',
                 'PRV',
                 'GRV',
                 'LQD',
                 'EXP',
                 'DRT',
                 'DRW',
                 'THR',
                 'ISO',
                 'BWD',
                 'LKT',
                 'WFP',
                 'SFP',
                 'CMW',
                 'PEA',
                 'EOH',
                 'EOL',
                 'CRT',
                 'UTL',
                 'IST',
                 'GLS',
                 'PLA',
                 'ANR',
                 'GTL',
                 'OPW',
                 'BDP',
                 'TRB',
                 'GNP',
                 'COD',
                 'RNS',
                 '2RS',
                 'DEC')),
    'HL70717': ('Access Restriction Value',
                ('ALL',
                 'DEM',
                 'LOC',
                 'PID-7',
                 'PID-17',
                 'HIV',
                 'STD',
                 'PSY',
                 'DRG',
                 'SMD',
                 'NO',
                 'OO',
                 'OI')),
    'HL70719': ('Access Restriction Reason',
                ('PAT',
                 'PHY',
                 'REG',
                 'ORG',
                 'EMP',
                 'DIA',
                 'VIP')),
    'HL70725': ('Mood Codes',
                ('INT',
                 'APT',
                 'ARQ',
                 'PRMS',
                 'PRP',
                 'RQO',
                 'EVN',
                 'EVN.CRT',
                 'EXP')),
    'HL70728': ('CCL Value',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70731': ('DRG Diagnosis Determination Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70734': ('Grouper Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4',
                 '5',
                 '6',
                 '7',
                 '8',
                 '9')),
    'HL70739': ('DRG Status Patient',
                ('1',
                 '2',
                 '3')),
    'HL70742': ('DRG Status Financial Calculation',
                ('0',
                 '1',
                 '3',
                 '4',
                 '5',
                 '10',
                 '11')),
    'HL70749': ('DRG Grouping Status',
                ('0',
                 '1',
                 '2',
                 '3')),
    'HL70755': ('DRG Status Weight At Birth',
                ('0',
                 '1',
                 '2')),
    'HL70757': ('Status Respiration Minutes',
                ('0',
                 '1',
                 '2')),
    'HL70759': ('Status Admission',
                ('0',
                 '1',
                 '2',
                 '3')),
    'HL70761': ('RG Procedure Determination Status',
                ('0',
                 '1',
                 '2',
                 '3',
                 '4')),
    'HL70763': ('DRG Procedure Relevance',
                ('0',
                 '1',
                 '2')),
    'HL70771': ('Resource Type or Category',
                ()),
    'HL70776': ('Item Status',
                ('A',
                 'P',
                 'I')),
    'HL70778': ('Item Type',
                ('EQP',
                 'SUP',
                 'IMP',
                 'MED',
                 'TDC')),
    'HL70790': ('Approving Regulatory Agency',
                ('FDA',
                 'AMA')),
    'HL70793': ('Ruling Act',
                ('SMDA',)),
    'HL70806': ('Sterilization Type',
                ('EOG',
                 'PCA',
                 'STM')),
    'HL70809': ('Maintenance Cycle ',
                ()),
    'HL70811': ('Maintenance Type ',
                ()),
    'HL70818': ('Package ',
                ('CS',
                 'BX',
                 'EA',
                 'SET')),
    'HL70834': ('Mime Types',
                ('application',
                 'audio',
                 'image',
                 'model',
                 'text',
                 'video',
                 'multipart')),
    'HL70836': ('Problem Severity',
                ()),
    'HL70838': ('Problem Perspective',
                ()),
    'HL70865': ('Referral Documentation Completion Status',
                ()),
    'HL70868': ('Telecommunication Expiration Reason',
                ('M',
                 'E',
                 'R',
                 'C',
                 'N')),
    'HL70871': ('Supply Risk Codes',
                ('COR',
                 'FLA',
                 'EXP',
                 'INJ',
                 'TOX',
                 'RAD',
                 'UNK')),
    'HL70879': ('Product/Service Code',
                ()),
    'HL70880': ('Product/Service Code Modifier',
                ()),
    'HL70881': ('Role Executing Physician',
                ('T',
                 'P',
                 'B')),
    'HL70882': ('Medical Role Executing Physician',
                ('E',
                 'SE')),
    'HL70894': ('Side of Body',
                ('L',
                 'R')),
    'HL70895': ('Present On Admission (POA) Indicator',
                ('Y',
                 'N',
                 'U',
                 'W',
                 'E')),
    'HL70904': ('Security Check Scheme',
                ('BCV',
                 'CCS',
                 'VID')),
    'HL70905': ('Shipment Status',
                ('ONH',
                 'INV',
                 'PRC',
                 'REJ',
                 'TTL',
                 'TRN')),
    'HL70906': ('Shipment Priority',
                ('A',
                 'CR',
                 'CS',
                 'CSP',
                 'CSR',
                 'EL',
                 'EM',
                 'P',
                 'PRN',
                 'R',
                 'RR',
                 'S',
                 'T',
                 'UD',
                 'UR')),
    'HL70907': ('Shipment Confidentiality',
                ('B',
                 'D',
                 'I',
                 'L',
                 'N',
                 'R',
                 'V',
                 'ETH',
                 'HIV',
                 'PSY',
                 'SDV',
                 'C',
                 'S',
                 'T')),
    'HL70908': ('Package Type',
                ()),
    'HL70909': ('Patient Results Release Categorization Scheme',
                ('STBD',
                 'SIMM',
                 'SWNL',
                 'SID',
                 'SIDC',
                 'SWTH')),
    'HL70910': ('Acquisition Modality',
                ()),
    'HL70912': ('articipation',
                ('AAP',
                 'AC',
                 'AD',
                 'AI',
                 'AP',
                 'ARI',
                 'AT',
                 'AUT',
                 'CP',
                 'DP',
                 'EP',
                 'EQUIP',
                 'FHCP',
                 'MDIR',
                 'OP',
                 'PB',
                 'PH',
                 'PI',
                 'PO',
                 'POMD',
                 'PP',
                 'PRI',
                 'RCT',
                 'RO',
                 'RP',
                 'RT',
                 'SB',
                 'SC',
                 'TN',
                 'TR',
                 'VP',
                 'VPS',
                 'VTS',
                 'WAY',
                 'WAYR')),
    'HL70913': ('ISO-4217 Monetary Denomination Code',
                ()),
    'HL70914': ('Root Cause ',
                ('AP',
                 'IM',
                 'L',
                 'NA',
                 'PD')),
    'HL70915': ('Process Control Code',
                ()),
    'HL70916': ('Relevant Clinical Information',
                ('F',
                 'NF',
                 'NG')),
    'HL70917': ('Bolus Type',
                ('C',
                 'L')),
    'HL70918': ('PCA Type',
                ('C',
                 'P',
                 'PC')),
    'HL70919': ('Exclusive Test',
                ('Y',
                 'N',
                 'D')),
    'HL70920': ('Preferred Specimen/Attribute Status',
                ('P',
                 'A')),
    'HL70921': ('Certification Type Code',
                ('ADM',
                 'SERV',
                 'PROC')),
    'HL70922': ('Certification Category Code',
                ('IR',
                 'RA',
                 'RE')),
    'HL70923': ('Process Interruption',
                ('NIN',
                 'WOT',
                 'ABR')),
    'HL70924': ('Cumulative Dosage Limit UoM',
                ('A',
                 'D',
                 'M',
                 'O',
                 'PL',
                 'WK')),
    'HL70925': ('Phlebotomy Issue',
                ('INF',
                 'VSM',
                 'COL',
                 'MIS',
                 'NAD',
                 'PFL',
                 'CLT',
                 'DND',
                 'DBG',
                 'DAK',
                 'DMT',
                 'IPF',
                 'ACN')),
    'HL70926': ('Phlebotomy Status',
                ('SUC',
                 'NDR',
                 'UL5')),
    'HL70927': ('Arm Stick',
                ('L',
                 'R',
                 'B')),
    'HL70929': ('Weight Units',
                ('(lb_av)',
                 '(oz_av)',
                 'kg',
                 'g')),
    'HL70930': ('Volume Units',
                ('l',
                 '(pt_us)',
                 'ml')),
    'HL70931': ('Transport Temperature Units',
                ('degF',
                 'Cel')),
    'HL70932': ('Donation Duration Units',
                ('min',
                 's')),
    'HL70933': ('Intended Procedure Type',
                ('WBL',
                 '2RC',
                 'PLS',
                 'PLT',
                 'PNP',
                 'PNR',
                 'PPR',
                 'GRN',
                 'HEM',
                 'HPC',
                 'LYM',
                 'THA',
                 'THW')),
    'HL70934': ('Order Workflow Profile',
                ())}
