# -*- coding: utf-8 -*-
#
# Copyright (c) 2012-2018, CRS4
#
# Permission is hereby granted, free of charge, to any person obtaining a copy of
# this software and associated documentation files (the "Software"), to deal in
# the Software without restriction, including without limitation the rights to
# use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
# the Software, and to permit persons to whom the Software is furnished to do so,
# subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in all
# copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
# FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
# COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
# IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
# CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

TABLES = {
    'HL70001': ('Administrative sex', ('A', 'F', 'M', 'N', 'O', 'U')),
    'HL70002': (
        'Marital status', ('A', 'B', 'C', 'D', 'E', 'G', 'I', 'M', 'N', 'O', 'P', 'R', 'S', 'T', 'U', 'W')),
    'HL70003': ('Event type',
                ('A01', 'A02', 'A03', 'A04', 'A05', 'A06', 'A07', 'A08', 'A09', 'A10', 'A11', 'A12', 'A13', 'A14',
                 'A15',
                 'A16', 'A17', 'A18', 'A19', 'A20', 'A21', 'A22', 'A23', 'A24', 'A25', 'A26', 'A27', 'A28', 'A29',
                 'A30',
                 'A31', 'A32', 'A33', 'A34', 'A35', 'A36', 'A37', 'A38', 'A39', 'A40', 'A41', 'A42', 'A43', 'A44',
                 'A45',
                 'A46', 'A47', 'A48', 'A49', 'A50', 'A51', 'A52', 'A53', 'A54', 'A55', 'A60', 'A61', 'A62', 'B01',
                 'B02',
                 'B03', 'B04', 'B05', 'B06', 'C01', 'C02', 'C03', 'C04', 'C05', 'C06', 'C07', 'C08', 'C09', 'C10',
                 'C11',
                 'C12', 'I01', 'I02', 'I03', 'I04', 'I05', 'I06', 'I07', 'I08', 'I09', 'I10', 'I11', 'I12', 'I13',
                 'I14',
                 'I15', 'J01', 'J02', 'K21', 'K22', 'K23', 'K24', 'K25', 'M01', 'M02', 'M03', 'M04', 'M05', 'M06',
                 'M07',
                 'M08', 'M09', 'M10', 'M11', 'M12', 'N01', 'N02', 'O01', 'O02', 'O03', 'O04', 'O05', 'O06', 'O07',
                 'O08',
                 'O09', 'O10', 'O11', 'O12', 'O13', 'O14', 'O15', 'O16', 'O17', 'O18', 'O19', 'O20', 'O21', 'P01',
                 'P02',
                 'P03', 'P04', 'P05', 'P06', 'P07', 'P08', 'P09', 'P10', 'PC1', 'PC2', 'PC3', 'PC4', 'PC5', 'PC6',
                 'PC7',
                 'PC8', 'PC9', 'PCA', 'PCB', 'PCC', 'PCD', 'PCE', 'PCF', 'PCG', 'PCH', 'PCJ', 'PCK', 'PCL', 'Q01',
                 'Q02',
                 'Q03', 'Q04', 'Q05', 'Q06', 'Q07', 'Q08', 'Q09', 'Q16', 'Q17', 'Q21', 'Q22', 'Q23', 'Q24', 'Q25',
                 'R01',
                 'R02', 'R03', 'R04', 'R05', 'R06', 'R07', 'R08', 'R09', 'R21', 'RAR', 'RDR', 'RER', 'RGR', 'ROR',
                 'S01',
                 'S02', 'S03', 'S04', 'S05', 'S06', 'S07', 'S08', 'S09', 'S10', 'S11', 'S12', 'S13', 'S14', 'S15',
                 'S16',
                 'S17', 'S18', 'S19', 'S20', 'S21', 'S22', 'S23', 'S24', 'S25', 'S26', 'T01', 'T02', 'T03', 'T04',
                 'T05',
                 'T06', 'T07', 'T08', 'T09', 'T10', 'T11', 'T12', 'U01', 'U02', 'U03', 'U04', 'U05', 'U06', 'U07',
                 'U08',
                 'U09', 'U10', 'U11', 'U12', 'U13', 'V01', 'V02', 'V03', 'V04', 'Varies', 'W01', 'W02')),
    'HL70004': ('Patient class', ('B', 'C', 'E', 'I', 'N', 'O', 'P', 'R', 'U')),
    'HL70005': ('Race', ('1002-5', '2028-9', '2054-5', '2076-8', '2106-3', '2131-1')),
    'HL70006': ('Religion',
                ('ABC', 'AGN', 'AME',
                 'AMT', 'ANG', 'AOG',
                 'ATH', 'BAH', 'BAP',
                 'BMA', 'BOT', 'BTA',
                 'BTH', 'BUD', 'CAT',
                 'CFR', 'CHR', 'CHS',
                 'CMA', 'CNF', 'COC',
                 'COG', 'COI', 'COL',
                 'COM', 'COP', 'COT',
                 'CRR', 'EOT', 'EPI',
                 'ERL', 'EVC', 'FRQ',
                 'FWB', 'GRE', 'HIN',
                 'HOT', 'HSH', 'HVA',
                 'JAI', 'JCO', 'JEW',
                 'JOR', 'JOT', 'JRC',
                 'JRF', 'JRN', 'JWN',
                 'LMS', 'LUT', 'MEN',
                 'MET', 'MOM', 'MOS',
                 'MOT', 'MSH', 'MSU',
                 'NAM', 'NAZ', 'NOE',
                 'NRL', 'ORT', 'OTH',
                 'PEN', 'PRC', 'PRE',
                 'PRO', 'QUA', 'REC',
                 'REO', 'SAA', 'SEV',
                 'SHN', 'SIK', 'SOU',
                 'SPI', 'UCC', 'UMD',
                 'UNI', 'UNU', 'VAR',
                 'WES', 'WMC')),
    'HL70007': ('Admission type', ('A', 'C', 'E', 'L', 'N', 'R', 'U')),
    'HL70008': ('Acknowledgment code', ('AA', 'AE', 'AR', 'CA', 'CE', 'CR')),
    'HL70009': ('Ambulatory status',
                ('A0', 'A1', 'A2', 'A3', 'A4',
                 'A5', 'A6', 'A7', 'A8', 'A9',
                 'B1', 'B2', 'B3', 'B4', 'B5',
                 'B6')),
    'HL70017': ('Transaction type', ('AJ', 'CD', 'CG', 'CO', 'PY')),
    'HL70023': ('Admit source', ('1', '2', '3', '4', '5', '6', '7', '8', '9')),
    'HL70027': ('Priority', ('A', 'P', 'R', 'S', 'T')),
    'HL70038': ('Order status', ('A', 'CA', 'CM', 'DC', 'ER', 'HD', 'IP', 'RP', 'SC')),
    'HL70043': ('Condition code',
                ('01', '02', '03',
                 '04', '05', '06',
                 '07', '08', '09',
                 '10', '11',
                 '12 ... 16', '18',
                 '19', '20', '21',
                 '26', '27', '28',
                 '29', '31', '32',
                 '33', '34', '36',
                 '37', '38', '39',
                 '40', '41', '46',
                 '48', '55', '56',
                 '57', '60', '61',
                 '62', '66', '67',
                 '68', '70', '71',
                 '72', '73', '74',
                 '75', '76', '77',
                 '78', '79', '80')),
    'HL70048': ('What subject filter',
                ('ADV', 'ANU', 'APA', 'APM', 'APN', 'APP', 'ARN', 'CAN', 'DEM', 'FIN', 'GID', 'GOL', 'MRI', 'MRO',
                 'NCK',
                 'NSC', 'NST', 'ORD', 'OTH', 'PRB', 'PRO', 'RAR', 'RDR', 'RER', 'RES', 'RGR', 'ROR', 'SAL', 'SBK',
                 'SBL',
                 'SOF', 'SOP', 'SSA', 'SSR', 'STA', 'VXI', 'XID')),
    'HL70052': ('Diagnosis type', ('A', 'F', 'W')),
    'HL70061': ('Check digit scheme', ('ISO', 'M10', 'M11', 'NPI')),
    'HL70062': ('Event reason', ('01', '02', '03')),
    'HL70063': ('Relationship',
                ('ASC', 'BRO', 'CGV', 'CHD', 'DEP', 'DOM', 'EMC', 'EME', 'EMR', 'EXF', 'FCH', 'FND', 'FTH', 'GCH',
                 'GRD',
                 'GRP', 'MGR', 'MTH', 'NCH', 'NON', 'OAD', 'OTH', 'OWN', 'PAR', 'SCH', 'SEL', 'SIB', 'SIS', 'SPO',
                 'TRA',
                 'UNK', 'WRD')),
    'HL70065': ('Specimen action code', ('A', 'G', 'L', 'O', 'P', 'R', 'S')),
    'HL70066': ('Employment status', ('1', '2', '3', '4', '5', '6', '9', 'C', 'D', 'F', 'L', 'O', 'P', 'T')),
    'HL70069': ('Hospital service', ('CAR', 'MED', 'PUL', 'SUR', 'URO')),
    'HL70070': ('Specimen source codes',
                ('ABS', 'AMN', 'ASP', 'BBL', 'BDY',
                 'BIFL', 'BLD', 'BLDA', 'BLDC',
                 'BLDCO', 'BLDV', 'BON', 'BPH',
                 'BPU', 'BRN', 'BRO', 'BRTH', 'CALC',
                 'CBLD', 'CDM', 'CNJT', 'CNL', 'COL',
                 'CSF', 'CTP', 'CUR', 'CVM', 'CVX',
                 'CYST', 'DIAF', 'DOSE', 'DRN',
                 'DUFL', 'EAR', 'EARW', 'ELT',
                 'ENDC', 'ENDM', 'EOS', 'EXG',
                 'EXHLD', 'EYE', 'FIB', 'FIST',
                 'FLT', 'FLU', 'GAS', 'GAST', 'GEN',
                 'GENC', 'GENL', 'GENV', 'HAR',
                 'IHG', 'ISLT', 'IT', 'LAM', 'LIQ',
                 'LN', 'LNA', 'LNV', 'LYM', 'MAC',
                 'MAR', 'MBLD', 'MEC', 'MILK', 'MLK',
                 'NAIL', 'NOS', 'ORH', 'PAFL', 'PAT',
                 'PLAS', 'PLB', 'PLC', 'PLR', 'PMN',
                 'PPP', 'PRP', 'PRT', 'PUS', 'RBC',
                 'RT', 'SAL', 'SEM', 'SER', 'SKM',
                 'SKN', 'SMN', 'SNV', 'SPRM', 'SPT',
                 'SPTC', 'SPTT', 'STL', 'STON',
                 'SWT', 'TEAR', 'THRB', 'THRT',
                 'TISG', 'TISPL', 'TISS', 'TISU',
                 'TLGI', 'TLNG', 'TSMI', 'TUB',
                 'ULC', 'UMB', 'UMED', 'UR', 'URC',
                 'URNS', 'URT', 'URTH', 'USUB',
                 'VITF', 'VOM', 'WAT', 'WBC', 'WICK',
                 'WND', 'WNDA', 'WNDD', 'WNDE',
                 'XXX')),
    'HL70074': ('Diagnostic service section ID',
                ('AU', 'BG', 'BLB', 'CH', 'CP', 'CT', 'CTH', 'CUS', 'EC', 'EN', 'HM', 'ICU', 'IMG', 'IMM', 'LAB',
                 'MB',
                 'MCB', 'MYC', 'NMR', 'NMS', 'NRS', 'OSL', 'OT', 'OTH', 'OUS', 'PAR', 'PAT', 'PF', 'PHR', 'PHY',
                 'PT',
                 'RAD', 'RC', 'RT', 'RUS', 'RX', 'SP', 'SR', 'TX', 'URN', 'VR', 'VUS', 'XRC')),
    'HL70076': ('Message type',
                ('ACK', 'ADR',
                 'ADT', 'BAR',
                 'CRM', 'CSU',
                 'DFT', 'DOC',
                 'DSR', 'EAC',
                 'EAN', 'EAR',
                 'EDR', 'EQQ',
                 'ERP', 'ESR',
                 'ESU', 'INR',
                 'INU', 'LSR',
                 'LSU', 'MCF',
                 'MDM', 'MFD',
                 'MFK', 'MFN',
                 'MFQ', 'MFR',
                 'NMD', 'NMQ',
                 'NMR', 'OMD',
                 'OMG', 'OML',
                 'OMN', 'OMP',
                 'OMS', 'ORD',
                 'ORF', 'ORG',
                 'ORL', 'ORM',
                 'ORN', 'ORP',
                 'ORR', 'ORS',
                 'ORU', 'OSQ',
                 'OSR', 'OUL',
                 'PEX', 'PGL',
                 'PIN', 'PMU',
                 'PPG', 'PPP',
                 'PPR', 'PPT',
                 'PPV', 'PRR',
                 'PTR', 'QBP',
                 'QCK', 'QCN',
                 'QRY', 'QSB',
                 'QSX', 'QVR',
                 'RAR', 'RAS',
                 'RCI', 'RCL',
                 'RDE', 'RDR',
                 'RDS', 'RDY',
                 'REF', 'RER',
                 'RGR', 'RGV',
                 'ROR', 'RPA',
                 'RPI', 'RPL',
                 'RPR', 'RQA',
                 'RQC', 'RQI',
                 'RQP', 'RQQ',
                 'RRA', 'RRD',
                 'RRE', 'RRG',
                 'RRI', 'RSP',
                 'RTB', 'SIU',
                 'SPQ', 'SQM',
                 'SQR', 'SRM',
                 'SRR', 'SSR',
                 'SSU', 'SUR',
                 'TBR', 'TCR',
                 'TCU', 'UDM',
                 'VQQ', 'VXQ',
                 'VXR', 'VXU',
                 'VXX')),
    'HL70078': ('Abnormal flags',
                ('<', '>', 'A', 'AA', 'B', 'D', 'H', 'HH', 'I', 'L', 'LL', 'MS', 'N', 'null', 'R', 'S', 'U', 'VS',
                 'W')),
    'HL70080': ('Nature of abnormal testing', ('A', 'N', 'R', 'S')),
    'HL70083': ('Outlier type', ('C', 'D')),
    'HL70085': ('Observation result status codes interpretation',
                ('C', 'D', 'F', 'I', 'N', 'O', 'P', 'R', 'S', 'U', 'W', 'X')),
    'HL70091': ('Query priority', ('D', 'I')),
    'HL70092': ('Re-admission indicator', ('R',)),
    'HL70093': ('Release information', ('...', 'N', 'Y')),
    'HL70098': ('Type of agreement', ('M', 'S', 'U')),
    'HL70100': ('When to charge', ('D', 'O', 'R', 'S', 'T')),
    'HL70102': ('Delayed acknowledgment type', ('D', 'F')),
    'HL70103': ('Processing ID', ('D', 'P', 'T')),
    'HL70104': ('Version ID', ('2.0', '2.0D', '2.1', '2.2', '2.3', '2.3.1', '2.4')),
    'HL70105': ('Source of comment', ('L', 'O', 'P')),
    'HL70106': ('Query/response format code', ('D', 'R', 'T')),
    'HL70107': ('Deferred response type', ('B', 'L')),
    'HL70108': ('Query results level', ('O', 'R', 'S', 'T')),
    'HL70109': ('Report priority', ('R', 'S')),
    'HL70112': ('Discharge disposition',
                ('01', '02', '03', '04', '05', '06', '07', '08', '09',
                 '10 ...19', '20', '21 ... 29', '30', '31 ... 39', '40', '41',
                 '42')),
    'HL70116': ('Bed status', ('C', 'H', 'I', 'K', 'O', 'U')),
    'HL70121': ('Response flag', ('D', 'E', 'F', 'N', 'R')),
    'HL70122': ('Charge type', ('CH', 'CO', 'CR', 'DP', 'GR', 'NC', 'PC', 'RS')),
    'HL70123': ('Result status', ('A', 'C', 'F', 'I', 'O', 'P', 'R', 'S', 'X', 'Y', 'Z')),
    'HL70124': ('Transportation mode', ('CART', 'PORT', 'WALK', 'WHLC')),
    'HL70125': ('Value type',
                ('AD', 'CE', 'CF', 'CK', 'CN', 'CP',
                 'CX', 'DT', 'ED', 'FT', 'MO', 'NM',
                 'PN', 'RP', 'SN', 'ST', 'TM', 'TN',
                 'TS', 'TX', 'XAD', 'XCN', 'XON',
                 'XPN', 'XTN')),
    'HL70126': ('Quantity limited request', ('CH', 'LI', 'PG', 'RD', 'ZO')),
    'HL70127': ('Allergen type', ('AA', 'DA', 'EA', 'FA', 'LA', 'MA', 'MC', 'PA')),
    'HL70128': ('Allergy severity', ('MI', 'MO', 'SV', 'U')),
    'HL70130': ('Visit user code', ('HO', 'MO', 'PH', 'TE')),
    'HL70133': (
        'Procedure practitioner identifier code type', ('AN', 'AS', 'CM', 'NP', 'PR', 'PS', 'RD', 'RS', 'SN')),
    'HL70135': ('Assignment of benefits', ('M', 'N', 'Y')),
    'HL70136': ('Yes/no indicator', ('N', 'Y')),
    'HL70137': ('Mail claim party', ('E', 'G', 'I', 'O', 'P')),
    'HL70140': ('Military service',
                ('AUSA', 'AUSAF', 'AUSN', 'NATO', 'NOAA',
                 'USA', 'USAF', 'USCG', 'USMC', 'USN',
                 'USPHS')),
    'HL70141': ('Military rank/grade', ('E1 ... E9', 'O1 ... O10', 'W1 ... W4')),
    'HL70142': ('Military status', ('ACT', 'DEC', 'RET')),
    'HL70144': ('Eligibility source', ('1', '2', '3', '4', '5', '6', '7')),
    'HL70145': ('Room type', ('2ICU', '2PRI', '2SPR', 'ICU', 'PRI', 'SPR')),
    'HL70146': ('Amount type', ('DF', 'LM', 'PC', 'RT', 'UL')),
    'HL70147': ('Policy type', ('2ANC', '2MMD', '3MMD', 'ANC', 'MMD')),
    'HL70148': ('Penalty type', ('AT', 'PC')),
    'HL70149': ('Day type', ('AP', 'DE', 'PE')),
    'HL70150': ('Pre-certification patient type', ('ER', 'IPE', 'OPE', 'UR')),
    'HL70153': ('Value code',
                ('01', '02', '04', '05', '06', '08', '09', '10', '11', '12', '13', '14', '15', '16', '17', '21',
                 '22',
                 '23', '24', '30', '31', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48',
                 '49',
                 '50', '51', '52', '53', '56', '57', '58', '59', '60', '67', '68', '70 ... 72', '75 ... 79', '80',
                 '81',
                 'A1', 'A2', 'A3', 'X0', 'X4')),
    'HL70155': ('Accept/application acknowledgment conditions', ('AL', 'ER', 'NE', 'SU')),
    'HL70156': ('Which date/time qualifier', ('ANY', 'COL', 'ORD', 'RCT', 'REP', 'SCHED')),
    'HL70157': ('Which date/time status qualifier', ('ANY', 'CFN', 'COR', 'FIN', 'PRE', 'REP')),
    'HL70158': ('Date/time selection qualifier', ('1ST', 'ALL', 'LST', 'REV')),
    'HL70159': ('Diet code specification type', ('D', 'P', 'S')),
    'HL70160': ('Tray type', ('EARLY', 'GUEST', 'LATE', 'MSG', 'NO')),
    'HL70161': ('Allow substitution', ('G', 'N', 'T')),
    'HL70162': ('Route of administration',
                ('AP', 'B', 'DT', 'EP', 'ET', 'GTT', 'GU', 'IA', 'IB', 'IC', 'ICV', 'ID', 'IH', 'IHA', 'IM',
                 'IMR', 'IN', 'IO', 'IP', 'IS', 'IT', 'IU', 'IV', 'MM', 'MTH', 'NG', 'NP', 'NS', 'NT', 'OP',
                 'OT', 'OTH', 'PF', 'PO', 'PR', 'RM', 'SC', 'SD', 'SL', 'TD', 'TL', 'TP', 'TRA', 'UR', 'VG',
                 'VM', 'WND')),
    'HL70163': ('Body site',
                ('BE', 'BN', 'BU', 'CT', 'LA', 'LAC', 'LACF', 'LD', 'LE', 'LEJ', 'LF', 'LG', 'LH', 'LIJ', 'LLAQ',
                 'LLFA', 'LMFA', 'LN', 'LPC', 'LSC', 'LT', 'LUA', 'LUAQ', 'LUFA', 'LVG', 'LVL', 'NB', 'OD', 'OS',
                 'OU', 'PA', 'PERIN', 'RA', 'RAC', 'RACF', 'RD', 'RE', 'REJ', 'RF', 'RG', 'RH', 'RIJ', 'RLAQ',
                 'RLFA', 'RMFA', 'RN', 'RPC', 'RSC', 'RT', 'RUA', 'RUAQ', 'RUFA', 'RVG', 'RVL')),
    'HL70164': ('Administration device', ('AP', 'BT', 'HL', 'IPPB', 'IVP', 'IVS', 'MI', 'NEB', 'PCA')),
    'HL70165': ('Administration method',
                ('CH', 'DI', 'DU', 'IF', 'IR', 'IS', 'IVP', 'IVPB', 'NB', 'PF', 'PT', 'SH', 'SO', 'WA', 'WI')),
    'HL70166': ('RX component type', ('A', 'B')),
    'HL70167': ('Substitution status', ('0', '1', '2', '3', '4', '5', '7', '8', 'G', 'N', 'T')),
    'HL70168': ('Processing priority', ('A', 'B', 'C', 'P', 'R', 'S', 'T')),
    'HL70169': ('Reporting priority', ('C', 'R')),
    'HL70170': ('Derived specimen', ('C', 'N', 'P')),
    'HL70173': ('Coordination of benefits', ('CO', 'IN')),
    'HL70174': ('Nature of service/test/observation', ('A', 'C', 'F', 'P', 'S')),
    'HL70175': ('Master file identifier code',
                ('CDM', 'CLN', 'CMA', 'CMB', 'LOC', 'OMA', 'OMB', 'OMC', 'OMD', 'OME', 'PRA', 'STF')),
    'HL70177': ('Confidentiality code', ('AID', 'EMP', 'ETH', 'HIV', 'PSY', 'R', 'U', 'UWM', 'V', 'VIP')),
    'HL70178': ('File level event code', ('REP', 'UPD')),
    'HL70179': ('Response level', ('AL', 'ER', 'NE', 'SU')),
    'HL70180': ('Record-level event code', ('MAC', 'MAD', 'MDC', 'MDL', 'MUP')),
    'HL70181': ('MFN record-level error return', ('S', 'U')),
    'HL70182': ('Staff type', ()),
    'HL70183': ('Active/inactive', ('A', 'I')),
    'HL70184': ('Department', ()),
    'HL70185': ('Preferred method of contact', ('B', 'C', 'E', 'F', 'H', 'O')),
    'HL70187': ('Provider billing', ('I', 'P')),
    'HL70189': ('Ethnic group', ('...', 'H', 'N', 'U')),
    'HL70190': ('Address type', ('B', 'BA', 'BDL', 'BR', 'C', 'F', 'H', 'L', 'M', 'N', 'O', 'P', 'RH')),
    'HL70191': ('Type of referenced data', ('AP', 'AU', 'FT', 'IM', 'multipart', 'NS', 'SD', 'SI', 'TEXT', 'TX')),
    'HL70193': ('Amount class', ('AT', 'LM', 'PC', 'UL')),
    'HL70200': ('Name type', ('A', 'B', 'C', 'D', 'I', 'L', 'M', 'N', 'P', 'R', 'S', 'T', 'U')),
    'HL70201': ('Telecommunication use code', ('ASN', 'BPN', 'EMR', 'NET', 'ORN', 'PRN', 'VHN', 'WPN')),
    'HL70202': ('Telecommunication equipment type', ('BP', 'CP', 'FX', 'Internet', 'MD', 'PH', 'X.400')),
    'HL70203': ('Identifier type',
                ('AM', 'AN', 'BA', 'BR', 'BRN', 'DI', 'DL', 'DN', 'DR', 'DS', 'EI', 'EN', 'FI', 'GI', 'GN', 'HC',
                 'JHN',
                 'LN', 'LR', 'MA', 'MC', 'MCN', 'MR', 'MS', 'NE', 'NH', 'NI', 'NNxxx', 'NPI', 'PEN', 'PI', 'PN',
                 'PRN',
                 'PT', 'RR', 'RRI', 'SL', 'SR', 'SS', 'U', 'UPIN', 'VN', 'VS', 'WC', 'WCN', 'XX')),
    'HL70204': ('Organizational name type', ('A', 'D', 'L', 'SL')),
    'HL70205': ('Price type', ('AP', 'DC', 'IC', 'PF', 'TF', 'TP', 'UP')),
    'HL70206': ('Segment action code', ('A', 'D', 'U')),
    'HL70207': ('Processing mode', ('A', 'I', 'Not present', 'R', 'T')),
    'HL70208': ('Query response status', ('AE', 'AR', 'NF', 'OK')),
    'HL70209': ('Relational operator', ('CT', 'EQ', 'GE', 'GN', 'GT', 'LE', 'LT', 'NE')),
    'HL70210': ('Relational conjunction', ('AND', 'OR')),
    'HL70211': ('Alternate character sets',
                ('8859/1', '8859/2', '8859/3', '8859/4', '8859/5',
                 '8859/6', '8859/7', '8859/8', '8859/9', 'ASCII',
                 'ISO IR14', 'ISO IR159', 'ISO IR87', 'UNICODE')),
    'HL70213': ('Purge status code', ('D', 'I', 'P')),
    'HL70217': ('Visit priority code', ('1', '2', '3')),
    'HL70220': ('Living arrangement', ('A', 'F', 'I', 'R', 'S', 'U')),
    'HL70223': ('Living dependency', ('C', 'CB', 'D', 'M', 'O', 'S', 'U', 'WU')),
    'HL70224': ('Transport arranged', ('A', 'N', 'U')),
    'HL70225': ('Escort required', ('N', 'R', 'U')),
    'HL70227': ('Manufacturers of vaccines (code=MVX)',
                ('AB', 'AD', 'ALP', 'AR', 'AVI', 'BA', 'BAY', 'BP', 'BPC', 'CEN', 'CHI', 'CON', 'EVN', 'GRE',
                 'IAG', 'IM',
                 'IUS', 'JPN', 'KGC', 'LED', 'MA', 'MED', 'MIL', 'MIP', 'MSD', 'NAB', 'NAV', 'NOV', 'NYB', 'ORT',
                 'OTC',
                 'OTH', 'PD', 'PMC', 'PRX', 'SCL', 'SI', 'SKB', 'UNK', 'USA', 'WA', 'WAL')),
    'HL70228': ('Diagnosis classification', ('C', 'D', 'I', 'M', 'O', 'R', 'S', 'T')),
    'HL70229': ('DRG payor', ('C', 'G', 'M')),
    'HL70230': ('Procedure functional type', ('A', 'D', 'I', 'P')),
    'HL70231': ('Student status', ('F', 'N', 'P')),
    'HL70232': ('Insurance company contact reason', ('01', '02', '03')),
    'HL70234': ('Report timing', ('10D', '15D', '30D', '3D', '7D', 'AD', 'CO', 'DE', 'PD', 'RQ')),
    'HL70235': ('Report source', ('C', 'D', 'E', 'H', 'L', 'M', 'N', 'O', 'P', 'R')),
    'HL70236': ('Event reported to', ('D', 'L', 'M', 'R')),
    'HL70237': ('Event qualification', ('A', 'B', 'D', 'I', 'L', 'M', 'O', 'W')),
    'HL70238': ('Event seriousness', ('N', 'S', 'Y')),
    'HL70239': ('Event expected', ('N', 'U', 'Y')),
    'HL70240': ('Event consequence', ('C', 'D', 'H', 'I', 'J', 'L', 'O', 'P', 'R')),
    'HL70241': ('Patient outcome', ('D', 'F', 'N', 'R', 'S', 'U', 'W')),
    'HL70242': ('Primary observer\'s qualification', ('C', 'H', 'L', 'M', 'O', 'P', 'R')),
    'HL70243': ('Identity may be divulged', ('N', 'NA', 'Y')),
    'HL70247': ('Status of evaluation', ('A', 'C', 'D', 'I', 'K', 'O', 'P', 'Q', 'R', 'U', 'X', 'Y')),
    'HL70248': ('Product source', ('A', 'L', 'N', 'R')),
    'HL70250': ('Relatedness assessment', ('H', 'I', 'M', 'N', 'S')),
    'HL70251': ('Action taken in response to the event', ('DI', 'DR', 'N', 'OT', 'WP', 'WT')),
    'HL70252': ('Causality observations', ('AW', 'BE', 'DR', 'EX', 'IN', 'LI', 'OE', 'OT', 'PL', 'SE', 'TC')),
    'HL70253': ('Indirect exposure mechanism', ('B', 'F', 'O', 'P', 'X')),
    'HL70254': ('Kind of quantity',
                ('ABS', 'ACNC', 'ACT', 'APER',
                 'ARB', 'AREA', 'ASPECT', 'CACT',
                 'CCNT', 'CCRTO', 'CFR', 'CLAS',
                 'CNC', 'CNST', 'COEF', 'COLOR',
                 'CONS', 'CRAT', 'CRTO', 'DEN',
                 'DEV', 'DIFF', 'ELAS', 'ELPOT',
                 'ELRAT', 'ELRES', 'ENGR', 'ENT',
                 'ENTCAT', 'ENTNUM', 'ENTSUB',
                 'ENTVOL', 'EQL', 'FORCE', 'FREQ',
                 'IMP', 'KINV', 'LEN', 'LINC',
                 'LIQ', 'MASS', 'MCNC', 'MCNT',
                 'MCRTO', 'MFR', 'MGFLUX', 'MINC',
                 'MORPH', 'MOTIL', 'MRAT', 'MRTO',
                 'NCNC', 'NCNT', 'NFR', 'NRTO',
                 'NUM', 'OD', 'OSMOL', 'PRES',
                 'PRID', 'PWR', 'RANGE', 'RATIO',
                 'RCRLTM', 'RDEN', 'REL', 'RLMCNC',
                 'RLSCNC', 'RLTM', 'SATFR', 'SCNC',
                 'SCNCIN', 'SCNT', 'SCNTR', 'SCRTO',
                 'SFR', 'SHAPE', 'SMELL', 'SRAT',
                 'SRTO', 'SUB', 'SUSC', 'TASTE',
                 'TEMP', 'TEMPDF', 'TEMPIN',
                 'THRMCNC', 'THRSCNC', 'TIME',
                 'TITR', 'TMDF', 'TMSTP', 'TRTO',
                 'TYPE', 'VCNT', 'VEL', 'VELRT',
                 'VFR', 'VISC', 'VOL', 'VRAT',
                 'VRTO')),
    'HL70255': ('Duration categories',
                ('*', '12H', '1H', '1L', '1W', '24H', '2.5H', '2D', '2H', '2L', '2W', '30M', '3D', '3H', '3L',
                 '3W', '4D',
                 '4H', '4W', '5D', '5H', '6D', '6H', '7H', '8H', 'PT')),
    'HL70256': ('Time delay post challenge',
                ('10D', '10M', '12H', '15M', '1H',
                 '1L', '1M', '1W', '20M', '24H',
                 '2.5H', '25M', '2D', '2H', '2L',
                 '2M', '2W', '30M', '3D', '3H', '3L',
                 '3M', '3W', '4D', '4H', '4M', '4W',
                 '5D', '5H', '5M', '6D', '6H', '6M',
                 '7D', '7H', '7M', '8H', '8H SHIFT',
                 '8M', '9M', 'BS', 'PEAK', 'RANDOM',
                 'TROUGH')),
    'HL70257': ('Nature of challenge', ('CFST', 'EXCZ', 'FFST')),
    'HL70258': ('Relationship modifier', ('BPU', 'CONTROL', 'DONOR', 'PATIENT')),
    'HL70259': ('Modality',
                ('AS', 'BS', 'CD', 'CP',
                 'CR', 'CS', 'CT', 'DD',
                 'DG', 'DM', 'EC', 'ES',
                 'FA', 'FS', 'LP', 'LS',
                 'MA', 'MS', 'NM', 'OT',
                 'PT', 'RF', 'ST', 'TG',
                 'US', 'XA')),
    'HL70260': ('Patient location type', ('B', 'C', 'D', 'E', 'L', 'N', 'O', 'R')),
    'HL70261': ('Location equipment', ('EEG', 'EKG', 'INF', 'IVP', 'OXY', 'SUC', 'VEN', 'VIT')),
    'HL70262': ('Privacy level', ('F', 'J', 'P', 'Q', 'S', 'W')),
    'HL70263': ('Level of care', ('A', 'C', 'E', 'F', 'N', 'R', 'S')),
    'HL70265': ('Specialty type',
                ('ALC', 'AMB', 'CAN', 'CAR', 'CCR',
                 'CHI', 'EDI', 'EMR', 'FPC', 'INT',
                 'ISO', 'NAT', 'NBI', 'OBG', 'OBS',
                 'OTH', 'PED', 'PHY', 'PIN', 'PPS',
                 'PRE', 'PSI', 'PSY', 'REH', 'SUR',
                 'WIC')),
    'HL70267': ('Days of the week', ('FRI', 'MON', 'SAT', 'SUN', 'THU', 'TUE', 'WED')),
    'HL70268': ('Override', ('A', 'R', 'X')),
    'HL70269': ('Charge on indicator', ('O', 'R')),
    'HL70270': (
        'Document type', ('AR', 'CD', 'CN', 'DI', 'DS', 'ED', 'HP', 'OP', 'PC', 'PH', 'PN', 'PR', 'SP', 'TS')),
    'HL70271': ('Document completion status', ('AU', 'DI', 'DO', 'IN', 'IP', 'LA', 'PA')),
    'HL70272': ('Document confidentiality status', ('R', 'U', 'V')),
    'HL70273': ('Document availability status', ('AV', 'CA', 'OB', 'UN')),
    'HL70275': ('Document storage status', ('AA', 'AC', 'AR', 'PU')),
    'HL70276': ('Appointment reason codes', ('CHECKUP', 'EMERGENCY', 'FOLLOWUP', 'ROUTINE', 'WALKIN')),
    'HL70277': ('Appointment type codes', ('Complete', 'Normal', 'Tentative')),
    'HL70278': ('Filler status codes',
                ('Blocked', 'Booked',
                 'Cancelled', 'Complete', 'Dc',
                 'Deleted', 'Overbook',
                 'Pending', 'Started',
                 'Waitlist')),
    'HL70279': ('Allow substitution codes', ('Confirm', 'No', 'Notify', 'Yes')),
    'HL70280': ('Referral priority', ('A', 'R', 'S')),
    'HL70281': ('Referral type', ('Hom', 'Lab', 'Med', 'Psy', 'Rad', 'Skn')),
    'HL70282': ('Referral disposition', ('AM', 'RP', 'SO', 'WR')),
    'HL70283': ('Referral status', ('A', 'E', 'P', 'R')),
    'HL70284': ('Referral category', ('A', 'E', 'I', 'O')),
    'HL70286': ('Provider role', ('CP', 'PP', 'RP', 'RT')),
    'HL70287': ('Problem/goal action code', ('AD', 'CO', 'DE', 'LI', 'UC', 'UN', 'UP')),
    'HL70290': ('MIME base64 encoding characters',
                ('0', '1', '10', '11', '12', '13', '14', '15', '16', '17', '18', '19', '2', '20', '21', '22',
                 '23', '24', '25', '26', '27', '28', '29', '3', '30', '31', '32', '33', '34', '35', '36', '37',
                 '38',
                 '39', '4', '40', '41', '42', '43', '44', '45', '46', '47', '48', '49', '5', '50', '51', '52',
                 '53', '54', '55', '56', '57', '58', '59', '6', '60', '61', '62', '63', '7', '8', '9', '(pad)')),
    'HL70291': ('Subtype of referenced data',
                ('BASIC', 'DICOM', 'FAX', 'GIF', 'HTML', 'JOT', 'JPEG', 'Octet-stream', 'PICT', 'PostScript',
                 'RTF',
                 'SGML', 'TIFF', 'x-hl7-cda-level-one', 'XML')),
    'HL70292': ('Vaccines administered (code = CVX)(parenteral, unless oral is noted)',
                ('01', '02', '03', '04', '05', '06', '07', '08', '09', '10', '100', '101', '11', '12', '13', '14',
                 '15',
                 '16', '17', '18', '19', '20', '21', '22', '23', '24', '25', '26', '27', '28', '29', '30', '31',
                 '32',
                 '33', '34', '35', '36', '37', '38', '39', '40', '41', '42', '43', '44', '45', '46', '47', '48',
                 '49',
                 '50', '51', '52', '53', '54', '55', '56', '57', '58', '59', '60', '61', '62', '63', '64', '65',
                 '66',
                 '67', '68', '69', '70', '71', '72', '73', '74', '75', '76', '77', '78', '79', '80', '81', '82',
                 '83',
                 '84', '85', '86', '87', '88', '89', '90', '91', '92', '93', '94', '95', '96', '97', '98', '99',
                 '999')),
    'HL70294': ('Time selection criteria parameter class codes',
                ('Fri', 'Mon', 'Prefend', 'Prefstart', 'Sat', 'Sun', 'Thu', 'Tue', 'Wed')),
    'HL70298': ('CP range type', ('F', 'P')),
    'HL70299': ('Encoding', ('A', 'Base64', 'Hex')),
    'HL70301': (
        'Universal ID type', ('DNS', 'GUID', 'HCD', 'HL7', 'ISO', 'L,M,N', 'Random', 'UUID', 'x400', 'x500')),
    'HL70305': ('Person location type', ('C', 'D', 'H', 'N', 'O', 'P', 'S')),
    'HL70309': ('Coverage type', ('B', 'H', 'P')),
    'HL70311': ('Job status', ('O', 'P', 'T', 'U')),
    'HL70315': ('Living will code', ('F', 'I', 'N', 'U', 'Y')),
    'HL70316': ('Organ donor code', ('F', 'I', 'N', 'P', 'R', 'U', 'Y')),
    'HL70317': ('Annotations', ('9900', '9901', '9902', '9903', '9904')),
    'HL70321': ('Dispense method', ('AD', 'F', 'TR', 'UD')),
    'HL70322': ('Completion status', ('CP', 'NA', 'PA', 'RE')),
    'HL70323': ('Action code', ('A', 'D', 'U')),
    'HL70324': ('Location characteristic ID',
                ('GEN', 'IMP', 'INF', 'LCR', 'LIC', 'OVR', 'PRL', 'SET',
                 'SHA', 'SMK', 'STF', 'TEA')),
    'HL70325': ('Location relationship ID', ('ALI', 'DTY', 'LAB', 'LB2', 'PAR', 'RX', 'RX2')),
    'HL70326': ('Visit indicator', ('A', 'V')),
    'HL70329': ('Quantity method', ('A', 'E')),
    'HL70330': ('Marketing basis', ('510E', '510K', '522S', 'PMA', 'PRE', 'TXN')),
    'HL70331': ('Facility type', ('A', 'D', 'M', 'U')),
    'HL70332': ('Source type', ('A', 'I')),
    'HL70334': ('Disabled person', ('AP', 'GT', 'IN', 'PT')),
    'HL70335': ('Repeat pattern',
                ('A', 'BID', 'C', 'D', 'I', 'M',
                 'Meal Related Timings', 'Once', 'P', 'PRN',
                 'PRNxxx', 'QAM', 'QHS', 'QID', 'Q<integer>D',
                 'Q<integer>H', 'Q<integer>J<day#>',
                 'Q<integer>L', 'Q<integer>M', 'Q<integer>S',
                 'Q<integer>W', 'QOD', 'QPM', 'QSHIFT', 'TID',
                 'U <spec>', 'V', 'xID')),
    'HL70336': ('Referral reason', ('O', 'P', 'S', 'W')),
    'HL70337': ('Certification status', ('C', 'E')),
    'HL70338': (
        'Practitioner ID number type',
        ('CY', 'DEA', 'GL', 'L&I', 'MCD', 'MCR', 'QA', 'SL', 'TAX', 'TRL', 'UPIN')),
    'HL70339': ('Advanced beneficiary notice code', ('1', '2', '3', '4')),
    'HL70344': ('Patient\'s relationship to insured',
                ('01', '02', '03', '04', '05', '06',
                 '07', '08', '09', '10', '11', '12',
                 '13', '14', '15', '16', '17', '18',
                 '19')),
    'HL70348': ('Special program indicator', ('01', '02', '03', '04', '05', '06', '07', '08')),
    'HL70349': ('PSRO/UR approval indicator', ('1', '2', '3', '4', '5')),
    'HL70350': ('Occurrence code',
                ('01', '02', '03', '04', '05', '06',
                 '09', '10', '11', '12', '17', '18',
                 '19', '20', '21', '22', '24', '25',
                 '26', '27', '28', '29', '30', '31',
                 '32', '33', '34', '35', '36', '37',
                 '40', '41', '42', '43', '44', '45',
                 '46', '47 ... 49', '50', '51',
                 '70 ... 99', 'A1', 'A2', 'A3')),
    'HL70351': ('Occurrence span', ('70', '71', '72', '73', '74', '75', '76', '77', '78', '79', 'M0')),
    'HL70353': ('CWE statuses', ('NA', 'NASK', 'NAV', 'U', 'UASK')),
    'HL70354': ('Message structure',
                ('ACK', 'ADR_A19', 'ADT_A01', 'ADT_A02',
                 'ADT_A03', 'ADT_A05', 'ADT_A06',
                 'ADT_A09', 'ADT_A15', 'ADT_A16',
                 'ADT_A17', 'ADT_A18', 'ADT_A20',
                 'ADT_A21', 'ADT_A24', 'ADT_A30',
                 'ADT_A37', 'ADT_A38', 'ADT_A39',
                 'ADT_A43', 'ADT_A45', 'ADT_A50',
                 'ADT_A52', 'ADT_A54', 'ADT_A60',
                 'ADT_A61', 'BAR_P01', 'BAR_P02',
                 'BAR_P05', 'BAR_P06', 'BAR_P10',
                 'CRM_C01', 'CSU_C09', 'DFT_P03',
                 'DOC_T12', 'DSR_P04', 'DSR_Q01',
                 'DSR_Q03', 'EAC_U07', 'EAN_U09',
                 'EAR_U08', 'EDR_R07', 'EQQ_Q04',
                 'ERP_R09', 'ESR_U02', 'ESU_U01',
                 'INR_U06', 'INU_U05', 'LSU_U12',
                 'MDM_T01', 'MDM_T02', 'MFD_MFA',
                 'MFK_M01', 'MFN_M01', 'MFN_M02',
                 'MFN_M03', 'MFN_M04', 'MFN_M05',
                 'MFN_M06', 'MFN_M07', 'MFN_M08',
                 'MFN_M09', 'MFN_M10', 'MFN_M11',
                 'MFN_M12', 'MFQ_M01', 'MFR_M01',
                 'NMD_N02', 'NMQ_N01', 'NMR_N01',
                 'OMD_O03', 'OMG_O19', 'OML_O21',
                 'OMN_O07', 'OMP_O09', 'OMS_O05',
                 'ORD_O04', 'ORF_R04', 'ORG_O20',
                 'ORL_O22', 'ORM_O01', 'ORN_O08',
                 'ORP_O10', 'ORR_O02', 'ORS_O06',
                 'ORU_R01', 'ORU_W01', 'OSQ_Q06',
                 'OSR_Q06', 'OUL_R21', 'PEX_P07',
                 'PGL_PC6', 'PMU_B01', 'PMU_B03',
                 'PMU_B04', 'PPG_PCG', 'PPP_PCB',
                 'PPR_PC1', 'PPT_PCL', 'PPV_PCA',
                 'PRR_PC5', 'PTR_PCF', 'QBP_Q11',
                 'QBP_Q13', 'QBP_Q15', 'QBP_Q21',
                 'QCK_Q02', 'QCN_J01', 'QRY_A19',
                 'QRY_PC4', 'QRY_Q01', 'QRY_Q02',
                 'QRY_R02', 'QRY_T12', 'QSB_Q16',
                 'QVR_Q17', 'RAR_RAR', 'RAS_O17',
                 'RCI_I05', 'RCL_I06', 'RDE_O11',
                 'RDR_RDR', 'RDS_O13', 'RDY_K11',
                 'RDY_K15', 'REF_I12', 'RER_RER',
                 'RGR_RGR', 'RGV_O15', 'ROR_ROR',
                 'RPA_I08', 'RPI_I01', 'RPI_I04',
                 'RPL_I02', 'RPR_I03', 'RQA_I08',
                 'RQC_I05', 'RQI_I01', 'RQP_I04',
                 'RQQ_Q09', 'RRA_O18', 'RRD_O14',
                 'RRE_O12', 'RRG_O16', 'RRI_I12',
                 'RSP_K21', 'RSP_K22', 'RSP_K23',
                 'RSP_K24', 'RSP_K25', 'RTB_K13',
                 'SIU_S12', 'SPQ_Q08', 'SQM_S25',
                 'SQR_S25', 'SRM_S01', 'SRR_S01',
                 'SSR_U04', 'SSU_U03', 'SUR_P09',
                 'TBR_R08', 'TCU_U10', 'UDM_Q05',
                 'VQQ_Q07', 'VXQ_V01', 'VXR_V03',
                 'VXU_V04', 'VXX_V02')),
    'HL70355': ('Primary key value type', ('CE', 'PL')),
    'HL70356': ('Alternate character set handling scheme', ('2.3', 'ISO 2022-1994', '<null>')),
    'HL70357': ('Message error condition codes',
                (
                    '0', '100', '101', '102', '103', '200', '201', '202', '203', '204', '205', '206', '207',
                    'Errors',
                    'Rejection', 'Success')),
    'HL70359': ('Diagnosis priority', ('0', '1', '2 ...')),
    'HL70360': ('Degree',
                ('AA',
                 'AAS',
                 'ABA',
                 'AE', 'AS',
                 'BA',
                 'BBA',
                 'BE',
                 'BFA',
                 'BN', 'BS',
                 'BSL',
                 'BT',
                 'CER',
                 'DBA',
                 'DED',
                 'DIP',
                 'DO', 'HS',
                 'JD', 'MA',
                 'MBA',
                 'MCE',
                 'MD',
                 'MDI',
                 'ME',
                 'MED',
                 'MEE',
                 'MFA',
                 'MME',
                 'MS',
                 'MSL',
                 'MT', 'NG',
                 'PharmD',
                 'PHD',
                 'PHE',
                 'PHS',
                 'SEC',
                 'TS')),
    'HL70363': ('Assigning authority',
                ('AUSDVA', 'AUSHIC', 'CANAB', 'CANBC', 'CANMB', 'CANNB', 'CANNF', 'CANNS', 'CANNT', 'CANNU',
                 'CANON',
                 'CANPE', 'CANQC', 'CANSK', 'CANYT', 'NLVWS', 'USCDC', 'USHCFA', 'USSSA')),
    'HL70364': ('Comment type', ('1R', '2R', 'AI', 'DR', 'GI', 'GR', 'PI', 'RE')),
    'HL70365': ('Equipment state', ('CL', 'CO', 'ES', 'ID', 'IN', 'OP', 'PA', 'PD', 'PU')),
    'HL70366': ('Local/remote control state', ('L', 'R')),
    'HL70367': ('Alert level', ('C', 'N', 'S', 'W')),
    'HL70368': ('Remote control command',
                ('AB', 'CL', 'CN', 'DI', 'EN', 'ES', 'EX', 'IN', 'LC', 'LK', 'LO', 'PA', 'RC', 'RE', 'SA', 'SU',
                 'TT', 'UC', 'UN')),
    'HL70369': ('Specimen role', ('B', 'C', 'P', 'Q', 'R')),
    'HL70370': ('Container status', ('I', 'L', 'M', 'O', 'P', 'R', 'U', 'X')),
    'HL70371': ('Additive', ('BOR', 'C32', 'C38', 'EDTK', 'EDTN', 'HCL6', 'HEPL', 'HEPN')),
    'HL70372': ('Specimen component', ('BLD', 'BSEP', 'PLAS', 'PPP', 'PRP', 'SED', 'SER', 'SUP')),
    'HL70373': ('Treatment', ('ACID', 'ALK', 'DEFB', 'FILT', 'LDLP', 'NEUT', 'RECA', 'UFIL')),
    'HL70374': ('System induced contaminants', ('CNTM',)),
    'HL70375': ('Artificial blood', ('FLUR', 'SFHB')),
    'HL70376': ('Special handling considerations', ('C37', 'CAMB', 'CATM', 'CFRZ', 'CREF', 'PRTL')),
    'HL70377': ('Other environmental factors', ('A60', 'ATM')),
    'HL70383': ('Substance status', ('CE', 'CW', 'EE', 'EW', 'NE', 'NW', 'OE', 'OK', 'OW', 'QE', 'QW')),
    'HL70384': ('Substance type', ('CO', 'DI', 'LI', 'LW', 'MR', 'OT', 'PT', 'PW', 'RC', 'SC', 'SR', 'SW')),
    'HL70387': ('Command response', ('ER', 'OK', 'ST', 'TI', 'UN')),
    'HL70388': ('Processing type', ('E', 'P')),
    'HL70389': ('Analyte repeat status', ('D', 'F', 'O', 'R')),
    'HL70391': ('Segment group', ('etc', 'OBRG', 'ORCG', 'PIDG', 'RXAG', 'RXDG', 'RXEG', 'RXOG')),
    'HL70392': ('Match reason', ('DB', 'NA', 'NP', 'SS')),
    'HL70393': ('Match algorithms', ('LINKSOFT_2.01', 'MATCHWARE_1.2')),
    'HL70394': ('Response modality', ('B', 'R', 'T')),
    'HL70395': ('Modify indicator', ('M', 'N')),
    'HL70396': ('Coding System',
                ('L', 'ACR', 'ART', 'AS4', 'AS4E', 'ATC', 'C4', 'C5', 'CAS',
                 'CD2', 'CDCA', 'CDCM', 'CDS', 'CE', 'CLP', 'CPTM', 'CST',
                 'CVX', 'DCL', 'DCM', 'DQL', 'E', 'E5', 'E6', 'E7', 'ENZC',
                 'FDDC', 'FDDX', 'FDK', 'HB', 'HCPCS', 'HHC', 'HI', 'HL7nnnn',
                 'HPC', 'I10', 'I10P', 'I9', 'I9C', 'IBT', 'IC2', 'ICDO',
                 'ICS', 'ICSD', 'ISOnnnn', 'IUPC', 'IUPP', 'JC8', 'LB', 'LN',
                 'MCD', 'MCR', 'MDDX', 'MEDC', 'MEDR', 'MEDX', 'MGPI', 'MVX',
                 'NDA', 'NDC', 'NIC', 'NPI', 'OHA', 'POS', 'RC', 'SDM', 'SNM',
                 'SNM3', 'SNT', 'UC', 'UMD', 'UML', 'UPC', 'UPIN', 'W1', 'W2',
                 'W4', 'WC', '99IHE')),
    'HL70397': ('Sequencing', ('A', 'AN', 'D', 'DN', 'N')),
    'HL70398': ('Continuation style code', ('F', 'I')),
    'HL70399': ('Country code',
                ('ABW', 'AFG', 'AFT', 'AGO', 'AIA', 'ALB', 'AND', 'ANT', 'ARE', 'ARG', 'ARM', 'ASM', 'ATA', 'ATG',
                 'AUS',
                 'AUT', 'AZE', 'BDI', 'BEL', 'BEN', 'BFA', 'BGD', 'BGR', 'BHR', 'BHS', 'BIH', 'BLR', 'BLZ', 'BMU',
                 'BOL',
                 'BRA', 'BRB', 'BRN', 'BTN', 'BVT', 'BWA', 'CAF', 'CAN', 'CCK', 'CHE', 'CHL', 'CHN', 'CIV', 'CMR',
                 'COD',
                 'COG', 'COK', 'COL', 'COM', 'CPV', 'CRI', 'CUB', 'CXR', 'CYM', 'CYP', 'CZE', 'DEU', 'DJI', 'DMA',
                 'DNK',
                 'DOM', 'DZA', 'ECU', 'EGY', 'ERI', 'ESH', 'ESP', 'EST', 'ETH', 'FIN', 'FJI', 'FLK', 'FRA', 'FRO',
                 'FSM',
                 'GAB', 'GBR', 'GEO', 'GHA', 'GIB', 'GIN', 'GLP', 'GMB', 'GNB', 'GNQ', 'GRC', 'GRD', 'GRL', 'GTM',
                 'GUF',
                 'GUM', 'GUY', 'HKG', 'HMD', 'HND', 'HRV', 'HTI', 'HUN', 'IDN', 'IND', 'IOT', 'IRL', 'IRN', 'IRQ',
                 'ISL',
                 'ISR', 'ITA', 'JAM', 'JOR', 'JPN', 'KAZ', 'KEN', 'KGZ', 'KHM', 'KIR', 'KNA', 'KOR', 'KWT', 'LAO',
                 'LBN',
                 'LBR', 'LBY', 'LCA', 'LIE', 'LKA', 'LSO', 'LTU', 'LUX', 'LVA', 'MAC', 'MAR', 'MCO', 'MDA', 'MDG',
                 'MDV',
                 'MEX', 'MHL', 'MKD', 'MLI', 'MLT', 'MMR', 'MNG', 'MNP', 'MOZ', 'MRT', 'MSR', 'MTQ', 'MUS', 'MWI',
                 'MYS',
                 'MYT', 'NAM', 'NCL', 'NER', 'NFK', 'NGA', 'NIC', 'NIU', 'NLD', 'NOR', 'NPL', 'NRU', 'NZL', 'OMN',
                 'PAK',
                 'PAN', 'PCN', 'PER', 'PHL', 'PLW', 'PNG', 'POL', 'PRI', 'PRK', 'PRT', 'PRY', 'PYF', 'QAT', 'REU',
                 'ROM',
                 'RUS', 'RWA', 'SAU', 'SDN', 'SEN', 'SGP', 'SGS', 'SHN', 'SJM', 'SLB', 'SLE', 'SLV', 'SMR', 'SOM',
                 'SPM',
                 'STP', 'SUR', 'SVK', 'SVN', 'SWE', 'SWZ', 'SYC', 'SYR', 'TCA', 'TCD', 'TGO', 'THA', 'TJK', 'TKL',
                 'TKM',
                 'TMP', 'TON', 'TTO', 'TUN', 'TUR', 'TUV', 'TWN', 'TZA', 'UGA', 'UKR', 'UMI', 'URY', 'USA', 'UZB',
                 'VAT',
                 'VCT', 'VEN', 'VGB', 'VIR', 'VNM', 'VUT', 'WLF', 'WSM', 'YEM', 'YUG', 'ZAF', 'ZMB', 'ZWE')),
    'HL70401': ('Government reimbursement program', ('C', 'MM')),
    'HL70402': ('School type', ('D', 'G', 'M', 'U')),
    'HL70403': ('Language ability', ('1', '2', '3', '4', '5')),
    'HL70404': ('Language proficiency', ('1', '2', '3', '4', '5', '6')),
    'HL70406': ('Organization unit type', ('1', '2', '3', '4', '5', 'H', 'O')),
    'HL70409': ('Application change type', ('M', 'SD', 'SU')),
    'HL70411': ('Supplemental service information values',
                ('1ST', '2ND', '3RD', '4TH', '5TH', 'ANT',
                 'A/P', 'BLT', 'DEC', 'DST', 'LAT', 'LFT',
                 'LLQ', 'LOW', 'LUQ', 'MED', 'OR', 'PED', 'POS',
                 'PRT', 'PRX', 'REC', 'RGH', 'RLQ', 'RUQ',
                 'UPP', 'UPR', 'WCT', 'WOC', 'WSD')),
    'HL70415': ('DRG transfer type', ('E', 'N')),
    'HL70416': ('Procedure DRG type', ('1', '2', '3', '4', '5')),
    'HL70417': ('Tissue type code', ('0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'B', 'C', 'G')),
    'HL70418': ('Procedure priority', ('0', '1', '2 ...')),
    'HL70421': ('Severity of illness code', ('MI', 'MO', 'SE')),
    'HL70422': ('Triage code', ('1', '2', '3', '4', '5', '99')),
    'HL70423': ('Case category code', ('D',)),
    'HL70424': ('Gestation category code', ('1', '2', '3')),
    'HL70425': ('Newborn code', ('1', '2', '3', '4', '5')),
    'HL70426': ('Blood product code',
                ('CRYO', 'CRYOP', 'FFP', 'FFPTH', 'PC', 'PCA', 'PCNEO', 'PCW', 'PLT', 'PLTNEO', 'PLTP', 'PLTPH',
                 'PLTPHLR', 'RWB', 'WBA')),
    'HL70427': (
        'Risk management incident code', ('B', 'C', 'D', 'E', 'F', 'H', 'I', 'J', 'K', 'O', 'P', 'R', 'S', 'T')),
    'HL70428': ('Incident type code', ('O', 'P', 'U')),
    'HL70429': ('Production class Code', ('BR', 'DA', 'DR', 'DU', 'LY', 'MT', 'NA', 'OT', 'PL', 'RA', 'SH', 'U')),
    'HL70430': ('Mode of arrival code', ('A', 'C', 'F', 'H', 'O', 'P', 'U')),
    'HL70431': ('Recreational drug use code', ('A', 'C', 'K', 'M', 'O', 'T', 'U')),
    'HL70432': ('Admission level of care code', ('AC', 'CH', 'CO', 'CR', 'IM', 'MO')),
    'HL70433': ('Precaution code', ('A', 'B', 'C', 'D', 'I', 'N', 'O', 'P', 'U')),
    'HL70434': ('Patient condition code', ('A', 'C', 'O', 'P', 'S', 'U')),
    'HL70435': ('Advance directive code', ('DNR',)),
    'HL70436': ('Sensitivity to Causative Agent code', ('AD', 'AL', 'CT', 'IN')),
    'HL70437': ('Alert device code', ('B', 'N', 'W')),
    'HL70438': ('Allergy clinical status', ('C', 'D', 'E', 'I', 'P', 'S', 'U')),
    'HL70440': ('Data types',
                ('AD', 'CD', 'CE', 'CF', 'CK',
                 'CM', 'CN', 'CNE', 'CP',
                 'CQ', 'CWE', 'CX', 'DLN',
                 'DR', 'DT', 'ED', 'EI', 'FC',
                 'FN', 'FT', 'HD', 'ID', 'IS',
                 'JCC', 'MA', 'MO', 'NA',
                 'NM', 'PL', 'PN', 'PPN',
                 'PT', 'QIP', 'QSC', 'RCD',
                 'RI', 'RP', 'SAD', 'SCV',
                 'SI', 'SN', 'SRT', 'ST',
                 'TM', 'TN', 'TQ', 'TS', 'TX',
                 'VH', 'VID', 'XAD', 'XCN',
                 'XON', 'XPN', 'XTN')),
    'HL70441': ('Immunization registry status', ('A', 'I', 'L', 'M', 'O', 'P', 'U')),
    'HL70442': ('Location service code', ('D', 'E', 'P', 'T')),
    'HL70443': ('Provider role', ('AD', 'AT', 'CP', 'FHCP', 'PP', 'RP', 'RT')),
    'HL70444': ('Name assembly order', ('F', 'G')),
    'HL70445': ('Identity Reliability Code', ('AL', 'UA', 'UD', 'US')),
    'HL70450': ('Event type', ('LOG', 'SER')),
    'HL70451': ('Substance identifier', ('ALL',)),
    'HL70452': ('Health care provider type code', ('SUGGESTION',)),
    'HL70453': ('Health care provider classification', ('SUGGESTION',)),
    'HL70454': ('Health care provider area of specialization', ('SUGGESTION',)),
    'HL70455': ('Type of bill code', ('...', '131', '141')),
    'HL70456': ('Revenue code', ('...', '260', '280', '301', '991', '993', '994')),
    'HL70457': ('Overall claim disposition code', ('0', '1', '2', '3', '4')),
    'HL70458': ('OCE edit code',
                ('...', '1', '10', '11', '12',
                 '13', '14', '15', '16', '17',
                 '18', '19', '2', '20', '21',
                 '22', '23', '24', '25', '26',
                 '27', '28', '29', '3', '30',
                 '31', '32', '33', '34', '35.',
                 '36.', '37', '38.', '39.', '4',
                 '40.', '41.', '42.', '5', '6',
                 '7', '8', '9')),
    'HL70459': ('Reimbursement Action Code', ('0', '1', '2', '3')),
    'HL70460': ('Denial or rejection code', ('0', '1', '2')),
    'HL70465': ('Name/address representation', ('A', 'I', 'P')),
    'HL70466': ('Ambulatory payment classification code', ('...', '031', '163', '181')),
    'HL70467': ('Modifier edit code', ('0', '1', '2', '3', '4', 'U')),
    'HL70468': ('Payment adjustment code', ('1', '2', '3', '4', '5')),
    'HL70469': ('Packaging status code', ('0', '1', '2')),
    'HL70470': ('Reimbursement type code',
                ('Crnl', 'DME', 'EPO', 'Lab', 'Mamm', 'NoPay',
                 'OPPS', 'PartH', 'Pckg', 'Thrpy')),
    'HL70472': ('TQ Conjunction ID', ('A', 'C', 'S')),
    'HL70473': ('Formulary status', ('G', 'N', 'R', 'Y')),
    'HL70474': ('Organization unit type - ORG', ('D', 'F', 'L', 'M', 'S', 'U', 'V'))}
