from .fields import FIELDS

SEGMENTS = {
    'ACC': ('sequence',
            (('ACC_1', FIELDS['ACC_1'], (0, 1), 'FIE'),
             ('ACC_2', FIELDS['ACC_2'], (0, 1), 'FIE'),
             ('ACC_3', FIELDS['ACC_3'], (0, 1), 'FIE'),)),
    'ADD': ('sequence',
            (('ADD_1', FIELDS['ADD_1'], (0, 1), 'FIE'),)),
    'AL1': ('sequence',
            (('AL1_1', FIELDS['AL1_1'], (1, 1), 'FIE'),
             ('AL1_2', FIELDS['AL1_2'], (0, 1), 'FIE'),
             ('AL1_3', FIELDS['AL1_3'], (1, 1), 'FIE'),
             ('AL1_4', FIELDS['AL1_4'], (0, 1), 'FIE'),
             ('AL1_5', FIELDS['AL1_5'], (0, 1), 'FIE'),
             ('AL1_6', FIELDS['AL1_6'], (0, 1), 'FIE'),)),
    'ANYHL7SEGMENT': ('choice',
                      (('ACC', None, (0, -1), 'FIE'),
                       ('ADD', None, (0, -1), 'FIE'),
                       ('AL1', None, (0, -1), 'FIE'),
                       ('BHS', None, (0, -1), 'FIE'),
                       ('BLG', None, (0, -1), 'FIE'),
                       ('BTS', None, (0, -1), 'FIE'),
                       ('DG1', None, (0, -1), 'FIE'),
                       ('DSC', None, (0, -1), 'FIE'),
                       ('DSP', None, (0, -1), 'FIE'),
                       ('ERR', None, (0, -1), 'FIE'),
                       ('EVN', None, (0, -1), 'FIE'),
                       ('FHS', None, (0, -1), 'FIE'),
                       ('FT1', None, (0, -1), 'FIE'),
                       ('FTS', None, (0, -1), 'FIE'),
                       ('GT1', None, (0, -1), 'FIE'),
                       ('IN1', None, (0, -1), 'FIE'),
                       ('IN2', None, (0, -1), 'FIE'),
                       ('IN3', None, (0, -1), 'FIE'),
                       ('MFA', None, (0, -1), 'FIE'),
                       ('MFE', None, (0, -1), 'FIE'),
                       ('MFI', None, (0, -1), 'FIE'),
                       ('MRG', None, (0, -1), 'FIE'),
                       ('MSA', None, (0, -1), 'FIE'),
                       ('MSH', None, (0, -1), 'FIE'),
                       ('NCK', None, (0, -1), 'FIE'),
                       ('NK1', None, (0, -1), 'FIE'),
                       ('NPU', None, (0, -1), 'FIE'),
                       ('NSC', None, (0, -1), 'FIE'),
                       ('NST', None, (0, -1), 'FIE'),
                       ('NTE', None, (0, -1), 'FIE'),
                       ('OBR', None, (0, -1), 'FIE'),
                       ('OBX', None, (0, -1), 'FIE'),
                       ('ODS', None, (0, -1), 'FIE'),
                       ('ODT', None, (0, -1), 'FIE'),
                       ('OM1', None, (0, -1), 'FIE'),
                       ('OM2', None, (0, -1), 'FIE'),
                       ('OM3', None, (0, -1), 'FIE'),
                       ('OM4', None, (0, -1), 'FIE'),
                       ('OM5', None, (0, -1), 'FIE'),
                       ('OM6', None, (0, -1), 'FIE'),
                       ('ORC', None, (0, -1), 'FIE'),
                       ('PID', None, (0, -1), 'FIE'),
                       ('PR1', None, (0, -1), 'FIE'),
                       ('PRA', None, (0, -1), 'FIE'),
                       ('PV1', None, (0, -1), 'FIE'),
                       ('PV2', None, (0, -1), 'FIE'),
                       ('QRD', None, (0, -1), 'FIE'),
                       ('QRF', None, (0, -1), 'FIE'),
                       ('RQ1', None, (0, -1), 'FIE'),
                       ('RQD', None, (0, -1), 'FIE'),
                       ('RXA', None, (0, -1), 'FIE'),
                       ('RXC', None, (0, -1), 'FIE'),
                       ('RXD', None, (0, -1), 'FIE'),
                       ('RXE', None, (0, -1), 'FIE'),
                       ('RXG', None, (0, -1), 'FIE'),
                       ('RXO', None, (0, -1), 'FIE'),
                       ('RXR', None, (0, -1), 'FIE'),
                       ('STF', None, (0, -1), 'FIE'),
                       ('UB1', None, (0, -1), 'FIE'),
                       ('UB2', None, (0, -1), 'FIE'),
                       ('URD', None, (0, -1), 'FIE'),
                       ('URS', None, (0, -1), 'FIE'),)),
    'BHS': ('sequence',
            (('BHS_1', FIELDS['BHS_1'], (1, 1), 'FIE'),
             ('BHS_2', FIELDS['BHS_2'], (1, 1), 'FIE'),
             ('BHS_3', FIELDS['BHS_3'], (0, 1), 'FIE'),
             ('BHS_4', FIELDS['BHS_4'], (0, 1), 'FIE'),
             ('BHS_5', FIELDS['BHS_5'], (0, 1), 'FIE'),
             ('BHS_6', FIELDS['BHS_6'], (0, 1), 'FIE'),
             ('BHS_7', FIELDS['BHS_7'], (0, 1), 'FIE'),
             ('BHS_8', FIELDS['BHS_8'], (0, 1), 'FIE'),
             ('BHS_9', FIELDS['BHS_9'], (0, 1), 'FIE'),
             ('BHS_10', FIELDS['BHS_10'], (0, 1), 'FIE'),
             ('BHS_11', FIELDS['BHS_11'], (0, 1), 'FIE'),
             ('BHS_12', FIELDS['BHS_12'], (0, 1), 'FIE'),)),
    'BLG': ('sequence',
            (('BLG_1', FIELDS['BLG_1'], (0, 1), 'FIE'),
             ('BLG_2', FIELDS['BLG_2'], (0, 1), 'FIE'),
             ('BLG_3', FIELDS['BLG_3'], (0, 1), 'FIE'),)),
    'BTS': ('sequence',
            (('BTS_1', FIELDS['BTS_1'], (0, 1), 'FIE'),
             ('BTS_2', FIELDS['BTS_2'], (0, 1), 'FIE'),
             ('BTS_3', FIELDS['BTS_3'], (0, -1), 'FIE'),)),
    'DG1': ('sequence',
            (('DG1_1', FIELDS['DG1_1'], (1, 1), 'FIE'),
             ('DG1_2', FIELDS['DG1_2'], (1, 1), 'FIE'),
             ('DG1_3', FIELDS['DG1_3'], (0, 1), 'FIE'),
             ('DG1_4', FIELDS['DG1_4'], (0, 1), 'FIE'),
             ('DG1_5', FIELDS['DG1_5'], (0, 1), 'FIE'),
             ('DG1_6', FIELDS['DG1_6'], (1, 1), 'FIE'),
             ('DG1_7', FIELDS['DG1_7'], (0, 1), 'FIE'),
             ('DG1_8', FIELDS['DG1_8'], (0, 1), 'FIE'),
             ('DG1_9', FIELDS['DG1_9'], (0, 1), 'FIE'),
             ('DG1_10', FIELDS['DG1_10'], (0, 1), 'FIE'),
             ('DG1_11', FIELDS['DG1_11'], (0, 1), 'FIE'),
             ('DG1_12', FIELDS['DG1_12'], (0, 1), 'FIE'),
             ('DG1_13', FIELDS['DG1_13'], (0, 1), 'FIE'),
             ('DG1_14', FIELDS['DG1_14'], (0, 1), 'FIE'),
             ('DG1_15', FIELDS['DG1_15'], (0, 1), 'FIE'),
             ('DG1_16', FIELDS['DG1_16'], (0, 1), 'FIE'),)),
    'DSC': ('sequence',
            (('DSC_1', FIELDS['DSC_1'], (0, 1), 'FIE'),)),
    'DSP': ('sequence',
            (('DSP_1', FIELDS['DSP_1'], (0, 1), 'FIE'),
             ('DSP_2', FIELDS['DSP_2'], (0, 1), 'FIE'),
             ('DSP_3', FIELDS['DSP_3'], (1, 1), 'FIE'),
             ('DSP_4', FIELDS['DSP_4'], (0, 1), 'FIE'),
             ('DSP_5', FIELDS['DSP_5'], (0, 1), 'FIE'),)),
    'ERR': ('sequence',
            (('ERR_1', FIELDS['ERR_1'], (1, -1), 'FIE'),)),
    'EVN': ('sequence',
            (('EVN_1', FIELDS['EVN_1'], (1, 1), 'FIE'),
             ('EVN_2', FIELDS['EVN_2'], (1, 1), 'FIE'),
             ('EVN_3', FIELDS['EVN_3'], (0, 1), 'FIE'),
             ('EVN_4', FIELDS['EVN_4'], (0, 1), 'FIE'),
             ('EVN_5', FIELDS['EVN_5'], (0, 1), 'FIE'),)),
    'FHS': ('sequence',
            (('FHS_1', FIELDS['FHS_1'], (1, 1), 'FIE'),
             ('FHS_2', FIELDS['FHS_2'], (1, 1), 'FIE'),
             ('FHS_3', FIELDS['FHS_3'], (0, 1), 'FIE'),
             ('FHS_4', FIELDS['FHS_4'], (0, 1), 'FIE'),
             ('FHS_5', FIELDS['FHS_5'], (0, 1), 'FIE'),
             ('FHS_6', FIELDS['FHS_6'], (0, 1), 'FIE'),
             ('FHS_7', FIELDS['FHS_7'], (0, 1), 'FIE'),
             ('FHS_8', FIELDS['FHS_8'], (0, 1), 'FIE'),
             ('FHS_9', FIELDS['FHS_9'], (0, 1), 'FIE'),
             ('FHS_10', FIELDS['FHS_10'], (0, 1), 'FIE'),
             ('FHS_11', FIELDS['FHS_11'], (0, 1), 'FIE'),
             ('FHS_12', FIELDS['FHS_12'], (0, 1), 'FIE'),)),
    'FT1': ('sequence',
            (('FT1_1', FIELDS['FT1_1'], (0, 1), 'FIE'),
             ('FT1_2', FIELDS['FT1_2'], (0, 1), 'FIE'),
             ('FT1_3', FIELDS['FT1_3'], (0, 1), 'FIE'),
             ('FT1_4', FIELDS['FT1_4'], (1, 1), 'FIE'),
             ('FT1_5', FIELDS['FT1_5'], (0, 1), 'FIE'),
             ('FT1_6', FIELDS['FT1_6'], (1, 1), 'FIE'),
             ('FT1_7', FIELDS['FT1_7'], (1, 1), 'FIE'),
             ('FT1_8', FIELDS['FT1_8'], (0, 1), 'FIE'),
             ('FT1_9', FIELDS['FT1_9'], (0, 1), 'FIE'),
             ('FT1_10', FIELDS['FT1_10'], (0, 1), 'FIE'),
             ('FT1_11', FIELDS['FT1_11'], (0, 1), 'FIE'),
             ('FT1_12', FIELDS['FT1_12'], (0, 1), 'FIE'),
             ('FT1_13', FIELDS['FT1_13'], (0, 1), 'FIE'),
             ('FT1_14', FIELDS['FT1_14'], (1, 1), 'FIE'),
             ('FT1_15', FIELDS['FT1_15'], (0, 1), 'FIE'),
             ('FT1_16', FIELDS['FT1_16'], (0, 1), 'FIE'),
             ('FT1_17', FIELDS['FT1_17'], (0, 1), 'FIE'),
             ('FT1_18', FIELDS['FT1_18'], (0, 1), 'FIE'),
             ('FT1_19', FIELDS['FT1_19'], (0, -1), 'FIE'),
             ('FT1_20', FIELDS['FT1_20'], (0, 1), 'FIE'),
             ('FT1_21', FIELDS['FT1_21'], (0, 1), 'FIE'),
             ('FT1_22', FIELDS['FT1_22'], (0, 1), 'FIE'),
             ('FT1_23', FIELDS['FT1_23'], (0, 1), 'FIE'),)),
    'FTS': ('sequence',
            (('FTS_1', FIELDS['FTS_1'], (0, 1), 'FIE'),
             ('FTS_2', FIELDS['FTS_2'], (0, 1), 'FIE'),)),
    'GT1': ('sequence',
            (('GT1_1', FIELDS['GT1_1'], (1, 1), 'FIE'),
             ('GT1_2', FIELDS['GT1_2'], (0, 1), 'FIE'),
             ('GT1_3', FIELDS['GT1_3'], (1, 1), 'FIE'),
             ('GT1_4', FIELDS['GT1_4'], (0, 1), 'FIE'),
             ('GT1_5', FIELDS['GT1_5'], (0, 1), 'FIE'),
             ('GT1_6', FIELDS['GT1_6'], (0, -1), 'FIE'),
             ('GT1_7', FIELDS['GT1_7'], (0, -1), 'FIE'),
             ('GT1_8', FIELDS['GT1_8'], (0, 1), 'FIE'),
             ('GT1_9', FIELDS['GT1_9'], (0, 1), 'FIE'),
             ('GT1_10', FIELDS['GT1_10'], (0, 1), 'FIE'),
             ('GT1_11', FIELDS['GT1_11'], (0, 1), 'FIE'),
             ('GT1_12', FIELDS['GT1_12'], (0, 1), 'FIE'),
             ('GT1_13', FIELDS['GT1_13'], (0, 1), 'FIE'),
             ('GT1_14', FIELDS['GT1_14'], (0, 1), 'FIE'),
             ('GT1_15', FIELDS['GT1_15'], (0, 1), 'FIE'),
             ('GT1_16', FIELDS['GT1_16'], (0, 1), 'FIE'),
             ('GT1_17', FIELDS['GT1_17'], (0, 1), 'FIE'),
             ('GT1_18', FIELDS['GT1_18'], (0, -1), 'FIE'),
             ('GT1_19', FIELDS['GT1_19'], (0, 1), 'FIE'),
             ('GT1_20', FIELDS['GT1_20'], (0, 1), 'FIE'),
             ('GT1_21', FIELDS['GT1_21'], (0, 1), 'FIE'),)),
    'IN1': ('sequence',
            (('IN1_1', FIELDS['IN1_1'], (1, 1), 'FIE'),
             ('IN1_2', FIELDS['IN1_2'], (1, 1), 'FIE'),
             ('IN1_3', FIELDS['IN1_3'], (1, 1), 'FIE'),
             ('IN1_4', FIELDS['IN1_4'], (0, 1), 'FIE'),
             ('IN1_5', FIELDS['IN1_5'], (0, 1), 'FIE'),
             ('IN1_6', FIELDS['IN1_6'], (0, 1), 'FIE'),
             ('IN1_7', FIELDS['IN1_7'], (0, -1), 'FIE'),
             ('IN1_8', FIELDS['IN1_8'], (0, 1), 'FIE'),
             ('IN1_9', FIELDS['IN1_9'], (0, 1), 'FIE'),
             ('IN1_10', FIELDS['IN1_10'], (0, 1), 'FIE'),
             ('IN1_11', FIELDS['IN1_11'], (0, 1), 'FIE'),
             ('IN1_12', FIELDS['IN1_12'], (0, 1), 'FIE'),
             ('IN1_13', FIELDS['IN1_13'], (0, 1), 'FIE'),
             ('IN1_14', FIELDS['IN1_14'], (0, 1), 'FIE'),
             ('IN1_15', FIELDS['IN1_15'], (0, 1), 'FIE'),
             ('IN1_16', FIELDS['IN1_16'], (0, 1), 'FIE'),
             ('IN1_17', FIELDS['IN1_17'], (0, 1), 'FIE'),
             ('IN1_18', FIELDS['IN1_18'], (0, 1), 'FIE'),
             ('IN1_19', FIELDS['IN1_19'], (0, 1), 'FIE'),
             ('IN1_20', FIELDS['IN1_20'], (0, 1), 'FIE'),
             ('IN1_21', FIELDS['IN1_21'], (0, 1), 'FIE'),
             ('IN1_22', FIELDS['IN1_22'], (0, 1), 'FIE'),
             ('IN1_23', FIELDS['IN1_23'], (0, 1), 'FIE'),
             ('IN1_24', FIELDS['IN1_24'], (0, 1), 'FIE'),
             ('IN1_25', FIELDS['IN1_25'], (0, 1), 'FIE'),
             ('IN1_26', FIELDS['IN1_26'], (0, 1), 'FIE'),
             ('IN1_27', FIELDS['IN1_27'], (0, 1), 'FIE'),
             ('IN1_28', FIELDS['IN1_28'], (0, 1), 'FIE'),
             ('IN1_29', FIELDS['IN1_29'], (0, 1), 'FIE'),
             ('IN1_30', FIELDS['IN1_30'], (0, 1), 'FIE'),
             ('IN1_31', FIELDS['IN1_31'], (0, 1), 'FIE'),
             ('IN1_32', FIELDS['IN1_32'], (0, 1), 'FIE'),
             ('IN1_33', FIELDS['IN1_33'], (0, 1), 'FIE'),
             ('IN1_34', FIELDS['IN1_34'], (0, 1), 'FIE'),
             ('IN1_35', FIELDS['IN1_35'], (0, 1), 'FIE'),
             ('IN1_36', FIELDS['IN1_36'], (0, 1), 'FIE'),
             ('IN1_37', FIELDS['IN1_37'], (0, 1), 'FIE'),
             ('IN1_38', FIELDS['IN1_38'], (0, 1), 'FIE'),
             ('IN1_39', FIELDS['IN1_39'], (0, 1), 'FIE'),
             ('IN1_40', FIELDS['IN1_40'], (0, 1), 'FIE'),
             ('IN1_41', FIELDS['IN1_41'], (0, 1), 'FIE'),
             ('IN1_42', FIELDS['IN1_42'], (0, 1), 'FIE'),
             ('IN1_43', FIELDS['IN1_43'], (0, 1), 'FIE'),
             ('IN1_44', FIELDS['IN1_44'], (0, 1), 'FIE'),
             ('IN1_45', FIELDS['IN1_45'], (0, 1), 'FIE'),
             ('IN1_46', FIELDS['IN1_46'], (0, 1), 'FIE'),)),
    'IN2': ('sequence',
            (('IN2_1', FIELDS['IN2_1'], (0, 1), 'FIE'),
             ('IN2_2', FIELDS['IN2_2'], (0, 1), 'FIE'),
             ('IN2_3', FIELDS['IN2_3'], (0, 1), 'FIE'),
             ('IN2_4', FIELDS['IN2_4'], (0, 1), 'FIE'),
             ('IN2_5', FIELDS['IN2_5'], (0, 1), 'FIE'),
             ('IN2_6', FIELDS['IN2_6'], (0, 1), 'FIE'),
             ('IN2_7', FIELDS['IN2_7'], (0, 1), 'FIE'),
             ('IN2_8', FIELDS['IN2_8'], (0, 1), 'FIE'),
             ('IN2_9', FIELDS['IN2_9'], (0, 1), 'FIE'),
             ('IN2_10', FIELDS['IN2_10'], (0, 1), 'FIE'),
             ('IN2_11', FIELDS['IN2_11'], (0, 1), 'FIE'),
             ('IN2_12', FIELDS['IN2_12'], (0, 1), 'FIE'),
             ('IN2_13', FIELDS['IN2_13'], (0, 1), 'FIE'),
             ('IN2_14', FIELDS['IN2_14'], (0, 1), 'FIE'),
             ('IN2_15', FIELDS['IN2_15'], (0, 1), 'FIE'),
             ('IN2_16', FIELDS['IN2_16'], (0, 1), 'FIE'),
             ('IN2_17', FIELDS['IN2_17'], (0, 1), 'FIE'),
             ('IN2_18', FIELDS['IN2_18'], (0, 1), 'FIE'),
             ('IN2_19', FIELDS['IN2_19'], (0, 1), 'FIE'),
             ('IN2_20', FIELDS['IN2_20'], (0, 1), 'FIE'),
             ('IN2_21', FIELDS['IN2_21'], (0, 1), 'FIE'),
             ('IN2_22', FIELDS['IN2_22'], (0, 1), 'FIE'),
             ('IN2_23', FIELDS['IN2_23'], (0, 1), 'FIE'),
             ('IN2_24', FIELDS['IN2_24'], (0, -1), 'FIE'),
             ('IN2_25', FIELDS['IN2_25'], (0, 1), 'FIE'),
             ('IN2_26', FIELDS['IN2_26'], (0, 1), 'FIE'),
             ('IN2_27', FIELDS['IN2_27'], (0, 1), 'FIE'),
             ('IN2_28', FIELDS['IN2_28'], (0, -1), 'FIE'),
             ('IN2_29', FIELDS['IN2_29'], (0, -1), 'FIE'),
             ('IN2_30', FIELDS['IN2_30'], (0, 1), 'FIE'),)),
    'IN3': ('sequence',
            (('IN3_1', FIELDS['IN3_1'], (1, 1), 'FIE'),
             ('IN3_2', FIELDS['IN3_2'], (0, 1), 'FIE'),
             ('IN3_3', FIELDS['IN3_3'], (0, 1), 'FIE'),
             ('IN3_4', FIELDS['IN3_4'], (0, 1), 'FIE'),
             ('IN3_5', FIELDS['IN3_5'], (0, 1), 'FIE'),
             ('IN3_6', FIELDS['IN3_6'], (0, 1), 'FIE'),
             ('IN3_7', FIELDS['IN3_7'], (0, 1), 'FIE'),
             ('IN3_8', FIELDS['IN3_8'], (0, 1), 'FIE'),
             ('IN3_9', FIELDS['IN3_9'], (0, 1), 'FIE'),
             ('IN3_10', FIELDS['IN3_10'], (0, 1), 'FIE'),
             ('IN3_11', FIELDS['IN3_11'], (0, 1), 'FIE'),
             ('IN3_12', FIELDS['IN3_12'], (0, 1), 'FIE'),
             ('IN3_13', FIELDS['IN3_13'], (0, 1), 'FIE'),
             ('IN3_14', FIELDS['IN3_14'], (0, 1), 'FIE'),
             ('IN3_15', FIELDS['IN3_15'], (0, 1), 'FIE'),
             ('IN3_16', FIELDS['IN3_16'], (0, -1), 'FIE'),
             ('IN3_17', FIELDS['IN3_17'], (0, 1), 'FIE'),
             ('IN3_18', FIELDS['IN3_18'], (0, 1), 'FIE'),
             ('IN3_19', FIELDS['IN3_19'], (0, -1), 'FIE'),
             ('IN3_20', FIELDS['IN3_20'], (0, -1), 'FIE'),
             ('IN3_21', FIELDS['IN3_21'], (0, 1), 'FIE'),
             ('IN3_22', FIELDS['IN3_22'], (0, 1), 'FIE'),
             ('IN3_23', FIELDS['IN3_23'], (0, 1), 'FIE'),
             ('IN3_24', FIELDS['IN3_24'], (0, 1), 'FIE'),
             ('IN3_25', FIELDS['IN3_25'], (0, 1), 'FIE'),)),
    'MFA': ('sequence',
            (('MFA_1', FIELDS['MFA_1'], (1, 1), 'FIE'),
             ('MFA_2', FIELDS['MFA_2'], (0, 1), 'FIE'),
             ('MFA_3', FIELDS['MFA_3'], (0, 1), 'FIE'),
             ('MFA_4', FIELDS['MFA_4'], (1, 1), 'FIE'),
             ('MFA_5', FIELDS['MFA_5'], (1, -1), 'FIE'),)),
    'MFE': ('sequence',
            (('MFE_1', FIELDS['MFE_1'], (1, 1), 'FIE'),
             ('MFE_2', FIELDS['MFE_2'], (0, 1), 'FIE'),
             ('MFE_3', FIELDS['MFE_3'], (0, 1), 'FIE'),
             ('MFE_4', FIELDS['MFE_4'], (1, -1), 'FIE'),)),
    'MFI': ('sequence',
            (('MFI_1', FIELDS['MFI_1'], (1, 1), 'FIE'),
             ('MFI_2', FIELDS['MFI_2'], (0, 1), 'FIE'),
             ('MFI_3', FIELDS['MFI_3'], (1, 1), 'FIE'),
             ('MFI_4', FIELDS['MFI_4'], (0, 1), 'FIE'),
             ('MFI_5', FIELDS['MFI_5'], (0, 1), 'FIE'),
             ('MFI_6', FIELDS['MFI_6'], (1, 1), 'FIE'),)),
    'MRG': ('sequence',
            (('MRG_1', FIELDS['MRG_1'], (1, 1), 'FIE'),
             ('MRG_2', FIELDS['MRG_2'], (0, 1), 'FIE'),
             ('MRG_3', FIELDS['MRG_3'], (0, 1), 'FIE'),
             ('MRG_4', FIELDS['MRG_4'], (0, 1), 'FIE'),)),
    'MSA': ('sequence',
            (('MSA_1', FIELDS['MSA_1'], (1, 1), 'FIE'),
             ('MSA_2', FIELDS['MSA_2'], (1, 1), 'FIE'),
             ('MSA_3', FIELDS['MSA_3'], (0, 1), 'FIE'),
             ('MSA_4', FIELDS['MSA_4'], (0, 1), 'FIE'),
             ('MSA_5', FIELDS['MSA_5'], (0, 1), 'FIE'),
             ('MSA_6', FIELDS['MSA_6'], (0, 1), 'FIE'),)),
    'MSH': ('sequence',
            (('MSH_1', FIELDS['MSH_1'], (1, 1), 'FIE'),
             ('MSH_2', FIELDS['MSH_2'], (1, 1), 'FIE'),
             ('MSH_3', FIELDS['MSH_3'], (0, 1), 'FIE'),
             ('MSH_4', FIELDS['MSH_4'], (0, 1), 'FIE'),
             ('MSH_5', FIELDS['MSH_5'], (0, 1), 'FIE'),
             ('MSH_6', FIELDS['MSH_6'], (0, 1), 'FIE'),
             ('MSH_7', FIELDS['MSH_7'], (0, 1), 'FIE'),
             ('MSH_8', FIELDS['MSH_8'], (0, 1), 'FIE'),
             ('MSH_9', FIELDS['MSH_9'], (1, 1), 'FIE'),
             ('MSH_10', FIELDS['MSH_10'], (1, 1), 'FIE'),
             ('MSH_11', FIELDS['MSH_11'], (1, 1), 'FIE'),
             ('MSH_12', FIELDS['MSH_12'], (1, 1), 'FIE'),
             ('MSH_13', FIELDS['MSH_13'], (0, 1), 'FIE'),
             ('MSH_14', FIELDS['MSH_14'], (0, 1), 'FIE'),
             ('MSH_15', FIELDS['MSH_15'], (0, 1), 'FIE'),
             ('MSH_16', FIELDS['MSH_16'], (0, 1), 'FIE'),
             ('MSH_17', FIELDS['MSH_17'], (0, 1), 'FIE'),)),
    'NCK': ('sequence',
            (('NCK_1', FIELDS['NCK_1'], (1, 1), 'FIE'),)),
    'NK1': ('sequence',
            (('NK1_1', FIELDS['NK1_1'], (1, 1), 'FIE'),
             ('NK1_2', FIELDS['NK1_2'], (0, 1), 'FIE'),
             ('NK1_3', FIELDS['NK1_3'], (0, 1), 'FIE'),
             ('NK1_4', FIELDS['NK1_4'], (0, 1), 'FIE'),
             ('NK1_5', FIELDS['NK1_5'], (0, -1), 'FIE'),
             ('NK1_6', FIELDS['NK1_6'], (0, 1), 'FIE'),
             ('NK1_7', FIELDS['NK1_7'], (0, 1), 'FIE'),
             ('NK1_8', FIELDS['NK1_8'], (0, 1), 'FIE'),
             ('NK1_9', FIELDS['NK1_9'], (0, 1), 'FIE'),
             ('NK1_10', FIELDS['NK1_10'], (0, 1), 'FIE'),
             ('NK1_11', FIELDS['NK1_11'], (0, 1), 'FIE'),
             ('NK1_12', FIELDS['NK1_12'], (0, 1), 'FIE'),
             ('NK1_13', FIELDS['NK1_13'], (0, 1), 'FIE'),)),
    'NPU': ('sequence',
            (('NPU_1', FIELDS['NPU_1'], (1, 1), 'FIE'),
             ('NPU_2', FIELDS['NPU_2'], (0, 1), 'FIE'),)),
    'NSC': ('sequence',
            (('NSC_1', FIELDS['NSC_1'], (1, 1), 'FIE'),
             ('NSC_2', FIELDS['NSC_2'], (0, 1), 'FIE'),
             ('NSC_3', FIELDS['NSC_3'], (0, 1), 'FIE'),
             ('NSC_4', FIELDS['NSC_4'], (0, 1), 'FIE'),
             ('NSC_5', FIELDS['NSC_5'], (0, 1), 'FIE'),
             ('NSC_6', FIELDS['NSC_6'], (0, 1), 'FIE'),
             ('NSC_7', FIELDS['NSC_7'], (0, 1), 'FIE'),
             ('NSC_8', FIELDS['NSC_8'], (0, 1), 'FIE'),
             ('NSC_9', FIELDS['NSC_9'], (0, 1), 'FIE'),)),
    'NST': ('sequence',
            (('NST_1', FIELDS['NST_1'], (1, 1), 'FIE'),
             ('NST_2', FIELDS['NST_2'], (0, 1), 'FIE'),
             ('NST_3', FIELDS['NST_3'], (0, 1), 'FIE'),
             ('NST_4', FIELDS['NST_4'], (0, 1), 'FIE'),
             ('NST_5', FIELDS['NST_5'], (0, 1), 'FIE'),
             ('NST_6', FIELDS['NST_6'], (0, 1), 'FIE'),
             ('NST_7', FIELDS['NST_7'], (0, 1), 'FIE'),
             ('NST_8', FIELDS['NST_8'], (0, 1), 'FIE'),
             ('NST_9', FIELDS['NST_9'], (0, 1), 'FIE'),
             ('NST_10', FIELDS['NST_10'], (0, 1), 'FIE'),
             ('NST_11', FIELDS['NST_11'], (0, 1), 'FIE'),
             ('NST_12', FIELDS['NST_12'], (0, 1), 'FIE'),
             ('NST_13', FIELDS['NST_13'], (0, 1), 'FIE'),
             ('NST_14', FIELDS['NST_14'], (0, 1), 'FIE'),
             ('NST_15', FIELDS['NST_15'], (0, 1), 'FIE'),)),
    'NTE': ('sequence',
            (('NTE_1', FIELDS['NTE_1'], (0, 1), 'FIE'),
             ('NTE_2', FIELDS['NTE_2'], (0, 1), 'FIE'),
             ('NTE_3', FIELDS['NTE_3'], (0, -1), 'FIE'),)),
    'OBR': ('sequence',
            (('OBR_1', FIELDS['OBR_1'], (0, 1), 'FIE'),
             ('OBR_2', FIELDS['OBR_2'], (0, 1), 'FIE'),
             ('OBR_3', FIELDS['OBR_3'], (0, 1), 'FIE'),
             ('OBR_4', FIELDS['OBR_4'], (1, 1), 'FIE'),
             ('OBR_5', FIELDS['OBR_5'], (0, 1), 'FIE'),
             ('OBR_6', FIELDS['OBR_6'], (0, 1), 'FIE'),
             ('OBR_7', FIELDS['OBR_7'], (0, 1), 'FIE'),
             ('OBR_8', FIELDS['OBR_8'], (0, 1), 'FIE'),
             ('OBR_9', FIELDS['OBR_9'], (0, 1), 'FIE'),
             ('OBR_10', FIELDS['OBR_10'], (0, -1), 'FIE'),
             ('OBR_11', FIELDS['OBR_11'], (0, 1), 'FIE'),
             ('OBR_12', FIELDS['OBR_12'], (0, 1), 'FIE'),
             ('OBR_13', FIELDS['OBR_13'], (0, 1), 'FIE'),
             ('OBR_14', FIELDS['OBR_14'], (0, 1), 'FIE'),
             ('OBR_15', FIELDS['OBR_15'], (0, 1), 'FIE'),
             ('OBR_16', FIELDS['OBR_16'], (0, 1), 'FIE'),
             ('OBR_17', FIELDS['OBR_17'], (0, -1), 'FIE'),
             ('OBR_18', FIELDS['OBR_18'], (0, 1), 'FIE'),
             ('OBR_19', FIELDS['OBR_19'], (0, 1), 'FIE'),
             ('OBR_20', FIELDS['OBR_20'], (0, 1), 'FIE'),
             ('OBR_21', FIELDS['OBR_21'], (0, 1), 'FIE'),
             ('OBR_22', FIELDS['OBR_22'], (0, 1), 'FIE'),
             ('OBR_23', FIELDS['OBR_23'], (0, 1), 'FIE'),
             ('OBR_24', FIELDS['OBR_24'], (0, 1), 'FIE'),
             ('OBR_25', FIELDS['OBR_25'], (0, 1), 'FIE'),
             ('OBR_26', FIELDS['OBR_26'], (0, 1), 'FIE'),
             ('OBR_27', FIELDS['OBR_27'], (0, -1), 'FIE'),
             ('OBR_28', FIELDS['OBR_28'], (0, -1), 'FIE'),
             ('OBR_29', FIELDS['OBR_29'], (0, 1), 'FIE'),
             ('OBR_30', FIELDS['OBR_30'], (0, 1), 'FIE'),
             ('OBR_31', FIELDS['OBR_31'], (0, -1), 'FIE'),
             ('OBR_32', FIELDS['OBR_32'], (0, 1), 'FIE'),
             ('OBR_33', FIELDS['OBR_33'], (0, -1), 'FIE'),
             ('OBR_34', FIELDS['OBR_34'], (0, -1), 'FIE'),
             ('OBR_35', FIELDS['OBR_35'], (0, -1), 'FIE'),
             ('OBR_36', FIELDS['OBR_36'], (0, 1), 'FIE'),)),
    'OBX': ('sequence',
            (('OBX_1', FIELDS['OBX_1'], (0, 1), 'FIE'),
             ('OBX_2', FIELDS['OBX_2'], (1, 1), 'FIE'),
             ('OBX_3', FIELDS['OBX_3'], (1, 1), 'FIE'),
             ('OBX_4', FIELDS['OBX_4'], (0, 1), 'FIE'),
             ('OBX_5', FIELDS['OBX_5'], (0, 1), 'FIE'),
             ('OBX_6', FIELDS['OBX_6'], (0, 1), 'FIE'),
             ('OBX_7', FIELDS['OBX_7'], (0, 1), 'FIE'),
             ('OBX_8', FIELDS['OBX_8'], (0, -1), 'FIE'),
             ('OBX_9', FIELDS['OBX_9'], (0, 1), 'FIE'),
             ('OBX_10', FIELDS['OBX_10'], (0, 1), 'FIE'),
             ('OBX_11', FIELDS['OBX_11'], (1, 1), 'FIE'),
             ('OBX_12', FIELDS['OBX_12'], (0, 1), 'FIE'),
             ('OBX_13', FIELDS['OBX_13'], (0, 1), 'FIE'),
             ('OBX_14', FIELDS['OBX_14'], (0, 1), 'FIE'),
             ('OBX_15', FIELDS['OBX_15'], (0, 1), 'FIE'),
             ('OBX_16', FIELDS['OBX_16'], (0, 1), 'FIE'),)),
    'ODS': ('sequence',
            (('ODS_1', FIELDS['ODS_1'], (1, 1), 'FIE'),
             ('ODS_2', FIELDS['ODS_2'], (0, -1), 'FIE'),
             ('ODS_3', FIELDS['ODS_3'], (1, -1), 'FIE'),
             ('ODS_4', FIELDS['ODS_4'], (0, -1), 'FIE'),)),
    'ODT': ('sequence',
            (('ODT_1', FIELDS['ODT_1'], (1, 1), 'FIE'),
             ('ODT_2', FIELDS['ODT_2'], (0, -1), 'FIE'),
             ('ODT_3', FIELDS['ODT_3'], (0, -1), 'FIE'),)),
    'OM1': ('sequence',
            (('OM1_1', FIELDS['OM1_1'], (0, 1), 'FIE'),
             ('OM1_2', FIELDS['OM1_2'], (0, 1), 'FIE'),
             ('OM1_3', FIELDS['OM1_3'], (1, 1), 'FIE'),
             ('OM1_4', FIELDS['OM1_4'], (0, -1), 'FIE'),
             ('OM1_5', FIELDS['OM1_5'], (1, 1), 'FIE'),
             ('OM1_6', FIELDS['OM1_6'], (1, 1), 'FIE'),
             ('OM1_7', FIELDS['OM1_7'], (0, 1), 'FIE'),
             ('OM1_8', FIELDS['OM1_8'], (0, 1), 'FIE'),
             ('OM1_9', FIELDS['OM1_9'], (1, -1), 'FIE'),
             ('OM1_10', FIELDS['OM1_10'], (0, 1), 'FIE'),
             ('OM1_11', FIELDS['OM1_11'], (0, 1), 'FIE'),
             ('OM1_12', FIELDS['OM1_12'], (0, 1), 'FIE'),
             ('OM1_13', FIELDS['OM1_13'], (0, 1), 'FIE'),
             ('OM1_14', FIELDS['OM1_14'], (0, -1), 'FIE'),
             ('OM1_15', FIELDS['OM1_15'], (0, -1), 'FIE'),
             ('OM1_16', FIELDS['OM1_16'], (0, 1), 'FIE'),
             ('OM1_17', FIELDS['OM1_17'], (0, -1), 'FIE'),
             ('OM1_18', FIELDS['OM1_18'], (0, 1), 'FIE'),
             ('OM1_19', FIELDS['OM1_19'], (1, 1), 'FIE'),
             ('OM1_20', FIELDS['OM1_20'], (0, 1), 'FIE'),
             ('OM1_21', FIELDS['OM1_21'], (0, 1), 'FIE'),
             ('OM1_22', FIELDS['OM1_22'], (1, 1), 'FIE'),
             ('OM1_23', FIELDS['OM1_23'], (0, 1), 'FIE'),
             ('OM1_24', FIELDS['OM1_24'], (0, 1), 'FIE'),
             ('OM1_25', FIELDS['OM1_25'], (0, 1), 'FIE'),
             ('OM1_26', FIELDS['OM1_26'], (0, -1), 'FIE'),
             ('OM1_27', FIELDS['OM1_27'], (0, 1), 'FIE'),
             ('OM1_28', FIELDS['OM1_28'], (0, -1), 'FIE'),
             ('OM1_29', FIELDS['OM1_29'], (0, -1), 'FIE'),
             ('OM1_30', FIELDS['OM1_30'], (0, -1), 'FIE'),
             ('OM1_31', FIELDS['OM1_31'], (0, 1), 'FIE'),
             ('OM1_32', FIELDS['OM1_32'], (0, -1), 'FIE'),
             ('OM1_33', FIELDS['OM1_33'], (0, 1), 'FIE'),
             ('OM1_34', FIELDS['OM1_34'], (0, -1), 'FIE'),
             ('OM1_35', FIELDS['OM1_35'], (0, -1), 'FIE'),
             ('OM1_36', FIELDS['OM1_36'], (0, 1), 'FIE'),
             ('OM1_37', FIELDS['OM1_37'], (0, -1), 'FIE'),
             ('OM1_38', FIELDS['OM1_38'], (0, 1), 'FIE'),
             ('OM1_39', FIELDS['OM1_39'], (0, 1), 'FIE'),
             ('OM1_40', FIELDS['OM1_40'], (0, 1), 'FIE'),
             ('OM1_41', FIELDS['OM1_41'], (0, -1), 'FIE'),
             ('OM1_42', FIELDS['OM1_42'], (0, 1), 'FIE'),)),
    'OM2': ('sequence',
            (('OM2_1', FIELDS['OM2_1'], (0, 1), 'FIE'),
             ('OM2_2', FIELDS['OM2_2'], (0, 1), 'FIE'),
             ('OM2_3', FIELDS['OM2_3'], (0, 1), 'FIE'),
             ('OM2_4', FIELDS['OM2_4'], (0, 1), 'FIE'),
             ('OM2_5', FIELDS['OM2_5'], (0, 1), 'FIE'),
             ('OM2_6', FIELDS['OM2_6'], (1, -1), 'FIE'),
             ('OM2_7', FIELDS['OM2_7'], (0, -1), 'FIE'),
             ('OM2_8', FIELDS['OM2_8'], (0, 1), 'FIE'),
             ('OM2_9', FIELDS['OM2_9'], (0, 1), 'FIE'),
             ('OM2_10', FIELDS['OM2_10'], (0, -1), 'FIE'),
             ('OM2_11', FIELDS['OM2_11'], (0, 1), 'FIE'),)),
    'OM3': ('sequence',
            (('OM3_1', FIELDS['OM3_1'], (0, 1), 'FIE'),
             ('OM3_2', FIELDS['OM3_2'], (0, 1), 'FIE'),
             ('OM3_3', FIELDS['OM3_3'], (0, 1), 'FIE'),
             ('OM3_4', FIELDS['OM3_4'], (0, -1), 'FIE'),
             ('OM3_5', FIELDS['OM3_5'], (0, -1), 'FIE'),
             ('OM3_6', FIELDS['OM3_6'], (0, 1), 'FIE'),
             ('OM3_7', FIELDS['OM3_7'], (0, 1), 'FIE'),
             ('OM3_8', FIELDS['OM3_8'], (0, 1), 'FIE'),)),
    'OM4': ('sequence',
            (('OM4_1', FIELDS['OM4_1'], (0, 1), 'FIE'),
             ('OM4_2', FIELDS['OM4_2'], (0, 1), 'FIE'),
             ('OM4_3', FIELDS['OM4_3'], (0, 1), 'FIE'),
             ('OM4_4', FIELDS['OM4_4'], (0, 1), 'FIE'),
             ('OM4_5', FIELDS['OM4_5'], (0, 1), 'FIE'),
             ('OM4_6', FIELDS['OM4_6'], (0, 1), 'FIE'),
             ('OM4_7', FIELDS['OM4_7'], (0, 1), 'FIE'),
             ('OM4_8', FIELDS['OM4_8'], (0, 1), 'FIE'),
             ('OM4_9', FIELDS['OM4_9'], (0, 1), 'FIE'),
             ('OM4_10', FIELDS['OM4_10'], (0, 1), 'FIE'),
             ('OM4_11', FIELDS['OM4_11'], (0, 1), 'FIE'),
             ('OM4_12', FIELDS['OM4_12'], (0, 1), 'FIE'),
             ('OM4_13', FIELDS['OM4_13'], (0, 1), 'FIE'),
             ('OM4_14', FIELDS['OM4_14'], (0, -1), 'FIE'),
             ('OM4_15', FIELDS['OM4_15'], (0, 1), 'FIE'),)),
    'OM5': ('sequence',
            (('OM5_1', FIELDS['OM5_1'], (0, 1), 'FIE'),
             ('OM5_2', FIELDS['OM5_2'], (0, 1), 'FIE'),
             ('OM5_3', FIELDS['OM5_3'], (0, -1), 'FIE'),
             ('OM5_4', FIELDS['OM5_4'], (0, 1), 'FIE'),)),
    'OM6': ('sequence',
            (('OM6_1', FIELDS['OM6_1'], (0, 1), 'FIE'),
             ('OM6_2', FIELDS['OM6_2'], (0, 1), 'FIE'),
             ('OM6_3', FIELDS['OM6_3'], (0, 1), 'FIE'),)),
    'ORC': ('sequence',
            (('ORC_1', FIELDS['ORC_1'], (1, 1), 'FIE'),
             ('ORC_2', FIELDS['ORC_2'], (0, 1), 'FIE'),
             ('ORC_3', FIELDS['ORC_3'], (0, 1), 'FIE'),
             ('ORC_4', FIELDS['ORC_4'], (0, 1), 'FIE'),
             ('ORC_5', FIELDS['ORC_5'], (0, 1), 'FIE'),
             ('ORC_6', FIELDS['ORC_6'], (0, 1), 'FIE'),
             ('ORC_7', FIELDS['ORC_7'], (0, -1), 'FIE'),
             ('ORC_8', FIELDS['ORC_8'], (0, 1), 'FIE'),
             ('ORC_9', FIELDS['ORC_9'], (0, 1), 'FIE'),
             ('ORC_10', FIELDS['ORC_10'], (0, 1), 'FIE'),
             ('ORC_11', FIELDS['ORC_11'], (0, 1), 'FIE'),
             ('ORC_12', FIELDS['ORC_12'], (0, 1), 'FIE'),
             ('ORC_13', FIELDS['ORC_13'], (0, 1), 'FIE'),
             ('ORC_14', FIELDS['ORC_14'], (0, -1), 'FIE'),
             ('ORC_15', FIELDS['ORC_15'], (0, 1), 'FIE'),
             ('ORC_16', FIELDS['ORC_16'], (0, 1), 'FIE'),
             ('ORC_17', FIELDS['ORC_17'], (0, 1), 'FIE'),
             ('ORC_18', FIELDS['ORC_18'], (0, 1), 'FIE'),
             ('ORC_19', FIELDS['ORC_19'], (0, 1), 'FIE'),)),
    'PID': ('sequence',
            (('PID_1', FIELDS['PID_1'], (0, 1), 'FIE'),
             ('PID_2', FIELDS['PID_2'], (0, 1), 'FIE'),
             ('PID_3', FIELDS['PID_3'], (1, -1), 'FIE'),
             ('PID_4', FIELDS['PID_4'], (0, 1), 'FIE'),
             ('PID_5', FIELDS['PID_5'], (1, 1), 'FIE'),
             ('PID_6', FIELDS['PID_6'], (0, 1), 'FIE'),
             ('PID_7', FIELDS['PID_7'], (0, 1), 'FIE'),
             ('PID_8', FIELDS['PID_8'], (0, 1), 'FIE'),
             ('PID_9', FIELDS['PID_9'], (0, -1), 'FIE'),
             ('PID_10', FIELDS['PID_10'], (0, 1), 'FIE'),
             ('PID_11', FIELDS['PID_11'], (0, -1), 'FIE'),
             ('PID_12', FIELDS['PID_12'], (0, 1), 'FIE'),
             ('PID_13', FIELDS['PID_13'], (0, -1), 'FIE'),
             ('PID_14', FIELDS['PID_14'], (0, -1), 'FIE'),
             ('PID_15', FIELDS['PID_15'], (0, 1), 'FIE'),
             ('PID_16', FIELDS['PID_16'], (0, 1), 'FIE'),
             ('PID_17', FIELDS['PID_17'], (0, 1), 'FIE'),
             ('PID_18', FIELDS['PID_18'], (0, 1), 'FIE'),
             ('PID_19', FIELDS['PID_19'], (0, 1), 'FIE'),
             ('PID_20', FIELDS['PID_20'], (0, 1), 'FIE'),
             ('PID_21', FIELDS['PID_21'], (0, 1), 'FIE'),
             ('PID_22', FIELDS['PID_22'], (0, 1), 'FIE'),
             ('PID_23', FIELDS['PID_23'], (0, 1), 'FIE'),
             ('PID_24', FIELDS['PID_24'], (0, 1), 'FIE'),
             ('PID_25', FIELDS['PID_25'], (0, 1), 'FIE'),
             ('PID_26', FIELDS['PID_26'], (0, -1), 'FIE'),
             ('PID_27', FIELDS['PID_27'], (0, 1), 'FIE'),)),
    'PR1': ('sequence',
            (('PR1_1', FIELDS['PR1_1'], (1, 1), 'FIE'),
             ('PR1_2', FIELDS['PR1_2'], (1, -1), 'FIE'),
             ('PR1_3', FIELDS['PR1_3'], (1, -1), 'FIE'),
             ('PR1_4', FIELDS['PR1_4'], (0, -1), 'FIE'),
             ('PR1_5', FIELDS['PR1_5'], (1, 1), 'FIE'),
             ('PR1_6', FIELDS['PR1_6'], (1, 1), 'FIE'),
             ('PR1_7', FIELDS['PR1_7'], (0, 1), 'FIE'),
             ('PR1_8', FIELDS['PR1_8'], (0, 1), 'FIE'),
             ('PR1_9', FIELDS['PR1_9'], (0, 1), 'FIE'),
             ('PR1_10', FIELDS['PR1_10'], (0, 1), 'FIE'),
             ('PR1_11', FIELDS['PR1_11'], (0, 1), 'FIE'),
             ('PR1_12', FIELDS['PR1_12'], (0, -1), 'FIE'),
             ('PR1_13', FIELDS['PR1_13'], (0, 1), 'FIE'),
             ('PR1_14', FIELDS['PR1_14'], (0, 1), 'FIE'),)),
    'PRA': ('sequence',
            (('PRA_1', FIELDS['PRA_1'], (1, 1), 'FIE'),
             ('PRA_2', FIELDS['PRA_2'], (0, -1), 'FIE'),
             ('PRA_3', FIELDS['PRA_3'], (0, -1), 'FIE'),
             ('PRA_4', FIELDS['PRA_4'], (0, 1), 'FIE'),
             ('PRA_5', FIELDS['PRA_5'], (0, -1), 'FIE'),
             ('PRA_6', FIELDS['PRA_6'], (0, -1), 'FIE'),
             ('PRA_7', FIELDS['PRA_7'], (0, -1), 'FIE'),)),
    'PV1': ('sequence',
            (('PV1_1', FIELDS['PV1_1'], (0, 1), 'FIE'),
             ('PV1_2', FIELDS['PV1_2'], (1, 1), 'FIE'),
             ('PV1_3', FIELDS['PV1_3'], (0, 1), 'FIE'),
             ('PV1_4', FIELDS['PV1_4'], (0, 1), 'FIE'),
             ('PV1_5', FIELDS['PV1_5'], (0, 1), 'FIE'),
             ('PV1_6', FIELDS['PV1_6'], (0, 1), 'FIE'),
             ('PV1_7', FIELDS['PV1_7'], (0, 1), 'FIE'),
             ('PV1_8', FIELDS['PV1_8'], (0, 1), 'FIE'),
             ('PV1_9', FIELDS['PV1_9'], (0, -1), 'FIE'),
             ('PV1_10', FIELDS['PV1_10'], (0, 1), 'FIE'),
             ('PV1_11', FIELDS['PV1_11'], (0, 1), 'FIE'),
             ('PV1_12', FIELDS['PV1_12'], (0, 1), 'FIE'),
             ('PV1_13', FIELDS['PV1_13'], (0, 1), 'FIE'),
             ('PV1_14', FIELDS['PV1_14'], (0, 1), 'FIE'),
             ('PV1_15', FIELDS['PV1_15'], (0, -1), 'FIE'),
             ('PV1_16', FIELDS['PV1_16'], (0, 1), 'FIE'),
             ('PV1_17', FIELDS['PV1_17'], (0, 1), 'FIE'),
             ('PV1_18', FIELDS['PV1_18'], (0, 1), 'FIE'),
             ('PV1_19', FIELDS['PV1_19'], (0, 1), 'FIE'),
             ('PV1_20', FIELDS['PV1_20'], (0, -1), 'FIE'),
             ('PV1_21', FIELDS['PV1_21'], (0, 1), 'FIE'),
             ('PV1_22', FIELDS['PV1_22'], (0, 1), 'FIE'),
             ('PV1_23', FIELDS['PV1_23'], (0, 1), 'FIE'),
             ('PV1_24', FIELDS['PV1_24'], (0, -1), 'FIE'),
             ('PV1_25', FIELDS['PV1_25'], (0, -1), 'FIE'),
             ('PV1_26', FIELDS['PV1_26'], (0, -1), 'FIE'),
             ('PV1_27', FIELDS['PV1_27'], (0, -1), 'FIE'),
             ('PV1_28', FIELDS['PV1_28'], (0, 1), 'FIE'),
             ('PV1_29', FIELDS['PV1_29'], (0, 1), 'FIE'),
             ('PV1_30', FIELDS['PV1_30'], (0, 1), 'FIE'),
             ('PV1_31', FIELDS['PV1_31'], (0, 1), 'FIE'),
             ('PV1_32', FIELDS['PV1_32'], (0, 1), 'FIE'),
             ('PV1_33', FIELDS['PV1_33'], (0, 1), 'FIE'),
             ('PV1_34', FIELDS['PV1_34'], (0, 1), 'FIE'),
             ('PV1_35', FIELDS['PV1_35'], (0, 1), 'FIE'),
             ('PV1_36', FIELDS['PV1_36'], (0, 1), 'FIE'),
             ('PV1_37', FIELDS['PV1_37'], (0, 1), 'FIE'),
             ('PV1_38', FIELDS['PV1_38'], (0, 1), 'FIE'),
             ('PV1_39', FIELDS['PV1_39'], (0, 1), 'FIE'),
             ('PV1_40', FIELDS['PV1_40'], (0, 1), 'FIE'),
             ('PV1_41', FIELDS['PV1_41'], (0, 1), 'FIE'),
             ('PV1_42', FIELDS['PV1_42'], (0, 1), 'FIE'),
             ('PV1_43', FIELDS['PV1_43'], (0, 1), 'FIE'),
             ('PV1_44', FIELDS['PV1_44'], (0, 1), 'FIE'),
             ('PV1_45', FIELDS['PV1_45'], (0, 1), 'FIE'),
             ('PV1_46', FIELDS['PV1_46'], (0, 1), 'FIE'),
             ('PV1_47', FIELDS['PV1_47'], (0, 1), 'FIE'),
             ('PV1_48', FIELDS['PV1_48'], (0, 1), 'FIE'),
             ('PV1_49', FIELDS['PV1_49'], (0, 1), 'FIE'),
             ('PV1_50', FIELDS['PV1_50'], (0, 1), 'FIE'),)),
    'PV2': ('sequence',
            (('PV2_1', FIELDS['PV2_1'], (0, 1), 'FIE'),
             ('PV2_2', FIELDS['PV2_2'], (0, 1), 'FIE'),
             ('PV2_3', FIELDS['PV2_3'], (0, 1), 'FIE'),
             ('PV2_4', FIELDS['PV2_4'], (0, 1), 'FIE'),
             ('PV2_5', FIELDS['PV2_5'], (0, -1), 'FIE'),
             ('PV2_6', FIELDS['PV2_6'], (0, 1), 'FIE'),
             ('PV2_7', FIELDS['PV2_7'], (0, 1), 'FIE'),
             ('PV2_8', FIELDS['PV2_8'], (0, 1), 'FIE'),
             ('PV2_9', FIELDS['PV2_9'], (0, 1), 'FIE'),)),
    'QRD': ('sequence',
            (('QRD_1', FIELDS['QRD_1'], (1, 1), 'FIE'),
             ('QRD_2', FIELDS['QRD_2'], (1, 1), 'FIE'),
             ('QRD_3', FIELDS['QRD_3'], (1, 1), 'FIE'),
             ('QRD_4', FIELDS['QRD_4'], (1, 1), 'FIE'),
             ('QRD_5', FIELDS['QRD_5'], (0, 1), 'FIE'),
             ('QRD_6', FIELDS['QRD_6'], (0, 1), 'FIE'),
             ('QRD_7', FIELDS['QRD_7'], (1, 1), 'FIE'),
             ('QRD_8', FIELDS['QRD_8'], (1, -1), 'FIE'),
             ('QRD_9', FIELDS['QRD_9'], (1, -1), 'FIE'),
             ('QRD_10', FIELDS['QRD_10'], (1, -1), 'FIE'),
             ('QRD_11', FIELDS['QRD_11'], (0, -1), 'FIE'),
             ('QRD_12', FIELDS['QRD_12'], (0, 1), 'FIE'),)),
    'QRF': ('sequence',
            (('QRF_1', FIELDS['QRF_1'], (1, -1), 'FIE'),
             ('QRF_2', FIELDS['QRF_2'], (0, 1), 'FIE'),
             ('QRF_3', FIELDS['QRF_3'], (0, 1), 'FIE'),
             ('QRF_4', FIELDS['QRF_4'], (0, -1), 'FIE'),
             ('QRF_5', FIELDS['QRF_5'], (0, -1), 'FIE'),
             ('QRF_6', FIELDS['QRF_6'], (0, -1), 'FIE'),
             ('QRF_7', FIELDS['QRF_7'], (0, -1), 'FIE'),
             ('QRF_8', FIELDS['QRF_8'], (0, -1), 'FIE'),)),
    'RQ1': ('sequence',
            (('RQ1_1', FIELDS['RQ1_1'], (0, 1), 'FIE'),
             ('RQ1_2', FIELDS['RQ1_2'], (0, 1), 'FIE'),
             ('RQ1_3', FIELDS['RQ1_3'], (0, 1), 'FIE'),
             ('RQ1_4', FIELDS['RQ1_4'], (0, 1), 'FIE'),
             ('RQ1_5', FIELDS['RQ1_5'], (0, 1), 'FIE'),
             ('RQ1_6', FIELDS['RQ1_6'], (0, 1), 'FIE'),
             ('RQ1_7', FIELDS['RQ1_7'], (0, 1), 'FIE'),)),
    'RQD': ('sequence',
            (('RQD_1', FIELDS['RQD_1'], (0, 1), 'FIE'),
             ('RQD_2', FIELDS['RQD_2'], (0, 1), 'FIE'),
             ('RQD_3', FIELDS['RQD_3'], (0, 1), 'FIE'),
             ('RQD_4', FIELDS['RQD_4'], (0, 1), 'FIE'),
             ('RQD_5', FIELDS['RQD_5'], (0, 1), 'FIE'),
             ('RQD_6', FIELDS['RQD_6'], (0, 1), 'FIE'),
             ('RQD_7', FIELDS['RQD_7'], (0, 1), 'FIE'),
             ('RQD_8', FIELDS['RQD_8'], (0, 1), 'FIE'),
             ('RQD_9', FIELDS['RQD_9'], (0, 1), 'FIE'),
             ('RQD_10', FIELDS['RQD_10'], (0, 1), 'FIE'),)),
    'RXA': ('sequence',
            (('RXA_1', FIELDS['RXA_1'], (1, 1), 'FIE'),
             ('RXA_2', FIELDS['RXA_2'], (1, 1), 'FIE'),
             ('RXA_3', FIELDS['RXA_3'], (1, 1), 'FIE'),
             ('RXA_4', FIELDS['RXA_4'], (1, 1), 'FIE'),
             ('RXA_5', FIELDS['RXA_5'], (1, 1), 'FIE'),
             ('RXA_6', FIELDS['RXA_6'], (1, 1), 'FIE'),
             ('RXA_7', FIELDS['RXA_7'], (0, 1), 'FIE'),
             ('RXA_8', FIELDS['RXA_8'], (0, 1), 'FIE'),
             ('RXA_9', FIELDS['RXA_9'], (0, 1), 'FIE'),
             ('RXA_10', FIELDS['RXA_10'], (0, 1), 'FIE'),
             ('RXA_11', FIELDS['RXA_11'], (0, 1), 'FIE'),
             ('RXA_12', FIELDS['RXA_12'], (0, 1), 'FIE'),)),
    'RXC': ('sequence',
            (('RXC_1', FIELDS['RXC_1'], (1, 1), 'FIE'),
             ('RXC_2', FIELDS['RXC_2'], (1, 1), 'FIE'),
             ('RXC_3', FIELDS['RXC_3'], (1, 1), 'FIE'),
             ('RXC_4', FIELDS['RXC_4'], (1, 1), 'FIE'),)),
    'RXD': ('sequence',
            (('RXD_1', FIELDS['RXD_1'], (0, 1), 'FIE'),
             ('RXD_2', FIELDS['RXD_2'], (1, 1), 'FIE'),
             ('RXD_3', FIELDS['RXD_3'], (0, 1), 'FIE'),
             ('RXD_4', FIELDS['RXD_4'], (1, 1), 'FIE'),
             ('RXD_5', FIELDS['RXD_5'], (0, 1), 'FIE'),
             ('RXD_6', FIELDS['RXD_6'], (0, 1), 'FIE'),
             ('RXD_7', FIELDS['RXD_7'], (1, 1), 'FIE'),
             ('RXD_8', FIELDS['RXD_8'], (0, 1), 'FIE'),
             ('RXD_9', FIELDS['RXD_9'], (0, -1), 'FIE'),
             ('RXD_10', FIELDS['RXD_10'], (0, 1), 'FIE'),
             ('RXD_11', FIELDS['RXD_11'], (0, 1), 'FIE'),
             ('RXD_12', FIELDS['RXD_12'], (0, 1), 'FIE'),
             ('RXD_13', FIELDS['RXD_13'], (0, 1), 'FIE'),
             ('RXD_14', FIELDS['RXD_14'], (0, 1), 'FIE'),
             ('RXD_15', FIELDS['RXD_15'], (0, 1), 'FIE'),)),
    'RXE': ('sequence',
            (('RXE_1', FIELDS['RXE_1'], (0, -1), 'FIE'),
             ('RXE_2', FIELDS['RXE_2'], (1, 1), 'FIE'),
             ('RXE_3', FIELDS['RXE_3'], (1, 1), 'FIE'),
             ('RXE_4', FIELDS['RXE_4'], (0, 1), 'FIE'),
             ('RXE_5', FIELDS['RXE_5'], (1, 1), 'FIE'),
             ('RXE_6', FIELDS['RXE_6'], (0, 1), 'FIE'),
             ('RXE_7', FIELDS['RXE_7'], (0, -1), 'FIE'),
             ('RXE_8', FIELDS['RXE_8'], (0, 1), 'FIE'),
             ('RXE_9', FIELDS['RXE_9'], (0, 1), 'FIE'),
             ('RXE_10', FIELDS['RXE_10'], (0, 1), 'FIE'),
             ('RXE_11', FIELDS['RXE_11'], (0, 1), 'FIE'),
             ('RXE_12', FIELDS['RXE_12'], (0, 1), 'FIE'),
             ('RXE_13', FIELDS['RXE_13'], (0, 1), 'FIE'),
             ('RXE_14', FIELDS['RXE_14'], (0, 1), 'FIE'),
             ('RXE_15', FIELDS['RXE_15'], (1, 1), 'FIE'),
             ('RXE_16', FIELDS['RXE_16'], (0, 1), 'FIE'),
             ('RXE_17', FIELDS['RXE_17'], (0, 1), 'FIE'),
             ('RXE_18', FIELDS['RXE_18'], (0, 1), 'FIE'),
             ('RXE_19', FIELDS['RXE_19'], (0, 1), 'FIE'),
             ('RXE_20', FIELDS['RXE_20'], (0, 1), 'FIE'),
             ('RXE_21', FIELDS['RXE_21'], (0, 1), 'FIE'),
             ('RXE_22', FIELDS['RXE_22'], (0, 1), 'FIE'),
             ('RXE_23', FIELDS['RXE_23'], (0, 1), 'FIE'),
             ('RXE_24', FIELDS['RXE_24'], (0, 1), 'FIE'),)),
    'RXG': ('sequence',
            (('RXG_1', FIELDS['RXG_1'], (1, 1), 'FIE'),
             ('RXG_2', FIELDS['RXG_2'], (0, 1), 'FIE'),
             ('RXG_3', FIELDS['RXG_3'], (0, -1), 'FIE'),
             ('RXG_4', FIELDS['RXG_4'], (1, 1), 'FIE'),
             ('RXG_5', FIELDS['RXG_5'], (1, 1), 'FIE'),
             ('RXG_6', FIELDS['RXG_6'], (0, 1), 'FIE'),
             ('RXG_7', FIELDS['RXG_7'], (1, 1), 'FIE'),
             ('RXG_8', FIELDS['RXG_8'], (0, 1), 'FIE'),
             ('RXG_9', FIELDS['RXG_9'], (0, 1), 'FIE'),
             ('RXG_10', FIELDS['RXG_10'], (0, 1), 'FIE'),
             ('RXG_11', FIELDS['RXG_11'], (0, 1), 'FIE'),
             ('RXG_12', FIELDS['RXG_12'], (0, 1), 'FIE'),
             ('RXG_13', FIELDS['RXG_13'], (0, -1), 'FIE'),
             ('RXG_14', FIELDS['RXG_14'], (0, 1), 'FIE'),
             ('RXG_15', FIELDS['RXG_15'], (0, 1), 'FIE'),
             ('RXG_16', FIELDS['RXG_16'], (0, 1), 'FIE'),)),
    'RXO': ('sequence',
            (('RXO_1', FIELDS['RXO_1'], (1, 1), 'FIE'),
             ('RXO_2', FIELDS['RXO_2'], (1, 1), 'FIE'),
             ('RXO_3', FIELDS['RXO_3'], (0, 1), 'FIE'),
             ('RXO_4', FIELDS['RXO_4'], (1, 1), 'FIE'),
             ('RXO_5', FIELDS['RXO_5'], (0, 1), 'FIE'),
             ('RXO_6', FIELDS['RXO_6'], (0, -1), 'FIE'),
             ('RXO_7', FIELDS['RXO_7'], (0, -1), 'FIE'),
             ('RXO_8', FIELDS['RXO_8'], (0, 1), 'FIE'),
             ('RXO_9', FIELDS['RXO_9'], (0, 1), 'FIE'),
             ('RXO_10', FIELDS['RXO_10'], (0, 1), 'FIE'),
             ('RXO_11', FIELDS['RXO_11'], (0, 1), 'FIE'),
             ('RXO_12', FIELDS['RXO_12'], (0, 1), 'FIE'),
             ('RXO_13', FIELDS['RXO_13'], (0, 1), 'FIE'),
             ('RXO_14', FIELDS['RXO_14'], (0, 1), 'FIE'),
             ('RXO_15', FIELDS['RXO_15'], (0, 1), 'FIE'),
             ('RXO_16', FIELDS['RXO_16'], (0, 1), 'FIE'),
             ('RXO_17', FIELDS['RXO_17'], (0, 1), 'FIE'),)),
    'RXR': ('sequence',
            (('RXR_1', FIELDS['RXR_1'], (1, 1), 'FIE'),
             ('RXR_2', FIELDS['RXR_2'], (0, 1), 'FIE'),
             ('RXR_3', FIELDS['RXR_3'], (0, 1), 'FIE'),
             ('RXR_4', FIELDS['RXR_4'], (0, 1), 'FIE'),)),
    'STF': ('sequence',
            (('STF_1', FIELDS['STF_1'], (1, 1), 'FIE'),
             ('STF_2', FIELDS['STF_2'], (0, -1), 'FIE'),
             ('STF_3', FIELDS['STF_3'], (0, 1), 'FIE'),
             ('STF_4', FIELDS['STF_4'], (0, -1), 'FIE'),
             ('STF_5', FIELDS['STF_5'], (0, 1), 'FIE'),
             ('STF_6', FIELDS['STF_6'], (0, 1), 'FIE'),
             ('STF_7', FIELDS['STF_7'], (0, 1), 'FIE'),
             ('STF_8', FIELDS['STF_8'], (0, -1), 'FIE'),
             ('STF_9', FIELDS['STF_9'], (0, -1), 'FIE'),
             ('STF_10', FIELDS['STF_10'], (0, -1), 'FIE'),
             ('STF_11', FIELDS['STF_11'], (0, -1), 'FIE'),
             ('STF_12', FIELDS['STF_12'], (0, -1), 'FIE'),
             ('STF_13', FIELDS['STF_13'], (0, -1), 'FIE'),
             ('STF_14', FIELDS['STF_14'], (0, -1), 'FIE'),
             ('STF_15', FIELDS['STF_15'], (0, -1), 'FIE'),
             ('STF_16', FIELDS['STF_16'], (0, 1), 'FIE'),)),
    'UB1': ('sequence',
            (('UB1_1', FIELDS['UB1_1'], (0, 1), 'FIE'),
             ('UB1_2', FIELDS['UB1_2'], (0, 1), 'FIE'),
             ('UB1_3', FIELDS['UB1_3'], (0, 1), 'FIE'),
             ('UB1_4', FIELDS['UB1_4'], (0, 1), 'FIE'),
             ('UB1_5', FIELDS['UB1_5'], (0, 1), 'FIE'),
             ('UB1_6', FIELDS['UB1_6'], (0, 1), 'FIE'),
             ('UB1_7', FIELDS['UB1_7'], (0, -1), 'FIE'),
             ('UB1_8', FIELDS['UB1_8'], (0, 1), 'FIE'),
             ('UB1_9', FIELDS['UB1_9'], (0, 1), 'FIE'),
             ('UB1_10', FIELDS['UB1_10'], (0, -1), 'FIE'),
             ('UB1_11', FIELDS['UB1_11'], (0, 1), 'FIE'),
             ('UB1_12', FIELDS['UB1_12'], (0, 1), 'FIE'),
             ('UB1_13', FIELDS['UB1_13'], (0, 1), 'FIE'),
             ('UB1_14', FIELDS['UB1_14'], (0, 1), 'FIE'),
             ('UB1_15', FIELDS['UB1_15'], (0, 1), 'FIE'),
             ('UB1_16', FIELDS['UB1_16'], (0, -1), 'FIE'),
             ('UB1_17', FIELDS['UB1_17'], (0, 1), 'FIE'),
             ('UB1_18', FIELDS['UB1_18'], (0, 1), 'FIE'),
             ('UB1_19', FIELDS['UB1_19'], (0, 1), 'FIE'),
             ('UB1_20', FIELDS['UB1_20'], (0, 1), 'FIE'),
             ('UB1_21', FIELDS['UB1_21'], (0, 1), 'FIE'),
             ('UB1_22', FIELDS['UB1_22'], (0, 1), 'FIE'),
             ('UB1_23', FIELDS['UB1_23'], (0, 1), 'FIE'),)),
    'UB2': ('sequence',
            (('UB2_1', FIELDS['UB2_1'], (0, 1), 'FIE'),
             ('UB2_2', FIELDS['UB2_2'], (0, 1), 'FIE'),
             ('UB2_3', FIELDS['UB2_3'], (0, -1), 'FIE'),
             ('UB2_4', FIELDS['UB2_4'], (0, 1), 'FIE'),
             ('UB2_5', FIELDS['UB2_5'], (0, 1), 'FIE'),
             ('UB2_6', FIELDS['UB2_6'], (0, -1), 'FIE'),
             ('UB2_7', FIELDS['UB2_7'], (0, -1), 'FIE'),
             ('UB2_8', FIELDS['UB2_8'], (0, -1), 'FIE'),
             ('UB2_9', FIELDS['UB2_9'], (0, -1), 'FIE'),
             ('UB2_10', FIELDS['UB2_10'], (0, -1), 'FIE'),
             ('UB2_11', FIELDS['UB2_11'], (0, 1), 'FIE'),
             ('UB2_12', FIELDS['UB2_12'], (0, -1), 'FIE'),
             ('UB2_13', FIELDS['UB2_13'], (0, -1), 'FIE'),
             ('UB2_14', FIELDS['UB2_14'], (0, -1), 'FIE'),
             ('UB2_15', FIELDS['UB2_15'], (0, 1), 'FIE'),
             ('UB2_16', FIELDS['UB2_16'], (0, -1), 'FIE'),)),
    'URD': ('sequence',
            (('URD_1', FIELDS['URD_1'], (0, 1), 'FIE'),
             ('URD_2', FIELDS['URD_2'], (0, 1), 'FIE'),
             ('URD_3', FIELDS['URD_3'], (1, -1), 'FIE'),
             ('URD_4', FIELDS['URD_4'], (0, -1), 'FIE'),
             ('URD_5', FIELDS['URD_5'], (0, -1), 'FIE'),
             ('URD_6', FIELDS['URD_6'], (0, -1), 'FIE'),
             ('URD_7', FIELDS['URD_7'], (0, 1), 'FIE'),)),
    'URS': ('sequence',
            (('URS_1', FIELDS['URS_1'], (1, -1), 'FIE'),
             ('URS_2', FIELDS['URS_2'], (0, 1), 'FIE'),
             ('URS_3', FIELDS['URS_3'], (0, 1), 'FIE'),
             ('URS_4', FIELDS['URS_4'], (0, -1), 'FIE'),
             ('URS_5', FIELDS['URS_5'], (0, -1), 'FIE'),
             ('URS_6', FIELDS['URS_6'], (0, -1), 'FIE'),
             ('URS_7', FIELDS['URS_7'], (0, -1), 'FIE'),
             ('URS_8', FIELDS['URS_8'], (0, -1), 'FIE'),)),
}
