# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HealthStateCount(Model):
    """Represents information about how many health entities are in Ok, Warning
    and Error health state.

    :param ok_count: The number of health entities with aggregated health
     state Ok.
    :type ok_count: long
    :param warning_count: The number of health entities with aggregated health
     state Warning.
    :type warning_count: long
    :param error_count: The number of health entities with aggregated health
     state Error.
    :type error_count: long
    """

    _validation = {
        'ok_count': {'minimum': 0},
        'warning_count': {'minimum': 0},
        'error_count': {'minimum': 0},
    }

    _attribute_map = {
        'ok_count': {'key': 'OkCount', 'type': 'long'},
        'warning_count': {'key': 'WarningCount', 'type': 'long'},
        'error_count': {'key': 'ErrorCount', 'type': 'long'},
    }

    def __init__(self, *, ok_count: int=None, warning_count: int=None, error_count: int=None, **kwargs) -> None:
        super(HealthStateCount, self).__init__(**kwargs)
        self.ok_count = ok_count
        self.warning_count = warning_count
        self.error_count = error_count
