# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class BackupProgressInfo(Model):
    """Describes the progress of a partition's backup.

    :param backup_state: Represents the current state of the partition backup
     operation. Possible values include: 'Invalid', 'Accepted',
     'BackupInProgress', 'Success', 'Failure', 'Timeout'
    :type backup_state: str or ~azure.servicefabric.models.BackupState
    :param time_stamp_utc: TimeStamp in UTC when operation succeeded or
     failed.
    :type time_stamp_utc: datetime
    :param backup_id: Unique ID of the newly created backup.
    :type backup_id: str
    :param backup_location: Location, relative to the backup store, of the
     newly created backup.
    :type backup_location: str
    :param epoch_of_last_backup_record: Specifies the epoch of the last record
     included in backup.
    :type epoch_of_last_backup_record: ~azure.servicefabric.models.BackupEpoch
    :param lsn_of_last_backup_record: The LSN of last record included in
     backup.
    :type lsn_of_last_backup_record: str
    :param failure_error: Denotes the failure encountered in performing backup
     operation.
    :type failure_error: ~azure.servicefabric.models.FabricErrorError
    """

    _attribute_map = {
        'backup_state': {'key': 'BackupState', 'type': 'str'},
        'time_stamp_utc': {'key': 'TimeStampUtc', 'type': 'iso-8601'},
        'backup_id': {'key': 'BackupId', 'type': 'str'},
        'backup_location': {'key': 'BackupLocation', 'type': 'str'},
        'epoch_of_last_backup_record': {'key': 'EpochOfLastBackupRecord', 'type': 'BackupEpoch'},
        'lsn_of_last_backup_record': {'key': 'LsnOfLastBackupRecord', 'type': 'str'},
        'failure_error': {'key': 'FailureError', 'type': 'FabricErrorError'},
    }

    def __init__(self, **kwargs):
        super(BackupProgressInfo, self).__init__(**kwargs)
        self.backup_state = kwargs.get('backup_state', None)
        self.time_stamp_utc = kwargs.get('time_stamp_utc', None)
        self.backup_id = kwargs.get('backup_id', None)
        self.backup_location = kwargs.get('backup_location', None)
        self.epoch_of_last_backup_record = kwargs.get('epoch_of_last_backup_record', None)
        self.lsn_of_last_backup_record = kwargs.get('lsn_of_last_backup_record', None)
        self.failure_error = kwargs.get('failure_error', None)
