# This file auto-generated by `generate_schema_interface.py`.
# Do not modify this file directly.

import traitlets as T
from ..baseobject import BaseObject
from .fontstyle import FontStyle
from .fontweight import FontWeight
from .horizontalalign import HorizontalAlign
from .interpolate import Interpolate
from .shape import Shape
from .stackoffset import StackOffset
from .verticalalign import VerticalAlign


class MarkConfig(BaseObject):
    """Wrapper for Vega-Lite MarkConfig definition.
    
    Attributes
    ----------
    align: HorizontalAlign
        The horizontal alignment of the text.
    angle: CFloat
        The rotation angle of the text, in degrees.
    applyColorToBackground: Bool
        Apply color field to background color instead of the text.
    barSize: CFloat
        The size of the bars.
    barThinSize: CFloat
        The size of the bars on continuous scales.
    baseline: VerticalAlign
        The vertical alignment of the text.
    color: Unicode
        Default color.
    dx: CFloat
        The horizontal offset, in pixels, between the text label and its anchor point.
    dy: CFloat
        The vertical offset, in pixels, between the text label and its anchor point.
    fill: Unicode
        Default Fill Color.
    fillOpacity: CFloat
        
    filled: Bool
        Whether the shape\'s color should be used as fill color instead of stroke color.
    font: Unicode
        The typeface to set the text in .
    fontSize: CFloat
        The font size, in pixels.
    fontStyle: FontStyle
        The font style .
    fontWeight: FontWeight
        The font weight .
    format: Unicode
        The formatting pattern for text value.
    interpolate: Interpolate
        The line interpolation method to use.
    lineSize: CFloat
        Size of line mark.
    opacity: CFloat
        
    orient: Unicode
        The orientation of a non-stacked bar, tick, area, and line charts.
    radius: CFloat
        Polar coordinate radial offset, in pixels, of the text label from the origin determined by the x and y properties.
    ruleSize: CFloat
        Size of rule mark.
    shape: Shape
        The symbol shape to use.
    shortTimeLabels: Bool
        Whether month names and weekday names should be abbreviated.
    size: CFloat
        The pixel area each the point.
    stacked: StackOffset
        
    stroke: Unicode
        Default Stroke Color.
    strokeDash: List(CFloat)
        An array of alternating stroke, space lengths for creating dashed or dotted lines.
    strokeDashOffset: CFloat
        The offset (in pixels) into which to begin drawing with the stroke dash array.
    strokeOpacity: CFloat
        
    strokeWidth: CFloat
        
    tension: CFloat
        Depending on the interpolation type, sets the tension parameter.
    text: Unicode
        Placeholder Text.
    theta: CFloat
        Polar coordinate angle, in radians, of the text label from the origin determined by the x and y properties.
    tickSize: CFloat
        The width of the ticks.
    tickThickness: CFloat
        Thickness of the tick mark.
    """
    align = HorizontalAlign(allow_none=True, default_value=None, help="""The horizontal alignment of the text.""")
    angle = T.CFloat(allow_none=True, default_value=None, help="""The rotation angle of the text, in degrees.""")
    applyColorToBackground = T.Bool(allow_none=True, default_value=None, help="""Apply color field to background color instead of the text.""")
    barSize = T.CFloat(allow_none=True, default_value=None, help="""The size of the bars.""")
    barThinSize = T.CFloat(allow_none=True, default_value=None, help="""The size of the bars on continuous scales.""")
    baseline = VerticalAlign(allow_none=True, default_value=None, help="""The vertical alignment of the text.""")
    color = T.Unicode(allow_none=True, default_value=None, help="""Default color.""")
    dx = T.CFloat(allow_none=True, default_value=None, help="""The horizontal offset, in pixels, between the text label and its anchor point.""")
    dy = T.CFloat(allow_none=True, default_value=None, help="""The vertical offset, in pixels, between the text label and its anchor point.""")
    fill = T.Unicode(allow_none=True, default_value=None, help="""Default Fill Color.""")
    fillOpacity = T.CFloat(allow_none=True, default_value=None, min=0, max=1)
    filled = T.Bool(allow_none=True, default_value=None, help="""Whether the shape\'s color should be used as fill color instead of stroke color.""")
    font = T.Unicode(allow_none=True, default_value=None, help="""The typeface to set the text in .""")
    fontSize = T.CFloat(allow_none=True, default_value=None, help="""The font size, in pixels.""")
    fontStyle = FontStyle(allow_none=True, default_value=None, help="""The font style .""")
    fontWeight = FontWeight(allow_none=True, default_value=None, help="""The font weight .""")
    format = T.Unicode(allow_none=True, default_value=None, help="""The formatting pattern for text value.""")
    interpolate = Interpolate(allow_none=True, default_value=None, help="""The line interpolation method to use.""")
    lineSize = T.CFloat(allow_none=True, default_value=None, help="""Size of line mark.""")
    opacity = T.CFloat(allow_none=True, default_value=None, min=0, max=1)
    orient = T.Unicode(allow_none=True, default_value=None, help="""The orientation of a non-stacked bar, tick, area, and line charts.""")
    radius = T.CFloat(allow_none=True, default_value=None, help="""Polar coordinate radial offset, in pixels, of the text label from the origin determined by the x and y properties.""")
    ruleSize = T.CFloat(allow_none=True, default_value=None, help="""Size of rule mark.""")
    shape = Shape(allow_none=True, default_value=None, help="""The symbol shape to use.""")
    shortTimeLabels = T.Bool(allow_none=True, default_value=None, help="""Whether month names and weekday names should be abbreviated.""")
    size = T.CFloat(allow_none=True, default_value=None, help="""The pixel area each the point.""")
    stacked = StackOffset(allow_none=True, default_value=None)
    stroke = T.Unicode(allow_none=True, default_value=None, help="""Default Stroke Color.""")
    strokeDash = T.List(T.CFloat(), allow_none=True, default_value=None, help="""An array of alternating stroke, space lengths for creating dashed or dotted lines.""")
    strokeDashOffset = T.CFloat(allow_none=True, default_value=None, help="""The offset (in pixels) into which to begin drawing with the stroke dash array.""")
    strokeOpacity = T.CFloat(allow_none=True, default_value=None, min=0, max=1)
    strokeWidth = T.CFloat(allow_none=True, default_value=None, min=0)
    tension = T.CFloat(allow_none=True, default_value=None, help="""Depending on the interpolation type, sets the tension parameter.""")
    text = T.Unicode(allow_none=True, default_value=None, help="""Placeholder Text.""")
    theta = T.CFloat(allow_none=True, default_value=None, help="""Polar coordinate angle, in radians, of the text label from the origin determined by the x and y properties.""")
    tickSize = T.CFloat(allow_none=True, default_value=None, help="""The width of the ticks.""")
    tickThickness = T.CFloat(allow_none=True, default_value=None, help="""Thickness of the tick mark.""")
    
    def __init__(self, align=None, angle=None, applyColorToBackground=None, barSize=None, barThinSize=None, baseline=None, color=None, dx=None, dy=None, fill=None, fillOpacity=None, filled=None, font=None, fontSize=None, fontStyle=None, fontWeight=None, format=None, interpolate=None, lineSize=None, opacity=None, orient=None, radius=None, ruleSize=None, shape=None, shortTimeLabels=None, size=None, stacked=None, stroke=None, strokeDash=None, strokeDashOffset=None, strokeOpacity=None, strokeWidth=None, tension=None, text=None, theta=None, tickSize=None, tickThickness=None, **kwargs):
        kwds = dict(align=align, angle=angle, applyColorToBackground=applyColorToBackground, barSize=barSize, barThinSize=barThinSize, baseline=baseline, color=color, dx=dx, dy=dy, fill=fill, fillOpacity=fillOpacity, filled=filled, font=font, fontSize=fontSize, fontStyle=fontStyle, fontWeight=fontWeight, format=format, interpolate=interpolate, lineSize=lineSize, opacity=opacity, orient=orient, radius=radius, ruleSize=ruleSize, shape=shape, shortTimeLabels=shortTimeLabels, size=size, stacked=stacked, stroke=stroke, strokeDash=strokeDash, strokeDashOffset=strokeDashOffset, strokeOpacity=strokeOpacity, strokeWidth=strokeWidth, tension=tension, text=text, theta=theta, tickSize=tickSize, tickThickness=tickThickness)
        kwargs.update({k:v for k, v in kwds.items() if v is not None})
        super(MarkConfig, self).__init__(**kwargs)