from nicelib import Sig, RetHandler, ret_return
from .common import KinesisError


@RetHandler(num_retvals=0)
def ret_errcheck(ret):
    """Check error code, ignoring void functions"""
    if ret is not None and ret != 0:
        raise KinesisError(ret)


@RetHandler(num_retvals=0)
def ret_success(ret, funcname):
    if not ret:
        raise KinesisError(msg="Call to function '{}' failed".format(funcname))


# Global list of function Sigs, with prefixes stripped
all_sigs = {
    'BuildDeviceList': Sig(),
    'CanHome': Sig('in', ret=ret_return),
    #'CanMoveWithoutHomingFirst': Sig(...),
    #'ChannelEnable': Sig(...),
    #'CheckConnection': Sig(...),
    'ClearMessageQueue': Sig('in'),
    'Close': Sig('in'),
    #'Disable': Sig(...),
    #'DisableChannel': Sig(...),
    #'DisableOutput': Sig(...),
    #'Disconnect': Sig(...),
    #'Enable': Sig(...),
    #'EnableChannel': Sig(...),
    #'EnableLastMsgTimer': Sig(...),
    #'EnableMaxCurrentAdjust': Sig(...),
    #'EnableOutput': Sig(...),
    #'EnableTIAGainAdjust': Sig(...),
    #'FindTIAGain': Sig(...),
    #'GetAbsoluteMoveParameters': Sig(...),
    'GetBacklash': Sig('in', ret=ret_return),
    #'GetBowIndex': Sig(...),
    #'GetButtonParameters': Sig(...),
    #'GetButtonParametersStruct': Sig(...),
    #'GetButtonParams': Sig(...),
    #'GetButtonParamsBlock': Sig(...),
    #'GetCalibrationFile': Sig(...),
    #'GetCircleDiameter': Sig(...),
    #'GetCircleDiameterLUT': Sig(...),
    #'GetCircleHomePosition': Sig(...),
    #'GetCircleParams': Sig(...),
    #'GetCirclePosition': Sig(...),
    #'GetControlMode': Sig(...),
    #'GetControlSource': Sig(...),
    #'GetCurrentLimit': Sig(...),
    #'GetCurrentLoopParams': Sig(...),
    #'GetCurrentPosition': Sig(...),
    #'GetCurrentReading': Sig(...),
    #'GetCycleParams': Sig(...),
    #'GetCycleParamsBlock': Sig(...),
    #'GetDCPIDParams': Sig(...),
    #'GetDemandedPosition': Sig(...),
    #'GetDeviceInfo': Sig(...),
    'GetDeviceInfo': Sig('in', 'out', ret=ret_success),
    #'GetDeviceList': Sig(...),
    #'GetDeviceListByType': Sig(...),
    'GetDeviceListByTypeExt': Sig('buf', 'len', 'in'),
    #'GetDeviceListByTypes': Sig(...),
    'GetDeviceListByTypesExt': Sig('buf', 'len', 'in', 'in'),
    'GetDeviceListExt': Sig('buf', 'len'),
    'GetDeviceListSize': Sig(ret=ret_return),
    #'GetDeviceUnitFromRealValue': Sig(...),
    #'GetDigitalOutput': Sig(...),
    #'GetDigitalOutputs': Sig(...),
    #'GetDisplayMode': Sig(...),
    #'GetDisplayUnits': Sig(...),
    #'GetDriveOPParameters': Sig(...),
    #'GetDriveOPParametersStruct': Sig(...),
    #'GetElectricOutputParams': Sig(...),
    #'GetEncoderCounter': Sig(...),
    #'GetFeedbackLoopPIconsts': Sig(...),
    #'GetFeedbackLoopPIconstsBlock': Sig(...),
    #'GetFeedbackMode': Sig(...),
    #'GetFeedbackSigParameters': Sig(...),
    #'GetFeedbackSigParametersStruct': Sig(...),
    #'GetFeedbackSource': Sig(...),
    'GetFirmwareVersion': Sig('in', ret=ret_return),
    #'GetForceCalib': Sig(...),
    #'GetGain': Sig(...),
    #'GetHWDisplayMode': Sig(...),
    'GetHardwareInfo': Sig('in', 'buf', 'len', 'out', 'out', 'buf', 'len', 'out', 'out', 'out'),
    #'GetHardwareInfoBlock': Sig(...),
    #'GetHomeParameters': Sig(...),
    #'GetHomeParametersStruct': Sig(...),
    #'GetHomingParamsBlock': Sig(...),
    #'GetHomingVelocity': Sig(...),
    #'GetHubAnalogInput': Sig(...),
    #'GetHubAnalogOutput': Sig(...),
    #'GetHubBay': Sig(...),
    'GetIOSettings': Sig('in', 'out'),
    #'GetIOsettings': Sig(...),
    #'GetIOsettingsBlock': Sig(...),
    #'GetInputVoltage': Sig(...),
    #'GetInterlockState': Sig(...),
    #'GetJogMode': Sig(...),
    #'GetJogParameters': Sig(...),
    #'GetJogParametersStruct': Sig(...),
    #'GetJogParamsBlock': Sig(...),
    #'GetJogStepSize': Sig(...),
    'GetJogVelParams': Sig('in', 'out', 'out'),
    #'GetJoystickParams': Sig(...),
    #'GetLEDBrightness': Sig(...),
    #'GetLEDswitches': Sig(...),
    #'GetLaserDiodeCurrentReading': Sig(...),
    #'GetLaserDiodeMaxCurrentLimit': Sig(...),
    #'GetLaserPolarity': Sig(...),
    #'GetLaserSetPoint': Sig(...),
    #'GetLimitSwitchParameters': Sig(...),
    #'GetLimitSwitchParametersStruct': Sig(...),
    'GetLimitSwitchParams': Sig('in', 'out', 'out', 'out', 'out', 'out'),
    'GetLimitSwitchParamsBlock': Sig('in', 'out'),
    #'GetLimits': Sig(...),
    #'GetLoopPIDparams': Sig(...),
    #'GetLowPassFilterparams': Sig(...),
    #'GetMMIChannelParameters': Sig(...),
    #'GetMMIChannelParametersStruct': Sig(...),
    #'GetMMIDeviceParameters': Sig(...),
    #'GetMMIDeviceParametersStruct': Sig(...),
    #'GetMMIParams': Sig(...),
    #'GetMMIParamsBlock': Sig(...),
    #'GetMMIParamsExt': Sig(...),
    #'GetMaxCurrentDigPot': Sig(...),
    #'GetMaxOutputVoltage': Sig(...),
    #'GetMaxPotStepRate': Sig(...),
    #'GetMaxTravel': Sig(...),
    #'GetMaximumTravel': Sig(...),
    #'GetMinOutputVoltage': Sig(...),
    #'GetMode': Sig(...),
    #'GetMotorParams': Sig(...),
    'GetMotorParamsExt': Sig('in', 'out', 'out', 'out'),
    #'GetMotorTravelLimits': Sig(...),
    #'GetMotorTravelMode': Sig(...),
    #'GetMotorVelocityLimits': Sig(...),
    #'GetMoveAbsolutePosition': Sig(...),
    #'GetMoveRelativeDistance': Sig(...),
    #'GetNTChannels': Sig(...),
    'GetNextMessage': Sig('in', 'out', 'out', 'out', ret=ret_success),
    #'GetNotchFilterparams': Sig(...),
    #'GetNotchParams': Sig(...),
    #'GetNumChannels': Sig(...),
    'GetNumberPositions': Sig('in', ret=ret_return),
    #'GetOPMode': Sig(...),
    #'GetOperatingMode': Sig(...),
    #'GetOperatingState': Sig(...),
    #'GetOutputVoltage': Sig(...),
    #'GetPIDConsts': Sig(...),
    #'GetPIDLoopEncoderCoeff': Sig(...),
    #'GetPIDLoopEncoderParams': Sig(...),
    #'GetPIDparams': Sig(...),
    #'GetPhaseCompensationParams': Sig(...),
    #'GetPhotoCurrentReading': Sig(...),
    #'GetPosDemandParams': Sig(...),
    #'GetPosLoopParams': Sig(...),
    'GetPosition': Sig('in', ret=ret_return),
    #'GetPositionControlMode': Sig(...),
    'GetPositionCounter': Sig('in', ret=ret_return),
    #'GetPotentiometerParams': Sig(...),
    #'GetPotentiometerParamsBlock': Sig(...),
    #'GetPowerParams': Sig(...),
    #'GetPowerReading': Sig(...),
    #'GetPowerSet': Sig(...),
    #'GetRackDigitalOutputs': Sig(...),
    #'GetRackStatusBits': Sig(...),
    #'GetRangeMode': Sig(...),
    #'GetReading': Sig(...),
    #'GetReadingExt': Sig(...),
    #'GetRealValueFromDeviceUnit': Sig(...),
    #'GetRelativeMoveParameter': Sig(...),
    #'GetSensorType': Sig(...),
    #'GetSettledCurrentLoopParams': Sig(...),
    #'GetSignalState': Sig(...),
    #'GetSoftLimitMode': Sig(...),
    'GetSoftwareVersion': Sig('in', ret=ret_return),
    #'GetSolenoidState': Sig(...),
    #'GetStageAxisMaxPos': Sig(...),
    #'GetStageAxisMinPos': Sig(...),
    #'GetStageAxisParams': Sig(...),
    #'GetStageAxisParamsBlock': Sig(...),
    'GetStatusBits': Sig('in', ret=ret_return),
    #'GetTDIParams': Sig(...),
    #'GetTIALPFilterParams': Sig(...),
    #'GetTIARange': Sig(...),
    #'GetTIArangeParams': Sig(...),
    #'GetTempLoopParams': Sig(...),
    #'GetTemperatureReading': Sig(...),
    #'GetTemperatureSet': Sig(...),
    #'GetTrackSettleParams': Sig(...),
    #'GetTrackingThresholdSignal': Sig(...),
    'GetTransitTime': Sig('in', ret=ret_return),
    #'GetTrigIOParameters': Sig(...),
    #'GetTrigIOParametersStruct': Sig(...),
    #'GetTrigIOParams': Sig(...),
    #'GetTrigIOParamsBlock': Sig(...),
    #'GetTrigParamsParameters': Sig(...),
    #'GetTrigParamsParametersStruct': Sig(...),
    #'GetTriggerConfigParams': Sig(...),
    #'GetTriggerConfigParamsBlock': Sig(...),
    #'GetTriggerParamsParams': Sig(...),
    #'GetTriggerParamsParamsBlock': Sig(...),
    #'GetTriggerSwitches': Sig(...),
    #'GetVelParams': Sig(...),
    #'GetVelParamsBlock': Sig(...),
    #'GetVelocityProfileParams': Sig(...),
    #'GetVoltageReading': Sig(...),
    #'GetVoltageSource': Sig(...),
    #'GetWACalibFactor': Sig(...),
    #'GetWavelength': Sig(...),
    #'GetXYScanLine': Sig(...),
    #'GetXYScanRange': Sig(...),
    #'HasLastMsgTimerOverrun': Sig(...),
    'Home': Sig('in'),
    #'HomeCircle': Sig(...),
    'Identify': Sig('in'),
    #'IsCalibrationActive': Sig(...),
    #'IsChannelEnabled': Sig(...),
    #'IsChannelValid': Sig(...),
    #'IsXYScanAvailable': Sig(...),
    #'IsXYScanLineAvailable': Sig(...),
    #'IsXYScanning': Sig(...),
    'LoadSettings': Sig('in', ret=ret_success),
    #'MaxChannelCount': Sig(...),
    'MessageQueueSize': Sig('in', ret=ret_return),
    #'MoveAbsolute': Sig(...),
    #'MoveAtVelocity': Sig(...),
    #'MoveJog': Sig(...),
    'MoveRelative': Sig('in', 'in'),
    #'MoveRelativeDistance': Sig(...),
    #'MoveStop': Sig(...),
    'MoveToPosition': Sig('in', 'in'),
    'NeedsHoming': Sig('in', ret=ret_return),
    'Open': Sig('in'),
    #'OverrideHomeRequirement': Sig(...),
    'PersistSettings': Sig('in', ret=ret_success),
    'PollingDuration': Sig('in', ret=ret_return),
    'RegisterMessageCallback': Sig('in', 'in'),
    #'RequestAbsoluteMoveParameters': Sig(...),
    #'RequestActualPosition': Sig(...),
    #'RequestBacklash': Sig(...),
    #'RequestBowIndex': Sig(...),
    #'RequestButtonParameters': Sig(...),
    #'RequestButtonParams': Sig(...),
    #'RequestChannelStates': Sig(...),
    #'RequestCircleDiameterLUT': Sig(...),
    #'RequestCircleHomePosition': Sig(...),
    #'RequestCircleParams': Sig(...),
    #'RequestCirclePosition': Sig(...),
    #'RequestControlMode': Sig(...),
    #'RequestControlSource': Sig(...),
    #'RequestCurrentLimit': Sig(...),
    #'RequestCurrentLoopParams': Sig(...),
    #'RequestCurrentPosition': Sig(...),
    #'RequestCycleParams': Sig(...),
    #'RequestDCPIDParams': Sig(...),
    #'RequestDigitalOutput': Sig(...),
    #'RequestDigitalOutputs': Sig(...),
    #'RequestDisplay': Sig(...),
    #'RequestDisplayMode': Sig(...),
    #'RequestDisplayUnits': Sig(...),
    #'RequestDriveOPParameters': Sig(...),
    #'RequestElectricOutputParams': Sig(...),
    #'RequestEncoderCounter': Sig(...),
    #'RequestFeedbackLoopPIconsts': Sig(...),
    #'RequestFeedbackMode': Sig(...),
    #'RequestFeedbackSigParameters': Sig(...),
    #'RequestFeedbackSource': Sig(...),
    #'RequestForceCalib': Sig(...),
    #'RequestGain': Sig(...),
    #'RequestHWDisplayMode': Sig(...),
    #'RequestHomeParameters': Sig(...),
    #'RequestHomingParams': Sig(...),
    #'RequestHubAnalogOutput': Sig(...),
    #'RequestHubBay': Sig(...),
    #'RequestIOSettings': Sig(...),
    #'RequestIOsettings': Sig(...),
    #'RequestInputVoltage': Sig(...),
    #'RequestJogParameters': Sig(...),
    #'RequestJogParams': Sig(...),
    #'RequestJoystickParams': Sig(...),
    #'RequestLEDBrightness': Sig(...),
    #'RequestLEDswitches': Sig(...),
    #'RequestLaserDiodeMaxCurrentLimit': Sig(...),
    #'RequestLaserPolarity': Sig(...),
    #'RequestLaserSetPoint': Sig(...),
    #'RequestLimitSwitchParameters': Sig(...),
    #'RequestLimitSwitchParams': Sig(...),
    #'RequestLimits': Sig(...),
    #'RequestLoopPIDparams': Sig(...),
    #'RequestMMIParameters': Sig(...),
    #'RequestMMIParams': Sig(...),
    #'RequestMMIparams': Sig(...),
    #'RequestMaxCurrentDigPot': Sig(...),
    #'RequestMaxOutputVoltage': Sig(...),
    #'RequestMaxPotStepRate': Sig(...),
    #'RequestMaxTravel': Sig(...),
    #'RequestMaximumTravel': Sig(...),
    #'RequestMode': Sig(...),
    #'RequestMoveAbsolutePosition': Sig(...),
    #'RequestMoveRelativeDistance': Sig(...),
    #'RequestNTChannels': Sig(...),
    #'RequestOPMode': Sig(...),
    #'RequestOperatingMode': Sig(...),
    #'RequestOperatingState': Sig(...),
    #'RequestOutputVoltage': Sig(...),
    #'RequestPIDConsts': Sig(...),
    #'RequestPIDLoopEncoderParams': Sig(...),
    #'RequestPhaseCompensationParams': Sig(...),
    #'RequestPosDemandParams': Sig(...),
    #'RequestPosLoopParams': Sig(...),
    #'RequestPosTriggerParams': Sig(...),
    #'RequestPosition': Sig(...),
    #'RequestPositionControlMode': Sig(...),
    #'RequestPotentiometerParams': Sig(...),
    #'RequestPowerParams': Sig(...),
    #'RequestRackDigitalOutputs': Sig(...),
    #'RequestRackStatusBits': Sig(...),
    #'RequestReading': Sig(...),
    #'RequestReadings': Sig(...),
    #'RequestRelativeMoveParameter': Sig(...),
    #'RequestSensorType': Sig(...),
    #'RequestSetPower': Sig(...),
    'RequestSettings': Sig('in'),
    #'RequestSettledCurrentLoopParams': Sig(...),
    #'RequestSignalState': Sig(...),
    #'RequestStageAxisParams': Sig(...),
    'RequestStatus': Sig('in'),
    'RequestStatusBits': Sig('in'),
    #'RequestTDIParams': Sig(...),
    #'RequestTIALPFilterParams': Sig(...),
    #'RequestTIArangeParams': Sig(...),
    #'RequestTempLoopParams': Sig(...),
    #'RequestTemperatureSet': Sig(...),
    #'RequestTrackSettleParams': Sig(...),
    #'RequestTrackingThresholdSignal': Sig(...),
    #'RequestTrigIOParameters': Sig(...),
    #'RequestTrigIOParams': Sig(...),
    #'RequestTrigParamsParameters': Sig(...),
    #'RequestTriggerConfigParams': Sig(...),
    #'RequestTriggerSwitches': Sig(...),
    #'RequestVelParams': Sig(...),
    #'RequestVelocityProfileParams': Sig(...),
    #'RequestVoltageSource': Sig(...),
    #'RequestWACalibFactor': Sig(...),
    #'RequestWavelength': Sig(...),
    #'RequestXYScan': Sig(...),
    #'RequestsLEDBrightness': Sig(...),
    #'Reset': Sig(...),
    #'ResetParameters': Sig(...),
    #'ResetRotationModes': Sig(...),
    #'ResetStageToDefaults': Sig(...),
    #'ResumeMoveMessages': Sig(...),
    #'SetAbsoluteMoveParameters': Sig(...),
    'SetBacklash': Sig('in', 'in'),
    #'SetBowIndex': Sig(...),
    #'SetButtonParameters': Sig(...),
    #'SetButtonParametersStruct': Sig(...),
    #'SetButtonParams': Sig(...),
    #'SetButtonParamsBlock': Sig(...),
    #'SetCalibrationFile': Sig(...),
    #'SetCircleDiameter': Sig(...),
    #'SetCircleDiameterLUT': Sig(...),
    #'SetCircleHomePosition': Sig(...),
    #'SetCircleParams': Sig(...),
    #'SetClosedLoopMode': Sig(...),
    #'SetControlMode': Sig(...),
    #'SetControlSource': Sig(...),
    #'SetCurrentLimit': Sig(...),
    #'SetCurrentLoopParams': Sig(...),
    #'SetCycleParams': Sig(...),
    #'SetCycleParamsBlock': Sig(...),
    #'SetDCPIDParams': Sig(...),
    #'SetDigitalOutput': Sig(...),
    #'SetDigitalOutputs': Sig(...),
    #'SetDirection': Sig(...),
    #'SetDisplayMode': Sig(...),
    #'SetDisplayUnits': Sig(...),
    #'SetDriveOPParameters': Sig(...),
    #'SetDriveOPParametersStruct': Sig(...),
    #'SetElectricOutputParams': Sig(...),
    #'SetEncoderCounter': Sig(...),
    #'SetFeedbackLoopPIconsts': Sig(...),
    #'SetFeedbackLoopPIconstsBlock': Sig(...),
    #'SetFeedbackMode': Sig(...),
    #'SetFeedbackSigParameters': Sig(...),
    #'SetFeedbackSigParametersStruct': Sig(...),
    #'SetFeedbackSource': Sig(...),
    #'SetForceCalib': Sig(...),
    #'SetGain': Sig(...),
    #'SetHWDisplayMode': Sig(...),
    #'SetHomeParameters': Sig(...),
    #'SetHomeParametersStruct': Sig(...),
    #'SetHomingParamsBlock': Sig(...),
    #'SetHomingVelocity': Sig(...),
    #'SetHubAnalogInput': Sig(...),
    #'SetHubAnalogOutput': Sig(...),
    #'SetIOSettings': Sig(...),
    #'SetIOsettings': Sig(...),
    #'SetIOsettingsBlock': Sig(...),
    #'SetJogMode': Sig(...),
    #'SetJogParameters': Sig(...),
    #'SetJogParametersStruct': Sig(...),
    #'SetJogParamsBlock': Sig(...),
    'SetJogStepSize': Sig('in', 'in'),
    #'SetJogVelParams': Sig(...),
    #'SetJoystickParams': Sig(...),
    #'SetLEDBrightness': Sig(...),
    #'SetLEDswitches': Sig(...),
    #'SetLUTwaveParams': Sig(...),
    #'SetLUTwaveSample': Sig(...),
    #'SetLaserPolarity': Sig(...),
    #'SetLaserSetPoint': Sig(...),
    #'SetLimitSwitchParameters': Sig(...),
    #'SetLimitSwitchParametersStruct': Sig(...),
    #'SetLimitSwitchParams': Sig(...),
    #'SetLimitSwitchParamsBlock': Sig(...),
    #'SetLimitsSoftwareApproachPolicy': Sig(...),
    #'SetLoopPIDparams': Sig(...),
    #'SetLowPassFilterparams': Sig(...),
    #'SetMMIChannelParameters': Sig(...),
    #'SetMMIChannelParametersStruct': Sig(...),
    #'SetMMIDeviceParameters': Sig(...),
    #'SetMMIDeviceParametersStruct': Sig(...),
    #'SetMMIParams': Sig(...),
    #'SetMMIParamsBlock': Sig(...),
    #'SetMMIParamsExt': Sig(...),
    #'SetMaxCurrentDigPot': Sig(...),
    #'SetMaxOutputVoltage': Sig(...),
    #'SetMaxPotStepRate': Sig(...),
    #'SetMode': Sig(...),
    #'SetMotorParams': Sig(...),
    #'SetMotorParamsExt': Sig(...),
    #'SetMotorTravelLimits': Sig(...),
    #'SetMotorTravelMode': Sig(...),
    #'SetMotorVelocityLimits': Sig(...),
    #'SetMoveAbsolutePosition': Sig(...),
    #'SetMoveRelativeDistance': Sig(...),
    #'SetNTChannels': Sig(...),
    #'SetNotchFilterparams': Sig(...),
    #'SetNotchParams': Sig(...),
    #'SetOPMode': Sig(...),
    #'SetOpenLoopMode': Sig(...),
    #'SetOperatingMode': Sig(...),
    #'SetOperatingState': Sig(...),
    #'SetOutputVoltage': Sig(...),
    #'SetPIDConsts': Sig(...),
    #'SetPIDLoopEncoderCoeff': Sig(...),
    #'SetPIDLoopEncoderParams': Sig(...),
    #'SetPIDparams': Sig(...),
    #'SetPhaseCompensationParams': Sig(...),
    #'SetPosDemandParams': Sig(...),
    #'SetPosLoopParams': Sig(...),
    #'SetPosition': Sig(...),
    #'SetPositionControlMode': Sig(...),
    #'SetPositionCounter': Sig(...),
    #'SetPotentiometerParams': Sig(...),
    #'SetPotentiometerParamsBlock': Sig(...),
    #'SetPower': Sig(...),
    #'SetPowerParams': Sig(...),
    #'SetRackDigitalOutputs': Sig(...),
    #'SetRangeMode': Sig(...),
    #'SetRelativeMoveParameter': Sig(...),
    #'SetRotationModes': Sig(...),
    #'SetSensorType': Sig(...),
    #'SetSettledCurrentLoopParams': Sig(...),
    #'SetStageAxisLimits': Sig(...),
    #'SetStageType': Sig(...),
    #'SetTDIParams': Sig(...),
    #'SetTIALPFilterParams': Sig(...),
    #'SetTIARange': Sig(...),
    #'SetTIArangeParams': Sig(...),
    #'SetTempLoopParams': Sig(...),
    #'SetTemperature': Sig(...),
    #'SetTrackSettleParams': Sig(...),
    #'SetTrackingThresholdSignal': Sig(...),
    'SetTransitTime': Sig('in', 'in'),
    #'SetTrigIOParameters': Sig(...),
    #'SetTrigIOParametersStruct': Sig(...),
    #'SetTrigIOParams': Sig(...),
    #'SetTrigIOParamsBlock': Sig(...),
    #'SetTrigParamsParameters': Sig(...),
    #'SetTrigParamsParametersStruct': Sig(...),
    #'SetTriggerConfigParams': Sig(...),
    #'SetTriggerConfigParamsBlock': Sig(...),
    #'SetTriggerParamsParams': Sig(...),
    #'SetTriggerParamsParamsBlock': Sig(...),
    #'SetTriggerSwitches': Sig(...),
    #'SetVelParams': Sig(...),
    #'SetVelParamsBlock': Sig(...),
    #'SetVelocityProfileParams': Sig(...),
    #'SetVoltageSource': Sig(...),
    #'SetWACalibFactor': Sig(...),
    #'SetZero': Sig(...),
    #'StartLUTwave': Sig(...),
    'StartPolling': Sig('in', 'in', ret=ret_success),
    'StopImmediate': Sig('in'),
    #'StopLUTwave': Sig(...),
    'StopPolling': Sig('in'),
    #'StopProfiled': Sig(...),
    #'StopXYScan': Sig(...),
    #'SuspendMoveMessages': Sig(...),
    #'TimeSinceLastMsgReceived': Sig(...),
    #'UsesPIDLoopEncoding': Sig(...),
    'WaitForMessage': Sig('in', 'out', 'out', 'out', ret=ret_success),
    #'ZeroPosition': Sig(...),
}
