/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build.util;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.util.Range;

public class AxisDetails {
    private final Field[] fields;
    public final String title;
    public final String scale;
    private final boolean categorical;
    public boolean rotatedTicks = false;
    public Object[] tickValues;
    public int size;
    public int leftGutter;
    public int rightGutter;
    public int topGutter;
    public int bottomGutter;

    public int maxCategoryWidth() {
        if (this.fields.length == 0) {
            return 0;
        }
        int maxCharCount = 1;
        for (Field f : this.fields) {
            Double[] sampleTicks;
            if (this.categorical) {
                for (Object s : f.categories()) {
                    int length = f.format(s).length();
                    if (s instanceof Range) {
                        ++length;
                    }
                    maxCharCount = Math.max(maxCharCount, length);
                }
                continue;
            }
            for (Double s : sampleTicks = Auto.makeNumericScale((Field)f, (boolean)true, (double[])new double[]{0.0, 0.0}, (double)0.0, (int)5, (boolean)false).divisions) {
                maxCharCount = Math.max(maxCharCount, f.format((Object)s).length());
            }
            maxCharCount = Math.max(maxCharCount, 3);
        }
        return (int)((double)maxCharCount * 6.5);
    }

    public int maxTickWidth() {
        int maxCharCount = 1;
        for (Object s : this.tickValues) {
            int length = s.toString().length();
            if (s instanceof Range) {
                ++length;
            }
            maxCharCount = Math.max(maxCharCount, length);
        }
        return (int)((double)maxCharCount * 6.5);
    }

    public AxisDetails(String dimension, Field[] definedFields, boolean categorical) {
        this.scale = "scale_" + dimension;
        this.fields = this.suitable(definedFields);
        this.title = AxisDetails.title(this.fields);
        this.categorical = categorical;
    }

    private Field[] suitable(Field[] fields) {
        LinkedHashSet<Field> result = new LinkedHashSet<Field>();
        for (Field f : fields) {
            if (f.name.startsWith("'")) continue;
            result.add(f);
        }
        return result.toArray(new Field[result.size()]);
    }

    public boolean isLog() {
        return this.fields.length > 0 && "log".equals(this.fields[0].property("transform"));
    }

    public void layoutVertically(double availableSpace) {
        if (!this.exists()) {
            return;
        }
        int tickCount = this.countTicks(this.fields);
        this.topGutter = 5;
        this.bottomGutter = 5;
        this.tickValues = this.makeSkippingTickValues(availableSpace -= (double)(this.topGutter + this.bottomGutter), tickCount);
        this.size = this.tickValues == null ? this.maxCategoryWidth() : this.maxTickWidth();
        this.size += this.estimatedTitleHeight() + 10;
    }

    public void layoutHorizontally(double availableSpace, boolean fillToEdge) {
        if (!this.exists()) {
            return;
        }
        int tickWidth = this.maxCategoryWidth();
        int tickCount = this.countTicks(this.fields);
        if (!this.categorical) {
            fillToEdge = true;
        }
        if (fillToEdge) {
            availableSpace -= (double)tickWidth;
        }
        int spaceForOneTick = (int)(availableSpace / (double)tickCount);
        if (this.categorical && tickWidth > spaceForOneTick + 5) {
            this.rotatedTicks = true;
            this.tickValues = this.makeSkippingTickValues(availableSpace, tickCount);
            int tickHeight = (int)((double)tickWidth / Math.sqrt(2.0));
            this.size = tickHeight + 16 + this.estimatedTitleHeight();
            if (fillToEdge) {
                this.rightGutter = 10;
                this.leftGutter = tickHeight - 8;
            } else {
                this.rightGutter = Math.max(0, 10 - spaceForOneTick / 2);
                this.leftGutter = Math.max(0, tickHeight - 8 - spaceForOneTick / 2);
            }
        } else {
            this.size = this.estimatedSimpleSizeWhenHorizontal();
            this.leftGutter = fillToEdge ? tickWidth / 2 : Math.max(0, tickWidth / 2 - spaceForOneTick / 2);
            this.rightGutter = this.leftGutter;
        }
    }

    public int estimatedSimpleSizeWhenHorizontal() {
        return this.exists() ? 20 + this.estimatedTitleHeight() : 0;
    }

    public boolean exists() {
        return this.fields.length > 0;
    }

    private int estimatedTitleHeight() {
        return this.title == null ? 0 : 16;
    }

    private static String title(Field[] fields) {
        if (fields.length == 1) {
            return fields[0].isSynthetic() ? null : fields[0].label;
        }
        LinkedHashSet<String> titles = new LinkedHashSet<String>();
        LinkedHashSet<String> originalTitles = new LinkedHashSet<String>();
        for (Field f : fields) {
            titles.add(f.label);
            String originalLabel = (String)f.property("originalLabel");
            originalTitles.add(originalLabel == null ? f.label : originalLabel);
        }
        if (originalTitles.size() < titles.size()) {
            titles = originalTitles;
        }
        return titles.isEmpty() ? null : Data.join(titles);
    }

    private int countTicks(Field[] fields) {
        if (fields.length == 0) {
            return 1;
        }
        int n = 0;
        for (Field f : fields) {
            n += this.categorical ? f.categories().length : 5;
        }
        return n;
    }

    private Object[] makeSkippingTickValues(double width, int count) {
        if (!this.categorical) {
            return null;
        }
        double spacePerTick = width / (double)count;
        int skipFrequency = (int)Math.round(20.0 / spacePerTick);
        if (skipFrequency < 2) {
            return null;
        }
        ArrayList<Object> useThese = new ArrayList<Object>();
        int at = 0;
        for (Field f : this.fields) {
            for (Object s : f.categories()) {
                if (at++ % skipFrequency != 0) continue;
                useThese.add(s);
            }
        }
        return useThese.toArray(new Object[useThese.size()]);
    }
}

