/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.build;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.brunel.action.Param;
import org.brunel.build.Builder;
import org.brunel.build.DataTransformParameters;
import org.brunel.build.ElementDependency;
import org.brunel.build.controls.Controls;
import org.brunel.build.util.BuilderOptions;
import org.brunel.data.Data;
import org.brunel.data.Dataset;
import org.brunel.data.Field;
import org.brunel.model.VisComposition;
import org.brunel.model.VisException;
import org.brunel.model.VisItem;
import org.brunel.model.VisSingle;
import org.brunel.model.VisTypes;
import org.brunel.model.style.StyleSheet;

public abstract class AbstractBuilder
implements Builder {
    private static final double[][][] LAYOUTS = new double[][][]{new double[][]{{0.0, 0.0, 100.0, 100.0}}, new double[][]{{0.0, 0.0, 100.0, 50.0}, {0.0, 50.0, 100.0, 100.0}}, new double[][]{{0.0, 0.0, 100.0, 50.0}, {0.0, 50.0, 50.0, 100.0}, {50.0, 50.0, 100.0, 100.0}}, new double[][]{{0.0, 0.0, 50.0, 50.0}, {0.0, 50.0, 50.0, 100.0}, {50.0, 0.0, 100.0, 50.0}, {50.0, 50.0, 100.0, 100.0}}};
    protected final BuilderOptions options;
    private String currentVisualizationID;
    private String currentChartID;
    private String currentElementID;
    private StyleSheet visStyles;
    protected Controls controls;
    private Dataset[] datasets;

    public AbstractBuilder(BuilderOptions options) {
        this.options = options;
    }

    @Override
    public final BuilderOptions getOptions() {
        return this.options;
    }

    @Override
    public final void build(VisItem main, int width, int height) {
        this.visStyles = new StyleSheet();
        this.datasets = main.getDataSets();
        this.currentVisualizationID = this.defineVisSystem(main, width, height);
        this.controls = new Controls(this.currentVisualizationID);
        if (main.children() == null) {
            this.buildTiledCharts(width, height, new VisItem[]{main.getSingle()});
        } else {
            VisTypes.Composition compositionMethod = ((VisComposition)main).method;
            if (compositionMethod == VisTypes.Composition.tile) {
                this.buildTiledCharts(width, height, main.children());
            } else if (compositionMethod == VisTypes.Composition.overlay) {
                double[] loc = this.getLocation(this.findFirstBounds(main));
                this.buildOverlayComposition(main.children(), loc);
            } else if (compositionMethod == VisTypes.Composition.inside || compositionMethod == VisTypes.Composition.nested) {
                this.buildTiledCharts(width, height, new VisItem[]{main.getSingle()});
            }
        }
        this.endVisSystem(main, this.currentVisualizationID);
    }

    public abstract String makeImports();

    private void buildOverlayComposition(VisItem[] items, double[] loc) {
        Dataset[] data = new Dataset[items.length];
        VisSingle[] elements = new VisSingle[items.length];
        for (int i = 0; i < items.length; ++i) {
            elements[i] = items[i].getSingle().resolve();
            data[i] = this.buildData(elements[i]);
        }
        ElementDependency dependency = new ElementDependency(elements);
        this.currentChartID = this.defineChart(loc, elements, data);
        for (int i = 0; i < elements.length; ++i) {
            this.buildElement(elements[i], data[i], dependency);
        }
        this.endChart(this.currentChartID);
    }

    private void buildTiledCharts(int width, int height, VisItem[] charts) {
        int nUnplacedCharts = 0;
        for (VisItem chart : charts) {
            if (this.findFirstBounds(chart) != null) continue;
            ++nUnplacedCharts;
        }
        int unplacedCount = 0;
        for (VisItem chart : charts) {
            double[] loc;
            Param[] bounds = this.findFirstBounds(chart);
            if (bounds == null) {
                double[][] layout = this.squarify(LAYOUTS[Math.min(nUnplacedCharts - 1, 3)], width, height);
                loc = layout[unplacedCount++];
            } else {
                loc = this.getLocation(bounds);
            }
            VisItem[] items = chart.children();
            if (items == null) {
                this.buildOverlayComposition(new VisItem[]{chart}, loc);
                continue;
            }
            this.buildOverlayComposition(items, loc);
        }
    }

    @Override
    public String getStyleOverrides() {
        return this.visStyles.toString("#" + this.currentVisualizationID + ".brunel");
    }

    protected abstract String defineVisSystem(VisItem var1, int var2, int var3);

    private double[][] squarify(double[][] layout, int width, int height) {
        double[][] alternate = new double[layout.length][];
        for (int i = 0; i < layout.length; ++i) {
            alternate[i] = new double[]{layout[i][1], layout[i][0], layout[i][3], layout[i][2]};
        }
        return this.squarifyDivergence(alternate, width, height) < this.squarifyDivergence(layout, width, height) ? alternate : (double[][])layout;
    }

    private double[] getLocation(Param[] bounds) {
        double l = 0.0;
        double t = 0.0;
        double r = 100.0;
        double b = 100.0;
        if (bounds != null && bounds.length > 0) {
            l = bounds[0].asDouble();
        }
        if (bounds != null && bounds.length > 1) {
            t = bounds[1].asDouble();
        }
        if (bounds != null && bounds.length > 2) {
            r = bounds[2].asDouble();
        }
        if (bounds != null && bounds.length > 3) {
            b = bounds[3].asDouble();
        }
        return new double[]{t, l, b, r};
    }

    private Param[] findFirstBounds(VisItem chart) {
        if (chart.children() == null) {
            return chart.getSingle().bounds;
        }
        for (VisItem v : chart.children()) {
            Param[] result = this.findFirstBounds(v);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    protected abstract String defineChart(double[] var1, VisSingle[] var2, Dataset[] var3);

    private Dataset buildData(VisSingle vis) {
        String constantsCommand = this.makeConstantsCommand(vis);
        String filterCommand = this.makeFilterCommands(vis);
        String binCommand = this.makeTransformCommands(vis);
        String summaryCommand = this.buildSummaryCommands(vis);
        String sortCommand = this.makeFieldCommands(vis.fSort);
        String seriesYFields = this.makeSeriesCommand(vis);
        String usedFields = this.required(vis.usedFields(true));
        DataTransformParameters params = new DataTransformParameters(constantsCommand, filterCommand, binCommand, summaryCommand, "", sortCommand, seriesYFields, usedFields);
        params = this.modifyParameters(params, vis);
        Dataset data = vis.getDataset();
        data = data.addConstants(params.constantsCommand);
        data = data.filter(params.filterCommand);
        data = data.bin(params.transformCommand);
        data = data.summarize(params.summaryCommand);
        data = data.series(params.seriesCommand);
        data = data.sort(params.sortCommand);
        data = data.stack(params.stackCommand);
        data.set("parameters", (Object)params);
        return data;
    }

    private String makeSeriesCommand(VisSingle vis) {
        if (vis.fY.size() < 2) {
            return "";
        }
        LinkedHashSet<String> keep = new LinkedHashSet<String>();
        for (Param p : vis.fX) {
            keep.add(p.asString());
        }
        Collections.addAll(keep, vis.nonPositionFields());
        keep.remove("#series");
        keep.remove("#values");
        return Data.join(vis.fY) + ";" + Data.join(keep);
    }

    private void buildElement(VisSingle vis, Dataset data, ElementDependency dependency) {
        try {
            this.controls.buildControls(vis, vis.getDataset());
            this.currentElementID = this.defineElement(vis, data, this.indexOf(vis.getDataset(), this.datasets), dependency);
            if (vis.styles != null) {
                StyleSheet styles = vis.styles.replaceClass("currentElement", this.currentElementID);
                this.visStyles.add(styles, this.currentChartID);
            }
        }
        catch (Exception e) {
            throw VisException.makeBuilding(e, vis);
        }
    }

    private int indexOf(Dataset data, Dataset[] datasets) {
        for (int i = 0; i < datasets.length; ++i) {
            if (data != datasets[i]) continue;
            return i;
        }
        throw new IllegalStateException("Could not find data set in array of datasets");
    }

    protected abstract void endVisSystem(VisItem var1, String var2);

    protected abstract void endChart(String var1);

    private double squarifyDivergence(double[][] rects, int width, int height) {
        double sum = 0.0;
        for (double[] r : rects) {
            double h = Math.abs(r[1] - r[3]) * (double)width;
            double v = Math.abs(r[0] - r[2]) * (double)height;
            double div = h / v - 1.62;
            sum += Math.sqrt(h * v) * div * div;
        }
        return sum;
    }

    private String makeConstantsCommand(VisSingle vis) {
        ArrayList<String> toAdd = new ArrayList<String>();
        for (String f : vis.usedFields(false)) {
            if (f.startsWith("#") || vis.getDataset().field(f) != null) continue;
            toAdd.add(f);
        }
        return Data.join(toAdd, (String)"; ");
    }

    private String makeFilterCommands(VisSingle vis) {
        String[] pos;
        ArrayList<String> commands = new ArrayList<String>();
        for (String s : pos = vis.positionFields()) {
            Field f = vis.getDataset().field(s);
            if (f == null || !(f.numericProperty("valid") < (double)f.rowCount())) continue;
            commands.add(s + " valid");
        }
        for (Map.Entry<Param, String> e : vis.fTransform.entrySet()) {
            int N;
            String operation = e.getValue();
            Param key = e.getKey();
            String name = this.getParameterFieldValue(vis, key);
            Field f = vis.getDataset().field(name);
            if (f == null) {
                N = vis.getDataset().rowCount();
            } else {
                name = f.name;
                N = f.valid();
            }
            if (name.equals("#row")) {
                if (operation.equals("top")) {
                    operation = "bottom";
                } else if (operation.equals("bottom")) {
                    operation = "top";
                }
            }
            int n = this.getParameterIntValue(key, 10);
            if (operation.equals("top")) {
                commands.add(name + " ranked 1," + n);
                continue;
            }
            if (operation.equals("bottom")) {
                commands.add(name + " ranked " + (N - n) + "," + N);
                continue;
            }
            if (operation.equals("inner")) {
                commands.add(name + " ranked " + n + "," + (N - n));
                continue;
            }
            if (!operation.equals("outer")) continue;
            commands.add(name + " !ranked " + n + "," + (N - n));
        }
        return Data.join(commands, (String)"; ");
    }

    private String getParameterFieldValue(VisSingle vis, Param param) {
        String s;
        if (param != null && param.isField()) {
            return param.asField();
        }
        if (vis.fY.size() == 1 && !(s = vis.fY.get(0).asField()).startsWith("'") && !s.startsWith("#")) {
            return s;
        }
        if (vis.aestheticFields().length > 0) {
            return vis.aestheticFields()[0];
        }
        return "#row";
    }

    protected int getParameterIntValue(Param param, int defaultValue) {
        if (param == null) {
            return defaultValue;
        }
        if (param.isField()) {
            return this.getParameterIntValue(param.firstModifier(), defaultValue);
        }
        return (int)param.asDouble();
    }

    private String makeFieldCommands(List<Param> params) {
        Object[] commands = new String[params.size()];
        for (int i = 0; i < params.size(); ++i) {
            Param p = params.get(i);
            String s = p.asField();
            commands[i] = p.hasModifiers() ? s + ":" + p.firstModifier().asString() : s;
        }
        return Data.join((Object[])commands, (String)"; ");
    }

    private String buildSummaryCommands(VisSingle item) {
        HashMap<String, String> spec = new HashMap<String, String>();
        HashSet<String> fields = new HashSet<String>(Arrays.asList(item.usedFields(false)));
        fields.remove("#series");
        fields.remove("#values");
        for (Map.Entry<Param, String> entry : item.fSummarize.entrySet()) {
            Param p = entry.getKey();
            String name = p.asField();
            String measure = entry.getValue();
            if (p.hasModifiers()) {
                measure = measure + ":" + p.firstModifier().asString();
            }
            spec.put(name, name + ":" + measure);
            fields.remove(name);
        }
        for (String string : fields) {
            if (string.equals("#count")) {
                spec.put(string, string + ":sum");
                continue;
            }
            spec.put(string, string);
        }
        for (Param param : item.fX) {
            spec.put(param.asField(), param.asField() + ":base");
        }
        if (spec.containsKey("#count") || item.fSummarize.size() > 0) {
            Object[] result = new String[spec.size()];
            boolean bl = false;
            for (Map.Entry e : spec.entrySet()) {
                result[++var5_11] = (String)e.getKey() + "=" + (String)e.getValue();
            }
            return Data.join((Object[])result, (String)"; ");
        }
        return "";
    }

    private String makeTransformCommands(VisSingle item) {
        if (item.fTransform.isEmpty()) {
            return "";
        }
        StringBuilder b = new StringBuilder();
        for (Map.Entry<Param, String> e : item.fTransform.entrySet()) {
            Param p = e.getKey();
            String name = p.asField();
            String measure = e.getValue();
            if (!measure.equals("bin") && !measure.equals("rank")) continue;
            if (p.hasModifiers()) {
                measure = measure + ":" + p.firstModifier().asString();
            }
            if (b.length() > 0) {
                b.append("; ");
            }
            b.append(name).append("=").append(measure);
        }
        return b.toString();
    }

    private String required(String[] fields) {
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, fields);
        if (!result.contains("#row")) {
            result.add("#row");
        }
        if (!result.contains("#count")) {
            result.add("#count");
        }
        return Data.join(result, (String)"; ");
    }

    protected abstract DataTransformParameters modifyParameters(DataTransformParameters var1, VisSingle var2);

    protected abstract String defineElement(VisSingle var1, Dataset var2, int var3, ElementDependency var4);
}

