/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import java.util.ArrayList;
import java.util.List;
import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.summary.MeasureField;
import org.brunel.data.summary.Regression;
import org.brunel.data.summary.Smooth;
import org.brunel.data.util.ItemsList;
import org.brunel.data.util.Range;

public final class SummaryValues {
    private final Field[] fields;
    public final List<Integer> rows = new ArrayList<Integer>();
    public double[] percentSums;

    public SummaryValues(Field[] fields) {
        this.fields = fields;
    }

    public int firstRow() {
        return this.rows.get(0);
    }

    public Object get(int fieldIndex, MeasureField m, Field[] xFields) {
        String summary = m.measureFunction;
        if (summary.equals("count")) {
            return this.rows.size();
        }
        if (summary.equals("fit")) {
            Field x = xFields[0];
            if (m.fit == null) {
                m.fit = new Regression(m.field, x);
            }
            return m.fit.get(x.value(this.rows.get(0)));
        }
        if (summary.equals("smooth")) {
            Field x = xFields[0];
            Double windowPercent = null;
            if (m.option != null) {
                windowPercent = Double.parseDouble(m.option);
            }
            if (m.fit == null) {
                m.fit = new Smooth(m.field, x, windowPercent);
            }
            return m.fit.get(x.value(this.rows.get(0)));
        }
        Object[] data = new Object[this.rows.size()];
        for (int i = 0; i < data.length; ++i) {
            data[i] = this.fields[fieldIndex].value(this.rows.get(i));
        }
        Field f = Data.makeColumnField("temp", null, data);
        Double mean = f.numericProperty("mean");
        if (summary.equals("percent")) {
            if (mean == null) {
                return null;
            }
            double sum = this.percentSums[fieldIndex];
            return sum > 0.0 ? Double.valueOf(100.0 * mean * f.numericProperty("valid") / sum) : null;
        }
        if (summary.equals("range")) {
            if (mean == null) {
                return null;
            }
            Double low = f.numericProperty("min");
            Double high = f.numericProperty("max");
            return low == null ? null : Range.make(low, high, m.getDateFormat());
        }
        if (summary.equals("iqr")) {
            if (mean == null) {
                return null;
            }
            Double low = f.numericProperty("q1");
            Double high = f.numericProperty("q3");
            return low == null ? null : Range.make(low, high, m.getDateFormat());
        }
        if (summary.equals("sum")) {
            if (mean == null) {
                return null;
            }
            return mean * f.numericProperty("valid");
        }
        if (summary.equals("list")) {
            ItemsList categories = new ItemsList((Object[])f.property("categories"), m.getDateFormat());
            if (m.option != null) {
                int displayCount = Integer.parseInt(m.option);
                categories.setDisplayCount(displayCount);
            }
            return categories;
        }
        return f.property(summary);
    }
}

