/*
 * Decompiled with CFR 0.152.
 */
package org.brunel.data.summary;

import org.brunel.data.Data;
import org.brunel.data.Field;
import org.brunel.data.auto.Auto;
import org.brunel.data.summary.Fit;
import org.brunel.data.summary.Regression;

public class Smooth
implements Fit {
    private final int delta;
    private final double[][] data;

    public Smooth(Field y, Field x, Double windowPercent) {
        if (windowPercent == null) {
            int n = Auto.optimalBinCount(x);
            this.delta = Math.max(2, Math.round(x.valid() / n));
        } else {
            this.delta = Math.max(2, (int)((double)x.valid() * windowPercent / 200.0));
        }
        this.data = Regression.asPairs(y, x);
    }

    @Override
    public Double get(Object value) {
        Double at = Data.asNumeric(value);
        if (at == null) {
            return null;
        }
        double[] y = this.data[0];
        double[] x = this.data[1];
        int idx = this.search(at, x);
        int low = Math.max(0, idx - this.delta);
        int high = Math.min(idx + this.delta, x.length - 1);
        double window = Math.max(at - x[low], x[high] - at);
        double sy = 0.0;
        double sw = 0.0;
        for (int i = low; i <= high; ++i) {
            double d = (x[i] - at) / window;
            double w = 0.75 * (1.0 - d * d);
            sw += w;
            sy += w * y[i];
        }
        return sw > 0.0 ? Double.valueOf(sy / sw) : null;
    }

    private int search(double at, double[] x) {
        int p = 0;
        int q = x.length - 1;
        while (q - p > 1) {
            int t = p + q >> 1;
            if (x[t] <= at) {
                p = t;
            }
            if (!(x[t] >= at)) continue;
            q = t;
        }
        while (p > 0 && x[p - 1] == at) {
            --p;
        }
        while (q < x.length - 1 && x[q + 1] == at) {
            ++q;
        }
        return p + q >> 1;
    }
}

