/* File: coremodule.c
 * This file is auto-generated with f2py (version:2).
 * f2py is a Fortran to Python Interface Generator (FPIG), Second Edition,
 * written by Pearu Peterson <pearu@cens.ioc.ee>.
 * See http://cens.ioc.ee/projects/f2py2e/
 * Generation date: Fri Dec 11 10:48:27 2015
 * $Revision:$
 * $Date:$
 * Do not edit this file directly unless you know what you are doing!!!
 */

#ifdef __cplusplus
extern "C" {
#endif

/*********************** See f2py2e/cfuncs.py: includes ***********************/
#include "Python.h"
#include <stdarg.h>
#include "fortranobject.h"
#include <math.h>

/**************** See f2py2e/rules.py: mod_rules['modulebody'] ****************/
static PyObject *core_error;
static PyObject *core_module;

/*********************** See f2py2e/cfuncs.py: typedefs ***********************/
typedef struct {double r,i;} complex_double;

/****************** See f2py2e/cfuncs.py: typedefs_generated ******************/
/*need_typedefs_generated*/

/********************** See f2py2e/cfuncs.py: cppmacros **********************/
#if defined(PREPEND_FORTRAN)
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F
#else
#define F_FUNC(f,F) _##f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) _##F##_
#else
#define F_FUNC(f,F) _##f##_
#endif
#endif
#else
#if defined(NO_APPEND_FORTRAN)
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F
#else
#define F_FUNC(f,F) f
#endif
#else
#if defined(UPPERCASE_FORTRAN)
#define F_FUNC(f,F) F##_
#else
#define F_FUNC(f,F) f##_
#endif
#endif
#endif
#if defined(UNDERSCORE_G77)
#define F_FUNC_US(f,F) F_FUNC(f##_,F##_)
#else
#define F_FUNC_US(f,F) F_FUNC(f,F)
#endif

#define rank(var) var ## _Rank
#define shape(var,dim) var ## _Dims[dim]
#define old_rank(var) (PyArray_NDIM((PyArrayObject *)(capi_ ## var ## _tmp)))
#define old_shape(var,dim) PyArray_DIM(((PyArrayObject *)(capi_ ## var ## _tmp)),dim)
#define fshape(var,dim) shape(var,rank(var)-dim-1)
#define len(var) shape(var,0)
#define flen(var) fshape(var,0)
#define old_size(var) PyArray_SIZE((PyArrayObject *)(capi_ ## var ## _tmp))
/* #define index(i) capi_i ## i */
#define slen(var) capi_ ## var ## _len
#define size(var, ...) f2py_size((PyArrayObject *)(capi_ ## var ## _tmp), ## __VA_ARGS__, -1)

#ifdef DEBUGCFUNCS
#define CFUNCSMESS(mess) fprintf(stderr,"debug-capi:"mess);
#define CFUNCSMESSPY(mess,obj) CFUNCSMESS(mess) \
  PyObject_Print((PyObject *)obj,stderr,Py_PRINT_RAW);\
  fprintf(stderr,"\n");
#else
#define CFUNCSMESS(mess)
#define CFUNCSMESSPY(mess,obj)
#endif

#ifndef max
#define max(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef min
#define min(a,b) ((a < b) ? (a) : (b))
#endif
#ifndef MAX
#define MAX(a,b) ((a > b) ? (a) : (b))
#endif
#ifndef MIN
#define MIN(a,b) ((a < b) ? (a) : (b))
#endif

#define pyobj_from_complex_double1(v) (PyComplex_FromDoubles(v.r,v.i))
#define CHECKSCALAR(check,tcheck,name,show,var)\
  if (!(check)) {\
    char errstring[256];\
    sprintf(errstring, "%s: "show, "("tcheck") failed for "name, var);\
    PyErr_SetString(core_error,errstring);\
    /*goto capi_fail;*/\
  } else 

/************************ See f2py2e/cfuncs.py: cfuncs ************************/
static int f2py_size(PyArrayObject* var, ...)
{
  npy_int sz = 0;
  npy_int dim;
  npy_int rank;
  va_list argp;
  va_start(argp, var);
  dim = va_arg(argp, npy_int);
  if (dim==-1)
    {
      sz = PyArray_SIZE(var);
    }
  else
    {
      rank = PyArray_NDIM(var);
      if (dim>=1 && dim<=rank)
        sz = PyArray_DIM(var, dim-1);
      else
        fprintf(stderr, "f2py_size: 2nd argument value=%d fails to satisfy 1<=value<=%d. Result will be 0.\n", dim, rank);
    }
  va_end(argp);
  return sz;
}

static int complex_double_from_pyobj(complex_double* v,PyObject *obj,const char *errmess) {
  Py_complex c;
  if (PyComplex_Check(obj)) {
    c=PyComplex_AsCComplex(obj);
    (*v).r=c.real, (*v).i=c.imag;
    return 1;
  }
  if (PyArray_IsScalar(obj, ComplexFloating)) {
    if (PyArray_IsScalar(obj, CFloat)) {
      npy_cfloat new;
      PyArray_ScalarAsCtype(obj, &new);
      (*v).r = (double)new.real;
      (*v).i = (double)new.imag;
    }
    else if (PyArray_IsScalar(obj, CLongDouble)) {
      npy_clongdouble new;
      PyArray_ScalarAsCtype(obj, &new);
      (*v).r = (double)new.real;
      (*v).i = (double)new.imag;
    }
    else { /* if (PyArray_IsScalar(obj, CDouble)) */
      PyArray_ScalarAsCtype(obj, v);
    }
    return 1;
  }
  if (PyArray_CheckScalar(obj)) { /* 0-dim array or still array scalar */
    PyObject *arr;
    if (PyArray_Check(obj)) {
      arr = PyArray_Cast((PyArrayObject *)obj, NPY_CDOUBLE);
    }
    else {
      arr = PyArray_FromScalar(obj, PyArray_DescrFromType(NPY_CDOUBLE));
    }
    if (arr==NULL) return 0;
    (*v).r = ((npy_cdouble *)PyArray_DATA(arr))->real;
    (*v).i = ((npy_cdouble *)PyArray_DATA(arr))->imag;
    return 1;
  }
  /* Python does not provide PyNumber_Complex function :-( */
  (*v).i=0.0;
  if (PyFloat_Check(obj)) {
#ifdef __sgi
    (*v).r = PyFloat_AsDouble(obj);
#else
    (*v).r = PyFloat_AS_DOUBLE(obj);
#endif
    return 1;
  }
  if (PyInt_Check(obj)) {
    (*v).r = (double)PyInt_AS_LONG(obj);
    return 1;
  }
  if (PyLong_Check(obj)) {
    (*v).r = PyLong_AsDouble(obj);
    return (!PyErr_Occurred());
  }
  if (PySequence_Check(obj) && !(PyString_Check(obj) || PyUnicode_Check(obj))) {
    PyObject *tmp = PySequence_GetItem(obj,0);
    if (tmp) {
      if (complex_double_from_pyobj(v,tmp,errmess)) {
        Py_DECREF(tmp);
        return 1;
      }
      Py_DECREF(tmp);
    }
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL)
      err = PyExc_TypeError;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static int int_from_pyobj(int* v,PyObject *obj,const char *errmess) {
  PyObject* tmp = NULL;
  if (PyInt_Check(obj)) {
    *v = (int)PyInt_AS_LONG(obj);
    return 1;
  }
  tmp = PyNumber_Int(obj);
  if (tmp) {
    *v = PyInt_AS_LONG(tmp);
    Py_DECREF(tmp);
    return 1;
  }
  if (PyComplex_Check(obj))
    tmp = PyObject_GetAttrString(obj,"real");
  else if (PyString_Check(obj) || PyUnicode_Check(obj))
    /*pass*/;
  else if (PySequence_Check(obj))
    tmp = PySequence_GetItem(obj,0);
  if (tmp) {
    PyErr_Clear();
    if (int_from_pyobj(v,tmp,errmess)) {Py_DECREF(tmp); return 1;}
    Py_DECREF(tmp);
  }
  {
    PyObject* err = PyErr_Occurred();
    if (err==NULL) err = core_error;
    PyErr_SetString(err,errmess);
  }
  return 0;
}

static struct { int nd;npy_intp *d;int *i,*i_tr,tr; } forcombcache;
static int initforcomb(npy_intp *dims,int nd,int tr) {
  int k;
  if (dims==NULL) return 0;
  if (nd<0) return 0;
  forcombcache.nd = nd;
  forcombcache.d = dims;
  forcombcache.tr = tr;
  if ((forcombcache.i = (int *)malloc(sizeof(int)*nd))==NULL) return 0;
  if ((forcombcache.i_tr = (int *)malloc(sizeof(int)*nd))==NULL) return 0;
  for (k=1;k<nd;k++) {
    forcombcache.i[k] = forcombcache.i_tr[nd-k-1] = 0;
  }
  forcombcache.i[0] = forcombcache.i_tr[nd-1] = -1;
  return 1;
}
static int *nextforcomb(void) {
  int j,*i,*i_tr,k;
  int nd=forcombcache.nd;
  if ((i=forcombcache.i) == NULL) return NULL;
  if ((i_tr=forcombcache.i_tr) == NULL) return NULL;
  if (forcombcache.d == NULL) return NULL;
  i[0]++;
  if (i[0]==forcombcache.d[0]) {
    j=1;
    while ((j<nd) && (i[j]==forcombcache.d[j]-1)) j++;
    if (j==nd) {
      free(i);
      free(i_tr);
      return NULL;
    }
    for (k=0;k<j;k++) i[k] = i_tr[nd-k-1] = 0;
    i[j]++;
    i_tr[nd-j-1]++;
  } else
    i_tr[nd-1]++;
  if (forcombcache.tr) return i_tr;
  return i;
}

/********************* See f2py2e/cfuncs.py: userincludes *********************/
/*need_userincludes*/

/********************* See f2py2e/capi_rules.py: usercode *********************/


/* See f2py2e/rules.py */
extern void F_FUNC_US(arcioni_singular,ARCIONI_SINGULAR)(double*,double*,double*);
extern void F_FUNC_US(z_efie_faces_mutual,Z_EFIE_FACES_MUTUAL)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,complex_double*,complex_double*,complex_double*,complex_double*);
extern void F_FUNC_US(z_efie_faces_self,Z_EFIE_FACES_SELF)(int*,int*,int*,int*,int*,double*,int*,complex_double*,double*,double*,double*,double*,int*,int*,complex_double*,complex_double*,complex_double*,complex_double*);
extern void F_FUNC_US(face_integrals_hanninen,FACE_INTEGRALS_HANNINEN)(double*,int*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC_US(face_integrals_yla_oijala,FACE_INTEGRALS_YLA_OIJALA)(double*,int*,double*,double*,double*,double*,double*,double*,double*,double*);
extern void F_FUNC_US(z_mfie_faces_self,Z_MFIE_FACES_SELF)(int*,int*,int*,int*,int*,double*,int*,double*,complex_double*,double*,double*,double*,int*,double*,int*,int*,complex_double*,complex_double*);
extern void F_FUNC_US(z_mfie_faces_mutual,Z_MFIE_FACES_MUTUAL)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,double*,int*,complex_double*,complex_double*);
extern void F_FUNC_US(set_threads,SET_THREADS)(int*);
extern void F_FUNC_US(get_threads,GET_THREADS)(int*);
/*eof externroutines*/

/******************** See f2py2e/capi_rules.py: usercode1 ********************/


/******************* See f2py2e/cb_rules.py: buildcallback *******************/
/*need_callbacks*/

/*********************** See f2py2e/rules.py: buildapi ***********************/

/****************************** arcioni_singular ******************************/
static char doc_f2py_rout_core_arcioni_singular[] = "\
i_a,i_phi = arcioni_singular(nodes)\n\nWrapper for ``arcioni_singular``.\
\n\nParameters\n----------\n"
"nodes : input rank-2 array('d') with bounds (3,3)\n"
"\nReturns\n-------\n"
"i_a : rank-2 array('d') with bounds (3,3)\n"
"i_phi : float";
/* extern void F_FUNC_US(arcioni_singular,ARCIONI_SINGULAR)(double*,double*,double*); */
static PyObject *f2py_rout_core_arcioni_singular(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *nodes = NULL;
  npy_intp nodes_Dims[2] = {-1, -1};
  const int nodes_Rank = 2;
  PyArrayObject *capi_nodes_tmp = NULL;
  int capi_nodes_intent = 0;
  PyObject *nodes_capi = Py_None;
  double *i_a = NULL;
  npy_intp i_a_Dims[2] = {-1, -1};
  const int i_a_Rank = 2;
  PyArrayObject *capi_i_a_tmp = NULL;
  int capi_i_a_intent = 0;
  double i_phi = 0;
  static char *capi_kwlist[] = {"nodes",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:core.arcioni_singular",\
    capi_kwlist,&nodes_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i_a */
  i_a_Dims[0]=3,i_a_Dims[1]=3;
  capi_i_a_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_a_tmp = array_from_pyobj(NPY_DOUBLE,i_a_Dims,i_a_Rank,capi_i_a_intent,Py_None);
  if (capi_i_a_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_a' of core.arcioni_singular to C/Fortran array" );
  } else {
    i_a = (double *)(PyArray_DATA(capi_i_a_tmp));

  /* Processing variable i_phi */
  /* Processing variable nodes */
  nodes_Dims[0]=3,nodes_Dims[1]=3;
  capi_nodes_intent |= F2PY_INTENT_IN;
  capi_nodes_tmp = array_from_pyobj(NPY_DOUBLE,nodes_Dims,nodes_Rank,capi_nodes_intent,nodes_capi);
  if (capi_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes' of core.arcioni_singular to C/Fortran array" );
  } else {
    nodes = (double *)(PyArray_DATA(capi_nodes_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(nodes,i_a,&i_phi);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("Nd",capi_i_a_tmp,i_phi);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_nodes_tmp!=nodes_capi) {
    Py_XDECREF(capi_nodes_tmp); }
  }  /*if (capi_nodes_tmp == NULL) ... else of nodes*/
  /* End of cleaning variable nodes */
  /* End of cleaning variable i_phi */
  }  /*if (capi_i_a_tmp == NULL) ... else of i_a*/
  /* End of cleaning variable i_a */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of arcioni_singular **************************/

/**************************** z_efie_faces_mutual ****************************/
static char doc_f2py_rout_core_z_efie_faces_mutual[] = "\
a_face,phi_face,a_dgamma_face,phi_dgamma_face = z_efie_faces_mutual(nodes_o,triangle_nodes_o,nodes_s,triangle_nodes_s,gamma_0,xi_eta_eval,weights,[num_nodes_o,num_triangles_o,num_nodes_s,num_triangles_s,num_integration])\n\nWrapper for ``z_efie_faces_mutual``.\
\n\nParameters\n----------\n"
"nodes_o : input rank-2 array('d') with bounds (num_nodes_o,3)\n"
"triangle_nodes_o : input rank-2 array('i') with bounds (num_triangles_o,3)\n"
"nodes_s : input rank-2 array('d') with bounds (num_nodes_s,3)\n"
"triangle_nodes_s : input rank-2 array('i') with bounds (num_triangles_s,3)\n"
"gamma_0 : input complex\n"
"xi_eta_eval : input rank-2 array('d') with bounds (num_integration,2)\n"
"weights : input rank-1 array('d') with bounds (num_integration)\n"
"\nOther Parameters\n----------------\n"
"num_nodes_o : input int, optional\n    Default: shape(nodes_o,0)\n"
"num_triangles_o : input int, optional\n    Default: shape(triangle_nodes_o,0)\n"
"num_nodes_s : input int, optional\n    Default: shape(nodes_s,0)\n"
"num_triangles_s : input int, optional\n    Default: shape(triangle_nodes_s,0)\n"
"num_integration : input int, optional\n    Default: shape(xi_eta_eval,0)\n"
"\nReturns\n-------\n"
"a_face : rank-4 array('D') with bounds (num_triangles_o,3,num_triangles_s,3)\n"
"phi_face : rank-2 array('D') with bounds (num_triangles_o,num_triangles_s)\n"
"a_dgamma_face : rank-4 array('D') with bounds (num_triangles_o,3,num_triangles_s,3)\n"
"phi_dgamma_face : rank-2 array('D') with bounds (num_triangles_o,num_triangles_s)";
/* extern void F_FUNC_US(z_efie_faces_mutual,Z_EFIE_FACES_MUTUAL)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,complex_double*,complex_double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_z_efie_faces_mutual(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,complex_double*,complex_double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes_o = 0;
  PyObject *num_nodes_o_capi = Py_None;
  int num_triangles_o = 0;
  PyObject *num_triangles_o_capi = Py_None;
  int num_nodes_s = 0;
  PyObject *num_nodes_s_capi = Py_None;
  int num_triangles_s = 0;
  PyObject *num_triangles_s_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  double *nodes_o = NULL;
  npy_intp nodes_o_Dims[2] = {-1, -1};
  const int nodes_o_Rank = 2;
  PyArrayObject *capi_nodes_o_tmp = NULL;
  int capi_nodes_o_intent = 0;
  PyObject *nodes_o_capi = Py_None;
  int *triangle_nodes_o = NULL;
  npy_intp triangle_nodes_o_Dims[2] = {-1, -1};
  const int triangle_nodes_o_Rank = 2;
  PyArrayObject *capi_triangle_nodes_o_tmp = NULL;
  int capi_triangle_nodes_o_intent = 0;
  PyObject *triangle_nodes_o_capi = Py_None;
  double *nodes_s = NULL;
  npy_intp nodes_s_Dims[2] = {-1, -1};
  const int nodes_s_Rank = 2;
  PyArrayObject *capi_nodes_s_tmp = NULL;
  int capi_nodes_s_intent = 0;
  PyObject *nodes_s_capi = Py_None;
  int *triangle_nodes_s = NULL;
  npy_intp triangle_nodes_s_Dims[2] = {-1, -1};
  const int triangle_nodes_s_Rank = 2;
  PyArrayObject *capi_triangle_nodes_s_tmp = NULL;
  int capi_triangle_nodes_s_intent = 0;
  PyObject *triangle_nodes_s_capi = Py_None;
  complex_double gamma_0;
  PyObject *gamma_0_capi = Py_None;
  double *xi_eta_eval = NULL;
  npy_intp xi_eta_eval_Dims[2] = {-1, -1};
  const int xi_eta_eval_Rank = 2;
  PyArrayObject *capi_xi_eta_eval_tmp = NULL;
  int capi_xi_eta_eval_intent = 0;
  PyObject *xi_eta_eval_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  complex_double *a_face = NULL;
  npy_intp a_face_Dims[4] = {-1, -1, -1, -1};
  const int a_face_Rank = 4;
  PyArrayObject *capi_a_face_tmp = NULL;
  int capi_a_face_intent = 0;
  complex_double *phi_face = NULL;
  npy_intp phi_face_Dims[2] = {-1, -1};
  const int phi_face_Rank = 2;
  PyArrayObject *capi_phi_face_tmp = NULL;
  int capi_phi_face_intent = 0;
  complex_double *a_dgamma_face = NULL;
  npy_intp a_dgamma_face_Dims[4] = {-1, -1, -1, -1};
  const int a_dgamma_face_Rank = 4;
  PyArrayObject *capi_a_dgamma_face_tmp = NULL;
  int capi_a_dgamma_face_intent = 0;
  complex_double *phi_dgamma_face = NULL;
  npy_intp phi_dgamma_face_Dims[2] = {-1, -1};
  const int phi_dgamma_face_Rank = 2;
  PyArrayObject *capi_phi_dgamma_face_tmp = NULL;
  int capi_phi_dgamma_face_intent = 0;
  static char *capi_kwlist[] = {"nodes_o","triangle_nodes_o","nodes_s","triangle_nodes_s","gamma_0","xi_eta_eval","weights","num_nodes_o","num_triangles_o","num_nodes_s","num_triangles_s","num_integration",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOO|OOOOO:core.z_efie_faces_mutual",\
    capi_kwlist,&nodes_o_capi,&triangle_nodes_o_capi,&nodes_s_capi,&triangle_nodes_s_capi,&gamma_0_capi,&xi_eta_eval_capi,&weights_capi,&num_nodes_o_capi,&num_triangles_o_capi,&num_nodes_s_capi,&num_triangles_s_capi,&num_integration_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable nodes_s */
  nodes_s_Dims[1]=3;
  capi_nodes_s_intent |= F2PY_INTENT_IN;
  capi_nodes_s_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_Dims,nodes_s_Rank,capi_nodes_s_intent,nodes_s_capi);
  if (capi_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `nodes_s' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    nodes_s = (double *)(PyArray_DATA(capi_nodes_s_tmp));

  /* Processing variable triangle_nodes_s */
  triangle_nodes_s_Dims[1]=3;
  capi_triangle_nodes_s_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_s_tmp = array_from_pyobj(NPY_INT,triangle_nodes_s_Dims,triangle_nodes_s_Rank,capi_triangle_nodes_s_intent,triangle_nodes_s_capi);
  if (capi_triangle_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `triangle_nodes_s' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    triangle_nodes_s = (int *)(PyArray_DATA(capi_triangle_nodes_s_tmp));

  /* Processing variable gamma_0 */
    f2py_success = complex_double_from_pyobj(&gamma_0,gamma_0_capi,"core.z_efie_faces_mutual() 5th argument (gamma_0) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable triangle_nodes_o */
  triangle_nodes_o_Dims[1]=3;
  capi_triangle_nodes_o_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_o_tmp = array_from_pyobj(NPY_INT,triangle_nodes_o_Dims,triangle_nodes_o_Rank,capi_triangle_nodes_o_intent,triangle_nodes_o_capi);
  if (capi_triangle_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangle_nodes_o' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    triangle_nodes_o = (int *)(PyArray_DATA(capi_triangle_nodes_o_tmp));

  /* Processing variable nodes_o */
  nodes_o_Dims[1]=3;
  capi_nodes_o_intent |= F2PY_INTENT_IN;
  capi_nodes_o_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_Dims,nodes_o_Rank,capi_nodes_o_intent,nodes_o_capi);
  if (capi_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes_o' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    nodes_o = (double *)(PyArray_DATA(capi_nodes_o_tmp));

  /* Processing variable xi_eta_eval */
  xi_eta_eval_Dims[1]=2;
  capi_xi_eta_eval_intent |= F2PY_INTENT_IN;
  capi_xi_eta_eval_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_eval_Dims,xi_eta_eval_Rank,capi_xi_eta_eval_intent,xi_eta_eval_capi);
  if (capi_xi_eta_eval_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `xi_eta_eval' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    xi_eta_eval = (double *)(PyArray_DATA(capi_xi_eta_eval_tmp));

  /* Processing variable num_nodes_s */
  if (num_nodes_s_capi == Py_None) num_nodes_s = shape(nodes_s,0); else
    f2py_success = int_from_pyobj(&num_nodes_s,num_nodes_s_capi,"core.z_efie_faces_mutual() 3rd keyword (num_nodes_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes_s,0)==num_nodes_s,"shape(nodes_s,0)==num_nodes_s","3rd keyword num_nodes_s","z_efie_faces_mutual:num_nodes_s=%d",num_nodes_s) {
  /* Processing variable num_triangles_o */
  if (num_triangles_o_capi == Py_None) num_triangles_o = shape(triangle_nodes_o,0); else
    f2py_success = int_from_pyobj(&num_triangles_o,num_triangles_o_capi,"core.z_efie_faces_mutual() 2nd keyword (num_triangles_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes_o,0)==num_triangles_o,"shape(triangle_nodes_o,0)==num_triangles_o","2nd keyword num_triangles_o","z_efie_faces_mutual:num_triangles_o=%d",num_triangles_o) {
  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta_eval,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.z_efie_faces_mutual() 5th keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_eval,0)==num_integration,"shape(xi_eta_eval,0)==num_integration","5th keyword num_integration","z_efie_faces_mutual:num_integration=%d",num_integration) {
  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 7th argument `weights' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    weights = (double *)(PyArray_DATA(capi_weights_tmp));

  /* Processing variable num_triangles_s */
  if (num_triangles_s_capi == Py_None) num_triangles_s = shape(triangle_nodes_s,0); else
    f2py_success = int_from_pyobj(&num_triangles_s,num_triangles_s_capi,"core.z_efie_faces_mutual() 4th keyword (num_triangles_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes_s,0)==num_triangles_s,"shape(triangle_nodes_s,0)==num_triangles_s","4th keyword num_triangles_s","z_efie_faces_mutual:num_triangles_s=%d",num_triangles_s) {
  /* Processing variable num_nodes_o */
  if (num_nodes_o_capi == Py_None) num_nodes_o = shape(nodes_o,0); else
    f2py_success = int_from_pyobj(&num_nodes_o,num_nodes_o_capi,"core.z_efie_faces_mutual() 1st keyword (num_nodes_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes_o,0)==num_nodes_o,"shape(nodes_o,0)==num_nodes_o","1st keyword num_nodes_o","z_efie_faces_mutual:num_nodes_o=%d",num_nodes_o) {
  /* Processing variable phi_dgamma_face */
  phi_dgamma_face_Dims[0]=num_triangles_o,phi_dgamma_face_Dims[1]=num_triangles_s;
  capi_phi_dgamma_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_phi_dgamma_face_tmp = array_from_pyobj(NPY_CDOUBLE,phi_dgamma_face_Dims,phi_dgamma_face_Rank,capi_phi_dgamma_face_intent,Py_None);
  if (capi_phi_dgamma_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `phi_dgamma_face' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    phi_dgamma_face = (complex_double *)(PyArray_DATA(capi_phi_dgamma_face_tmp));

  /* Processing variable a_face */
  a_face_Dims[0]=num_triangles_o,a_face_Dims[1]=3,a_face_Dims[2]=num_triangles_s,a_face_Dims[3]=3;
  capi_a_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a_face_tmp = array_from_pyobj(NPY_CDOUBLE,a_face_Dims,a_face_Rank,capi_a_face_intent,Py_None);
  if (capi_a_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `a_face' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    a_face = (complex_double *)(PyArray_DATA(capi_a_face_tmp));

  /* Processing variable a_dgamma_face */
  a_dgamma_face_Dims[0]=num_triangles_o,a_dgamma_face_Dims[1]=3,a_dgamma_face_Dims[2]=num_triangles_s,a_dgamma_face_Dims[3]=3;
  capi_a_dgamma_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a_dgamma_face_tmp = array_from_pyobj(NPY_CDOUBLE,a_dgamma_face_Dims,a_dgamma_face_Rank,capi_a_dgamma_face_intent,Py_None);
  if (capi_a_dgamma_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `a_dgamma_face' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    a_dgamma_face = (complex_double *)(PyArray_DATA(capi_a_dgamma_face_tmp));

  /* Processing variable phi_face */
  phi_face_Dims[0]=num_triangles_o,phi_face_Dims[1]=num_triangles_s;
  capi_phi_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_phi_face_tmp = array_from_pyobj(NPY_CDOUBLE,phi_face_Dims,phi_face_Rank,capi_phi_face_intent,Py_None);
  if (capi_phi_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `phi_face' of core.z_efie_faces_mutual to C/Fortran array" );
  } else {
    phi_face = (complex_double *)(PyArray_DATA(capi_phi_face_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes_o,&num_triangles_o,&num_nodes_s,&num_triangles_s,&num_integration,nodes_o,triangle_nodes_o,nodes_s,triangle_nodes_s,&gamma_0,xi_eta_eval,weights,a_face,phi_face,a_dgamma_face,phi_dgamma_face);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NNNN",capi_a_face_tmp,capi_phi_face_tmp,capi_a_dgamma_face_tmp,capi_phi_dgamma_face_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_phi_face_tmp == NULL) ... else of phi_face*/
  /* End of cleaning variable phi_face */
  }  /*if (capi_a_dgamma_face_tmp == NULL) ... else of a_dgamma_face*/
  /* End of cleaning variable a_dgamma_face */
  }  /*if (capi_a_face_tmp == NULL) ... else of a_face*/
  /* End of cleaning variable a_face */
  }  /*if (capi_phi_dgamma_face_tmp == NULL) ... else of phi_dgamma_face*/
  /* End of cleaning variable phi_dgamma_face */
  } /*CHECKSCALAR(shape(nodes_o,0)==num_nodes_o)*/
  } /*if (f2py_success) of num_nodes_o*/
  /* End of cleaning variable num_nodes_o */
  } /*CHECKSCALAR(shape(triangle_nodes_s,0)==num_triangles_s)*/
  } /*if (f2py_success) of num_triangles_s*/
  /* End of cleaning variable num_triangles_s */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  } /*CHECKSCALAR(shape(xi_eta_eval,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  } /*CHECKSCALAR(shape(triangle_nodes_o,0)==num_triangles_o)*/
  } /*if (f2py_success) of num_triangles_o*/
  /* End of cleaning variable num_triangles_o */
  } /*CHECKSCALAR(shape(nodes_s,0)==num_nodes_s)*/
  } /*if (f2py_success) of num_nodes_s*/
  /* End of cleaning variable num_nodes_s */
  if((PyObject *)capi_xi_eta_eval_tmp!=xi_eta_eval_capi) {
    Py_XDECREF(capi_xi_eta_eval_tmp); }
  }  /*if (capi_xi_eta_eval_tmp == NULL) ... else of xi_eta_eval*/
  /* End of cleaning variable xi_eta_eval */
  if((PyObject *)capi_nodes_o_tmp!=nodes_o_capi) {
    Py_XDECREF(capi_nodes_o_tmp); }
  }  /*if (capi_nodes_o_tmp == NULL) ... else of nodes_o*/
  /* End of cleaning variable nodes_o */
  if((PyObject *)capi_triangle_nodes_o_tmp!=triangle_nodes_o_capi) {
    Py_XDECREF(capi_triangle_nodes_o_tmp); }
  }  /*if (capi_triangle_nodes_o_tmp == NULL) ... else of triangle_nodes_o*/
  /* End of cleaning variable triangle_nodes_o */
  }  /*if (f2py_success) of gamma_0 frompyobj*/
  /* End of cleaning variable gamma_0 */
  if((PyObject *)capi_triangle_nodes_s_tmp!=triangle_nodes_s_capi) {
    Py_XDECREF(capi_triangle_nodes_s_tmp); }
  }  /*if (capi_triangle_nodes_s_tmp == NULL) ... else of triangle_nodes_s*/
  /* End of cleaning variable triangle_nodes_s */
  if((PyObject *)capi_nodes_s_tmp!=nodes_s_capi) {
    Py_XDECREF(capi_nodes_s_tmp); }
  }  /*if (capi_nodes_s_tmp == NULL) ... else of nodes_s*/
  /* End of cleaning variable nodes_s */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of z_efie_faces_mutual *************************/

/***************************** z_efie_faces_self *****************************/
static char doc_f2py_rout_core_z_efie_faces_self[] = "\
a_face,phi_face,a_dgamma_face,phi_dgamma_face = z_efie_faces_self(nodes,triangle_nodes,gamma_0,xi_eta_eval,weights,phi_precalc,a_precalc,indices_precalc,indptr_precalc,[num_nodes,num_triangles,num_integration,num_singular,degree_singular])\n\nWrapper for ``z_efie_faces_self``.\
\n\nParameters\n----------\n"
"nodes : input rank-2 array('d') with bounds (num_nodes,3)\n"
"triangle_nodes : input rank-2 array('i') with bounds (num_triangles,3)\n"
"gamma_0 : input complex\n"
"xi_eta_eval : input rank-2 array('d') with bounds (num_integration,2)\n"
"weights : input rank-1 array('d') with bounds (num_integration)\n"
"phi_precalc : input rank-2 array('d') with bounds (num_singular,degree_singular)\n"
"a_precalc : input rank-4 array('d') with bounds (num_singular,degree_singular,3,3)\n"
"indices_precalc : input rank-1 array('i') with bounds (num_singular)\n"
"indptr_precalc : input rank-1 array('i') with bounds (num_triangles + 1)\n"
"\nOther Parameters\n----------------\n"
"num_nodes : input int, optional\n    Default: shape(nodes,0)\n"
"num_triangles : input int, optional\n    Default: shape(triangle_nodes,0)\n"
"num_integration : input int, optional\n    Default: shape(xi_eta_eval,0)\n"
"num_singular : input int, optional\n    Default: shape(phi_precalc,0)\n"
"degree_singular : input int, optional\n    Default: shape(phi_precalc,1)\n"
"\nReturns\n-------\n"
"a_face : rank-4 array('D') with bounds (num_triangles,3,num_triangles,3)\n"
"phi_face : rank-2 array('D') with bounds (num_triangles,num_triangles)\n"
"a_dgamma_face : rank-4 array('D') with bounds (num_triangles,3,num_triangles,3)\n"
"phi_dgamma_face : rank-2 array('D') with bounds (num_triangles,num_triangles)";
/* extern void F_FUNC_US(z_efie_faces_self,Z_EFIE_FACES_SELF)(int*,int*,int*,int*,int*,double*,int*,complex_double*,double*,double*,double*,double*,int*,int*,complex_double*,complex_double*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_z_efie_faces_self(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*,double*,int*,complex_double*,double*,double*,double*,double*,int*,int*,complex_double*,complex_double*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes = 0;
  PyObject *num_nodes_capi = Py_None;
  int num_triangles = 0;
  PyObject *num_triangles_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  int num_singular = 0;
  PyObject *num_singular_capi = Py_None;
  int degree_singular = 0;
  PyObject *degree_singular_capi = Py_None;
  double *nodes = NULL;
  npy_intp nodes_Dims[2] = {-1, -1};
  const int nodes_Rank = 2;
  PyArrayObject *capi_nodes_tmp = NULL;
  int capi_nodes_intent = 0;
  PyObject *nodes_capi = Py_None;
  int *triangle_nodes = NULL;
  npy_intp triangle_nodes_Dims[2] = {-1, -1};
  const int triangle_nodes_Rank = 2;
  PyArrayObject *capi_triangle_nodes_tmp = NULL;
  int capi_triangle_nodes_intent = 0;
  PyObject *triangle_nodes_capi = Py_None;
  complex_double gamma_0;
  PyObject *gamma_0_capi = Py_None;
  double *xi_eta_eval = NULL;
  npy_intp xi_eta_eval_Dims[2] = {-1, -1};
  const int xi_eta_eval_Rank = 2;
  PyArrayObject *capi_xi_eta_eval_tmp = NULL;
  int capi_xi_eta_eval_intent = 0;
  PyObject *xi_eta_eval_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  double *phi_precalc = NULL;
  npy_intp phi_precalc_Dims[2] = {-1, -1};
  const int phi_precalc_Rank = 2;
  PyArrayObject *capi_phi_precalc_tmp = NULL;
  int capi_phi_precalc_intent = 0;
  PyObject *phi_precalc_capi = Py_None;
  double *a_precalc = NULL;
  npy_intp a_precalc_Dims[4] = {-1, -1, -1, -1};
  const int a_precalc_Rank = 4;
  PyArrayObject *capi_a_precalc_tmp = NULL;
  int capi_a_precalc_intent = 0;
  PyObject *a_precalc_capi = Py_None;
  int *indices_precalc = NULL;
  npy_intp indices_precalc_Dims[1] = {-1};
  const int indices_precalc_Rank = 1;
  PyArrayObject *capi_indices_precalc_tmp = NULL;
  int capi_indices_precalc_intent = 0;
  PyObject *indices_precalc_capi = Py_None;
  int *indptr_precalc = NULL;
  npy_intp indptr_precalc_Dims[1] = {-1};
  const int indptr_precalc_Rank = 1;
  PyArrayObject *capi_indptr_precalc_tmp = NULL;
  int capi_indptr_precalc_intent = 0;
  PyObject *indptr_precalc_capi = Py_None;
  complex_double *a_face = NULL;
  npy_intp a_face_Dims[4] = {-1, -1, -1, -1};
  const int a_face_Rank = 4;
  PyArrayObject *capi_a_face_tmp = NULL;
  int capi_a_face_intent = 0;
  complex_double *phi_face = NULL;
  npy_intp phi_face_Dims[2] = {-1, -1};
  const int phi_face_Rank = 2;
  PyArrayObject *capi_phi_face_tmp = NULL;
  int capi_phi_face_intent = 0;
  complex_double *a_dgamma_face = NULL;
  npy_intp a_dgamma_face_Dims[4] = {-1, -1, -1, -1};
  const int a_dgamma_face_Rank = 4;
  PyArrayObject *capi_a_dgamma_face_tmp = NULL;
  int capi_a_dgamma_face_intent = 0;
  complex_double *phi_dgamma_face = NULL;
  npy_intp phi_dgamma_face_Dims[2] = {-1, -1};
  const int phi_dgamma_face_Rank = 2;
  PyArrayObject *capi_phi_dgamma_face_tmp = NULL;
  int capi_phi_dgamma_face_intent = 0;
  static char *capi_kwlist[] = {"nodes","triangle_nodes","gamma_0","xi_eta_eval","weights","phi_precalc","a_precalc","indices_precalc","indptr_precalc","num_nodes","num_triangles","num_integration","num_singular","degree_singular",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|OOOOO:core.z_efie_faces_self",\
    capi_kwlist,&nodes_capi,&triangle_nodes_capi,&gamma_0_capi,&xi_eta_eval_capi,&weights_capi,&phi_precalc_capi,&a_precalc_capi,&indices_precalc_capi,&indptr_precalc_capi,&num_nodes_capi,&num_triangles_capi,&num_integration_capi,&num_singular_capi,&degree_singular_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable phi_precalc */
  ;
  capi_phi_precalc_intent |= F2PY_INTENT_IN;
  capi_phi_precalc_tmp = array_from_pyobj(NPY_DOUBLE,phi_precalc_Dims,phi_precalc_Rank,capi_phi_precalc_intent,phi_precalc_capi);
  if (capi_phi_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `phi_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    phi_precalc = (double *)(PyArray_DATA(capi_phi_precalc_tmp));

  /* Processing variable triangle_nodes */
  triangle_nodes_Dims[1]=3;
  capi_triangle_nodes_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_tmp = array_from_pyobj(NPY_INT,triangle_nodes_Dims,triangle_nodes_Rank,capi_triangle_nodes_intent,triangle_nodes_capi);
  if (capi_triangle_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangle_nodes' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    triangle_nodes = (int *)(PyArray_DATA(capi_triangle_nodes_tmp));

  /* Processing variable nodes */
  nodes_Dims[1]=3;
  capi_nodes_intent |= F2PY_INTENT_IN;
  capi_nodes_tmp = array_from_pyobj(NPY_DOUBLE,nodes_Dims,nodes_Rank,capi_nodes_intent,nodes_capi);
  if (capi_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    nodes = (double *)(PyArray_DATA(capi_nodes_tmp));

  /* Processing variable gamma_0 */
    f2py_success = complex_double_from_pyobj(&gamma_0,gamma_0_capi,"core.z_efie_faces_self() 3rd argument (gamma_0) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable xi_eta_eval */
  xi_eta_eval_Dims[1]=2;
  capi_xi_eta_eval_intent |= F2PY_INTENT_IN;
  capi_xi_eta_eval_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_eval_Dims,xi_eta_eval_Rank,capi_xi_eta_eval_intent,xi_eta_eval_capi);
  if (capi_xi_eta_eval_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `xi_eta_eval' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    xi_eta_eval = (double *)(PyArray_DATA(capi_xi_eta_eval_tmp));

  /* Processing variable num_triangles */
  if (num_triangles_capi == Py_None) num_triangles = shape(triangle_nodes,0); else
    f2py_success = int_from_pyobj(&num_triangles,num_triangles_capi,"core.z_efie_faces_self() 2nd keyword (num_triangles) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes,0)==num_triangles,"shape(triangle_nodes,0)==num_triangles","2nd keyword num_triangles","z_efie_faces_self:num_triangles=%d",num_triangles) {
  /* Processing variable a_dgamma_face */
  a_dgamma_face_Dims[0]=num_triangles,a_dgamma_face_Dims[1]=3,a_dgamma_face_Dims[2]=num_triangles,a_dgamma_face_Dims[3]=3;
  capi_a_dgamma_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a_dgamma_face_tmp = array_from_pyobj(NPY_CDOUBLE,a_dgamma_face_Dims,a_dgamma_face_Rank,capi_a_dgamma_face_intent,Py_None);
  if (capi_a_dgamma_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `a_dgamma_face' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    a_dgamma_face = (complex_double *)(PyArray_DATA(capi_a_dgamma_face_tmp));

  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta_eval,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.z_efie_faces_self() 3rd keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_eval,0)==num_integration,"shape(xi_eta_eval,0)==num_integration","3rd keyword num_integration","z_efie_faces_self:num_integration=%d",num_integration) {
  /* Processing variable degree_singular */
  if (degree_singular_capi == Py_None) degree_singular = shape(phi_precalc,1); else
    f2py_success = int_from_pyobj(&degree_singular,degree_singular_capi,"core.z_efie_faces_self() 5th keyword (degree_singular) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(phi_precalc,1)==degree_singular,"shape(phi_precalc,1)==degree_singular","5th keyword degree_singular","z_efie_faces_self:degree_singular=%d",degree_singular) {
  /* Processing variable indptr_precalc */
  indptr_precalc_Dims[0]=num_triangles + 1;
  capi_indptr_precalc_intent |= F2PY_INTENT_IN;
  capi_indptr_precalc_tmp = array_from_pyobj(NPY_INT,indptr_precalc_Dims,indptr_precalc_Rank,capi_indptr_precalc_intent,indptr_precalc_capi);
  if (capi_indptr_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 9th argument `indptr_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    indptr_precalc = (int *)(PyArray_DATA(capi_indptr_precalc_tmp));

  /* Processing variable phi_face */
  phi_face_Dims[0]=num_triangles,phi_face_Dims[1]=num_triangles;
  capi_phi_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_phi_face_tmp = array_from_pyobj(NPY_CDOUBLE,phi_face_Dims,phi_face_Rank,capi_phi_face_intent,Py_None);
  if (capi_phi_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `phi_face' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    phi_face = (complex_double *)(PyArray_DATA(capi_phi_face_tmp));

  /* Processing variable num_nodes */
  if (num_nodes_capi == Py_None) num_nodes = shape(nodes,0); else
    f2py_success = int_from_pyobj(&num_nodes,num_nodes_capi,"core.z_efie_faces_self() 1st keyword (num_nodes) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes,0)==num_nodes,"shape(nodes,0)==num_nodes","1st keyword num_nodes","z_efie_faces_self:num_nodes=%d",num_nodes) {
  /* Processing variable num_singular */
  if (num_singular_capi == Py_None) num_singular = shape(phi_precalc,0); else
    f2py_success = int_from_pyobj(&num_singular,num_singular_capi,"core.z_efie_faces_self() 4th keyword (num_singular) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(phi_precalc,0)==num_singular,"shape(phi_precalc,0)==num_singular","4th keyword num_singular","z_efie_faces_self:num_singular=%d",num_singular) {
  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `weights' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    weights = (double *)(PyArray_DATA(capi_weights_tmp));

  /* Processing variable a_face */
  a_face_Dims[0]=num_triangles,a_face_Dims[1]=3,a_face_Dims[2]=num_triangles,a_face_Dims[3]=3;
  capi_a_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_a_face_tmp = array_from_pyobj(NPY_CDOUBLE,a_face_Dims,a_face_Rank,capi_a_face_intent,Py_None);
  if (capi_a_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `a_face' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    a_face = (complex_double *)(PyArray_DATA(capi_a_face_tmp));

  /* Processing variable phi_dgamma_face */
  phi_dgamma_face_Dims[0]=num_triangles,phi_dgamma_face_Dims[1]=num_triangles;
  capi_phi_dgamma_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_phi_dgamma_face_tmp = array_from_pyobj(NPY_CDOUBLE,phi_dgamma_face_Dims,phi_dgamma_face_Rank,capi_phi_dgamma_face_intent,Py_None);
  if (capi_phi_dgamma_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `phi_dgamma_face' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    phi_dgamma_face = (complex_double *)(PyArray_DATA(capi_phi_dgamma_face_tmp));

  /* Processing variable indices_precalc */
  indices_precalc_Dims[0]=num_singular;
  capi_indices_precalc_intent |= F2PY_INTENT_IN;
  capi_indices_precalc_tmp = array_from_pyobj(NPY_INT,indices_precalc_Dims,indices_precalc_Rank,capi_indices_precalc_intent,indices_precalc_capi);
  if (capi_indices_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 8th argument `indices_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    indices_precalc = (int *)(PyArray_DATA(capi_indices_precalc_tmp));

  /* Processing variable a_precalc */
  a_precalc_Dims[0]=num_singular,a_precalc_Dims[1]=degree_singular,a_precalc_Dims[2]=3,a_precalc_Dims[3]=3;
  capi_a_precalc_intent |= F2PY_INTENT_IN;
  capi_a_precalc_tmp = array_from_pyobj(NPY_DOUBLE,a_precalc_Dims,a_precalc_Rank,capi_a_precalc_intent,a_precalc_capi);
  if (capi_a_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 7th argument `a_precalc' of core.z_efie_faces_self to C/Fortran array" );
  } else {
    a_precalc = (double *)(PyArray_DATA(capi_a_precalc_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes,&num_triangles,&num_integration,&num_singular,&degree_singular,nodes,triangle_nodes,&gamma_0,xi_eta_eval,weights,phi_precalc,a_precalc,indices_precalc,indptr_precalc,a_face,phi_face,a_dgamma_face,phi_dgamma_face);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NNNN",capi_a_face_tmp,capi_phi_face_tmp,capi_a_dgamma_face_tmp,capi_phi_dgamma_face_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_a_precalc_tmp!=a_precalc_capi) {
    Py_XDECREF(capi_a_precalc_tmp); }
  }  /*if (capi_a_precalc_tmp == NULL) ... else of a_precalc*/
  /* End of cleaning variable a_precalc */
  if((PyObject *)capi_indices_precalc_tmp!=indices_precalc_capi) {
    Py_XDECREF(capi_indices_precalc_tmp); }
  }  /*if (capi_indices_precalc_tmp == NULL) ... else of indices_precalc*/
  /* End of cleaning variable indices_precalc */
  }  /*if (capi_phi_dgamma_face_tmp == NULL) ... else of phi_dgamma_face*/
  /* End of cleaning variable phi_dgamma_face */
  }  /*if (capi_a_face_tmp == NULL) ... else of a_face*/
  /* End of cleaning variable a_face */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  } /*CHECKSCALAR(shape(phi_precalc,0)==num_singular)*/
  } /*if (f2py_success) of num_singular*/
  /* End of cleaning variable num_singular */
  } /*CHECKSCALAR(shape(nodes,0)==num_nodes)*/
  } /*if (f2py_success) of num_nodes*/
  /* End of cleaning variable num_nodes */
  }  /*if (capi_phi_face_tmp == NULL) ... else of phi_face*/
  /* End of cleaning variable phi_face */
  if((PyObject *)capi_indptr_precalc_tmp!=indptr_precalc_capi) {
    Py_XDECREF(capi_indptr_precalc_tmp); }
  }  /*if (capi_indptr_precalc_tmp == NULL) ... else of indptr_precalc*/
  /* End of cleaning variable indptr_precalc */
  } /*CHECKSCALAR(shape(phi_precalc,1)==degree_singular)*/
  } /*if (f2py_success) of degree_singular*/
  /* End of cleaning variable degree_singular */
  } /*CHECKSCALAR(shape(xi_eta_eval,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  }  /*if (capi_a_dgamma_face_tmp == NULL) ... else of a_dgamma_face*/
  /* End of cleaning variable a_dgamma_face */
  } /*CHECKSCALAR(shape(triangle_nodes,0)==num_triangles)*/
  } /*if (f2py_success) of num_triangles*/
  /* End of cleaning variable num_triangles */
  if((PyObject *)capi_xi_eta_eval_tmp!=xi_eta_eval_capi) {
    Py_XDECREF(capi_xi_eta_eval_tmp); }
  }  /*if (capi_xi_eta_eval_tmp == NULL) ... else of xi_eta_eval*/
  /* End of cleaning variable xi_eta_eval */
  }  /*if (f2py_success) of gamma_0 frompyobj*/
  /* End of cleaning variable gamma_0 */
  if((PyObject *)capi_nodes_tmp!=nodes_capi) {
    Py_XDECREF(capi_nodes_tmp); }
  }  /*if (capi_nodes_tmp == NULL) ... else of nodes*/
  /* End of cleaning variable nodes */
  if((PyObject *)capi_triangle_nodes_tmp!=triangle_nodes_capi) {
    Py_XDECREF(capi_triangle_nodes_tmp); }
  }  /*if (capi_triangle_nodes_tmp == NULL) ... else of triangle_nodes*/
  /* End of cleaning variable triangle_nodes */
  if((PyObject *)capi_phi_precalc_tmp!=phi_precalc_capi) {
    Py_XDECREF(capi_phi_precalc_tmp); }
  }  /*if (capi_phi_precalc_tmp == NULL) ... else of phi_precalc*/
  /* End of cleaning variable phi_precalc */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of z_efie_faces_self **************************/

/************************** face_integrals_hanninen **************************/
static char doc_f2py_rout_core_face_integrals_hanninen[] = "\
i_a,i_phi,z_nmfie,z_tmfie = face_integrals_hanninen(nodes_s,xi_eta_o,weights_o,nodes_o,gauss_points,gauss_weights,[n_o,normal_o,n_gauss])\n\nWrapper for ``face_integrals_hanninen``.\
\n\nParameters\n----------\n"
"nodes_s : input rank-2 array('d') with bounds (3,3)\n"
"xi_eta_o : input rank-2 array('d') with bounds (n_o,2)\n"
"weights_o : input rank-1 array('d') with bounds (n_o)\n"
"nodes_o : input rank-2 array('d') with bounds (3,3)\n"
"gauss_points : input rank-1 array('d') with bounds (n_gauss)\n"
"gauss_weights : input rank-1 array('d') with bounds (n_gauss)\n"
"\nOther Parameters\n----------------\n"
"n_o : input int, optional\n    Default: shape(xi_eta_o,0)\n"
"normal_o : input rank-1 array('d') with bounds (3), optional\n    Default: 0.0\n"
"n_gauss : input int, optional\n    Default: len(gauss_points)\n"
"\nReturns\n-------\n"
"i_a : rank-3 array('d') with bounds (2,3,3)\n"
"i_phi : rank-1 array('d') with bounds (2)\n"
"z_nmfie : rank-3 array('d') with bounds (2,3,3)\n"
"z_tmfie : rank-3 array('d') with bounds (2,3,3)";
/* extern void F_FUNC_US(face_integrals_hanninen,FACE_INTEGRALS_HANNINEN)(double*,int*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_core_face_integrals_hanninen(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,double*,int*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *nodes_s = NULL;
  npy_intp nodes_s_Dims[2] = {-1, -1};
  const int nodes_s_Rank = 2;
  PyArrayObject *capi_nodes_s_tmp = NULL;
  int capi_nodes_s_intent = 0;
  PyObject *nodes_s_capi = Py_None;
  int n_o = 0;
  PyObject *n_o_capi = Py_None;
  double *xi_eta_o = NULL;
  npy_intp xi_eta_o_Dims[2] = {-1, -1};
  const int xi_eta_o_Rank = 2;
  PyArrayObject *capi_xi_eta_o_tmp = NULL;
  int capi_xi_eta_o_intent = 0;
  PyObject *xi_eta_o_capi = Py_None;
  double *weights_o = NULL;
  npy_intp weights_o_Dims[1] = {-1};
  const int weights_o_Rank = 1;
  PyArrayObject *capi_weights_o_tmp = NULL;
  int capi_weights_o_intent = 0;
  PyObject *weights_o_capi = Py_None;
  double *nodes_o = NULL;
  npy_intp nodes_o_Dims[2] = {-1, -1};
  const int nodes_o_Rank = 2;
  PyArrayObject *capi_nodes_o_tmp = NULL;
  int capi_nodes_o_intent = 0;
  PyObject *nodes_o_capi = Py_None;
  double *normal_o = NULL;
  npy_intp normal_o_Dims[1] = {-1};
  const int normal_o_Rank = 1;
  PyArrayObject *capi_normal_o_tmp = NULL;
  int capi_normal_o_intent = 0;
  PyObject *normal_o_capi = Py_None;
  int n_gauss = 0;
  PyObject *n_gauss_capi = Py_None;
  double *gauss_points = NULL;
  npy_intp gauss_points_Dims[1] = {-1};
  const int gauss_points_Rank = 1;
  PyArrayObject *capi_gauss_points_tmp = NULL;
  int capi_gauss_points_intent = 0;
  PyObject *gauss_points_capi = Py_None;
  double *gauss_weights = NULL;
  npy_intp gauss_weights_Dims[1] = {-1};
  const int gauss_weights_Rank = 1;
  PyArrayObject *capi_gauss_weights_tmp = NULL;
  int capi_gauss_weights_intent = 0;
  PyObject *gauss_weights_capi = Py_None;
  double *i_a = NULL;
  npy_intp i_a_Dims[3] = {-1, -1, -1};
  const int i_a_Rank = 3;
  PyArrayObject *capi_i_a_tmp = NULL;
  int capi_i_a_intent = 0;
  double *i_phi = NULL;
  npy_intp i_phi_Dims[1] = {-1};
  const int i_phi_Rank = 1;
  PyArrayObject *capi_i_phi_tmp = NULL;
  int capi_i_phi_intent = 0;
  double *z_nmfie = NULL;
  npy_intp z_nmfie_Dims[3] = {-1, -1, -1};
  const int z_nmfie_Rank = 3;
  PyArrayObject *capi_z_nmfie_tmp = NULL;
  int capi_z_nmfie_intent = 0;
  double *z_tmfie = NULL;
  npy_intp z_tmfie_Dims[3] = {-1, -1, -1};
  const int z_tmfie_Rank = 3;
  PyArrayObject *capi_z_tmfie_tmp = NULL;
  int capi_z_tmfie_intent = 0;
  static char *capi_kwlist[] = {"nodes_s","xi_eta_o","weights_o","nodes_o","gauss_points","gauss_weights","n_o","normal_o","n_gauss",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOO|OOO:core.face_integrals_hanninen",\
    capi_kwlist,&nodes_s_capi,&xi_eta_o_capi,&weights_o_capi,&nodes_o_capi,&gauss_points_capi,&gauss_weights_capi,&n_o_capi,&normal_o_capi,&n_gauss_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i_phi */
  i_phi_Dims[0]=2;
  capi_i_phi_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_phi_tmp = array_from_pyobj(NPY_DOUBLE,i_phi_Dims,i_phi_Rank,capi_i_phi_intent,Py_None);
  if (capi_i_phi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_phi' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    i_phi = (double *)(PyArray_DATA(capi_i_phi_tmp));

  /* Processing variable nodes_s */
  nodes_s_Dims[0]=3,nodes_s_Dims[1]=3;
  capi_nodes_s_intent |= F2PY_INTENT_IN;
  capi_nodes_s_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_Dims,nodes_s_Rank,capi_nodes_s_intent,nodes_s_capi);
  if (capi_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes_s' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    nodes_s = (double *)(PyArray_DATA(capi_nodes_s_tmp));

  /* Processing variable z_tmfie */
  z_tmfie_Dims[0]=2,z_tmfie_Dims[1]=3,z_tmfie_Dims[2]=3;
  capi_z_tmfie_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_tmfie_tmp = array_from_pyobj(NPY_DOUBLE,z_tmfie_Dims,z_tmfie_Rank,capi_z_tmfie_intent,Py_None);
  if (capi_z_tmfie_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_tmfie' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    z_tmfie = (double *)(PyArray_DATA(capi_z_tmfie_tmp));

  /* Processing variable normal_o */
  normal_o_Dims[0]=3;
  capi_normal_o_intent |= F2PY_OPTIONAL|F2PY_INTENT_IN;
  capi_normal_o_tmp = array_from_pyobj(NPY_DOUBLE,normal_o_Dims,normal_o_Rank,capi_normal_o_intent,normal_o_capi);
  if (capi_normal_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd keyword `normal_o' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    normal_o = (double *)(PyArray_DATA(capi_normal_o_tmp));

  if (normal_o_capi == Py_None) {


    int *_i,capi_i=0;
    CFUNCSMESS("face_integrals_hanninen: Initializing normal_o=0.0\n");
    if (initforcomb(PyArray_DIMS(capi_normal_o_tmp),PyArray_NDIM(capi_normal_o_tmp),1)) {
      while ((_i = nextforcomb()))
        normal_o[capi_i++] = 0.0; /* fortran way */
    } else {
      if (!PyErr_Occurred())
        PyErr_SetString(core_error,"Initialization of 2nd keyword normal_o failed (initforcomb).");
      f2py_success = 0;
    }
  }
  if (f2py_success) {
  /* Processing variable z_nmfie */
  z_nmfie_Dims[0]=2,z_nmfie_Dims[1]=3,z_nmfie_Dims[2]=3;
  capi_z_nmfie_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_nmfie_tmp = array_from_pyobj(NPY_DOUBLE,z_nmfie_Dims,z_nmfie_Rank,capi_z_nmfie_intent,Py_None);
  if (capi_z_nmfie_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_nmfie' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    z_nmfie = (double *)(PyArray_DATA(capi_z_nmfie_tmp));

  /* Processing variable gauss_points */
  ;
  capi_gauss_points_intent |= F2PY_INTENT_IN;
  capi_gauss_points_tmp = array_from_pyobj(NPY_DOUBLE,gauss_points_Dims,gauss_points_Rank,capi_gauss_points_intent,gauss_points_capi);
  if (capi_gauss_points_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `gauss_points' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    gauss_points = (double *)(PyArray_DATA(capi_gauss_points_tmp));

  /* Processing variable nodes_o */
  nodes_o_Dims[0]=3,nodes_o_Dims[1]=3;
  capi_nodes_o_intent |= F2PY_INTENT_IN;
  capi_nodes_o_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_Dims,nodes_o_Rank,capi_nodes_o_intent,nodes_o_capi);
  if (capi_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `nodes_o' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    nodes_o = (double *)(PyArray_DATA(capi_nodes_o_tmp));

  /* Processing variable i_a */
  i_a_Dims[0]=2,i_a_Dims[1]=3,i_a_Dims[2]=3;
  capi_i_a_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_a_tmp = array_from_pyobj(NPY_DOUBLE,i_a_Dims,i_a_Rank,capi_i_a_intent,Py_None);
  if (capi_i_a_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_a' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    i_a = (double *)(PyArray_DATA(capi_i_a_tmp));

  /* Processing variable xi_eta_o */
  xi_eta_o_Dims[1]=2;
  capi_xi_eta_o_intent |= F2PY_INTENT_IN;
  capi_xi_eta_o_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_o_Dims,xi_eta_o_Rank,capi_xi_eta_o_intent,xi_eta_o_capi);
  if (capi_xi_eta_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `xi_eta_o' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    xi_eta_o = (double *)(PyArray_DATA(capi_xi_eta_o_tmp));

  /* Processing variable n_o */
  if (n_o_capi == Py_None) n_o = shape(xi_eta_o,0); else
    f2py_success = int_from_pyobj(&n_o,n_o_capi,"core.face_integrals_hanninen() 1st keyword (n_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_o,0)==n_o,"shape(xi_eta_o,0)==n_o","1st keyword n_o","face_integrals_hanninen:n_o=%d",n_o) {
  /* Processing variable weights_o */
  weights_o_Dims[0]=n_o;
  capi_weights_o_intent |= F2PY_INTENT_IN;
  capi_weights_o_tmp = array_from_pyobj(NPY_DOUBLE,weights_o_Dims,weights_o_Rank,capi_weights_o_intent,weights_o_capi);
  if (capi_weights_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `weights_o' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    weights_o = (double *)(PyArray_DATA(capi_weights_o_tmp));

  /* Processing variable n_gauss */
  if (n_gauss_capi == Py_None) n_gauss = len(gauss_points); else
    f2py_success = int_from_pyobj(&n_gauss,n_gauss_capi,"core.face_integrals_hanninen() 3rd keyword (n_gauss) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(len(gauss_points)>=n_gauss,"len(gauss_points)>=n_gauss","3rd keyword n_gauss","face_integrals_hanninen:n_gauss=%d",n_gauss) {
  /* Processing variable gauss_weights */
  gauss_weights_Dims[0]=n_gauss;
  capi_gauss_weights_intent |= F2PY_INTENT_IN;
  capi_gauss_weights_tmp = array_from_pyobj(NPY_DOUBLE,gauss_weights_Dims,gauss_weights_Rank,capi_gauss_weights_intent,gauss_weights_capi);
  if (capi_gauss_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `gauss_weights' of core.face_integrals_hanninen to C/Fortran array" );
  } else {
    gauss_weights = (double *)(PyArray_DATA(capi_gauss_weights_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(nodes_s,&n_o,xi_eta_o,weights_o,nodes_o,normal_o,&n_gauss,gauss_points,gauss_weights,i_a,i_phi,z_nmfie,z_tmfie);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NNNN",capi_i_a_tmp,capi_i_phi_tmp,capi_z_nmfie_tmp,capi_z_tmfie_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_gauss_weights_tmp!=gauss_weights_capi) {
    Py_XDECREF(capi_gauss_weights_tmp); }
  }  /*if (capi_gauss_weights_tmp == NULL) ... else of gauss_weights*/
  /* End of cleaning variable gauss_weights */
  } /*CHECKSCALAR(len(gauss_points)>=n_gauss)*/
  } /*if (f2py_success) of n_gauss*/
  /* End of cleaning variable n_gauss */
  if((PyObject *)capi_weights_o_tmp!=weights_o_capi) {
    Py_XDECREF(capi_weights_o_tmp); }
  }  /*if (capi_weights_o_tmp == NULL) ... else of weights_o*/
  /* End of cleaning variable weights_o */
  } /*CHECKSCALAR(shape(xi_eta_o,0)==n_o)*/
  } /*if (f2py_success) of n_o*/
  /* End of cleaning variable n_o */
  if((PyObject *)capi_xi_eta_o_tmp!=xi_eta_o_capi) {
    Py_XDECREF(capi_xi_eta_o_tmp); }
  }  /*if (capi_xi_eta_o_tmp == NULL) ... else of xi_eta_o*/
  /* End of cleaning variable xi_eta_o */
  }  /*if (capi_i_a_tmp == NULL) ... else of i_a*/
  /* End of cleaning variable i_a */
  if((PyObject *)capi_nodes_o_tmp!=nodes_o_capi) {
    Py_XDECREF(capi_nodes_o_tmp); }
  }  /*if (capi_nodes_o_tmp == NULL) ... else of nodes_o*/
  /* End of cleaning variable nodes_o */
  if((PyObject *)capi_gauss_points_tmp!=gauss_points_capi) {
    Py_XDECREF(capi_gauss_points_tmp); }
  }  /*if (capi_gauss_points_tmp == NULL) ... else of gauss_points*/
  /* End of cleaning variable gauss_points */
  }  /*if (capi_z_nmfie_tmp == NULL) ... else of z_nmfie*/
  /* End of cleaning variable z_nmfie */
  }  /*if (f2py_success) of normal_o init*/
  if((PyObject *)capi_normal_o_tmp!=normal_o_capi) {
    Py_XDECREF(capi_normal_o_tmp); }
  }  /*if (capi_normal_o_tmp == NULL) ... else of normal_o*/
  /* End of cleaning variable normal_o */
  }  /*if (capi_z_tmfie_tmp == NULL) ... else of z_tmfie*/
  /* End of cleaning variable z_tmfie */
  if((PyObject *)capi_nodes_s_tmp!=nodes_s_capi) {
    Py_XDECREF(capi_nodes_s_tmp); }
  }  /*if (capi_nodes_s_tmp == NULL) ... else of nodes_s*/
  /* End of cleaning variable nodes_s */
  }  /*if (capi_i_phi_tmp == NULL) ... else of i_phi*/
  /* End of cleaning variable i_phi */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/*********************** end of face_integrals_hanninen ***********************/

/************************* face_integrals_yla_oijala *************************/
static char doc_f2py_rout_core_face_integrals_yla_oijala[] = "\
i_a,i_phi,z_nmfie,z_tmfie = face_integrals_yla_oijala(nodes_s,xi_eta_o,weights_o,nodes_o,[n_o,normal_o])\n\nWrapper for ``face_integrals_yla_oijala``.\
\n\nParameters\n----------\n"
"nodes_s : input rank-2 array('d') with bounds (3,3)\n"
"xi_eta_o : input rank-2 array('d') with bounds (n_o,2)\n"
"weights_o : input rank-1 array('d') with bounds (n_o)\n"
"nodes_o : input rank-2 array('d') with bounds (3,3)\n"
"\nOther Parameters\n----------------\n"
"n_o : input int, optional\n    Default: shape(xi_eta_o,0)\n"
"normal_o : input rank-1 array('d') with bounds (3), optional\n    Default: 0.0\n"
"\nReturns\n-------\n"
"i_a : rank-3 array('d') with bounds (2,3,3)\n"
"i_phi : rank-1 array('d') with bounds (2)\n"
"z_nmfie : rank-3 array('d') with bounds (2,3,3)\n"
"z_tmfie : rank-3 array('d') with bounds (2,3,3)";
/* extern void F_FUNC_US(face_integrals_yla_oijala,FACE_INTEGRALS_YLA_OIJALA)(double*,int*,double*,double*,double*,double*,double*,double*,double*,double*); */
static PyObject *f2py_rout_core_face_integrals_yla_oijala(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(double*,int*,double*,double*,double*,double*,double*,double*,double*,double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  double *nodes_s = NULL;
  npy_intp nodes_s_Dims[2] = {-1, -1};
  const int nodes_s_Rank = 2;
  PyArrayObject *capi_nodes_s_tmp = NULL;
  int capi_nodes_s_intent = 0;
  PyObject *nodes_s_capi = Py_None;
  int n_o = 0;
  PyObject *n_o_capi = Py_None;
  double *xi_eta_o = NULL;
  npy_intp xi_eta_o_Dims[2] = {-1, -1};
  const int xi_eta_o_Rank = 2;
  PyArrayObject *capi_xi_eta_o_tmp = NULL;
  int capi_xi_eta_o_intent = 0;
  PyObject *xi_eta_o_capi = Py_None;
  double *weights_o = NULL;
  npy_intp weights_o_Dims[1] = {-1};
  const int weights_o_Rank = 1;
  PyArrayObject *capi_weights_o_tmp = NULL;
  int capi_weights_o_intent = 0;
  PyObject *weights_o_capi = Py_None;
  double *nodes_o = NULL;
  npy_intp nodes_o_Dims[2] = {-1, -1};
  const int nodes_o_Rank = 2;
  PyArrayObject *capi_nodes_o_tmp = NULL;
  int capi_nodes_o_intent = 0;
  PyObject *nodes_o_capi = Py_None;
  double *normal_o = NULL;
  npy_intp normal_o_Dims[1] = {-1};
  const int normal_o_Rank = 1;
  PyArrayObject *capi_normal_o_tmp = NULL;
  int capi_normal_o_intent = 0;
  PyObject *normal_o_capi = Py_None;
  double *i_a = NULL;
  npy_intp i_a_Dims[3] = {-1, -1, -1};
  const int i_a_Rank = 3;
  PyArrayObject *capi_i_a_tmp = NULL;
  int capi_i_a_intent = 0;
  double *i_phi = NULL;
  npy_intp i_phi_Dims[1] = {-1};
  const int i_phi_Rank = 1;
  PyArrayObject *capi_i_phi_tmp = NULL;
  int capi_i_phi_intent = 0;
  double *z_nmfie = NULL;
  npy_intp z_nmfie_Dims[3] = {-1, -1, -1};
  const int z_nmfie_Rank = 3;
  PyArrayObject *capi_z_nmfie_tmp = NULL;
  int capi_z_nmfie_intent = 0;
  double *z_tmfie = NULL;
  npy_intp z_tmfie_Dims[3] = {-1, -1, -1};
  const int z_tmfie_Rank = 3;
  PyArrayObject *capi_z_tmfie_tmp = NULL;
  int capi_z_tmfie_intent = 0;
  static char *capi_kwlist[] = {"nodes_s","xi_eta_o","weights_o","nodes_o","n_o","normal_o",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOO|OO:core.face_integrals_yla_oijala",\
    capi_kwlist,&nodes_s_capi,&xi_eta_o_capi,&weights_o_capi,&nodes_o_capi,&n_o_capi,&normal_o_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable i_phi */
  i_phi_Dims[0]=2;
  capi_i_phi_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_phi_tmp = array_from_pyobj(NPY_DOUBLE,i_phi_Dims,i_phi_Rank,capi_i_phi_intent,Py_None);
  if (capi_i_phi_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_phi' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    i_phi = (double *)(PyArray_DATA(capi_i_phi_tmp));

  /* Processing variable nodes_s */
  nodes_s_Dims[0]=3,nodes_s_Dims[1]=3;
  capi_nodes_s_intent |= F2PY_INTENT_IN;
  capi_nodes_s_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_Dims,nodes_s_Rank,capi_nodes_s_intent,nodes_s_capi);
  if (capi_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes_s' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    nodes_s = (double *)(PyArray_DATA(capi_nodes_s_tmp));

  /* Processing variable z_tmfie */
  z_tmfie_Dims[0]=2,z_tmfie_Dims[1]=3,z_tmfie_Dims[2]=3;
  capi_z_tmfie_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_tmfie_tmp = array_from_pyobj(NPY_DOUBLE,z_tmfie_Dims,z_tmfie_Rank,capi_z_tmfie_intent,Py_None);
  if (capi_z_tmfie_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_tmfie' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    z_tmfie = (double *)(PyArray_DATA(capi_z_tmfie_tmp));

  /* Processing variable normal_o */
  normal_o_Dims[0]=3;
  capi_normal_o_intent |= F2PY_OPTIONAL|F2PY_INTENT_IN;
  capi_normal_o_tmp = array_from_pyobj(NPY_DOUBLE,normal_o_Dims,normal_o_Rank,capi_normal_o_intent,normal_o_capi);
  if (capi_normal_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd keyword `normal_o' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    normal_o = (double *)(PyArray_DATA(capi_normal_o_tmp));

  if (normal_o_capi == Py_None) {


    int *_i,capi_i=0;
    CFUNCSMESS("face_integrals_yla_oijala: Initializing normal_o=0.0\n");
    if (initforcomb(PyArray_DIMS(capi_normal_o_tmp),PyArray_NDIM(capi_normal_o_tmp),1)) {
      while ((_i = nextforcomb()))
        normal_o[capi_i++] = 0.0; /* fortran way */
    } else {
      if (!PyErr_Occurred())
        PyErr_SetString(core_error,"Initialization of 2nd keyword normal_o failed (initforcomb).");
      f2py_success = 0;
    }
  }
  if (f2py_success) {
  /* Processing variable z_nmfie */
  z_nmfie_Dims[0]=2,z_nmfie_Dims[1]=3,z_nmfie_Dims[2]=3;
  capi_z_nmfie_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_nmfie_tmp = array_from_pyobj(NPY_DOUBLE,z_nmfie_Dims,z_nmfie_Rank,capi_z_nmfie_intent,Py_None);
  if (capi_z_nmfie_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_nmfie' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    z_nmfie = (double *)(PyArray_DATA(capi_z_nmfie_tmp));

  /* Processing variable nodes_o */
  nodes_o_Dims[0]=3,nodes_o_Dims[1]=3;
  capi_nodes_o_intent |= F2PY_INTENT_IN;
  capi_nodes_o_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_Dims,nodes_o_Rank,capi_nodes_o_intent,nodes_o_capi);
  if (capi_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `nodes_o' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    nodes_o = (double *)(PyArray_DATA(capi_nodes_o_tmp));

  /* Processing variable i_a */
  i_a_Dims[0]=2,i_a_Dims[1]=3,i_a_Dims[2]=3;
  capi_i_a_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_i_a_tmp = array_from_pyobj(NPY_DOUBLE,i_a_Dims,i_a_Rank,capi_i_a_intent,Py_None);
  if (capi_i_a_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `i_a' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    i_a = (double *)(PyArray_DATA(capi_i_a_tmp));

  /* Processing variable xi_eta_o */
  xi_eta_o_Dims[1]=2;
  capi_xi_eta_o_intent |= F2PY_INTENT_IN;
  capi_xi_eta_o_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_o_Dims,xi_eta_o_Rank,capi_xi_eta_o_intent,xi_eta_o_capi);
  if (capi_xi_eta_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `xi_eta_o' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    xi_eta_o = (double *)(PyArray_DATA(capi_xi_eta_o_tmp));

  /* Processing variable n_o */
  if (n_o_capi == Py_None) n_o = shape(xi_eta_o,0); else
    f2py_success = int_from_pyobj(&n_o,n_o_capi,"core.face_integrals_yla_oijala() 1st keyword (n_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta_o,0)==n_o,"shape(xi_eta_o,0)==n_o","1st keyword n_o","face_integrals_yla_oijala:n_o=%d",n_o) {
  /* Processing variable weights_o */
  weights_o_Dims[0]=n_o;
  capi_weights_o_intent |= F2PY_INTENT_IN;
  capi_weights_o_tmp = array_from_pyobj(NPY_DOUBLE,weights_o_Dims,weights_o_Rank,capi_weights_o_intent,weights_o_capi);
  if (capi_weights_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `weights_o' of core.face_integrals_yla_oijala to C/Fortran array" );
  } else {
    weights_o = (double *)(PyArray_DATA(capi_weights_o_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(nodes_s,&n_o,xi_eta_o,weights_o,nodes_o,normal_o,i_a,i_phi,z_nmfie,z_tmfie);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NNNN",capi_i_a_tmp,capi_i_phi_tmp,capi_z_nmfie_tmp,capi_z_tmfie_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_weights_o_tmp!=weights_o_capi) {
    Py_XDECREF(capi_weights_o_tmp); }
  }  /*if (capi_weights_o_tmp == NULL) ... else of weights_o*/
  /* End of cleaning variable weights_o */
  } /*CHECKSCALAR(shape(xi_eta_o,0)==n_o)*/
  } /*if (f2py_success) of n_o*/
  /* End of cleaning variable n_o */
  if((PyObject *)capi_xi_eta_o_tmp!=xi_eta_o_capi) {
    Py_XDECREF(capi_xi_eta_o_tmp); }
  }  /*if (capi_xi_eta_o_tmp == NULL) ... else of xi_eta_o*/
  /* End of cleaning variable xi_eta_o */
  }  /*if (capi_i_a_tmp == NULL) ... else of i_a*/
  /* End of cleaning variable i_a */
  if((PyObject *)capi_nodes_o_tmp!=nodes_o_capi) {
    Py_XDECREF(capi_nodes_o_tmp); }
  }  /*if (capi_nodes_o_tmp == NULL) ... else of nodes_o*/
  /* End of cleaning variable nodes_o */
  }  /*if (capi_z_nmfie_tmp == NULL) ... else of z_nmfie*/
  /* End of cleaning variable z_nmfie */
  }  /*if (f2py_success) of normal_o init*/
  if((PyObject *)capi_normal_o_tmp!=normal_o_capi) {
    Py_XDECREF(capi_normal_o_tmp); }
  }  /*if (capi_normal_o_tmp == NULL) ... else of normal_o*/
  /* End of cleaning variable normal_o */
  }  /*if (capi_z_tmfie_tmp == NULL) ... else of z_tmfie*/
  /* End of cleaning variable z_tmfie */
  if((PyObject *)capi_nodes_s_tmp!=nodes_s_capi) {
    Py_XDECREF(capi_nodes_s_tmp); }
  }  /*if (capi_nodes_s_tmp == NULL) ... else of nodes_s*/
  /* End of cleaning variable nodes_s */
  }  /*if (capi_i_phi_tmp == NULL) ... else of i_phi*/
  /* End of cleaning variable i_phi */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/********************** end of face_integrals_yla_oijala **********************/

/***************************** z_mfie_faces_self *****************************/
static char doc_f2py_rout_core_z_mfie_faces_self[] = "\
z_face,z_face_dgamma = z_mfie_faces_self(nodes,triangle_nodes,triangle_areas,gamma_0,xi_eta,weights,normals,t_form,z_precalc,indices_precalc,indptr_precalc,[num_nodes,num_triangles,num_integration,num_singular,degree_singular])\n\nWrapper for ``z_mfie_faces_self``.\
\n\nParameters\n----------\n"
"nodes : input rank-2 array('d') with bounds (num_nodes,3)\n"
"triangle_nodes : input rank-2 array('i') with bounds (num_triangles,3)\n"
"triangle_areas : input rank-1 array('d') with bounds (num_triangles)\n"
"gamma_0 : input complex\n"
"xi_eta : input rank-2 array('d') with bounds (num_integration,2)\n"
"weights : input rank-1 array('d') with bounds (num_integration)\n"
"normals : input rank-2 array('d') with bounds (num_triangles,3)\n"
"t_form : input int\n"
"z_precalc : input rank-4 array('d') with bounds (num_singular,degree_singular,3,3)\n"
"indices_precalc : input rank-1 array('i') with bounds (num_singular)\n"
"indptr_precalc : input rank-1 array('i') with bounds (num_triangles + 1)\n"
"\nOther Parameters\n----------------\n"
"num_nodes : input int, optional\n    Default: shape(nodes,0)\n"
"num_triangles : input int, optional\n    Default: shape(triangle_nodes,0)\n"
"num_integration : input int, optional\n    Default: shape(xi_eta,0)\n"
"num_singular : input int, optional\n    Default: shape(z_precalc,0)\n"
"degree_singular : input int, optional\n    Default: shape(z_precalc,1)\n"
"\nReturns\n-------\n"
"z_face : rank-4 array('D') with bounds (num_triangles,3,num_triangles,3)\n"
"z_face_dgamma : rank-4 array('D') with bounds (num_triangles,3,num_triangles,3)";
/* extern void F_FUNC_US(z_mfie_faces_self,Z_MFIE_FACES_SELF)(int*,int*,int*,int*,int*,double*,int*,double*,complex_double*,double*,double*,double*,int*,double*,int*,int*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_z_mfie_faces_self(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*,double*,int*,double*,complex_double*,double*,double*,double*,int*,double*,int*,int*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes = 0;
  PyObject *num_nodes_capi = Py_None;
  int num_triangles = 0;
  PyObject *num_triangles_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  int num_singular = 0;
  PyObject *num_singular_capi = Py_None;
  int degree_singular = 0;
  PyObject *degree_singular_capi = Py_None;
  double *nodes = NULL;
  npy_intp nodes_Dims[2] = {-1, -1};
  const int nodes_Rank = 2;
  PyArrayObject *capi_nodes_tmp = NULL;
  int capi_nodes_intent = 0;
  PyObject *nodes_capi = Py_None;
  int *triangle_nodes = NULL;
  npy_intp triangle_nodes_Dims[2] = {-1, -1};
  const int triangle_nodes_Rank = 2;
  PyArrayObject *capi_triangle_nodes_tmp = NULL;
  int capi_triangle_nodes_intent = 0;
  PyObject *triangle_nodes_capi = Py_None;
  double *triangle_areas = NULL;
  npy_intp triangle_areas_Dims[1] = {-1};
  const int triangle_areas_Rank = 1;
  PyArrayObject *capi_triangle_areas_tmp = NULL;
  int capi_triangle_areas_intent = 0;
  PyObject *triangle_areas_capi = Py_None;
  complex_double gamma_0;
  PyObject *gamma_0_capi = Py_None;
  double *xi_eta = NULL;
  npy_intp xi_eta_Dims[2] = {-1, -1};
  const int xi_eta_Rank = 2;
  PyArrayObject *capi_xi_eta_tmp = NULL;
  int capi_xi_eta_intent = 0;
  PyObject *xi_eta_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  double *normals = NULL;
  npy_intp normals_Dims[2] = {-1, -1};
  const int normals_Rank = 2;
  PyArrayObject *capi_normals_tmp = NULL;
  int capi_normals_intent = 0;
  PyObject *normals_capi = Py_None;
  int t_form = 0;
  PyObject *t_form_capi = Py_None;
  double *z_precalc = NULL;
  npy_intp z_precalc_Dims[4] = {-1, -1, -1, -1};
  const int z_precalc_Rank = 4;
  PyArrayObject *capi_z_precalc_tmp = NULL;
  int capi_z_precalc_intent = 0;
  PyObject *z_precalc_capi = Py_None;
  int *indices_precalc = NULL;
  npy_intp indices_precalc_Dims[1] = {-1};
  const int indices_precalc_Rank = 1;
  PyArrayObject *capi_indices_precalc_tmp = NULL;
  int capi_indices_precalc_intent = 0;
  PyObject *indices_precalc_capi = Py_None;
  int *indptr_precalc = NULL;
  npy_intp indptr_precalc_Dims[1] = {-1};
  const int indptr_precalc_Rank = 1;
  PyArrayObject *capi_indptr_precalc_tmp = NULL;
  int capi_indptr_precalc_intent = 0;
  PyObject *indptr_precalc_capi = Py_None;
  complex_double *z_face = NULL;
  npy_intp z_face_Dims[4] = {-1, -1, -1, -1};
  const int z_face_Rank = 4;
  PyArrayObject *capi_z_face_tmp = NULL;
  int capi_z_face_intent = 0;
  complex_double *z_face_dgamma = NULL;
  npy_intp z_face_dgamma_Dims[4] = {-1, -1, -1, -1};
  const int z_face_dgamma_Rank = 4;
  PyArrayObject *capi_z_face_dgamma_tmp = NULL;
  int capi_z_face_dgamma_intent = 0;
  static char *capi_kwlist[] = {"nodes","triangle_nodes","triangle_areas","gamma_0","xi_eta","weights","normals","t_form","z_precalc","indices_precalc","indptr_precalc","num_nodes","num_triangles","num_integration","num_singular","degree_singular",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOOOO|OOOOO:core.z_mfie_faces_self",\
    capi_kwlist,&nodes_capi,&triangle_nodes_capi,&triangle_areas_capi,&gamma_0_capi,&xi_eta_capi,&weights_capi,&normals_capi,&t_form_capi,&z_precalc_capi,&indices_precalc_capi,&indptr_precalc_capi,&num_nodes_capi,&num_triangles_capi,&num_integration_capi,&num_singular_capi,&degree_singular_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable triangle_nodes */
  triangle_nodes_Dims[1]=3;
  capi_triangle_nodes_intent |= F2PY_INTENT_IN;
  capi_triangle_nodes_tmp = array_from_pyobj(NPY_INT,triangle_nodes_Dims,triangle_nodes_Rank,capi_triangle_nodes_intent,triangle_nodes_capi);
  if (capi_triangle_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangle_nodes' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    triangle_nodes = (int *)(PyArray_DATA(capi_triangle_nodes_tmp));

  /* Processing variable nodes */
  nodes_Dims[1]=3;
  capi_nodes_intent |= F2PY_INTENT_IN;
  capi_nodes_tmp = array_from_pyobj(NPY_DOUBLE,nodes_Dims,nodes_Rank,capi_nodes_intent,nodes_capi);
  if (capi_nodes_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    nodes = (double *)(PyArray_DATA(capi_nodes_tmp));

  /* Processing variable gamma_0 */
    f2py_success = complex_double_from_pyobj(&gamma_0,gamma_0_capi,"core.z_mfie_faces_self() 4th argument (gamma_0) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable z_precalc */
  z_precalc_Dims[2]=3,z_precalc_Dims[3]=3;
  capi_z_precalc_intent |= F2PY_INTENT_IN;
  capi_z_precalc_tmp = array_from_pyobj(NPY_DOUBLE,z_precalc_Dims,z_precalc_Rank,capi_z_precalc_intent,z_precalc_capi);
  if (capi_z_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 9th argument `z_precalc' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    z_precalc = (double *)(PyArray_DATA(capi_z_precalc_tmp));

  /* Processing variable t_form */
    t_form = (int)PyObject_IsTrue(t_form_capi);
    f2py_success = 1;
  if (f2py_success) {
  /* Processing variable xi_eta */
  xi_eta_Dims[1]=2;
  capi_xi_eta_intent |= F2PY_INTENT_IN;
  capi_xi_eta_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_Dims,xi_eta_Rank,capi_xi_eta_intent,xi_eta_capi);
  if (capi_xi_eta_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 5th argument `xi_eta' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    xi_eta = (double *)(PyArray_DATA(capi_xi_eta_tmp));

  /* Processing variable num_triangles */
  if (num_triangles_capi == Py_None) num_triangles = shape(triangle_nodes,0); else
    f2py_success = int_from_pyobj(&num_triangles,num_triangles_capi,"core.z_mfie_faces_self() 2nd keyword (num_triangles) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangle_nodes,0)==num_triangles,"shape(triangle_nodes,0)==num_triangles","2nd keyword num_triangles","z_mfie_faces_self:num_triangles=%d",num_triangles) {
  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.z_mfie_faces_self() 3rd keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta,0)==num_integration,"shape(xi_eta,0)==num_integration","3rd keyword num_integration","z_mfie_faces_self:num_integration=%d",num_integration) {
  /* Processing variable degree_singular */
  if (degree_singular_capi == Py_None) degree_singular = shape(z_precalc,1); else
    f2py_success = int_from_pyobj(&degree_singular,degree_singular_capi,"core.z_mfie_faces_self() 5th keyword (degree_singular) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(z_precalc,1)==degree_singular,"shape(z_precalc,1)==degree_singular","5th keyword degree_singular","z_mfie_faces_self:degree_singular=%d",degree_singular) {
  /* Processing variable indptr_precalc */
  indptr_precalc_Dims[0]=num_triangles + 1;
  capi_indptr_precalc_intent |= F2PY_INTENT_IN;
  capi_indptr_precalc_tmp = array_from_pyobj(NPY_INT,indptr_precalc_Dims,indptr_precalc_Rank,capi_indptr_precalc_intent,indptr_precalc_capi);
  if (capi_indptr_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 11st argument `indptr_precalc' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    indptr_precalc = (int *)(PyArray_DATA(capi_indptr_precalc_tmp));

  /* Processing variable num_singular */
  if (num_singular_capi == Py_None) num_singular = shape(z_precalc,0); else
    f2py_success = int_from_pyobj(&num_singular,num_singular_capi,"core.z_mfie_faces_self() 4th keyword (num_singular) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(z_precalc,0)==num_singular,"shape(z_precalc,0)==num_singular","4th keyword num_singular","z_mfie_faces_self:num_singular=%d",num_singular) {
  /* Processing variable num_nodes */
  if (num_nodes_capi == Py_None) num_nodes = shape(nodes,0); else
    f2py_success = int_from_pyobj(&num_nodes,num_nodes_capi,"core.z_mfie_faces_self() 1st keyword (num_nodes) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes,0)==num_nodes,"shape(nodes,0)==num_nodes","1st keyword num_nodes","z_mfie_faces_self:num_nodes=%d",num_nodes) {
  /* Processing variable triangle_areas */
  triangle_areas_Dims[0]=num_triangles;
  capi_triangle_areas_intent |= F2PY_INTENT_IN;
  capi_triangle_areas_tmp = array_from_pyobj(NPY_DOUBLE,triangle_areas_Dims,triangle_areas_Rank,capi_triangle_areas_intent,triangle_areas_capi);
  if (capi_triangle_areas_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `triangle_areas' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    triangle_areas = (double *)(PyArray_DATA(capi_triangle_areas_tmp));

  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `weights' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    weights = (double *)(PyArray_DATA(capi_weights_tmp));

  /* Processing variable normals */
  normals_Dims[0]=num_triangles,normals_Dims[1]=3;
  capi_normals_intent |= F2PY_INTENT_IN;
  capi_normals_tmp = array_from_pyobj(NPY_DOUBLE,normals_Dims,normals_Rank,capi_normals_intent,normals_capi);
  if (capi_normals_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 7th argument `normals' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    normals = (double *)(PyArray_DATA(capi_normals_tmp));

  /* Processing variable z_face */
  z_face_Dims[0]=num_triangles,z_face_Dims[1]=3,z_face_Dims[2]=num_triangles,z_face_Dims[3]=3;
  capi_z_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_face_tmp = array_from_pyobj(NPY_CDOUBLE,z_face_Dims,z_face_Rank,capi_z_face_intent,Py_None);
  if (capi_z_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_face' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    z_face = (complex_double *)(PyArray_DATA(capi_z_face_tmp));

  /* Processing variable z_face_dgamma */
  z_face_dgamma_Dims[0]=num_triangles,z_face_dgamma_Dims[1]=3,z_face_dgamma_Dims[2]=num_triangles,z_face_dgamma_Dims[3]=3;
  capi_z_face_dgamma_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_face_dgamma_tmp = array_from_pyobj(NPY_CDOUBLE,z_face_dgamma_Dims,z_face_dgamma_Rank,capi_z_face_dgamma_intent,Py_None);
  if (capi_z_face_dgamma_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_face_dgamma' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    z_face_dgamma = (complex_double *)(PyArray_DATA(capi_z_face_dgamma_tmp));

  /* Processing variable indices_precalc */
  indices_precalc_Dims[0]=num_singular;
  capi_indices_precalc_intent |= F2PY_INTENT_IN;
  capi_indices_precalc_tmp = array_from_pyobj(NPY_INT,indices_precalc_Dims,indices_precalc_Rank,capi_indices_precalc_intent,indices_precalc_capi);
  if (capi_indices_precalc_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 10th argument `indices_precalc' of core.z_mfie_faces_self to C/Fortran array" );
  } else {
    indices_precalc = (int *)(PyArray_DATA(capi_indices_precalc_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes,&num_triangles,&num_integration,&num_singular,&degree_singular,nodes,triangle_nodes,triangle_areas,&gamma_0,xi_eta,weights,normals,&t_form,z_precalc,indices_precalc,indptr_precalc,z_face,z_face_dgamma);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_z_face_tmp,capi_z_face_dgamma_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  if((PyObject *)capi_indices_precalc_tmp!=indices_precalc_capi) {
    Py_XDECREF(capi_indices_precalc_tmp); }
  }  /*if (capi_indices_precalc_tmp == NULL) ... else of indices_precalc*/
  /* End of cleaning variable indices_precalc */
  }  /*if (capi_z_face_dgamma_tmp == NULL) ... else of z_face_dgamma*/
  /* End of cleaning variable z_face_dgamma */
  }  /*if (capi_z_face_tmp == NULL) ... else of z_face*/
  /* End of cleaning variable z_face */
  if((PyObject *)capi_normals_tmp!=normals_capi) {
    Py_XDECREF(capi_normals_tmp); }
  }  /*if (capi_normals_tmp == NULL) ... else of normals*/
  /* End of cleaning variable normals */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  if((PyObject *)capi_triangle_areas_tmp!=triangle_areas_capi) {
    Py_XDECREF(capi_triangle_areas_tmp); }
  }  /*if (capi_triangle_areas_tmp == NULL) ... else of triangle_areas*/
  /* End of cleaning variable triangle_areas */
  } /*CHECKSCALAR(shape(nodes,0)==num_nodes)*/
  } /*if (f2py_success) of num_nodes*/
  /* End of cleaning variable num_nodes */
  } /*CHECKSCALAR(shape(z_precalc,0)==num_singular)*/
  } /*if (f2py_success) of num_singular*/
  /* End of cleaning variable num_singular */
  if((PyObject *)capi_indptr_precalc_tmp!=indptr_precalc_capi) {
    Py_XDECREF(capi_indptr_precalc_tmp); }
  }  /*if (capi_indptr_precalc_tmp == NULL) ... else of indptr_precalc*/
  /* End of cleaning variable indptr_precalc */
  } /*CHECKSCALAR(shape(z_precalc,1)==degree_singular)*/
  } /*if (f2py_success) of degree_singular*/
  /* End of cleaning variable degree_singular */
  } /*CHECKSCALAR(shape(xi_eta,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  } /*CHECKSCALAR(shape(triangle_nodes,0)==num_triangles)*/
  } /*if (f2py_success) of num_triangles*/
  /* End of cleaning variable num_triangles */
  if((PyObject *)capi_xi_eta_tmp!=xi_eta_capi) {
    Py_XDECREF(capi_xi_eta_tmp); }
  }  /*if (capi_xi_eta_tmp == NULL) ... else of xi_eta*/
  /* End of cleaning variable xi_eta */
  } /*if (f2py_success) of t_form*/
  /* End of cleaning variable t_form */
  if((PyObject *)capi_z_precalc_tmp!=z_precalc_capi) {
    Py_XDECREF(capi_z_precalc_tmp); }
  }  /*if (capi_z_precalc_tmp == NULL) ... else of z_precalc*/
  /* End of cleaning variable z_precalc */
  }  /*if (f2py_success) of gamma_0 frompyobj*/
  /* End of cleaning variable gamma_0 */
  if((PyObject *)capi_nodes_tmp!=nodes_capi) {
    Py_XDECREF(capi_nodes_tmp); }
  }  /*if (capi_nodes_tmp == NULL) ... else of nodes*/
  /* End of cleaning variable nodes */
  if((PyObject *)capi_triangle_nodes_tmp!=triangle_nodes_capi) {
    Py_XDECREF(capi_triangle_nodes_tmp); }
  }  /*if (capi_triangle_nodes_tmp == NULL) ... else of triangle_nodes*/
  /* End of cleaning variable triangle_nodes */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************** end of z_mfie_faces_self **************************/

/**************************** z_mfie_faces_mutual ****************************/
static char doc_f2py_rout_core_z_mfie_faces_mutual[] = "\
z_face,z_face_dgamma = z_mfie_faces_mutual(nodes_o,triangles_o,nodes_s,triangles_s,gamma_0,xi_eta,weights,normals_o,t_form,[num_nodes_o,num_triangles_o,num_nodes_s,num_triangles_s,num_integration])\n\nWrapper for ``z_mfie_faces_mutual``.\
\n\nParameters\n----------\n"
"nodes_o : input rank-2 array('d') with bounds (num_nodes_o,3)\n"
"triangles_o : input rank-2 array('i') with bounds (num_triangles_o,3)\n"
"nodes_s : input rank-2 array('d') with bounds (num_nodes_s,3)\n"
"triangles_s : input rank-2 array('i') with bounds (num_triangles_s,3)\n"
"gamma_0 : input complex\n"
"xi_eta : input rank-2 array('d') with bounds (num_integration,2)\n"
"weights : input rank-1 array('d') with bounds (num_integration)\n"
"normals_o : input rank-2 array('d') with bounds (num_triangles_o,3)\n"
"t_form : input int\n"
"\nOther Parameters\n----------------\n"
"num_nodes_o : input int, optional\n    Default: shape(nodes_o,0)\n"
"num_triangles_o : input int, optional\n    Default: shape(triangles_o,0)\n"
"num_nodes_s : input int, optional\n    Default: shape(nodes_s,0)\n"
"num_triangles_s : input int, optional\n    Default: shape(triangles_s,0)\n"
"num_integration : input int, optional\n    Default: shape(xi_eta,0)\n"
"\nReturns\n-------\n"
"z_face : rank-4 array('D') with bounds (num_triangles_o,3,num_triangles_s,3)\n"
"z_face_dgamma : rank-4 array('D') with bounds (num_triangles_o,3,num_triangles_s,3)";
/* extern void F_FUNC_US(z_mfie_faces_mutual,Z_MFIE_FACES_MUTUAL)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,double*,int*,complex_double*,complex_double*); */
static PyObject *f2py_rout_core_z_mfie_faces_mutual(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*,int*,int*,int*,int*,double*,int*,double*,int*,complex_double*,double*,double*,double*,int*,complex_double*,complex_double*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int num_nodes_o = 0;
  PyObject *num_nodes_o_capi = Py_None;
  int num_triangles_o = 0;
  PyObject *num_triangles_o_capi = Py_None;
  int num_nodes_s = 0;
  PyObject *num_nodes_s_capi = Py_None;
  int num_triangles_s = 0;
  PyObject *num_triangles_s_capi = Py_None;
  int num_integration = 0;
  PyObject *num_integration_capi = Py_None;
  double *nodes_o = NULL;
  npy_intp nodes_o_Dims[2] = {-1, -1};
  const int nodes_o_Rank = 2;
  PyArrayObject *capi_nodes_o_tmp = NULL;
  int capi_nodes_o_intent = 0;
  PyObject *nodes_o_capi = Py_None;
  int *triangles_o = NULL;
  npy_intp triangles_o_Dims[2] = {-1, -1};
  const int triangles_o_Rank = 2;
  PyArrayObject *capi_triangles_o_tmp = NULL;
  int capi_triangles_o_intent = 0;
  PyObject *triangles_o_capi = Py_None;
  double *nodes_s = NULL;
  npy_intp nodes_s_Dims[2] = {-1, -1};
  const int nodes_s_Rank = 2;
  PyArrayObject *capi_nodes_s_tmp = NULL;
  int capi_nodes_s_intent = 0;
  PyObject *nodes_s_capi = Py_None;
  int *triangles_s = NULL;
  npy_intp triangles_s_Dims[2] = {-1, -1};
  const int triangles_s_Rank = 2;
  PyArrayObject *capi_triangles_s_tmp = NULL;
  int capi_triangles_s_intent = 0;
  PyObject *triangles_s_capi = Py_None;
  complex_double gamma_0;
  PyObject *gamma_0_capi = Py_None;
  double *xi_eta = NULL;
  npy_intp xi_eta_Dims[2] = {-1, -1};
  const int xi_eta_Rank = 2;
  PyArrayObject *capi_xi_eta_tmp = NULL;
  int capi_xi_eta_intent = 0;
  PyObject *xi_eta_capi = Py_None;
  double *weights = NULL;
  npy_intp weights_Dims[1] = {-1};
  const int weights_Rank = 1;
  PyArrayObject *capi_weights_tmp = NULL;
  int capi_weights_intent = 0;
  PyObject *weights_capi = Py_None;
  double *normals_o = NULL;
  npy_intp normals_o_Dims[2] = {-1, -1};
  const int normals_o_Rank = 2;
  PyArrayObject *capi_normals_o_tmp = NULL;
  int capi_normals_o_intent = 0;
  PyObject *normals_o_capi = Py_None;
  int t_form = 0;
  PyObject *t_form_capi = Py_None;
  complex_double *z_face = NULL;
  npy_intp z_face_Dims[4] = {-1, -1, -1, -1};
  const int z_face_Rank = 4;
  PyArrayObject *capi_z_face_tmp = NULL;
  int capi_z_face_intent = 0;
  complex_double *z_face_dgamma = NULL;
  npy_intp z_face_dgamma_Dims[4] = {-1, -1, -1, -1};
  const int z_face_dgamma_Rank = 4;
  PyArrayObject *capi_z_face_dgamma_tmp = NULL;
  int capi_z_face_dgamma_intent = 0;
  static char *capi_kwlist[] = {"nodes_o","triangles_o","nodes_s","triangles_s","gamma_0","xi_eta","weights","normals_o","t_form","num_nodes_o","num_triangles_o","num_nodes_s","num_triangles_s","num_integration",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "OOOOOOOOO|OOOOO:core.z_mfie_faces_mutual",\
    capi_kwlist,&nodes_o_capi,&triangles_o_capi,&nodes_s_capi,&triangles_s_capi,&gamma_0_capi,&xi_eta_capi,&weights_capi,&normals_o_capi,&t_form_capi,&num_nodes_o_capi,&num_triangles_o_capi,&num_nodes_s_capi,&num_triangles_s_capi,&num_integration_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable triangles_o */
  triangles_o_Dims[1]=3;
  capi_triangles_o_intent |= F2PY_INTENT_IN;
  capi_triangles_o_tmp = array_from_pyobj(NPY_INT,triangles_o_Dims,triangles_o_Rank,capi_triangles_o_intent,triangles_o_capi);
  if (capi_triangles_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 2nd argument `triangles_o' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    triangles_o = (int *)(PyArray_DATA(capi_triangles_o_tmp));

  /* Processing variable nodes_s */
  nodes_s_Dims[1]=3;
  capi_nodes_s_intent |= F2PY_INTENT_IN;
  capi_nodes_s_tmp = array_from_pyobj(NPY_DOUBLE,nodes_s_Dims,nodes_s_Rank,capi_nodes_s_intent,nodes_s_capi);
  if (capi_nodes_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 3rd argument `nodes_s' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    nodes_s = (double *)(PyArray_DATA(capi_nodes_s_tmp));

  /* Processing variable gamma_0 */
    f2py_success = complex_double_from_pyobj(&gamma_0,gamma_0_capi,"core.z_mfie_faces_mutual() 5th argument (gamma_0) can't be converted to complex_double");
  if (f2py_success) {
  /* Processing variable triangles_s */
  triangles_s_Dims[1]=3;
  capi_triangles_s_intent |= F2PY_INTENT_IN;
  capi_triangles_s_tmp = array_from_pyobj(NPY_INT,triangles_s_Dims,triangles_s_Rank,capi_triangles_s_intent,triangles_s_capi);
  if (capi_triangles_s_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 4th argument `triangles_s' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    triangles_s = (int *)(PyArray_DATA(capi_triangles_s_tmp));

  /* Processing variable nodes_o */
  nodes_o_Dims[1]=3;
  capi_nodes_o_intent |= F2PY_INTENT_IN;
  capi_nodes_o_tmp = array_from_pyobj(NPY_DOUBLE,nodes_o_Dims,nodes_o_Rank,capi_nodes_o_intent,nodes_o_capi);
  if (capi_nodes_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 1st argument `nodes_o' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    nodes_o = (double *)(PyArray_DATA(capi_nodes_o_tmp));

  /* Processing variable t_form */
    t_form = (int)PyObject_IsTrue(t_form_capi);
    f2py_success = 1;
  if (f2py_success) {
  /* Processing variable xi_eta */
  xi_eta_Dims[1]=2;
  capi_xi_eta_intent |= F2PY_INTENT_IN;
  capi_xi_eta_tmp = array_from_pyobj(NPY_DOUBLE,xi_eta_Dims,xi_eta_Rank,capi_xi_eta_intent,xi_eta_capi);
  if (capi_xi_eta_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 6th argument `xi_eta' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    xi_eta = (double *)(PyArray_DATA(capi_xi_eta_tmp));

  /* Processing variable num_nodes_s */
  if (num_nodes_s_capi == Py_None) num_nodes_s = shape(nodes_s,0); else
    f2py_success = int_from_pyobj(&num_nodes_s,num_nodes_s_capi,"core.z_mfie_faces_mutual() 3rd keyword (num_nodes_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes_s,0)==num_nodes_s,"shape(nodes_s,0)==num_nodes_s","3rd keyword num_nodes_s","z_mfie_faces_mutual:num_nodes_s=%d",num_nodes_s) {
  /* Processing variable num_triangles_o */
  if (num_triangles_o_capi == Py_None) num_triangles_o = shape(triangles_o,0); else
    f2py_success = int_from_pyobj(&num_triangles_o,num_triangles_o_capi,"core.z_mfie_faces_mutual() 2nd keyword (num_triangles_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangles_o,0)==num_triangles_o,"shape(triangles_o,0)==num_triangles_o","2nd keyword num_triangles_o","z_mfie_faces_mutual:num_triangles_o=%d",num_triangles_o) {
  /* Processing variable num_integration */
  if (num_integration_capi == Py_None) num_integration = shape(xi_eta,0); else
    f2py_success = int_from_pyobj(&num_integration,num_integration_capi,"core.z_mfie_faces_mutual() 5th keyword (num_integration) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(xi_eta,0)==num_integration,"shape(xi_eta,0)==num_integration","5th keyword num_integration","z_mfie_faces_mutual:num_integration=%d",num_integration) {
  /* Processing variable weights */
  weights_Dims[0]=num_integration;
  capi_weights_intent |= F2PY_INTENT_IN;
  capi_weights_tmp = array_from_pyobj(NPY_DOUBLE,weights_Dims,weights_Rank,capi_weights_intent,weights_capi);
  if (capi_weights_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 7th argument `weights' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    weights = (double *)(PyArray_DATA(capi_weights_tmp));

  /* Processing variable num_triangles_s */
  if (num_triangles_s_capi == Py_None) num_triangles_s = shape(triangles_s,0); else
    f2py_success = int_from_pyobj(&num_triangles_s,num_triangles_s_capi,"core.z_mfie_faces_mutual() 4th keyword (num_triangles_s) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(triangles_s,0)==num_triangles_s,"shape(triangles_s,0)==num_triangles_s","4th keyword num_triangles_s","z_mfie_faces_mutual:num_triangles_s=%d",num_triangles_s) {
  /* Processing variable num_nodes_o */
  if (num_nodes_o_capi == Py_None) num_nodes_o = shape(nodes_o,0); else
    f2py_success = int_from_pyobj(&num_nodes_o,num_nodes_o_capi,"core.z_mfie_faces_mutual() 1st keyword (num_nodes_o) can't be converted to int");
  if (f2py_success) {
  CHECKSCALAR(shape(nodes_o,0)==num_nodes_o,"shape(nodes_o,0)==num_nodes_o","1st keyword num_nodes_o","z_mfie_faces_mutual:num_nodes_o=%d",num_nodes_o) {
  /* Processing variable normals_o */
  normals_o_Dims[0]=num_triangles_o,normals_o_Dims[1]=3;
  capi_normals_o_intent |= F2PY_INTENT_IN;
  capi_normals_o_tmp = array_from_pyobj(NPY_DOUBLE,normals_o_Dims,normals_o_Rank,capi_normals_o_intent,normals_o_capi);
  if (capi_normals_o_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting 8th argument `normals_o' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    normals_o = (double *)(PyArray_DATA(capi_normals_o_tmp));

  /* Processing variable z_face */
  z_face_Dims[0]=num_triangles_o,z_face_Dims[1]=3,z_face_Dims[2]=num_triangles_s,z_face_Dims[3]=3;
  capi_z_face_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_face_tmp = array_from_pyobj(NPY_CDOUBLE,z_face_Dims,z_face_Rank,capi_z_face_intent,Py_None);
  if (capi_z_face_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_face' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    z_face = (complex_double *)(PyArray_DATA(capi_z_face_tmp));

  /* Processing variable z_face_dgamma */
  z_face_dgamma_Dims[0]=num_triangles_o,z_face_dgamma_Dims[1]=3,z_face_dgamma_Dims[2]=num_triangles_s,z_face_dgamma_Dims[3]=3;
  capi_z_face_dgamma_intent |= F2PY_INTENT_OUT|F2PY_INTENT_HIDE;
  capi_z_face_dgamma_tmp = array_from_pyobj(NPY_CDOUBLE,z_face_dgamma_Dims,z_face_dgamma_Rank,capi_z_face_dgamma_intent,Py_None);
  if (capi_z_face_dgamma_tmp == NULL) {
    if (!PyErr_Occurred())
      PyErr_SetString(core_error,"failed in converting hidden `z_face_dgamma' of core.z_mfie_faces_mutual to C/Fortran array" );
  } else {
    z_face_dgamma = (complex_double *)(PyArray_DATA(capi_z_face_dgamma_tmp));

/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&num_nodes_o,&num_triangles_o,&num_nodes_s,&num_triangles_s,&num_integration,nodes_o,triangles_o,nodes_s,triangles_s,&gamma_0,xi_eta,weights,normals_o,&t_form,z_face,z_face_dgamma);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("NN",capi_z_face_tmp,capi_z_face_dgamma_tmp);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  }  /*if (capi_z_face_dgamma_tmp == NULL) ... else of z_face_dgamma*/
  /* End of cleaning variable z_face_dgamma */
  }  /*if (capi_z_face_tmp == NULL) ... else of z_face*/
  /* End of cleaning variable z_face */
  if((PyObject *)capi_normals_o_tmp!=normals_o_capi) {
    Py_XDECREF(capi_normals_o_tmp); }
  }  /*if (capi_normals_o_tmp == NULL) ... else of normals_o*/
  /* End of cleaning variable normals_o */
  } /*CHECKSCALAR(shape(nodes_o,0)==num_nodes_o)*/
  } /*if (f2py_success) of num_nodes_o*/
  /* End of cleaning variable num_nodes_o */
  } /*CHECKSCALAR(shape(triangles_s,0)==num_triangles_s)*/
  } /*if (f2py_success) of num_triangles_s*/
  /* End of cleaning variable num_triangles_s */
  if((PyObject *)capi_weights_tmp!=weights_capi) {
    Py_XDECREF(capi_weights_tmp); }
  }  /*if (capi_weights_tmp == NULL) ... else of weights*/
  /* End of cleaning variable weights */
  } /*CHECKSCALAR(shape(xi_eta,0)==num_integration)*/
  } /*if (f2py_success) of num_integration*/
  /* End of cleaning variable num_integration */
  } /*CHECKSCALAR(shape(triangles_o,0)==num_triangles_o)*/
  } /*if (f2py_success) of num_triangles_o*/
  /* End of cleaning variable num_triangles_o */
  } /*CHECKSCALAR(shape(nodes_s,0)==num_nodes_s)*/
  } /*if (f2py_success) of num_nodes_s*/
  /* End of cleaning variable num_nodes_s */
  if((PyObject *)capi_xi_eta_tmp!=xi_eta_capi) {
    Py_XDECREF(capi_xi_eta_tmp); }
  }  /*if (capi_xi_eta_tmp == NULL) ... else of xi_eta*/
  /* End of cleaning variable xi_eta */
  } /*if (f2py_success) of t_form*/
  /* End of cleaning variable t_form */
  if((PyObject *)capi_nodes_o_tmp!=nodes_o_capi) {
    Py_XDECREF(capi_nodes_o_tmp); }
  }  /*if (capi_nodes_o_tmp == NULL) ... else of nodes_o*/
  /* End of cleaning variable nodes_o */
  if((PyObject *)capi_triangles_s_tmp!=triangles_s_capi) {
    Py_XDECREF(capi_triangles_s_tmp); }
  }  /*if (capi_triangles_s_tmp == NULL) ... else of triangles_s*/
  /* End of cleaning variable triangles_s */
  }  /*if (f2py_success) of gamma_0 frompyobj*/
  /* End of cleaning variable gamma_0 */
  if((PyObject *)capi_nodes_s_tmp!=nodes_s_capi) {
    Py_XDECREF(capi_nodes_s_tmp); }
  }  /*if (capi_nodes_s_tmp == NULL) ... else of nodes_s*/
  /* End of cleaning variable nodes_s */
  if((PyObject *)capi_triangles_o_tmp!=triangles_o_capi) {
    Py_XDECREF(capi_triangles_o_tmp); }
  }  /*if (capi_triangles_o_tmp == NULL) ... else of triangles_o*/
  /* End of cleaning variable triangles_o */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/************************* end of z_mfie_faces_mutual *************************/

/******************************** set_threads ********************************/
static char doc_f2py_rout_core_set_threads[] = "\
set_threads(n)\n\nWrapper for ``set_threads``.\
\n\nParameters\n----------\n"
"n : input int";
/* extern void F_FUNC_US(set_threads,SET_THREADS)(int*); */
static PyObject *f2py_rout_core_set_threads(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  PyObject *n_capi = Py_None;
  static char *capi_kwlist[] = {"n",NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    "O:core.set_threads",\
    capi_kwlist,&n_capi))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
    f2py_success = int_from_pyobj(&n,n_capi,"core.set_threads() 1st argument (n) can't be converted to int");
  if (f2py_success) {
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("");
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  } /*if (f2py_success) of n*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of set_threads *****************************/

/******************************** get_threads ********************************/
static char doc_f2py_rout_core_get_threads[] = "\
n = get_threads()\n\nWrapper for ``get_threads``.\
\n\nReturns\n-------\n"
"n : int";
/* extern void F_FUNC_US(get_threads,GET_THREADS)(int*); */
static PyObject *f2py_rout_core_get_threads(const PyObject *capi_self,
                           PyObject *capi_args,
                           PyObject *capi_keywds,
                           void (*f2py_func)(int*)) {
  PyObject * volatile capi_buildvalue = NULL;
  volatile int f2py_success = 1;
/*decl*/

  int n = 0;
  static char *capi_kwlist[] = {NULL};

/*routdebugenter*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_clock();
#endif
  if (!PyArg_ParseTupleAndKeywords(capi_args,capi_keywds,\
    ":core.get_threads",\
    capi_kwlist))
    return NULL;
/*frompyobj*/
  /* Processing variable n */
/*end of frompyobj*/
#ifdef F2PY_REPORT_ATEXIT
f2py_start_call_clock();
#endif
/*callfortranroutine*/
        (*f2py_func)(&n);
if (PyErr_Occurred())
  f2py_success = 0;
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_call_clock();
#endif
/*end of callfortranroutine*/
    if (f2py_success) {
/*pyobjfrom*/
/*end of pyobjfrom*/
    CFUNCSMESS("Building return value.\n");
    capi_buildvalue = Py_BuildValue("i",n);
/*closepyobjfrom*/
/*end of closepyobjfrom*/
    } /*if (f2py_success) after callfortranroutine*/
/*cleanupfrompyobj*/
  /* End of cleaning variable n */
/*end of cleanupfrompyobj*/
  if (capi_buildvalue == NULL) {
/*routdebugfailure*/
  } else {
/*routdebugleave*/
  }
  CFUNCSMESS("Freeing memory.\n");
/*freemem*/
#ifdef F2PY_REPORT_ATEXIT
f2py_stop_clock();
#endif
  return capi_buildvalue;
}
/***************************** end of get_threads *****************************/
/*eof body*/

/******************* See f2py2e/f90mod_rules.py: buildhooks *******************/

static FortranDataDef f2py_core_for_def[] = {
  {"pi",0,{{-1}},NPY_DOUBLE},
  {"c",0,{{-1}},NPY_DOUBLE},
  {NULL}
};

static void f2py_setup_core_for(char *pi,char *c) {
  int i_f2py=0;
  f2py_core_for_def[i_f2py++].data = pi;
  f2py_core_for_def[i_f2py++].data = c;
}
extern void F_FUNC_US(f2pyinitcore_for,F2PYINITCORE_FOR)(void (*)(char*,char*));
static void f2py_init_core_for(void) {
  F_FUNC_US(f2pyinitcore_for,F2PYINITCORE_FOR)(f2py_setup_core_for);
}


static FortranDataDef f2py_constants_def[] = {
  {"sp",0,{{-1}},NPY_INT},
  {"wp",0,{{-1}},NPY_INT},
  {"dp",0,{{-1}},NPY_INT},
  {NULL}
};

static void f2py_setup_constants(char *sp,char *wp,char *dp) {
  int i_f2py=0;
  f2py_constants_def[i_f2py++].data = sp;
  f2py_constants_def[i_f2py++].data = wp;
  f2py_constants_def[i_f2py++].data = dp;
}
extern void F_FUNC(f2pyinitconstants,F2PYINITCONSTANTS)(void (*)(char*,char*,char*));
static void f2py_init_constants(void) {
  F_FUNC(f2pyinitconstants,F2PYINITCONSTANTS)(f2py_setup_constants);
}

/*need_f90modhooks*/

/************** See f2py2e/rules.py: module_rules['modulebody'] **************/

/******************* See f2py2e/common_rules.py: buildhooks *******************/

/*need_commonhooks*/

/**************************** See f2py2e/rules.py ****************************/

static FortranDataDef f2py_routine_defs[] = {
  {"arcioni_singular",-1,{{-1}},0,(char *)F_FUNC_US(arcioni_singular,ARCIONI_SINGULAR),(f2py_init_func)f2py_rout_core_arcioni_singular,doc_f2py_rout_core_arcioni_singular},
  {"z_efie_faces_mutual",-1,{{-1}},0,(char *)F_FUNC_US(z_efie_faces_mutual,Z_EFIE_FACES_MUTUAL),(f2py_init_func)f2py_rout_core_z_efie_faces_mutual,doc_f2py_rout_core_z_efie_faces_mutual},
  {"z_efie_faces_self",-1,{{-1}},0,(char *)F_FUNC_US(z_efie_faces_self,Z_EFIE_FACES_SELF),(f2py_init_func)f2py_rout_core_z_efie_faces_self,doc_f2py_rout_core_z_efie_faces_self},
  {"face_integrals_hanninen",-1,{{-1}},0,(char *)F_FUNC_US(face_integrals_hanninen,FACE_INTEGRALS_HANNINEN),(f2py_init_func)f2py_rout_core_face_integrals_hanninen,doc_f2py_rout_core_face_integrals_hanninen},
  {"face_integrals_yla_oijala",-1,{{-1}},0,(char *)F_FUNC_US(face_integrals_yla_oijala,FACE_INTEGRALS_YLA_OIJALA),(f2py_init_func)f2py_rout_core_face_integrals_yla_oijala,doc_f2py_rout_core_face_integrals_yla_oijala},
  {"z_mfie_faces_self",-1,{{-1}},0,(char *)F_FUNC_US(z_mfie_faces_self,Z_MFIE_FACES_SELF),(f2py_init_func)f2py_rout_core_z_mfie_faces_self,doc_f2py_rout_core_z_mfie_faces_self},
  {"z_mfie_faces_mutual",-1,{{-1}},0,(char *)F_FUNC_US(z_mfie_faces_mutual,Z_MFIE_FACES_MUTUAL),(f2py_init_func)f2py_rout_core_z_mfie_faces_mutual,doc_f2py_rout_core_z_mfie_faces_mutual},
  {"set_threads",-1,{{-1}},0,(char *)F_FUNC_US(set_threads,SET_THREADS),(f2py_init_func)f2py_rout_core_set_threads,doc_f2py_rout_core_set_threads},
  {"get_threads",-1,{{-1}},0,(char *)F_FUNC_US(get_threads,GET_THREADS),(f2py_init_func)f2py_rout_core_get_threads,doc_f2py_rout_core_get_threads},

/*eof routine_defs*/
  {NULL}
};

static PyMethodDef f2py_module_methods[] = {

  {NULL,NULL}
};

#if PY_VERSION_HEX >= 0x03000000
static struct PyModuleDef moduledef = {
  PyModuleDef_HEAD_INIT,
  "core",
  NULL,
  -1,
  f2py_module_methods,
  NULL,
  NULL,
  NULL,
  NULL
};
#endif

#if PY_VERSION_HEX >= 0x03000000
#define RETVAL m
PyMODINIT_FUNC PyInit_core(void) {
#else
#define RETVAL
PyMODINIT_FUNC initcore(void) {
#endif
  int i;
  PyObject *m,*d, *s;
#if PY_VERSION_HEX >= 0x03000000
  m = core_module = PyModule_Create(&moduledef);
#else
  m = core_module = Py_InitModule("core", f2py_module_methods);
#endif
  Py_TYPE(&PyFortran_Type) = &PyType_Type;
  import_array();
  if (PyErr_Occurred())
    {PyErr_SetString(PyExc_ImportError, "can't initialize module core (failed to import numpy)"); return RETVAL;}
  d = PyModule_GetDict(m);
  s = PyString_FromString("$Revision: $");
  PyDict_SetItemString(d, "__version__", s);
#if PY_VERSION_HEX >= 0x03000000
  s = PyUnicode_FromString(
#else
  s = PyString_FromString(
#endif
    "This module 'core' is auto-generated with f2py (version:2).\nFunctions:\n"
"  i_a,i_phi = arcioni_singular(nodes)\n"
"  a_face,phi_face,a_dgamma_face,phi_dgamma_face = z_efie_faces_mutual(nodes_o,triangle_nodes_o,nodes_s,triangle_nodes_s,gamma_0,xi_eta_eval,weights,num_nodes_o=shape(nodes_o,0),num_triangles_o=shape(triangle_nodes_o,0),num_nodes_s=shape(nodes_s,0),num_triangles_s=shape(triangle_nodes_s,0),num_integration=shape(xi_eta_eval,0))\n"
"  a_face,phi_face,a_dgamma_face,phi_dgamma_face = z_efie_faces_self(nodes,triangle_nodes,gamma_0,xi_eta_eval,weights,phi_precalc,a_precalc,indices_precalc,indptr_precalc,num_nodes=shape(nodes,0),num_triangles=shape(triangle_nodes,0),num_integration=shape(xi_eta_eval,0),num_singular=shape(phi_precalc,0),degree_singular=shape(phi_precalc,1))\n"
"  i_a,i_phi,z_nmfie,z_tmfie = face_integrals_hanninen(nodes_s,xi_eta_o,weights_o,nodes_o,gauss_points,gauss_weights,n_o=shape(xi_eta_o,0),normal_o=0.0,n_gauss=len(gauss_points))\n"
"  i_a,i_phi,z_nmfie,z_tmfie = face_integrals_yla_oijala(nodes_s,xi_eta_o,weights_o,nodes_o,n_o=shape(xi_eta_o,0),normal_o=0.0)\n"
"  z_face,z_face_dgamma = z_mfie_faces_self(nodes,triangle_nodes,triangle_areas,gamma_0,xi_eta,weights,normals,t_form,z_precalc,indices_precalc,indptr_precalc,num_nodes=shape(nodes,0),num_triangles=shape(triangle_nodes,0),num_integration=shape(xi_eta,0),num_singular=shape(z_precalc,0),degree_singular=shape(z_precalc,1))\n"
"  z_face,z_face_dgamma = z_mfie_faces_mutual(nodes_o,triangles_o,nodes_s,triangles_s,gamma_0,xi_eta,weights,normals_o,t_form,num_nodes_o=shape(nodes_o,0),num_triangles_o=shape(triangles_o,0),num_nodes_s=shape(nodes_s,0),num_triangles_s=shape(triangles_s,0),num_integration=shape(xi_eta,0))\n"
"  set_threads(n)\n"
"  n = get_threads()\n"
"Fortran 90/95 modules:\n""  core_for --- pi,c""  constants --- sp,wp,dp"".");
  PyDict_SetItemString(d, "__doc__", s);
  core_error = PyErr_NewException ("core.error", NULL, NULL);
  Py_DECREF(s);
  for(i=0;f2py_routine_defs[i].name!=NULL;i++)
    PyDict_SetItemString(d, f2py_routine_defs[i].name,PyFortranObject_NewAsAttr(&f2py_routine_defs[i]));









/*eof initf2pywraphooks*/
  PyDict_SetItemString(d, "constants", PyFortranObject_New(f2py_constants_def,f2py_init_constants));
  PyDict_SetItemString(d, "core_for", PyFortranObject_New(f2py_core_for_def,f2py_init_core_for));
/*eof initf90modhooks*/

/*eof initcommonhooks*/


#ifdef F2PY_REPORT_ATEXIT
  if (! PyErr_Occurred())
    on_exit(f2py_report_on_exit,(void*)"core");
#endif

  return RETVAL;
}
#ifdef __cplusplus
}
#endif
