/*
 * Decompiled with CFR 0.152.
 */
package be.re.xml.sax;

import be.re.io.FlushOutputStream;
import be.re.xml.sax.BalanceChecker;
import be.re.xml.sax.Tee;
import be.re.xml.sax.Util;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLFilter;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;

public class FilterOfFilters
extends XMLFilterImpl {
    private XMLFilter first;
    private XMLFilter last;

    public FilterOfFilters(XMLFilter[] filters) {
        this(filters, false);
    }

    public FilterOfFilters(XMLFilter[] filters, boolean debug) {
        this.setupChain(debug ? this.addDebug(filters) : filters);
    }

    public FilterOfFilters(XMLFilter[] filters, XMLReader parent) {
        this(filters, false, parent);
    }

    public FilterOfFilters(XMLFilter[] filters, boolean debug, XMLReader parent) {
        this.setupChain(debug ? this.addDebug(filters) : filters);
        this.setParent(parent);
    }

    private XMLFilter[] addDebug(XMLFilter[] filters) {
        XMLFilter[] result = new XMLFilter[filters.length * 2 + 1];
        result[0] = new Tee(new ContentHandler[]{FilterOfFilters.outputHandler(this.toString() + "_input.xml")});
        for (int i = 0; i < filters.length; ++i) {
            result[i * 2 + 1] = filters[i];
            result[i * 2 + 2] = new Tee(new ContentHandler[]{new BalanceChecker(new File(this.toString() + "_" + filters[i].toString() + ".balance")), FilterOfFilters.outputHandler(this.toString() + "_" + filters[i].toString())});
        }
        return result;
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.first != null ? this.first.getFeature(name) : super.getFeature(name);
    }

    public XMLReader getParent() {
        return this.first != null ? this.first.getParent() : super.getParent();
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return this.first != null ? this.first.getProperty(name) : super.getProperty(name);
    }

    private static ContentHandler outputHandler(String filename) {
        try {
            TransformerHandler handler = Util.newSAXTransformerFactory().newTransformerHandler();
            handler.setResult(new StreamResult(new FlushOutputStream(new FileOutputStream(filename))));
            return handler;
        }
        catch (Exception e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public void parse(InputSource input) throws IOException, SAXException {
        if (this.last != null) {
            this.last.parse(input);
        } else {
            super.parse(input);
        }
    }

    public void setContentHandler(ContentHandler handler) {
        if (this.last != null) {
            this.last.setContentHandler(handler);
        } else {
            super.setContentHandler(handler);
        }
    }

    public void setDTDHandler(DTDHandler handler) {
        if (this.last != null) {
            this.last.setDTDHandler(handler);
        } else {
            super.setDTDHandler(handler);
        }
    }

    public void setEntityResolver(EntityResolver resolver) {
        if (this.last != null) {
            this.last.setEntityResolver(resolver);
        } else {
            super.setEntityResolver(resolver);
        }
    }

    public void setErrorHandler(ErrorHandler handler) {
        if (this.last != null) {
            this.last.setErrorHandler(handler);
        } else {
            super.setErrorHandler(handler);
        }
    }

    public void setFeature(String name, boolean value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.first != null) {
            this.first.setFeature(name, value);
        } else {
            super.setFeature(name, value);
        }
    }

    public void setParent(XMLReader parent) {
        if (this.first != null) {
            this.first.setParent(parent);
        } else {
            super.setParent(parent);
        }
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if (this.first != null) {
            this.first.setProperty(name, value);
        } else {
            super.setProperty(name, value);
        }
    }

    private void setupChain(XMLFilter[] filters) {
        if (filters.length == 0) {
            return;
        }
        for (int i = filters.length - 1; i > 0; --i) {
            filters[i].setParent(filters[i - 1]);
            if (filters[i] instanceof ContentHandler) {
                filters[i - 1].setContentHandler((ContentHandler)((Object)filters[i]));
            }
            if (filters[i] instanceof DTDHandler) {
                filters[i - 1].setDTDHandler((DTDHandler)((Object)filters[i]));
            }
            if (filters[i] instanceof EntityResolver) {
                filters[i - 1].setEntityResolver((EntityResolver)((Object)filters[i]));
            }
            if (!(filters[i] instanceof ErrorHandler)) continue;
            filters[i - 1].setErrorHandler((ErrorHandler)((Object)filters[i]));
        }
        this.first = filters[0];
        this.last = filters[filters.length - 1];
        if (this.first instanceof ContentHandler) {
            super.setContentHandler((ContentHandler)((Object)this.first));
        }
        if (this.first instanceof DTDHandler) {
            super.setDTDHandler((DTDHandler)((Object)this.first));
        }
        if (this.first instanceof EntityResolver) {
            super.setEntityResolver((EntityResolver)((Object)this.first));
        }
        if (this.first instanceof ErrorHandler) {
            super.setErrorHandler((ErrorHandler)((Object)this.first));
        }
    }
}

