/*
 * Decompiled with CFR 0.152.
 */
package be.re.css;

import be.re.css.Constants;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.XMLFilterImpl;

class LengthAdjustFilter
extends XMLFilterImpl {
    private static final Set ofLengthType = new HashSet<String>(Arrays.asList("background-position", "border-bottom-width", "border-left-width", "border-right-width", "border-spacing", "border-top-width", "bottom", "font-size", "height", "img-height", "img-width", "left", "letter-spacing", "line-height", "margin-bottom", "margin-left", "margin-right", "margin-top", "marker-offset", "max-height", "max-width", "min-height", "min-width", "outline-width", "padding-bottom", "padding-left", "padding-right", "padding-top", "right", "size", "text-indent", "text-shadow", "top", "vertical-align", "width", "word-spacing"));

    LengthAdjustFilter() {
    }

    LengthAdjustFilter(XMLReader parent) {
        super(parent);
    }

    private static Attributes adjustAttributes(Attributes atts) {
        Attributes result = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            if (!Constants.CSS.equals(atts.getURI(i)) || !ofLengthType.contains(atts.getLocalName(i))) continue;
            boolean changed = false;
            String newValue = "";
            StringTokenizer tokenizer = new StringTokenizer(atts.getValue(i), " ");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (LengthAdjustFilter.mustReplace(token)) {
                    changed = true;
                    newValue = newValue + (newValue.equals("") ? "" : " ") + token + "px";
                    continue;
                }
                newValue = newValue + (newValue.equals("") ? "" : " ") + token;
            }
            if (!changed) continue;
            if (result == null) {
                result = new AttributesImpl(atts);
            }
            ((AttributesImpl)result).setValue(i, newValue);
        }
        return result != null ? result : atts;
    }

    private static boolean mustReplace(String s) {
        try {
            return Integer.parseInt(s) > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        super.startElement(namespaceURI, localName, qName, LengthAdjustFilter.adjustAttributes(atts));
    }
}

