/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.statistics;

import java.util.Date;
import org.inspektr.statistics.annotation.Statistic;
import org.springframework.util.Assert;

public final class StatisticActionContext {
    private final Date when;
    private final String what;
    private final Statistic.Precision[] requiredPrecision;
    private final String serverIpAddress;
    private final String applicationCode;

    public StatisticActionContext(Date when, String what, Statistic.Precision[] requiredPrecision, String serverIpAddress, String applicationCode) {
        this.when = new Date(when.getTime());
        this.what = what;
        this.requiredPrecision = requiredPrecision;
        this.serverIpAddress = serverIpAddress;
        this.applicationCode = applicationCode;
        Assert.notNull((Object)this.when, (String)"when cannot be null");
        Assert.notNull((Object)this.what, (String)"what cannot be null.");
        Assert.notNull((Object)this.requiredPrecision, (String)"requiredPrecision cannot be null");
        Assert.notNull((Object)this.serverIpAddress, (String)"serverIpAddress is a required field.");
        Assert.notNull((Object)this.applicationCode, (String)"applicationCode is a required field.");
    }

    public String getWhat() {
        return this.what;
    }

    public Date getWhen() {
        return new Date(this.when.getTime());
    }

    public Statistic.Precision[] getRequiredPrecision() {
        return this.requiredPrecision;
    }

    public String getServerIpAddress() {
        return this.serverIpAddress;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }
}

