/*
 * Decompiled with CFR 0.152.
 */
package org.inspektr.common.ioc.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import org.inspektr.common.ioc.annotation.NotEmpty;
import org.inspektr.common.ioc.validation.AnnotationValidator;
import org.springframework.beans.FatalBeanException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NotEmptyAnnotationValidator
implements AnnotationValidator {
    @Override
    public void validate(Field field, Annotation annotation, Object bean, String beanName) throws IllegalAccessException {
        Map m;
        Collection c;
        Object obj = field.get(bean);
        if (obj == null) {
            throw new FatalBeanException(this.constructMessage(field, beanName));
        }
        if (obj instanceof Collection && (c = (Collection)obj).isEmpty()) {
            throw new FatalBeanException(this.constructMessage(field, beanName));
        }
        if (obj.getClass().isArray() && Array.getLength(obj) == 0) {
            throw new FatalBeanException(this.constructMessage(field, beanName));
        }
        if (obj instanceof Map && (m = (Map)obj).isEmpty()) {
            throw new FatalBeanException(this.constructMessage(field, beanName));
        }
    }

    protected String constructMessage(Field field, String beanName) {
        return "Field '" + field.getName() + "' on bean '" + beanName + "' cannot be empty.";
    }

    @Override
    public Class<? extends Annotation> supports() {
        return NotEmpty.class;
    }
}

