/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support.ldap;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.directory.SearchControls;
import org.jasig.services.persondir.support.AbstractQueryPersonAttributeDao;
import org.jasig.services.persondir.support.MultivaluedPersonAttributeUtils;
import org.jasig.services.persondir.support.ldap.PersonAttributesMapper;
import org.jasig.services.persondir.support.ldap.QuerySearchExecutor;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.ldap.core.AttributesMapper;
import org.springframework.ldap.core.AttributesMapperCallbackHandler;
import org.springframework.ldap.core.ContextSource;
import org.springframework.ldap.core.LdapTemplate;
import org.springframework.ldap.core.NameClassPairCallbackHandler;
import org.springframework.ldap.core.SearchExecutor;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LdapPersonAttributeDao
extends AbstractQueryPersonAttributeDao
implements InitializingBean {
    private PersonAttributesMapper attributesMapper = new PersonAttributesMapper(Collections.EMPTY_MAP);
    private Set<String> possibleUserAttributeNames = Collections.emptySet();
    private LdapTemplate ldapTemplate = null;
    private String query = null;
    private String baseDN = "";
    private ContextSource contextSource = null;
    private SearchControls searchControls = new SearchControls();
    private boolean setReturningAttributes = true;

    public LdapPersonAttributeDao() {
        this.searchControls.setSearchScope(2);
    }

    public void afterPropertiesSet() throws Exception {
        if (this.setReturningAttributes) {
            Map<String, Set<String>> ldapAttributesToPortalAttributes = this.attributesMapper.getLdapAttributesToPortalAttributes();
            Set<String> ldapAttributes = ldapAttributesToPortalAttributes.keySet();
            this.searchControls.setReturningAttributes(ldapAttributes.toArray(new String[ldapAttributes.size()]));
        }
        if (this.contextSource == null) {
            throw new BeanCreationException("contextSource must be set");
        }
        if (this.query == null) {
            throw new BeanCreationException("query must be set");
        }
    }

    @Override
    protected Map<String, List<Object>> getUserAttributesIfNeeded(Object[] args) {
        QuerySearchExecutor se = new QuerySearchExecutor(this.baseDN, this.query, args, this.searchControls);
        AttributesMapperCallbackHandler attributesMapperCallbackHandler = new AttributesMapperCallbackHandler((AttributesMapper)this.attributesMapper);
        this.ldapTemplate.search((SearchExecutor)se, (NameClassPairCallbackHandler)attributesMapperCallbackHandler);
        List results = attributesMapperCallbackHandler.getList();
        return (Map)DataAccessUtils.uniqueResult((Collection)results);
    }

    public Set<String> getPossibleUserAttributeNames() {
        return this.possibleUserAttributeNames;
    }

    public Map<String, Set<String>> getLdapAttributesToPortalAttributes() {
        return this.attributesMapper.getLdapAttributesToPortalAttributes();
    }

    public void setLdapAttributesToPortalAttributes(Map<String, Object> ldapAttributesToPortalAttributesArg) {
        Map<String, Set<String>> ldapAttributesToPortalAttributes = MultivaluedPersonAttributeUtils.parseAttributeToAttributeMapping(ldapAttributesToPortalAttributesArg);
        this.attributesMapper = new PersonAttributesMapper(ldapAttributesToPortalAttributes);
        Collection userAttributeCol = MultivaluedPersonAttributeUtils.flattenCollection(ldapAttributesToPortalAttributes.values());
        this.possibleUserAttributeNames = Collections.unmodifiableSet(new HashSet(userAttributeCol));
    }

    @Deprecated
    public int getTimeLimit() {
        return this.searchControls.getTimeLimit();
    }

    @Deprecated
    public void setTimeLimit(int ms) {
        this.searchControls.setTimeLimit(ms);
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String uidQuery) {
        Assert.notNull((Object)uidQuery, (String)"uidQuery can not be null");
        this.query = uidQuery;
    }

    public String getBaseDN() {
        return this.baseDN;
    }

    public void setBaseDN(String baseDN) {
        if (baseDN == null) {
            baseDN = "";
        }
        this.baseDN = baseDN;
    }

    public ContextSource getContextSource() {
        return this.contextSource;
    }

    public void setContextSource(ContextSource contextSource) {
        Assert.notNull((Object)contextSource, (String)"contextSource can not be null");
        this.contextSource = contextSource;
        this.ldapTemplate = new LdapTemplate(this.contextSource);
    }

    public SearchControls getSearchControls() {
        return this.searchControls;
    }

    public void setSearchControls(SearchControls searchControls) {
        Assert.notNull((Object)searchControls, (String)"searchControls can not be null");
        this.searchControls = searchControls;
    }
}

