/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.services.persondir.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MultivaluedPersonAttributeUtils {
    public static Map<String, Set<String>> parseAttributeToAttributeMapping(Map<String, ? extends Object> mapping) {
        if (mapping == null) {
            return Collections.emptyMap();
        }
        HashMap mappedAttributesBuilder = new HashMap();
        for (Map.Entry<String, ? extends Object> mappingEntry : mapping.entrySet()) {
            String sourceAttrName = mappingEntry.getKey();
            Validate.notNull((Object)sourceAttrName, (String)"attribute name can not be null in Map");
            Object mappedAttribute = mappingEntry.getValue();
            if (mappedAttribute == null) {
                mappedAttributesBuilder.put(sourceAttrName, null);
                continue;
            }
            if (mappedAttribute instanceof String) {
                Set<String> mappedSet = Collections.singleton((String)mappedAttribute);
                mappedAttributesBuilder.put(sourceAttrName, mappedSet);
                continue;
            }
            if (mappedAttribute instanceof Set) {
                Set sourceSet = (Set)mappedAttribute;
                CollectionUtils.typedCollection((Collection)sourceSet, String.class);
                HashSet mappedSet = new HashSet(sourceSet);
                mappedAttributesBuilder.put(sourceAttrName, Collections.unmodifiableSet(mappedSet));
                continue;
            }
            throw new IllegalArgumentException("Invalid mapped type. key='" + sourceAttrName + "', value type='" + mappedAttribute.getClass().getName() + "'");
        }
        return Collections.unmodifiableMap(mappedAttributesBuilder);
    }

    public static <K, V> void addResult(Map<K, List<V>> results, K key, Object value) {
        Validate.notNull(results, (String)"Cannot add a result to a null map.");
        Validate.notNull(key, (String)"Cannot add a result with a null key.");
        if (value == null) {
            return;
        }
        List<V> currentValue = results.get(key);
        if (currentValue == null) {
            currentValue = new LinkedList<V>();
            results.put(key, currentValue);
        }
        if (value instanceof List) {
            currentValue.addAll((List)value);
        } else {
            currentValue.add(value);
        }
    }

    public static <T> Collection<T> flattenCollection(Collection<? extends Object> source) {
        Validate.notNull(source, (String)"Cannot flatten a null collection.");
        LinkedList<Object> result = new LinkedList<Object>();
        for (Object object : source) {
            if (object instanceof Collection) {
                Collection<T> flatCollection = MultivaluedPersonAttributeUtils.flattenCollection((Collection)object);
                result.addAll(flatCollection);
                continue;
            }
            result.add(object);
        }
        return result;
    }

    private MultivaluedPersonAttributeUtils() {
    }
}

