/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test.execution;

import java.util.Collection;
import java.util.Map;
import junit.framework.TestCase;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.Assert;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.DefaultExpressionParserFactory;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.definition.FlowDefinition;
import org.springframework.webflow.engine.impl.FlowExecutionImplFactory;
import org.springframework.webflow.execution.FlowExecution;
import org.springframework.webflow.execution.FlowExecutionException;
import org.springframework.webflow.execution.FlowExecutionFactory;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;
import org.springframework.webflow.test.MockExternalContext;

public abstract class AbstractFlowExecutionTests
extends TestCase {
    private FlowExecutionFactory flowExecutionFactory;
    private ExpressionParser expressionParser = DefaultExpressionParserFactory.getExpressionParser();
    private FlowExecution flowExecution;
    static /* synthetic */ Class class$org$springframework$webflow$execution$support$ApplicationView;
    static /* synthetic */ Class class$org$springframework$webflow$execution$support$FlowExecutionRedirect;
    static /* synthetic */ Class class$org$springframework$webflow$execution$support$FlowDefinitionRedirect;
    static /* synthetic */ Class class$org$springframework$webflow$execution$support$ExternalRedirect;

    public AbstractFlowExecutionTests() {
    }

    public AbstractFlowExecutionTests(String name) {
        super(name);
    }

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"The expression parser is required");
        this.expressionParser = expressionParser;
    }

    protected FlowExecutionFactory getFlowExecutionFactory() {
        if (this.flowExecutionFactory == null) {
            this.flowExecutionFactory = this.createFlowExecutionFactory();
        }
        return this.flowExecutionFactory;
    }

    protected ExternalContext createExternalContext(ParameterMap requestParameters) {
        return new MockExternalContext(requestParameters);
    }

    protected ViewSelection startFlow() throws FlowExecutionException {
        return this.startFlow(null, this.createExternalContext(null));
    }

    protected ViewSelection startFlow(MutableAttributeMap input) throws FlowExecutionException {
        return this.startFlow(input, this.createExternalContext(null));
    }

    protected ViewSelection startFlow(MutableAttributeMap input, ExternalContext context) throws FlowExecutionException {
        this.flowExecution = this.getFlowExecutionFactory().createFlowExecution(this.getFlowDefinition());
        return this.flowExecution.start(input, context);
    }

    protected ViewSelection signalEvent(String eventId) throws FlowExecutionException {
        return this.signalEvent(eventId, this.createExternalContext(null));
    }

    protected ViewSelection signalEvent(String eventId, ParameterMap requestParameters) throws FlowExecutionException {
        return this.signalEvent(eventId, this.createExternalContext(requestParameters));
    }

    protected ViewSelection signalEvent(String eventId, ExternalContext context) throws FlowExecutionException {
        Assert.state((this.flowExecution != null ? 1 : 0) != 0, (String)"The flow execution to test is [null]; you must start the flow execution before you can signal an event against it!");
        return this.flowExecution.signalEvent(eventId, context);
    }

    protected ViewSelection refresh() throws FlowExecutionException {
        return this.refresh(this.createExternalContext(null));
    }

    protected ViewSelection refresh(ExternalContext context) throws FlowExecutionException {
        Assert.state((this.flowExecution != null ? 1 : 0) != 0, (String)"The flow execution to test is [null]; you must start the flow execution before you can refresh it!");
        return this.flowExecution.refresh(context);
    }

    protected FlowExecution getFlowExecution() throws IllegalStateException {
        Assert.state((this.flowExecution != null ? 1 : 0) != 0, (String)"The flow execution to test is [null]; you must start the flow execution before you can query it!");
        return this.flowExecution;
    }

    protected Object getConversationAttribute(String attributeName) {
        return this.getFlowExecution().getConversationScope().get(attributeName);
    }

    protected Object getRequiredConversationAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecution().getConversationScope().getRequired(attributeName);
    }

    protected Object getRequiredConversationAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecution().getConversationScope().getRequired(attributeName, requiredType);
    }

    protected Object getFlowAttribute(String attributeName) {
        return this.getFlowExecution().getActiveSession().getScope().get(attributeName);
    }

    protected Object getRequiredFlowAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getScope().getRequired(attributeName);
    }

    protected Object getRequiredFlowAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getScope().getRequired(attributeName, requiredType);
    }

    protected Object getFlashAttribute(String attributeName) {
        return this.getFlowExecution().getActiveSession().getFlashMap().get(attributeName);
    }

    protected Object getRequiredFlashAttribute(String attributeName) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getFlashMap().getRequired(attributeName);
    }

    protected Object getRequiredFlashAttribute(String attributeName, Class requiredType) throws IllegalStateException {
        return this.getFlowExecution().getActiveSession().getFlashMap().getRequired(attributeName, requiredType);
    }

    protected void assertActiveFlowEquals(String expectedActiveFlowId) {
        AbstractFlowExecutionTests.assertEquals((String)("The active flow id '" + this.getFlowExecution().getActiveSession().getDefinition().getId() + "' does not equal the expected active flow id '" + expectedActiveFlowId + "'"), (String)expectedActiveFlowId, (String)this.getFlowExecution().getActiveSession().getDefinition().getId());
    }

    protected void assertFlowExecutionActive() {
        AbstractFlowExecutionTests.assertTrue((String)"The flow execution is not active but it should be", (boolean)this.getFlowExecution().isActive());
    }

    protected void assertFlowExecutionEnded() {
        AbstractFlowExecutionTests.assertTrue((String)"The flow execution is still active but it should have ended", (!this.getFlowExecution().isActive() ? 1 : 0) != 0);
    }

    protected void assertCurrentStateEquals(String expectedCurrentStateId) {
        AbstractFlowExecutionTests.assertEquals((String)("The current state '" + this.getFlowExecution().getActiveSession().getState().getId() + "' does not equal the expected state '" + expectedCurrentStateId + "'"), (String)expectedCurrentStateId, (String)this.getFlowExecution().getActiveSession().getState().getId());
    }

    protected void assertViewNameEquals(String expectedViewName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertEquals((String)"The view name is wrong:", (String)expectedViewName, (String)viewSelection.getViewName());
    }

    protected void assertModelAttributeEquals(Object expectedValue, String attributeName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertEquals((String)("The model attribute '" + attributeName + "' value is wrong:"), (Object)expectedValue, (Object)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel()));
    }

    protected void assertModelAttributeCollectionSize(int expectedSize, String attributeName, ApplicationView viewSelection) {
        this.assertModelAttributeNotNull(attributeName, viewSelection);
        Collection c = (Collection)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel());
        AbstractFlowExecutionTests.assertEquals((String)("The model attribute '" + attributeName + "' collection size is wrong:"), (int)expectedSize, (int)c.size());
    }

    protected void assertModelAttributeNotNull(String attributeName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertNotNull((String)("The model attribute '" + attributeName + "' is null but should not be; model contents are " + StylerUtils.style((Object)viewSelection.getModel())), (Object)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel()));
    }

    protected void assertModelAttributeNull(String attributeName, ApplicationView viewSelection) {
        AbstractFlowExecutionTests.assertNull((String)("The model attribute '" + attributeName + "' is not null but should be; model contents are " + StylerUtils.style((Object)viewSelection.getModel())), (Object)this.evaluateModelAttributeExpression(attributeName, viewSelection.getModel()));
    }

    protected ApplicationView applicationView(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$execution$support$ApplicationView == null ? (class$org$springframework$webflow$execution$support$ApplicationView = AbstractFlowExecutionTests.class$("org.springframework.webflow.execution.support.ApplicationView")) : class$org$springframework$webflow$execution$support$ApplicationView), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (ApplicationView)viewSelection;
    }

    protected FlowExecutionRedirect flowExecutionRedirect(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$execution$support$FlowExecutionRedirect == null ? (class$org$springframework$webflow$execution$support$FlowExecutionRedirect = AbstractFlowExecutionTests.class$("org.springframework.webflow.execution.support.FlowExecutionRedirect")) : class$org$springframework$webflow$execution$support$FlowExecutionRedirect), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (FlowExecutionRedirect)viewSelection;
    }

    protected FlowDefinitionRedirect flowDefinitionRedirect(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$execution$support$FlowDefinitionRedirect == null ? (class$org$springframework$webflow$execution$support$FlowDefinitionRedirect = AbstractFlowExecutionTests.class$("org.springframework.webflow.execution.support.FlowDefinitionRedirect")) : class$org$springframework$webflow$execution$support$FlowDefinitionRedirect), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (FlowDefinitionRedirect)viewSelection;
    }

    protected ExternalRedirect externalRedirect(ViewSelection viewSelection) {
        Assert.isInstanceOf((Class)(class$org$springframework$webflow$execution$support$ExternalRedirect == null ? (class$org$springframework$webflow$execution$support$ExternalRedirect = AbstractFlowExecutionTests.class$("org.springframework.webflow.execution.support.ExternalRedirect")) : class$org$springframework$webflow$execution$support$ExternalRedirect), (Object)viewSelection, (String)"Unexpected class of view selection: ");
        return (ExternalRedirect)viewSelection;
    }

    protected void nullView(ViewSelection viewSelection) {
        AbstractFlowExecutionTests.assertEquals((String)"Not the null view selection:", (Object)viewSelection, (Object)ViewSelection.NULL_VIEW);
    }

    protected Object evaluateModelAttributeExpression(String attributeName, Map model) {
        return this.expressionParser.parseExpression(attributeName).evaluate((Object)model, null);
    }

    protected FlowExecutionFactory createFlowExecutionFactory() {
        return new FlowExecutionImplFactory();
    }

    protected void updateFlowExecution(FlowExecution flowExecution) {
        this.flowExecution = flowExecution;
    }

    protected abstract FlowDefinition getFlowDefinition();

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

