/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.test;

import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.RequestControlContext;
import org.springframework.webflow.engine.State;
import org.springframework.webflow.engine.Transition;
import org.springframework.webflow.engine.TransitionableState;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.FlowSessionStatus;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.test.MockFlowSession;
import org.springframework.webflow.test.MockRequestContext;

public class MockRequestControlContext
extends MockRequestContext
implements RequestControlContext {
    public MockRequestControlContext(Flow rootFlow) {
        super(rootFlow);
    }

    public void setCurrentState(State state) {
        State previousState = (State)this.getCurrentState();
        this.getMockFlowExecutionContext().getMockActiveSession().setState(state);
        if (previousState == null) {
            this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.ACTIVE);
        }
    }

    public ViewSelection start(Flow flow, MutableAttributeMap input) throws IllegalStateException {
        this.getMockFlowExecutionContext().setActiveSession(new MockFlowSession(flow, input));
        this.getMockFlowExecutionContext().getMockActiveSession().setStatus(FlowSessionStatus.STARTING);
        ViewSelection selectedView = flow.start(this, input);
        return selectedView;
    }

    public ViewSelection signalEvent(Event event) {
        this.setLastEvent(event);
        ViewSelection selectedView = ((Flow)this.getActiveFlow()).onEvent(this);
        return selectedView;
    }

    public FlowSession endActiveFlowSession(MutableAttributeMap output) throws IllegalStateException {
        MockFlowSession endingSession = this.getMockFlowExecutionContext().getMockActiveSession();
        endingSession.getDefinitionInternal().end(this, output);
        endingSession.setStatus(FlowSessionStatus.ENDED);
        this.getMockFlowExecutionContext().setActiveSession(null);
        return endingSession;
    }

    public ViewSelection execute(Transition transition) {
        return transition.execute((TransitionableState)this.getCurrentState(), this);
    }
}

