/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.support;

import java.util.Iterator;
import java.util.Map;
import org.springframework.core.style.StylerUtils;
import org.springframework.util.StringUtils;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.core.collection.ParameterMap;
import org.springframework.webflow.execution.FlowExecutionContext;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.executor.support.FlowExecutorArgumentExtractionException;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;

public class RequestParameterFlowExecutorArgumentHandler
extends FlowExecutorArgumentHandler {
    private static final String PARAMETER_VALUE_DELIMITER = "_";
    private String parameterValueDelimiter = "_";

    public String getParameterValueDelimiter() {
        return this.parameterValueDelimiter;
    }

    public void setParameterValueDelimiter(String parameterValueDelimiter) {
        this.parameterValueDelimiter = parameterValueDelimiter;
    }

    public boolean isFlowIdPresent(ExternalContext context) {
        return context.getRequestParameterMap().contains(this.getFlowIdArgumentName());
    }

    public String extractFlowId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String flowId = context.getRequestParameterMap().get(this.getFlowIdArgumentName());
        if (!StringUtils.hasText((String)(flowId = this.applyDefaultFlowId(flowId)))) {
            throw new FlowExecutorArgumentExtractionException("Unable to extract the flow definition id parameter: make sure the client provides the '" + this.getFlowIdArgumentName() + "' parameter as input or set the 'defaultFlowId' property; " + "the parameters provided in this request are: " + StylerUtils.style((Object)context.getRequestParameterMap()));
        }
        return flowId;
    }

    public boolean isFlowExecutionKeyPresent(ExternalContext context) {
        return context.getRequestParameterMap().contains(this.getFlowExecutionKeyArgumentName());
    }

    public String extractFlowExecutionKey(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String encodedKey = context.getRequestParameterMap().get(this.getFlowExecutionKeyArgumentName());
        if (!StringUtils.hasText((String)encodedKey)) {
            throw new FlowExecutorArgumentExtractionException("Unable to extract the flow execution key parameter: make sure the client provides the '" + this.getFlowExecutionKeyArgumentName() + "' parameter as input; the parameters provided in this request are: " + StylerUtils.style((Object)context.getRequestParameterMap()));
        }
        return encodedKey;
    }

    public boolean isEventIdPresent(ExternalContext context) {
        return StringUtils.hasText((String)this.findParameter(this.getEventIdArgumentName(), context.getRequestParameterMap()));
    }

    public String extractEventId(ExternalContext context) throws FlowExecutorArgumentExtractionException {
        String eventId = this.findParameter(this.getEventIdArgumentName(), context.getRequestParameterMap());
        if (!StringUtils.hasText((String)eventId)) {
            throw new FlowExecutorArgumentExtractionException("Unable to extract the event id parameter: make sure the client provides the '" + this.getEventIdArgumentName() + "' parameter as input along with the '" + this.getFlowExecutionKeyArgumentName() + "' parameter; the parameters provided in this request are: " + StylerUtils.style((Object)context.getRequestParameterMap()));
        }
        return eventId;
    }

    protected String findParameter(String logicalParameterName, ParameterMap parameters) {
        String value = parameters.get(logicalParameterName);
        if (value != null) {
            return value;
        }
        String prefix = logicalParameterName + this.getParameterValueDelimiter();
        Iterator paramNames = parameters.asMap().keySet().iterator();
        while (paramNames.hasNext()) {
            String paramName = (String)paramNames.next();
            if (!paramName.startsWith(prefix)) continue;
            String strValue = paramName.substring(prefix.length());
            if (strValue.endsWith(".x") || strValue.endsWith(".y")) {
                strValue = strValue.substring(0, strValue.length() - 2);
            }
            return strValue;
        }
        return null;
    }

    public String createFlowDefinitionUrl(FlowDefinitionRedirect flowDefinitionRedirect, ExternalContext context) {
        StringBuffer url = new StringBuffer();
        this.appendFlowExecutorPath(url, context);
        url.append('?');
        this.appendQueryParameter(url, this.getFlowIdArgumentName(), flowDefinitionRedirect.getFlowDefinitionId());
        if (!flowDefinitionRedirect.getExecutionInput().isEmpty()) {
            url.append('&');
        }
        this.appendQueryParameters(url, flowDefinitionRedirect.getExecutionInput());
        return url.toString();
    }

    public String createFlowExecutionUrl(String flowExecutionKey, FlowExecutionContext flowExecution, ExternalContext context) {
        StringBuffer url = new StringBuffer();
        this.appendFlowExecutorPath(url, context);
        url.append('?');
        this.appendQueryParameter(url, this.getFlowExecutionKeyArgumentName(), flowExecutionKey);
        return url.toString();
    }

    public String createExternalUrl(ExternalRedirect redirect, String flowExecutionKey, ExternalContext context) {
        StringBuffer externalUrl = new StringBuffer();
        externalUrl.append(this.makeRedirectUrlContextRelativeIfNecessary(redirect.getUrl(), context));
        if (flowExecutionKey != null) {
            boolean first;
            boolean bl = first = redirect.getUrl().indexOf(63) < 0;
            if (first) {
                externalUrl.append('?');
            } else {
                externalUrl.append('&');
            }
            this.appendQueryParameter(externalUrl, this.getFlowExecutionKeyArgumentName(), flowExecutionKey);
        }
        return externalUrl.toString();
    }

    protected void appendFlowExecutorPath(StringBuffer url, ExternalContext context) {
        url.append(context.getContextPath());
        url.append(context.getDispatcherPath());
        if (context.getRequestPathInfo() != null) {
            url.append(context.getRequestPathInfo());
        }
    }

    protected void appendQueryParameters(StringBuffer url, Map parameters) {
        Iterator entries = parameters.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry entry = entries.next();
            this.appendQueryParameter(url, entry.getKey(), entry.getValue());
            if (!entries.hasNext()) continue;
            url.append('&');
        }
    }

    protected void appendQueryParameter(StringBuffer url, Object key, Object value) {
        String encodedKey = this.encodeValue(key);
        String encodedValue = this.encodeValue(value);
        url.append(encodedKey).append('=').append(encodedValue);
    }
}

