/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.mvc;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletSession;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.web.portlet.ModelAndView;
import org.springframework.web.portlet.mvc.AbstractController;
import org.springframework.webflow.context.portlet.PortletExternalContext;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;
import org.springframework.webflow.execution.support.FlowDefinitionRedirect;
import org.springframework.webflow.execution.support.FlowExecutionRedirect;
import org.springframework.webflow.executor.FlowExecutor;
import org.springframework.webflow.executor.ResponseInstruction;
import org.springframework.webflow.executor.support.FlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.RequestParameterFlowExecutorArgumentHandler;
import org.springframework.webflow.executor.support.ResponseInstructionHandler;

public class PortletFlowController
extends AbstractController
implements InitializingBean {
    private static final String RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE = "actionRequest.responseInstruction";
    private FlowExecutor flowExecutor;
    private FlowExecutorArgumentHandler argumentHandler = new RequestParameterFlowExecutorArgumentHandler();

    public PortletFlowController() {
        this.setCacheSeconds(0);
        this.setSynchronizeOnSession(true);
    }

    public FlowExecutor getFlowExecutor() {
        return this.flowExecutor;
    }

    public void setFlowExecutor(FlowExecutor flowExecutor) {
        this.flowExecutor = flowExecutor;
    }

    public FlowExecutorArgumentHandler getArgumentHandler() {
        return this.argumentHandler;
    }

    public void setArgumentHandler(FlowExecutorArgumentHandler argumentHandler) {
        this.argumentHandler = argumentHandler;
    }

    public void setDefaultFlowId(String defaultFlowId) {
        this.argumentHandler.setDefaultFlowId(defaultFlowId);
    }

    public void afterPropertiesSet() {
        Assert.notNull((Object)this.flowExecutor, (String)"The flow executor property is required");
        Assert.notNull((Object)this.argumentHandler, (String)"The argument handler property is required");
    }

    protected ModelAndView handleRenderRequestInternal(RenderRequest request, RenderResponse response) throws Exception {
        PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        ResponseInstruction responseInstruction = this.extractActionResponseInstruction((PortletRequest)request);
        if (responseInstruction != null) {
            return this.toModelAndView(responseInstruction);
        }
        if (this.argumentHandler.isFlowExecutionKeyPresent(context)) {
            String flowExecutionKey = this.argumentHandler.extractFlowExecutionKey(context);
            return this.toModelAndView(this.flowExecutor.refresh(flowExecutionKey, context));
        }
        String flowId = this.argumentHandler.extractFlowId(context);
        return this.toModelAndView(this.flowExecutor.launch(flowId, context));
    }

    protected void handleActionRequestInternal(final ActionRequest request, final ActionResponse response) throws Exception {
        final PortletExternalContext context = new PortletExternalContext(this.getPortletContext(), (PortletRequest)request, (PortletResponse)response);
        final String flowExecutionKey = this.argumentHandler.extractFlowExecutionKey(context);
        String eventId = this.argumentHandler.extractEventId(context);
        final ResponseInstruction responseInstruction = this.flowExecutor.resume(flowExecutionKey, eventId, context);
        new ResponseInstructionHandler(){

            protected void handleApplicationView(ApplicationView view) throws Exception {
                if (responseInstruction.isActiveView()) {
                    response.setRenderParameter(PortletFlowController.this.argumentHandler.getFlowExecutionKeyArgumentName(), responseInstruction.getFlowExecutionKey());
                }
                PortletFlowController.this.exposeToRenderPhase(responseInstruction, request);
            }

            protected void handleFlowDefinitionRedirect(FlowDefinitionRedirect redirect) throws Exception {
                response.setRenderParameter(PortletFlowController.this.argumentHandler.getFlowIdArgumentName(), redirect.getFlowDefinitionId());
                Iterator it = redirect.getExecutionInput().entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    response.setRenderParameter(PortletFlowController.this.convertToString(entry.getKey()), PortletFlowController.this.convertToString(entry.getValue()));
                }
            }

            protected void handleFlowExecutionRedirect(FlowExecutionRedirect redirect) throws Exception {
                response.setRenderParameter(PortletFlowController.this.argumentHandler.getFlowExecutionKeyArgumentName(), responseInstruction.getFlowExecutionKey());
            }

            protected void handleExternalRedirect(ExternalRedirect redirect) throws Exception {
                String url = PortletFlowController.this.argumentHandler.createExternalUrl(redirect, flowExecutionKey, context);
                response.sendRedirect(url);
            }

            protected void handleNull() throws Exception {
                if (responseInstruction.getFlowExecutionContext().isActive()) {
                    response.setRenderParameter(PortletFlowController.this.argumentHandler.getFlowExecutionKeyArgumentName(), responseInstruction.getFlowExecutionKey());
                }
                PortletFlowController.this.exposeToRenderPhase(responseInstruction, request);
            }
        }.handle(responseInstruction);
    }

    protected String convertToString(Object object) {
        return String.valueOf(object);
    }

    private void exposeToRenderPhase(ResponseInstruction responseInstruction, ActionRequest request) {
        PortletSession session = request.getPortletSession(false);
        Assert.notNull((Object)session, (String)"A PortletSession is required");
        session.setAttribute(RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE, (Object)responseInstruction);
    }

    private ResponseInstruction extractActionResponseInstruction(PortletRequest request) {
        PortletSession session = request.getPortletSession(false);
        ResponseInstruction response = null;
        if (session != null && (response = (ResponseInstruction)session.getAttribute(RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE)) != null) {
            session.removeAttribute(RESPONSE_INSTRUCTION_SESSION_ATTRIBUTE);
        }
        return response;
    }

    protected ModelAndView toModelAndView(ResponseInstruction responseInstruction) {
        if (responseInstruction.isApplicationView()) {
            ApplicationView forward = (ApplicationView)responseInstruction.getViewSelection();
            HashMap model = new HashMap(forward.getModel());
            this.argumentHandler.exposeFlowExecutionContext(responseInstruction.getFlowExecutionKey(), responseInstruction.getFlowExecutionContext(), model);
            return new ModelAndView(forward.getViewName(), model);
        }
        if (responseInstruction.isNull()) {
            return null;
        }
        throw new IllegalArgumentException("Don't know how to render response instruction " + responseInstruction);
    }
}

