/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.executor.jsf;

import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import javax.faces.el.ReferenceSyntaxException;
import org.springframework.webflow.execution.FlowExecution;

public abstract class AbstractFlowExecutionPropertyResolver
extends PropertyResolver {
    private final PropertyResolver resolverDelegate;

    public AbstractFlowExecutionPropertyResolver(PropertyResolver resolverDelegate) {
        this.resolverDelegate = resolverDelegate;
    }

    protected final PropertyResolver getResolverDelegate() {
        return this.resolverDelegate;
    }

    public Class getType(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            FlowExecution execution = (FlowExecution)base;
            this.assertPropertyNameValid(property);
            return this.doGetAttributeType(execution, (String)property);
        }
        return this.resolverDelegate.getType(base, property);
    }

    public Class getType(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            return null;
        }
        return this.resolverDelegate.getType(base, index);
    }

    public Object getValue(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            FlowExecution execution = (FlowExecution)base;
            this.assertPropertyNameValid(property);
            return this.doGetAttribute(execution, (String)property);
        }
        return this.resolverDelegate.getValue(base, property);
    }

    public Object getValue(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            throw new ReferenceSyntaxException("Cannot apply an index value to a flow execution");
        }
        return this.resolverDelegate.getValue(base, index);
    }

    public boolean isReadOnly(Object base, Object property) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            return false;
        }
        return this.resolverDelegate.isReadOnly(base, property);
    }

    public boolean isReadOnly(Object base, int index) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            return false;
        }
        return this.resolverDelegate.isReadOnly(base, index);
    }

    public void setValue(Object base, Object property, Object value) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            FlowExecution execution = (FlowExecution)base;
            this.assertPropertyNameValid(property);
            this.doSetAttribute(execution, (String)property, value);
        } else {
            this.resolverDelegate.setValue(base, property, value);
        }
    }

    public void setValue(Object base, int index, Object value) throws EvaluationException, PropertyNotFoundException {
        if (base instanceof FlowExecution) {
            throw new ReferenceSyntaxException("Cannot apply an index value to a flow execution");
        }
        this.resolverDelegate.setValue(base, index, value);
    }

    private void assertPropertyNameValid(Object property) {
        if (property == null) {
            throw new PropertyNotFoundException("The name of the flow execution attribute cannot be null");
        }
        if (!(property instanceof String)) {
            throw new PropertyNotFoundException("Flow execution attribute names must be strings but " + property + " was not");
        }
        if (((String)property).length() == 0) {
            throw new PropertyNotFoundException("The name of the flow execution attribute cannot be blank");
        }
    }

    protected abstract Class doGetAttributeType(FlowExecution var1, String var2);

    protected abstract Object doGetAttribute(FlowExecution var1, String var2);

    protected abstract void doSetAttribute(FlowExecution var1, String var2, Object var3);
}

