/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.engine.support;

import java.io.Serializable;
import org.springframework.binding.expression.Expression;
import org.springframework.binding.expression.ExpressionParser;
import org.springframework.binding.expression.SettableExpression;
import org.springframework.binding.mapping.AttributeMapper;
import org.springframework.binding.mapping.DefaultAttributeMapper;
import org.springframework.binding.mapping.Mapping;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.DefaultExpressionParserFactory;
import org.springframework.webflow.engine.support.AbstractFlowAttributeMapper;
import org.springframework.webflow.engine.support.AttributeExpression;
import org.springframework.webflow.execution.ScopeType;

public class ConfigurableFlowAttributeMapper
extends AbstractFlowAttributeMapper
implements Serializable {
    private ExpressionParser expressionParser = DefaultExpressionParserFactory.getExpressionParser();
    private DefaultAttributeMapper inputMapper = new DefaultAttributeMapper();
    private DefaultAttributeMapper outputMapper = new DefaultAttributeMapper();

    public void setExpressionParser(ExpressionParser expressionParser) {
        Assert.notNull((Object)expressionParser, (String)"The expression parser is required");
        this.expressionParser = expressionParser;
    }

    public ConfigurableFlowAttributeMapper addInputMapping(AttributeMapper inputMapping) {
        this.inputMapper.addMapping(inputMapping);
        return this;
    }

    public void addInputMappings(AttributeMapper[] inputMappings) {
        this.inputMapper.addMappings(inputMappings);
    }

    public ConfigurableFlowAttributeMapper addOutputMapping(AttributeMapper outputMapping) {
        this.outputMapper.addMapping(outputMapping);
        return this;
    }

    public void addOutputMappings(AttributeMapper[] outputMappings) {
        this.outputMapper.addMappings(outputMappings);
    }

    public ConfigurableFlowAttributeMapper addInputAttribute(String attributeName) {
        SettableExpression attribute = this.expressionParser.parseSettableExpression(attributeName);
        AttributeExpression scope = new AttributeExpression((Expression)attribute, ScopeType.FLOW);
        this.addInputMapping((AttributeMapper)new Mapping((Expression)scope, attribute, null));
        return this;
    }

    public void addInputAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            return;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            this.addInputAttribute(attributeNames[i]);
        }
    }

    public ConfigurableFlowAttributeMapper addOutputAttribute(String attributeName) {
        Expression attribute = this.expressionParser.parseExpression(attributeName);
        AttributeExpression scope = new AttributeExpression(attribute, ScopeType.FLOW);
        this.addOutputMapping((AttributeMapper)new Mapping(attribute, (SettableExpression)scope, null));
        return this;
    }

    public void addOutputAttributes(String[] attributeNames) {
        if (attributeNames == null) {
            return;
        }
        for (int i = 0; i < attributeNames.length; ++i) {
            this.addOutputAttribute(attributeNames[i]);
        }
    }

    public AttributeMapper[] getInputMappings() {
        return this.inputMapper.getMappings();
    }

    public AttributeMapper[] getOutputMappings() {
        return this.outputMapper.getMappings();
    }

    protected ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    protected AttributeMapper getInputMapper() {
        return this.inputMapper;
    }

    protected AttributeMapper getOutputMapper() {
        return this.outputMapper;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("inputMapper", (Object)this.inputMapper).append("outputMapper", (Object)this.outputMapper).toString();
    }
}

