/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.webflow.definition.registry;

import java.io.Serializable;
import org.springframework.core.io.Resource;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.Assert;
import org.springframework.webflow.core.collection.AttributeMap;
import org.springframework.webflow.core.collection.CollectionUtils;

public class FlowDefinitionResource
implements Serializable {
    private String id;
    private AttributeMap attributes;
    private Resource location;

    public FlowDefinitionResource(Resource location) {
        this.init(FlowDefinitionResource.conventionalFlowId(location), location, null);
    }

    public FlowDefinitionResource(Resource location, AttributeMap attributes) {
        this.init(FlowDefinitionResource.conventionalFlowId(location), location, attributes);
    }

    public FlowDefinitionResource(String id, Resource location) {
        this.init(id, location, null);
    }

    public FlowDefinitionResource(String id, Resource location, AttributeMap attributes) {
        this.init(id, location, attributes);
    }

    public String getId() {
        return this.id;
    }

    public Resource getLocation() {
        return this.location;
    }

    public AttributeMap getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FlowDefinitionResource)) {
            return false;
        }
        FlowDefinitionResource other = (FlowDefinitionResource)o;
        return this.id.equals(other.id) && this.location.equals(other.location);
    }

    public int hashCode() {
        return this.id.hashCode() + this.location.hashCode();
    }

    private void init(String id, Resource location, AttributeMap attributes) {
        Assert.hasText((String)id, (String)"The id of the externalized flow definition is required");
        Assert.notNull((Object)location, (String)"The location of the externalized flow definition is required");
        this.id = id;
        this.location = location;
        this.attributes = attributes != null ? attributes : CollectionUtils.EMPTY_ATTRIBUTE_MAP;
    }

    public static String conventionalFlowId(Resource location) {
        String fileName = location.getFilename();
        int extensionIndex = fileName.lastIndexOf(46);
        if (extensionIndex != -1) {
            return fileName.substring(0, extensionIndex);
        }
        return fileName;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("id", (Object)this.id).append("location", (Object)this.location).append("attributes", (Object)this.attributes).toString();
    }
}

