/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.authentication;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public class AuthenticationFilter
extends AbstractCasFilter {
    public static final String CONST_CAS_GATEWAY = "_const_cas_gateway_";
    private String casServerLoginUrl;
    private boolean renew = false;
    private boolean gateway = false;

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        super.initInternal(filterConfig);
        this.setCasServerLoginUrl(this.getPropertyFromInitParams(filterConfig, "casServerLoginUrl", null));
        this.log.trace((Object)("Loaded CasServerLoginUrl parameter: " + this.casServerLoginUrl));
        this.setRenew(Boolean.parseBoolean(this.getPropertyFromInitParams(filterConfig, "renew", "false")));
        this.log.trace((Object)("Loaded renew parameter: " + this.renew));
        this.setGateway(Boolean.parseBoolean(this.getPropertyFromInitParams(filterConfig, "gateway", "false")));
        this.log.trace((Object)("Loaded gateway parameter: " + this.gateway));
    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.casServerLoginUrl, "casServerLoginUrl cannot be null.");
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        boolean wasGatewayed;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        HttpSession session = request.getSession(false);
        String ticket = request.getParameter(this.getArtifactParameterName());
        Assertion assertion = session != null ? (Assertion)session.getAttribute("_const_cas_assertion_") : null;
        boolean bl = wasGatewayed = session != null && session.getAttribute(CONST_CAS_GATEWAY) != null;
        if (CommonUtils.isBlank(ticket) && assertion == null && !wasGatewayed) {
            this.log.debug((Object)"no ticket and no assertion found");
            if (this.gateway) {
                this.log.debug((Object)"setting gateway attribute in session");
                request.getSession(true).setAttribute(CONST_CAS_GATEWAY, (Object)"yes");
            }
            String serviceUrl = this.constructServiceUrl(request, response);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Constructed service url: " + serviceUrl));
            }
            String urlToRedirectTo = CommonUtils.constructRedirectUrl(this.casServerLoginUrl, this.getServiceParameterName(), serviceUrl, this.renew, this.gateway);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("redirecting to \"" + urlToRedirectTo + "\""));
            }
            response.sendRedirect(urlToRedirectTo);
            return;
        }
        if (session != null) {
            this.log.debug((Object)"removing gateway attribute from session");
            session.setAttribute(CONST_CAS_GATEWAY, null);
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }
}

