/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.util;

import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.DirContextOperations;

public final class SpringLdapUtils {
    public static final String OBJECTCLASS_ATTRIBUTE = "objectclass";
    public static final String LDAP_BOOLEAN_TRUE = "TRUE";
    public static final String LDAP_BOOLEAN_FALSE = "FALSE";

    public static Boolean getBoolean(DirContextOperations ctx, String attribute) {
        return SpringLdapUtils.getBoolean(ctx, attribute, false);
    }

    public static Boolean getBoolean(DirContextOperations ctx, String attribute, Boolean nullValue) {
        String v = ctx.getStringAttribute(attribute);
        if (v != null) {
            return v.equalsIgnoreCase(LDAP_BOOLEAN_TRUE);
        }
        return nullValue;
    }

    public static void setBoolean(DirContextOperations ctx, String attribute, Boolean value) {
        ctx.setAttributeValue(attribute, (Object)(value != false ? LDAP_BOOLEAN_TRUE : LDAP_BOOLEAN_FALSE));
    }

    public static boolean containsObjectClass(DirContextAdapter ctx, String objectclass) {
        String[] objectclasses = ctx.getStringAttributes(OBJECTCLASS_ATTRIBUTE);
        if (objectclasses == null || objectclasses.length == 0) {
            return false;
        }
        for (int i = 0; i < objectclasses.length; ++i) {
            String ocls = objectclasses[i];
            if (!ocls.equalsIgnoreCase(objectclass)) continue;
            return true;
        }
        return false;
    }
}

