/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.ldap.services;

import java.util.ArrayList;
import java.util.List;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.adaptors.ldap.services.DefaultLdapServiceMapper;
import org.jasig.cas.adaptors.ldap.services.LdapServiceMapper;
import org.jasig.cas.services.RegisteredService;
import org.jasig.cas.services.RegisteredServiceImpl;
import org.jasig.cas.services.ServiceRegistryDao;
import org.springframework.ldap.core.ContextMapper;
import org.springframework.ldap.core.DirContextAdapter;
import org.springframework.ldap.core.LdapTemplate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LdapServiceRegistryDao
implements ServiceRegistryDao {
    private final Log log = LogFactory.getLog(this.getClass());
    @NotNull
    private LdapTemplate ldapTemplate;
    @NotNull
    private String serviceBaseDn;
    private boolean ignoreMultipleSearchResults = false;
    @NotNull
    private LdapServiceMapper ldapServiceMapper = new DefaultLdapServiceMapper();
    private final SearchControls cachedSearchControls = new SearchControls();

    public LdapServiceRegistryDao() {
        this.cachedSearchControls.setSearchScope(2);
    }

    public RegisteredService save(RegisteredService rs) {
        RegisteredServiceImpl registeredService = (RegisteredServiceImpl)rs;
        if (registeredService.getId() != -1L) {
            return this.update(registeredService);
        }
        DirContextAdapter ctx = this.ldapServiceMapper.createCtx(this.serviceBaseDn, (RegisteredService)registeredService);
        String dn = ctx.getNameInNamespace();
        registeredService.setId((long)dn.hashCode());
        this.ldapServiceMapper.doMapToContext((RegisteredService)registeredService, ctx);
        this.ldapTemplate.bind(ctx.getNameInNamespace(), (Object)ctx, null);
        return registeredService;
    }

    public RegisteredService update(RegisteredServiceImpl registeredService) {
        DirContextAdapter ctx = this.lookupCtx(this.findDn(this.ldapServiceMapper.getSearchFilter(registeredService.getId()).encode()));
        if (ctx == null) {
            return null;
        }
        this.ldapServiceMapper.doMapToContext((RegisteredService)registeredService, ctx);
        String dn = ctx.getNameInNamespace();
        ModificationItem[] modItems = ctx.getModificationItems();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Attemting to perform modify operations on " + dn));
            for (ModificationItem modItem : modItems) {
                this.log.debug((Object)modItem.toString());
            }
        }
        this.ldapTemplate.modifyAttributes(dn, modItems);
        return registeredService;
    }

    protected DirContextAdapter lookupCtx(String dn) {
        return dn == null ? null : (DirContextAdapter)this.ldapTemplate.lookup(dn);
    }

    protected String findDn(String filter) {
        List results = this.ldapTemplate.search(this.serviceBaseDn, filter, 2, new String[0], new ContextMapper(){

            public Object mapFromContext(Object ctx) {
                return ((DirContextAdapter)ctx).getNameInNamespace();
            }
        });
        if (results == null || results.isEmpty()) {
            return null;
        }
        if (results.size() == 1 || this.ignoreMultipleSearchResults) {
            return (String)results.get(0);
        }
        throw new RuntimeException("Multiple results returned by LDAP Server for Filter " + filter);
    }

    public boolean delete(RegisteredService registeredService) {
        String dn = this.findDn(this.ldapServiceMapper.getSearchFilter(registeredService.getId()).encode());
        try {
            this.ldapTemplate.unbind(dn, false);
            return true;
        }
        catch (Exception e) {
            this.log.warn((Object)"Error deleting Registered Service", (Throwable)e);
            return false;
        }
    }

    public List<RegisteredService> load() {
        try {
            return this.ldapTemplate.search(this.serviceBaseDn, this.ldapServiceMapper.getLoadFilter().encode(), this.cachedSearchControls, (ContextMapper)this.ldapServiceMapper);
        }
        catch (Exception e) {
            this.log.error((Object)"Exception while loading Registered Services from LDAP Directory...", (Throwable)e);
            return new ArrayList<RegisteredService>();
        }
    }

    public RegisteredService findServiceById(long id) {
        return (RegisteredService)this.ldapTemplate.lookup(this.findDn(this.ldapServiceMapper.getSearchFilter(id).encode()), (ContextMapper)this.ldapServiceMapper);
    }

    public void setServiceBaseDN(String serviceBaseDN) {
        this.serviceBaseDn = serviceBaseDN;
    }

    public void setLdapTemplate(LdapTemplate ldapTemplate) {
        this.ldapTemplate = ldapTemplate;
    }

    public void setIgnoreMultipleSearchResults(boolean ignoreMultipleSearchResults) {
        this.ignoreMultipleSearchResults = ignoreMultipleSearchResults;
    }

    public void setLdapServiceMapper(LdapServiceMapper ldapServiceMapper) {
        this.ldapServiceMapper = ldapServiceMapper;
    }
}

