/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.support;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.web.support.ArgumentExtractor;
import org.springframework.util.Assert;
import org.springframework.webflow.context.servlet.ServletExternalContext;
import org.springframework.webflow.execution.RequestContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class WebUtils {
    public static final HttpServletRequest getHttpServletRequest(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletRequest from event of type: " + context.getExternalContext().getClass().getName()));
        return ((ServletExternalContext)context.getExternalContext()).getRequest();
    }

    public static final HttpServletResponse getHttpServletResponse(RequestContext context) {
        Assert.isInstanceOf(ServletExternalContext.class, (Object)context.getExternalContext(), (String)("Cannot obtain HttpServletResponse from event of type: " + context.getExternalContext().getClass().getName()));
        return ((ServletExternalContext)context.getExternalContext()).getResponse();
    }

    public static final WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, HttpServletRequest request) {
        for (ArgumentExtractor argumentExtractor : argumentExtractors) {
            WebApplicationService service = argumentExtractor.extractService(request);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    public static final WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequest(context);
        return WebUtils.getService(argumentExtractors, request);
    }

    public static final WebApplicationService getService(RequestContext context) {
        return (WebApplicationService)context.getFlowScope().get("service");
    }

    public static final void putTicketGrantingTicketInRequestScope(RequestContext context, String ticketValue) {
        context.getRequestScope().put("ticketGrantingTicketId", (Object)ticketValue);
    }

    public static final String getTicketGrantingTicketId(RequestContext context) {
        String tgtFromRequest = (String)context.getRequestScope().get("ticketGrantingTicketId");
        String tgtFromFlow = (String)context.getFlowScope().get("ticketGrantingTicketId");
        return tgtFromRequest != null ? tgtFromRequest : tgtFromFlow;
    }

    public static final void putServiceTicketInRequestScope(RequestContext context, String ticketValue) {
        context.getRequestScope().put("serviceTicketId", (Object)ticketValue);
    }

    public static final String getServiceTicketFromRequestScope(RequestContext context) {
        return context.getRequestScope().getString("serviceTicketId");
    }
}

