/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.web.flow;

import java.util.HashMap;
import org.jasig.cas.authentication.principal.Response;
import org.jasig.cas.authentication.principal.WebApplicationService;
import org.jasig.cas.web.support.WebUtils;
import org.springframework.webflow.engine.ViewSelector;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.ViewSelection;
import org.springframework.webflow.execution.support.ApplicationView;
import org.springframework.webflow.execution.support.ExternalRedirect;

public final class DynamicRedirectViewSelector
implements ViewSelector {
    public ViewSelection makeRefreshSelection(RequestContext context) {
        return this.makeEntrySelection(context);
    }

    public boolean isEntrySelectionRenderable(RequestContext request) {
        return false;
    }

    public ViewSelection makeEntrySelection(RequestContext request) {
        WebApplicationService service = WebUtils.getService(request);
        String ticket = WebUtils.getServiceTicketFromRequestScope(request);
        Response serviceResponse = service.getResponse(ticket);
        switch (serviceResponse.getResponseType()) {
            case POST: {
                HashMap<String, Object> model = new HashMap<String, Object>();
                model.put("parameters", serviceResponse.getAttributes());
                model.put("originalUrl", service.getId());
                return new ApplicationView("postResponseView", model);
            }
        }
        return new ExternalRedirect(service.getResponse(ticket).getUrl());
    }
}

