/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.util;

import java.io.InputStream;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.spec.PKCS8EncodedKeySpec;
import org.inspektr.common.ioc.annotation.NotNull;
import org.springframework.beans.factory.config.AbstractFactoryBean;
import org.springframework.core.io.Resource;

public final class PrivateKeyFactoryBean
extends AbstractFactoryBean {
    @NotNull
    private Resource location;
    @NotNull
    private String algorithm;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object createInstance() throws Exception {
        InputStream privKey = this.location.getInputStream();
        try {
            byte[] bytes = new byte[privKey.available()];
            privKey.read(bytes);
            privKey.close();
            PKCS8EncodedKeySpec privSpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(this.algorithm);
            PrivateKey privateKey = factory.generatePrivate(privSpec);
            return privateKey;
        }
        finally {
            privKey.close();
        }
    }

    public Class getObjectType() {
        return PrivateKey.class;
    }

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

