/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.proxy.support;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.authentication.principal.HttpBasedServiceCredentials;
import org.jasig.cas.ticket.proxy.ProxyHandler;
import org.jasig.cas.util.DefaultUniqueTicketIdGenerator;
import org.jasig.cas.util.HttpClient;
import org.jasig.cas.util.UniqueTicketIdGenerator;

public final class Cas20ProxyHandler
implements ProxyHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String PGTIOU_PREFIX = "PGTIOU";
    @NotNull
    private UniqueTicketIdGenerator uniqueTicketIdGenerator = new DefaultUniqueTicketIdGenerator();
    @NotNull
    private HttpClient httpClient;

    public String handle(Credentials credentials, String proxyGrantingTicketId) {
        HttpBasedServiceCredentials serviceCredentials = (HttpBasedServiceCredentials)credentials;
        String proxyIou = this.uniqueTicketIdGenerator.getNewTicketId(PGTIOU_PREFIX);
        String serviceCredentialsAsString = serviceCredentials.getCallbackUrl().toExternalForm();
        StringBuilder stringBuffer = new StringBuilder(serviceCredentialsAsString.length() + proxyIou.length() + proxyGrantingTicketId.length() + 15);
        stringBuffer.append(serviceCredentialsAsString);
        if (serviceCredentials.getCallbackUrl().getQuery() != null) {
            stringBuffer.append("&");
        } else {
            stringBuffer.append("?");
        }
        stringBuffer.append("pgtIou=");
        stringBuffer.append(proxyIou);
        stringBuffer.append("&pgtId=");
        stringBuffer.append(proxyGrantingTicketId);
        if (this.httpClient.isValidEndPoint(stringBuffer.toString())) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Sent ProxyIou of " + proxyIou + " for service: " + serviceCredentials.toString()));
            }
            return proxyIou;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Failed to send ProxyIou of " + proxyIou + " for service: " + serviceCredentials.toString()));
        }
        return null;
    }

    public void setUniqueTicketIdGenerator(UniqueTicketIdGenerator uniqueTicketIdGenerator) {
        this.uniqueTicketIdGenerator = uniqueTicketIdGenerator;
    }

    public void setHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }
}

