/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.audit.spi;

import org.aspectj.lang.JoinPoint;
import org.inspektr.audit.spi.AuditablePrincipalResolver;
import org.inspektr.common.ioc.annotation.NotNull;
import org.jasig.cas.authentication.principal.Credentials;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.TicketRegistry;

public class TicketOrCredentialBasedAuditablePrincipalResolver
implements AuditablePrincipalResolver {
    @NotNull
    private final TicketRegistry ticketRegistry;

    public TicketOrCredentialBasedAuditablePrincipalResolver(TicketRegistry ticketRegistry) {
        this.ticketRegistry = ticketRegistry;
    }

    public String resolveFrom(JoinPoint joinPoint, Object retval) {
        return this.resolveFromInternal(joinPoint);
    }

    public String resolveFrom(JoinPoint joinPoint, Exception retval) {
        return this.resolveFromInternal(joinPoint);
    }

    private String resolveFromInternal(JoinPoint joinPoint) {
        Object arg1 = joinPoint.getArgs()[0];
        if (arg1 instanceof Credentials) {
            return arg1.toString();
        }
        if (arg1 instanceof String) {
            Ticket ticket = this.ticketRegistry.getTicket((String)arg1);
            if (ticket == null) {
                return "";
            }
            if (ticket instanceof ServiceTicket) {
                ServiceTicket serviceTicket = (ServiceTicket)ticket;
                return serviceTicket.getGrantingTicket().getAuthentication().getPrincipal().getId();
            }
            TicketGrantingTicket tgt = (TicketGrantingTicket)ticket;
            return tgt.getAuthentication().getPrincipal().getId();
        }
        return "";
    }
}

