# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model
from msrest.exceptions import HttpOperationError


class CanceledSubscriptionId(Model):
    """The ID of the canceled subscription.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The ID of the canceled subscription
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(CanceledSubscriptionId, self).__init__(**kwargs)
        self.value = None


class CloudError(Model):
    """CloudError.
    """

    _attribute_map = {
    }


class EnabledSubscriptionId(Model):
    """The ID of the subscriptions that is being enabled.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The ID of the subscriptions that is being enabled
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(EnabledSubscriptionId, self).__init__(**kwargs)
        self.value = None


class ErrorResponse(Model):
    """Describes the format of Error response.

    :param code: Error code
    :type code: str
    :param message: Error message indicating why the operation failed.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponse, self).__init__(**kwargs)
        self.code = kwargs.get('code', None)
        self.message = kwargs.get('message', None)


class ErrorResponseException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponse'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseException, self).__init__(deserialize, response, 'ErrorResponse', *args)


class ErrorResponseBody(Model):
    """Error response indicates that the service is not able to process the
    incoming request. The reason is provided in the error message.

    :param error: The details of the error.
    :type error: ~azure.mgmt.subscription.models.ErrorResponse
    """

    _attribute_map = {
        'error': {'key': 'error', 'type': 'ErrorResponse'},
    }

    def __init__(self, **kwargs):
        super(ErrorResponseBody, self).__init__(**kwargs)
        self.error = kwargs.get('error', None)


class ErrorResponseBodyException(HttpOperationError):
    """Server responsed with exception of type: 'ErrorResponseBody'.

    :param deserialize: A deserializer
    :param response: Server response to be deserialized.
    """

    def __init__(self, deserialize, response, *args):

        super(ErrorResponseBodyException, self).__init__(deserialize, response, 'ErrorResponseBody', *args)


class Location(Model):
    """Location information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The fully qualified ID of the location. For example,
     /subscriptions/00000000-0000-0000-0000-000000000000/locations/westus.
    :vartype id: str
    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    :ivar name: The location name.
    :vartype name: str
    :ivar display_name: The display name of the location.
    :vartype display_name: str
    :ivar latitude: The latitude of the location.
    :vartype latitude: str
    :ivar longitude: The longitude of the location.
    :vartype longitude: str
    """

    _validation = {
        'id': {'readonly': True},
        'subscription_id': {'readonly': True},
        'name': {'readonly': True},
        'display_name': {'readonly': True},
        'latitude': {'readonly': True},
        'longitude': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'latitude': {'key': 'latitude', 'type': 'str'},
        'longitude': {'key': 'longitude', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Location, self).__init__(**kwargs)
        self.id = None
        self.subscription_id = None
        self.name = None
        self.display_name = None
        self.latitude = None
        self.longitude = None


class Operation(Model):
    """REST API operation.

    :param name: Operation name: {provider}/{resource}/{operation}
    :type name: str
    :param display: The object that represents the operation.
    :type display: ~azure.mgmt.subscription.models.OperationDisplay
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'display': {'key': 'display', 'type': 'OperationDisplay'},
    }

    def __init__(self, **kwargs):
        super(Operation, self).__init__(**kwargs)
        self.name = kwargs.get('name', None)
        self.display = kwargs.get('display', None)


class OperationDisplay(Model):
    """The object that represents the operation.

    :param provider: Service provider: Microsoft.Subscription
    :type provider: str
    :param resource: Resource on which the operation is performed: Profile,
     endpoint, etc.
    :type resource: str
    :param operation: Operation type: Read, write, delete, etc.
    :type operation: str
    """

    _attribute_map = {
        'provider': {'key': 'provider', 'type': 'str'},
        'resource': {'key': 'resource', 'type': 'str'},
        'operation': {'key': 'operation', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationDisplay, self).__init__(**kwargs)
        self.provider = kwargs.get('provider', None)
        self.resource = kwargs.get('resource', None)
        self.operation = kwargs.get('operation', None)


class OperationListResult(Model):
    """Result of the request to list operations. It contains a list of operations
    and a URL link to get the next set of results.

    :param value: List of operations.
    :type value: list[~azure.mgmt.subscription.models.Operation]
    :param next_link: URL to get the next set of operation list results if
     there are any.
    :type next_link: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Operation]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(OperationListResult, self).__init__(**kwargs)
        self.value = kwargs.get('value', None)
        self.next_link = kwargs.get('next_link', None)


class PutAliasListResult(Model):
    """The list of aliases.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The list of alias.
    :vartype value: list[~azure.mgmt.subscription.models.PutAliasResponse]
    :ivar next_link: The link (url) to the next page of results.
    :vartype next_link: str
    """

    _validation = {
        'value': {'readonly': True},
        'next_link': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[PutAliasResponse]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PutAliasListResult, self).__init__(**kwargs)
        self.value = None
        self.next_link = None


class PutAliasRequest(Model):
    """The parameters required to create a new subscription.

    All required parameters must be populated in order to send to Azure.

    :param properties: Required. Put alias request properties.
    :type properties:
     ~azure.mgmt.subscription.models.PutAliasRequestProperties
    """

    _validation = {
        'properties': {'required': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'PutAliasRequestProperties'},
    }

    def __init__(self, **kwargs):
        super(PutAliasRequest, self).__init__(**kwargs)
        self.properties = kwargs.get('properties', None)


class PutAliasRequestProperties(Model):
    """Put subscription properties.

    :param display_name: The friendly name of the subscription.
    :type display_name: str
    :param workload: The workload type of the subscription. It can be either
     Production or DevTest. Possible values include: 'Production', 'DevTest'
    :type workload: str or ~azure.mgmt.subscription.models.Workload
    :param billing_scope: Determines whether subscription is fieldLed,
     partnerLed or LegacyEA
    :type billing_scope: str
    :param subscription_id: This parameter can be used to create alias for
     existing subscription Id
    :type subscription_id: str
    :param reseller_id: Reseller ID, basically MPN Id
    :type reseller_id: str
    """

    _attribute_map = {
        'display_name': {'key': 'displayName', 'type': 'str'},
        'workload': {'key': 'workload', 'type': 'str'},
        'billing_scope': {'key': 'billingScope', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'reseller_id': {'key': 'resellerId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PutAliasRequestProperties, self).__init__(**kwargs)
        self.display_name = kwargs.get('display_name', None)
        self.workload = kwargs.get('workload', None)
        self.billing_scope = kwargs.get('billing_scope', None)
        self.subscription_id = kwargs.get('subscription_id', None)
        self.reseller_id = kwargs.get('reseller_id', None)


class PutAliasResponse(Model):
    """Subscription Information with the alias.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: Fully qualified ID for the alias resource.
    :vartype id: str
    :ivar name: Alias ID.
    :vartype name: str
    :ivar type: Resource type, Microsoft.Subscription/aliases.
    :vartype type: str
    :param properties: Put Alias response properties.
    :type properties:
     ~azure.mgmt.subscription.models.PutAliasResponseProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'PutAliasResponseProperties'},
    }

    def __init__(self, **kwargs):
        super(PutAliasResponse, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.properties = kwargs.get('properties', None)


class PutAliasResponseProperties(Model):
    """Put subscription creation result properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar subscription_id: Newly created subscription Id.
    :vartype subscription_id: str
    :param provisioning_state: The provisioning state of the resource.
     Possible values include: 'Accepted', 'Succeeded', 'Failed'
    :type provisioning_state: str or
     ~azure.mgmt.subscription.models.ProvisioningState
    """

    _validation = {
        'subscription_id': {'readonly': True},
    }

    _attribute_map = {
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(PutAliasResponseProperties, self).__init__(**kwargs)
        self.subscription_id = None
        self.provisioning_state = kwargs.get('provisioning_state', None)


class RenamedSubscriptionId(Model):
    """The ID of the subscriptions that is being renamed.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar value: The ID of the subscriptions that is being renamed
    :vartype value: str
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(RenamedSubscriptionId, self).__init__(**kwargs)
        self.value = None


class Subscription(Model):
    """Subscription information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The fully qualified ID for the subscription. For example,
     /subscriptions/00000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar subscription_id: The subscription ID.
    :vartype subscription_id: str
    :ivar display_name: The subscription display name.
    :vartype display_name: str
    :ivar state: The subscription state. Possible values are Enabled, Warned,
     PastDue, Disabled, and Deleted. Possible values include: 'Enabled',
     'Warned', 'PastDue', 'Disabled', 'Deleted'
    :vartype state: str or ~azure.mgmt.subscription.models.SubscriptionState
    :param subscription_policies: The subscription policies.
    :type subscription_policies:
     ~azure.mgmt.subscription.models.SubscriptionPolicies
    :param authorization_source: The authorization source of the request.
     Valid values are one or more combinations of Legacy, RoleBased, Bypassed,
     Direct and Management. For example, 'Legacy, RoleBased'.
    :type authorization_source: str
    """

    _validation = {
        'id': {'readonly': True},
        'subscription_id': {'readonly': True},
        'display_name': {'readonly': True},
        'state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'subscription_id': {'key': 'subscriptionId', 'type': 'str'},
        'display_name': {'key': 'displayName', 'type': 'str'},
        'state': {'key': 'state', 'type': 'SubscriptionState'},
        'subscription_policies': {'key': 'subscriptionPolicies', 'type': 'SubscriptionPolicies'},
        'authorization_source': {'key': 'authorizationSource', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(Subscription, self).__init__(**kwargs)
        self.id = None
        self.subscription_id = None
        self.display_name = None
        self.state = None
        self.subscription_policies = kwargs.get('subscription_policies', None)
        self.authorization_source = kwargs.get('authorization_source', None)


class SubscriptionName(Model):
    """The new name of the subscription.

    :param subscription_name: New subscription name
    :type subscription_name: str
    """

    _attribute_map = {
        'subscription_name': {'key': 'subscriptionName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionName, self).__init__(**kwargs)
        self.subscription_name = kwargs.get('subscription_name', None)


class SubscriptionPolicies(Model):
    """Subscription policies.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar location_placement_id: The subscription location placement ID. The
     ID indicates which regions are visible for a subscription. For example, a
     subscription with a location placement Id of Public_2014-09-01 has access
     to Azure public regions.
    :vartype location_placement_id: str
    :ivar quota_id: The subscription quota ID.
    :vartype quota_id: str
    :ivar spending_limit: The subscription spending limit. Possible values
     include: 'On', 'Off', 'CurrentPeriodOff'
    :vartype spending_limit: str or
     ~azure.mgmt.subscription.models.SpendingLimit
    """

    _validation = {
        'location_placement_id': {'readonly': True},
        'quota_id': {'readonly': True},
        'spending_limit': {'readonly': True},
    }

    _attribute_map = {
        'location_placement_id': {'key': 'locationPlacementId', 'type': 'str'},
        'quota_id': {'key': 'quotaId', 'type': 'str'},
        'spending_limit': {'key': 'spendingLimit', 'type': 'SpendingLimit'},
    }

    def __init__(self, **kwargs):
        super(SubscriptionPolicies, self).__init__(**kwargs)
        self.location_placement_id = None
        self.quota_id = None
        self.spending_limit = None


class TenantIdDescription(Model):
    """Tenant Id information.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar id: The fully qualified ID of the tenant. For example,
     /tenants/00000000-0000-0000-0000-000000000000.
    :vartype id: str
    :ivar tenant_id: The tenant ID. For example,
     00000000-0000-0000-0000-000000000000.
    :vartype tenant_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(TenantIdDescription, self).__init__(**kwargs)
        self.id = None
        self.tenant_id = None
