##############################################################################
#
# Copyright (c) 2010 Projekt01 GmbH and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################
"""
$Id: celery.py 4368 2015-09-21 04:00:22Z roger.ineichen $
"""

import os
import zc.buildout
import zc.recipe.egg

from p01.recipe.setup import LoggerMixin


PYTHONPATH = """
os.environ['PYTHONPATH'] = os.pathsep.join(sys.path)
"""

initialization_template = """import os
sys.argv[0] = os.path.abspath(sys.argv[0])
"""


env_template = """os.environ['%s'] = %r
"""


class CeleryRecipe(LoggerMixin):

    def __init__(self, buildout, name, options):
        self.buildout, self.name, self.options = buildout, name, options
        options.setdefault('config-path',
                os.path.join(self.buildout['buildout']['parts-directory'],
                                 self.name))
        options['location'] = os.path.join(
            buildout['buildout']['parts-directory'],
            self.name,
        )

    def install(self):
        dest = []
        options = self.options

        # setup optional settings.py file
        settings = []
        if 'settings' in options:
            settings.append(options['settings'])

            conf_filename = os.path.join(options['config-path'],
                                         'celeryconfig.py')
            dest.append(conf_filename)
            if not os.path.exists(os.path.dirname(conf_filename)):
                self.logger.info('Creating directory %s.' %
                            os.path.dirname(conf_filename))
                os.makedirs(os.path.dirname(conf_filename))

            conf_file = open(conf_filename, 'w')
            conf_file.write('# generated by p01.recipe.setup:celery\n')
            conf_file.write('\n'.join(settings))
            conf_file.close()
            self.logger.info('Generated config file %s.' % conf_filename)

        # setup environment and
        initialization = initialization_template
        # add PYTHONPATH
        initialization += PYTHONPATH
        # environment
        env_section = options.get('environment', '').strip()
        if env_section:
            env = self.buildout[env_section]
            for key, value in env.items():
                initialization += env_template % (key, value)

        if options.get('initialization'):
            # append additional initialization after sys path loading if given
            initialization += options.get('initialization')

        celery_egg_options = {
            'eggs': 'celery',
            'initialization': initialization}

        if len(settings):
            celery_egg_options['extra-paths'] = os.path.dirname(conf_filename)

        if 'eggs' in options:
            celery_egg_options['eggs'] = '\n'.join(['celery']
                                         + options['eggs'].split())
        if 'scripts' in options:
            celery_egg_options['scripts'] = options['scripts']

        celery_egg = zc.recipe.egg.Egg(
            self.buildout,
            self.name,
            celery_egg_options,
        )
        dest.extend(celery_egg.install())
        return dest

    update = install
