/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.scheduler.common.job;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.proactive.annotation.PublicAPI;
import org.ow2.proactive.scheduler.common.exception.UserException;
import org.ow2.proactive.scheduler.common.job.Job;
import org.ow2.proactive.scheduler.common.job.JobId;
import org.ow2.proactive.scheduler.common.job.JobType;
import org.ow2.proactive.scheduler.common.task.Task;

@PublicAPI
public class TaskFlowJob
extends Job {
    private int taskCountForUnSetTaskName = 1;
    private Map<String, Task> tasks = new LinkedHashMap<String, Task>();
    private static final long serialVersionUID = 810L;

    @Override
    public JobType getType() {
        return JobType.TASKSFLOW;
    }

    public void addTask(Task task) throws UserException {
        if (task.getName() == null) {
            throw new UserException("The name of the task must not be null !");
        }
        if (task.getName().equals("NOT SET")) {
            task.setName("task_" + this.taskCountForUnSetTaskName);
            ++this.taskCountForUnSetTaskName;
        }
        if (this.tasks.containsKey(task.getName())) {
            throw new UserException("The name of the task is already used : " + task.getName());
        }
        this.tasks.put(task.getName(), task);
    }

    public void addTasks(List<Task> tasks) throws UserException {
        for (Task task : tasks) {
            this.addTask(task);
        }
    }

    public ArrayList<Task> getTasks() {
        return new ArrayList<Task>(this.tasks.values());
    }

    public Task getTask(String name) {
        return this.tasks.get(name);
    }

    @Override
    public JobId getId() {
        return null;
    }

    @Override
    public String display() {
        String nl = System.lineSeparator();
        String answer = super.display();
        return answer + nl + "\tTasks = " + this.displayAllTasks();
    }

    private String displayAllTasks() {
        String nl = System.lineSeparator();
        String answer = "{" + nl;
        for (String tid : this.tasks.keySet()) {
            answer = answer + this.tasks.get(tid).display() + nl + nl;
        }
        answer = answer + "}";
        return answer;
    }
}

