# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class PolicyTrackedResource(Model):
    """Policy tracked resource record.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar tracked_resource_id: The ID of the policy tracked resource.
    :vartype tracked_resource_id: str
    :ivar policy_details: The details of the policy that require the tracked
     resource.
    :vartype policy_details: ~azure.mgmt.policyinsights.models.PolicyDetails
    :ivar created_by: The details of the policy triggered deployment that
     created the tracked resource.
    :vartype created_by:
     ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_modified_by: The details of the policy triggered deployment
     that modified the tracked resource.
    :vartype last_modified_by:
     ~azure.mgmt.policyinsights.models.TrackedResourceModificationDetails
    :ivar last_update_utc: Timestamp of the last update to the tracked
     resource.
    :vartype last_update_utc: datetime
    """

    _validation = {
        'tracked_resource_id': {'readonly': True},
        'policy_details': {'readonly': True},
        'created_by': {'readonly': True},
        'last_modified_by': {'readonly': True},
        'last_update_utc': {'readonly': True},
    }

    _attribute_map = {
        'tracked_resource_id': {'key': 'trackedResourceId', 'type': 'str'},
        'policy_details': {'key': 'policyDetails', 'type': 'PolicyDetails'},
        'created_by': {'key': 'createdBy', 'type': 'TrackedResourceModificationDetails'},
        'last_modified_by': {'key': 'lastModifiedBy', 'type': 'TrackedResourceModificationDetails'},
        'last_update_utc': {'key': 'lastUpdateUtc', 'type': 'iso-8601'},
    }

    def __init__(self, **kwargs):
        super(PolicyTrackedResource, self).__init__(**kwargs)
        self.tracked_resource_id = None
        self.policy_details = None
        self.created_by = None
        self.last_modified_by = None
        self.last_update_utc = None
