/*
 * Decompiled with CFR 0.152.
 */
package org.ow2.proactive.http;

import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLContext;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.ow2.proactive.http.AllowAllTrustStrategy;

public class CommonHttpClientBuilder {
    private static final AllowAllTrustStrategy ACCEPT_ANY_CERTIFICATE_TRUST_STRATEGY = new AllowAllTrustStrategy();
    private Boolean overrideAllowAnyHostname;
    private Boolean overrideAllowAnyCertificate;
    private int maxConnections;
    private RequestConfig requestConfig;
    private boolean useContentCompression = true;
    protected boolean useSystemProperties;
    protected boolean acceptAnyCertificate = false;
    protected boolean acceptAnyHostname = false;

    public CommonHttpClientBuilder allowAnyHostname(boolean acceptAnyHostname) {
        this.overrideAllowAnyHostname = acceptAnyHostname;
        return this;
    }

    public CommonHttpClientBuilder allowAnyCertificate(boolean acceptAnyCertificate) {
        this.overrideAllowAnyCertificate = acceptAnyCertificate;
        return this;
    }

    public CommonHttpClientBuilder disableContentCompression() {
        this.useContentCompression = false;
        return this;
    }

    public CommonHttpClientBuilder insecure(boolean insecure) {
        this.allowAnyHostname(insecure);
        this.allowAnyCertificate(insecure);
        return this;
    }

    public CommonHttpClientBuilder maxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public CommonHttpClientBuilder setDefaultRequestConfig(RequestConfig requestConfig) {
        this.requestConfig = requestConfig;
        return this;
    }

    public CommonHttpClientBuilder useSystemProperties() {
        return this.useSystemProperties(true);
    }

    public CommonHttpClientBuilder useSystemProperties(boolean useSystemProperties) {
        this.useSystemProperties = useSystemProperties;
        return this;
    }

    public CloseableHttpClient build() {
        HttpClientBuilder internalHttpClientBuilder = this.createInternalHttpClientBuilder();
        if (this.useSystemProperties) {
            internalHttpClientBuilder.useSystemProperties();
        }
        if (this.overrideAllowAnyHostname != null) {
            this.acceptAnyHostname = this.overrideAllowAnyHostname != false;
        }
        if (this.overrideAllowAnyCertificate != null) {
            this.acceptAnyCertificate = this.overrideAllowAnyCertificate != false;
        }
        if (this.acceptAnyCertificate) {
            internalHttpClientBuilder.setSslcontext(this.createSslContext());
        }
        if (this.acceptAnyHostname) {
            internalHttpClientBuilder.setHostnameVerifier(SSLConnectionSocketFactory.ALLOW_ALL_HOSTNAME_VERIFIER);
        }
        if (this.maxConnections > 0) {
            internalHttpClientBuilder.setMaxConnPerRoute(this.maxConnections);
            internalHttpClientBuilder.setMaxConnTotal(this.maxConnections);
        }
        if (this.requestConfig != null) {
            internalHttpClientBuilder.setDefaultRequestConfig(this.requestConfig);
        }
        if (!this.useContentCompression) {
            internalHttpClientBuilder.disableContentCompression();
        }
        return internalHttpClientBuilder.build();
    }

    public HttpClientBuilder createInternalHttpClientBuilder() {
        HttpClientBuilder result = HttpClientBuilder.create();
        result.setUserAgent("ProActive");
        return result;
    }

    protected SSLContext createSslContext() {
        try {
            SSLContextBuilder sslContextBuilder = new SSLContextBuilder();
            sslContextBuilder.loadTrustMaterial(null, (TrustStrategy)ACCEPT_ANY_CERTIFICATE_TRUST_STRATEGY);
            return sslContextBuilder.build();
        }
        catch (KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
    }
}

